/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.metstation;

import com.vividsolutions.jts.geom.Geometry;
import hec.clientapp.client.ClientApp;
import hec.gui.MoverDialog;
import hec.io.FilePath;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.rss.wq.client.WaterQualityMode;
import hec.rss.wq.client.metstation.MetDataSetEditorPanel;
import hec.rss.wq.client.metstation.MetStationSetDialog$MenuListenerImpl;
import hec.rss.wq.client.metstation.MetStationSetDialog$MetStationListCellRenderer;
import hec.rss.wq.client.metstation.MetStationSetDialog$MetStationSetCreator;
import hec.rss.wq.client.metstation.MetStationSetDialog$MetStationSetDeleter;
import hec.rss.wq.client.metstation.MetStationSetDialog$MetStationSetRename;
import hec.rss.wq.client.metstation.MetStationSetDialog$MetStationSetSaveAs;
import hec.rss.wq.model.MetData;
import hec.rss.wq.ui.OkApplyCancelDialog;
import hec.rss.wq.util.WqI18n;
import hec.watershed.model.Station;
import hec.watershed.model.StationSetDataObject;
import hec.wqenginecore.metstation.MetStation;
import hec.wqengineimpl.metstation.WQMetStation;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import mil.army.usace.hec.rmi.io.HecFileImpl;

public class MetStationSetDialog
extends OkApplyCancelDialog {
    JMenuItem newStationSetMenuItem;
    JMenuItem deleteStationSetMenuItem;
    JMenuItem selectActiveStationsMenuItem;
    JMenuItem saveAsStationSetMenuItem;
    private MetStationSetDialog$MetStationSetCreator _metStationCreator;
    private MetStationSetDialog$MetStationSetDeleter _metStationDeleter;
    private MetStationSetDialog$MetStationSetSaveAs _metStationSaveAs;
    private MetStationSetDialog$MetStationSetRename _metStationSetRename;
    List<MetData> _metDataList = new ArrayList<MetData>();

    public MetStationSetDialog(Window container, Dialog.ModalityType modalityType) {
        super((Window)container, new MetDataSetEditorPanel(), modalityType);
        container = new JMenuBar();
        boolean bl = ClientApp.frame().getCurrentMode() instanceof WaterQualityMode;
        if (bl) {
            this.setJMenuBar((JMenuBar)container);
            JMenu jMenu = new JMenu("Met Dataset");
            jMenu.addMenuListener(new MetStationSetDialog$MenuListenerImpl(this));
            this.newStationSetMenuItem = new JMenuItem("New...");
            this.newStationSetMenuItem.addActionListener(object -> {
                if (this._metStationCreator != null) {
                    object = this._metStationCreator.createMetStationSet();
                    if (object == null) {
                        return;
                    }
                    ((MetData)((Object)object)).getMetStationSet();
                    this._metDataList.add((MetData)((Object)object));
                    ((MetDataSetEditorPanel)this._payload).addToPanel(Collections.singletonList(object), (MetData)((Object)object));
                }
            });
            this.selectActiveStationsMenuItem = WqI18n.a("MetData.SelectActive.Menu").createMenuItem();
            this.selectActiveStationsMenuItem.addActionListener(actionEvent -> this.selectActiveStations());
            jMenu.add(this.newStationSetMenuItem);
            jMenu.add(this.selectActiveStationsMenuItem);
            this.saveAsStationSetMenuItem = WqI18n.a("MetData.Menu.SaveAs").createMenuItem();
            this.saveAsStationSetMenuItem.addActionListener(object -> {
                if (this._metStationSaveAs != null) {
                    int n;
                    String string;
                    object = ((MetDataSetEditorPanel)this._payload).getSelectedMetData();
                    boolean bl = false;
                    Identifier identifier = object.getIdentifier();
                    if (object.isModified()) {
                        try {
                            File file = File.createTempFile("MetData" + Long.toString(System.currentTimeMillis()), null);
                            file.delete();
                            string = file.getAbsolutePath();
                            identifier = new Identifier(string, (HecFile)new HecFileImpl(new FilePath(string)));
                            ((MetData)((Object)object)).writeFile(identifier);
                        }
                        catch (IOException iOException) {
                            System.out.println(iOException.getMessage());
                        }
                    }
                    if (this.isModified() && (n = JOptionPane.showConfirmDialog(this._payload, (object != null ? object.toString() : "") + " has changed.\nWould you like to save?", "Save", 0)) == 0) {
                        bl = true;
                    }
                    ((MetDataSetEditorPanel)this._payload).savePanel();
                    this.setModified(false);
                    Object object2 = object;
                    MetData metData = this._metStationSaveAs.saveAsMetStationSet((MetData)object2, object2.getName(), ((MetDataSetEditorPanel)this._payload).getCurrentDescription());
                    if (!bl) {
                        ((MetData)((Object)object)).readFile(identifier);
                    }
                    if (metData == null) {
                        return;
                    }
                    string = ClientApp.Workspace();
                    if (string != null) {
                        string.saveWorkspace();
                    }
                    metData.getMetStationSet();
                    this._metDataList.add(metData);
                    ((MetDataSetEditorPanel)this._payload).clearPanel();
                    ((MetDataSetEditorPanel)this._payload).addToPanel(Collections.singletonList(metData), metData);
                }
            });
            jMenu.add(this.saveAsStationSetMenuItem);
            this.deleteStationSetMenuItem = new JMenuItem("Delete...");
            this.deleteStationSetMenuItem.addActionListener(list -> {
                if (this._metStationDeleter != null) {
                    list = this._metStationDeleter.deleteMetStationSet(((MetDataSetEditorPanel)this._payload).getSelectedMetData());
                    if (list == null || list.isEmpty()) {
                        return;
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        for (int j = this._metDataList.size() - 1; j >= 0; --j) {
                            if (!this._metDataList.get(j).getName().equalsIgnoreCase((String)list.get(i))) continue;
                            this._metDataList.remove(j);
                        }
                    }
                    ((MetDataSetEditorPanel)this._payload).removeFromPanel((List<String>)((Object)list));
                }
            });
            jMenu.add(this.deleteStationSetMenuItem);
            ((JMenuBar)container).add(jMenu);
        }
    }

    public void addNewMetStationCreator(MetStationSetDialog$MetStationSetCreator metStationSetDialog$MetStationSetCreator) {
        this._metStationCreator = metStationSetDialog$MetStationSetCreator;
    }

    public void addMetStationDeleter(MetStationSetDialog$MetStationSetDeleter metStationSetDialog$MetStationSetDeleter) {
        this._metStationDeleter = metStationSetDialog$MetStationSetDeleter;
    }

    public void addMetStationRename(MetStationSetDialog$MetStationSetRename metStationSetDialog$MetStationSetRename) {
        this._metStationSetRename = metStationSetDialog$MetStationSetRename;
    }

    public void addSaveAsMetStation(MetStationSetDialog$MetStationSetSaveAs metStationSetDialog$MetStationSetSaveAs) {
        this._metStationSaveAs = metStationSetDialog$MetStationSetSaveAs;
    }

    public void fillForm(List<MetData> list, MetData metData) {
        this._metDataList = list;
        ((MetDataSetEditorPanel)this._payload).fillPanel(list, metData != null ? metData : null);
    }

    @Override
    protected void doClose(int n) {
        if (n == 0) {
            ((MetDataSetEditorPanel)this._payload).clearCachedData();
        }
        super.doClose(n);
    }

    @Override
    public boolean saveDialog() {
        try {
            ((MetDataSetEditorPanel)this._payload).validatePanel();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog((Component)((Object)this), iOException.getMessage(), "Error", 0);
            return false;
        }
        ((MetDataSetEditorPanel)this._payload).savePanel();
        return true;
    }

    public MetData getSelectedMetData() {
        return ((MetDataSetEditorPanel)this._payload).getSelectedMetData();
    }

    private void selectActiveStations() {
        Object[] objectArray;
        if (((MetDataSetEditorPanel)this._payload)._stationSet == null) {
            return;
        }
        Object object2 = (StationSetDataObject)ClientApp.Workspace().getDataListContainer().getDataList("hec.watershed.model.StationSet");
        object2 = object2.getObjectArray();
        object2 = (StationSetDataObject)object2[0];
        object2 = object2.getStationSet();
        Object object322 = station -> station.isMetStation();
        object2 = object2.getFeatures(object322).stream().collect(Collectors.toList());
        object322 = new MoverDialog((JDialog)((Object)this), true, "Set Active Met Stations");
        object322.setAvailableListLabel("Inactive Met Stations");
        object322.setSelectedListLabel("Active Met Stations");
        object322.setSelectionType(100);
        object322.setDescVisible(false);
        Object object4 = ((MetDataSetEditorPanel)this._payload)._stationSet.getStations().stream();
        object4 = object4.collect(Collectors.partitioningBy(MetStation::isActive));
        List<MetStation> list = object4.get(Boolean.FALSE);
        object4 = (List)object4.get(Boolean.TRUE);
        object2 = object2.iterator();
        while (object2.hasNext()) {
            objectArray = (Object[])object2.next();
            Stream object = ((MetDataSetEditorPanel)this._payload)._stationSet.getStations().stream();
            if (object.filter(arg_0 -> MetStationSetDialog.a((Station)objectArray, arg_0)).count() > 0L) continue;
            WQMetStation wQMetStation = new WQMetStation();
            wQMetStation.setActive(false);
            wQMetStation.setName(objectArray.getName());
            wQMetStation.setDescription(objectArray.getDescription());
            wQMetStation.setGeometry((Geometry)objectArray.getGeometry().clone());
            wQMetStation.setNearestMeridian(objectArray.getNearestMeridian());
            wQMetStation.setLatitude(objectArray.getLatitude());
            wQMetStation.setLongitude(objectArray.getLongitude());
            wQMetStation.setReferenceElevation(objectArray.getElevation());
            wQMetStation.setIsMetStation(objectArray.isMetStation());
            wQMetStation.setIsObserved(objectArray.isObservedStation());
            list.add((MetStation)wQMetStation);
            ((MetDataSetEditorPanel)this._payload)._stationSet.getStations().add(wQMetStation);
        }
        object322.setSelectedCellRenderer((ListCellRenderer)new MetStationSetDialog$MetStationListCellRenderer());
        object322.setAvailableCellRenderer((ListCellRenderer)new MetStationSetDialog$MetStationListCellRenderer());
        object322.setData(list, (List)object4);
        object322.setLocationRelativeTo((Component)((Object)this));
        object322.setVisible(true);
        if (object322.isCanceled()) {
            return;
        }
        object2 = object322.getSelectedObjects();
        objectArray = object322.getAvailableObjects();
        for (Object object322 : object2) {
            if (!(object322 instanceof WQMetStation)) continue;
            object322 = (WQMetStation)object322;
            object322.setActive(true);
        }
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            object322 = objectArray2[i];
            if (!(object322 instanceof WQMetStation)) continue;
            object322 = (WQMetStation)object322;
            object322.setActive(false);
        }
        ((MetDataSetEditorPanel)this._payload).updateView();
        ClientApp.app().getFrame().getMapPanel().paintMap();
        this.setModified(true);
    }

    private static /* synthetic */ boolean a(Station station, MetStation metStation) {
        return metStation.getName().equals(station.getName());
    }
}

