/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.metstation;

import hec.map.LocalPt;
import hec.map.MapCanvas;
import hec.map.MapMouseAdapter;
import hec.map.MapPanel;
import hec.rss.wq.client.metstation.AbstractMetStationSetGlyph;
import hec.rss.wq.client.metstation.MetStationMapGlyph;
import hec.rss.wq.client.observeddataset.ObsStationMapGlyph;
import hec.wqengineimpl.metstation.WQMetStation;
import hec.wqengineimpl.observed.WQObsStation;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import rma.swing.RmaImage;
import rma.swing.RmaJMenuLabel;

public class MetStationSetMapTool
extends MapMouseAdapter {
    private final Cursor _mouseCursor;

    public MetStationSetMapTool(MapPanel object, MapCanvas mapCanvas) {
        super(object, mapCanvas);
        object = RmaImage.loadURLImage((Component)mapCanvas, (String)"Images/rss/wq/stationCursor.png");
        this._mouseCursor = Toolkit.getDefaultToolkit().createCustomCursor((Image)object, new Point(0, 0), "Station Tool");
    }

    public Cursor getCursor() {
        return this._mouseCursor;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        MetStationMapGlyph metStationMapGlyph = (MetStationMapGlyph)this._mapPanel.findGlyphOfClass(MetStationMapGlyph.class, true);
        ObsStationMapGlyph obsStationMapGlyph = (ObsStationMapGlyph)this._mapPanel.findGlyphOfClass(ObsStationMapGlyph.class, true);
        LocalPt localPt = new LocalPt(mouseEvent.getX(), mouseEvent.getY());
        WQMetStation wQMetStation = null;
        WQObsStation wQObsStation = null;
        if (metStationMapGlyph != null) {
            wQMetStation = metStationMapGlyph.findStation(localPt);
        }
        if (obsStationMapGlyph != null) {
            wQObsStation = obsStationMapGlyph.findStation(localPt);
        }
        if (mouseEvent.isPopupTrigger()) {
            this.handlePopupMenu(localPt, metStationMapGlyph, obsStationMapGlyph, wQMetStation, wQObsStation);
        }
        this.handleStationSelected(metStationMapGlyph, obsStationMapGlyph, wQMetStation, wQObsStation);
    }

    private void handlePopupMenu(LocalPt localPt, MetStationMapGlyph object, ObsStationMapGlyph object2, WQMetStation object3, WQObsStation wQObsStation) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (object3 != null) {
            object3 = new RmaJMenuLabel(object3.getName());
            jPopupMenu.add((JMenuItem)object3);
            jPopupMenu.addSeparator();
            object = ((AbstractMetStationSetGlyph)((Object)object)).getMenuActions(localPt);
            object = object.iterator();
            while (object.hasNext()) {
                object3 = (Action)object.next();
                jPopupMenu.add(new JMenuItem((Action)object3));
            }
        }
        if (wQObsStation != null) {
            object3 = new RmaJMenuLabel(wQObsStation.getName());
            jPopupMenu.add((JMenuItem)object3);
            jPopupMenu.addSeparator();
            object = object2.getMenuActions(localPt);
            object = object.iterator();
            while (object.hasNext()) {
                object3 = (Action)object.next();
                object2 = new JMenuItem((Action)object3);
                jPopupMenu.add((JMenuItem)object2);
            }
        }
        jPopupMenu.show((Component)this._mapPanel, localPt.x, localPt.y);
    }

    private void handleStationSelected(MetStationMapGlyph metStationMapGlyph, ObsStationMapGlyph obsStationMapGlyph, WQMetStation wQMetStation, WQObsStation wQObsStation) {
        WQMetStation wQMetStation2;
        boolean bl = false;
        if (metStationMapGlyph != null && (wQMetStation2 = metStationMapGlyph.getSelectedStation()) != wQMetStation) {
            metStationMapGlyph.setSelectedStation(wQMetStation);
            bl = true;
        }
        if (obsStationMapGlyph != null && (wQMetStation2 = obsStationMapGlyph.getSelectedStation()) != wQObsStation) {
            obsStationMapGlyph.setSelectedStation(wQObsStation);
            bl = true;
        }
        if (bl) {
            this._mapPanel.paintMap();
        }
    }
}

