/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.metstation;

import hec.rss.wq.client.WaterQualityDPData;
import hec.rss.wq.client.metstation.StationSetDrawPropData;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJColorComboBox;
import rma.swing.RmaJFontButton;

public class StationSetPropPanel
extends JPanel {
    private final int _scale;
    RmaJCheckBox drawNameCB;
    RmaJFontButton nameFontBtn;
    RmaJColorComboBox metStationColorCombo;
    RmaJColorComboBox obsStationColorCombo;
    StationSetDrawPropData m_data = null;

    public StationSetPropPanel(StationSetDrawPropData stationSetDrawPropData, int n) {
        this.m_data = stationSetDrawPropData;
        this._scale = n;
        this.buildControls();
        this.fillPanel();
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        JComponent jComponent = new JLabel("Met Station Color:");
        this.add((Component)jComponent, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5500, 0, 0));
        this.metStationColorCombo = new RmaJColorComboBox();
        this.metStationColorCombo.setModifiable(true);
        this.metStationColorCombo.setAllowsCustomColor(true);
        StationSetPropPanel stationSetPropPanel = this;
        stationSetPropPanel.add((Component)stationSetPropPanel.metStationColorCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5505, 0, 0));
        jComponent = new JLabel("Observed Station Color:");
        this.add((Component)jComponent, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5500, 0, 0));
        this.obsStationColorCombo = new RmaJColorComboBox();
        this.obsStationColorCombo.setModifiable(true);
        this.obsStationColorCombo.setAllowsCustomColor(true);
        StationSetPropPanel stationSetPropPanel2 = this;
        stationSetPropPanel2.add((Component)stationSetPropPanel2.obsStationColorCombo, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.INSETS5505, 0, 0));
        jComponent = new JPanel(new GridBagLayout());
        this.add((Component)jComponent, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 18, 0, RmaInsets.INSETS5555, 0, 0));
        this.drawNameCB = new RmaJCheckBox("Draw Station Name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = RmaInsets.INSETS5550;
        jComponent.add((Component)this.drawNameCB, gridBagConstraints);
        this.nameFontBtn = new RmaJFontButton("Font...");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        jComponent.add((Component)this.nameFontBtn, gridBagConstraints);
    }

    public void fillPanel(StationSetDrawPropData stationSetDrawPropData) {
        this.m_data = stationSetDrawPropData;
        this.fillPanel();
    }

    public void fillPanel() {
        if (this.m_data == null) {
            return;
        }
        this.drawNameCB.setSelected(this.m_data.isDrawName());
        this.nameFontBtn.setFont(this.m_data.getNameFont());
        this.metStationColorCombo.setSelectedColor(this.m_data.getMetStationColor());
        this.obsStationColorCombo.setSelectedColor(this.m_data.getObservedStationColor());
    }

    public void savePanel() {
        if (this.m_data != null) {
            this.m_data.setDrawName(this.drawNameCB.isSelected());
            this.m_data.setNameFont(this.nameFontBtn.getFont());
            this.m_data.setMetStationColor(this.metStationColorCombo.getSelectedColor());
            this.m_data.setObservedStationColor(this.obsStationColorCombo.getSelectedColor());
            this.m_data.save(this._scale);
        }
    }

    public void setToDefaults() {
        ((WaterQualityDPData)this.m_data).setDefaults();
        this.fillPanel();
    }

    public StationSetDrawPropData copyData(int n) {
        return StationSetDrawPropData.a(n, this.m_data);
    }
}

