/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.observeddataset;

import com.vividsolutions.jts.awt.ShapeWriter;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.HecClientFrame;
import hec.lang.NamedType;
import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.MapGlyph;
import hec.map.MapLabelItem;
import hec.map.MapObjectInterface;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.crs.CRSException;
import hec.rss.client.RssSystemGlyph;
import hec.rss.model.JunctionElement;
import hec.rss.model.RssSystem;
import hec.rss.wq.client.WaterQualityDPData;
import hec.rss.wq.client.geometry.GeometryMapGlyph;
import hec.rss.wq.client.metstation.StationSetDrawPropData;
import hec.rss.wq.client.observeddataset.AbstractObsStationSetGlyph$Circle;
import hec.rss.wq.client.observeddataset.AbstractObsStationSetGlyph$Diamond;
import hec.rss.wq.client.observeddataset.AbstractObsStationSetGlyph$HalfDiamondLeft;
import hec.rss.wq.client.observeddataset.AbstractObsStationSetGlyph$HalfDiamondRight;
import hec.rss.wq.client.observeddataset.AbstractObsStationSetGlyph$OpenObsEditorAction;
import hec.rss.wq.client.observeddataset.ObservedStationNamedType;
import hec.rss.wq.model.ObsDatasetManager;
import hec.wqengineimpl.observed.WQObsStation;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.Action;

public abstract class AbstractObsStationSetGlyph
extends MapGlyph {
    private static final int STATION_ICON_WIDTH = 25;
    private static final int STATION_ICON_HEIGHT = 25;
    private static final Shape HALF_DIAMOND_LEFT = new AbstractObsStationSetGlyph$HalfDiamondLeft(25.0, 25.0);
    private static final Shape HALF_DIAMOND_RIGHT = new AbstractObsStationSetGlyph$HalfDiamondRight(25.0, 25.0);
    private static final Shape DIAMOND = new AbstractObsStationSetGlyph$Diamond(25.0, 25.0);
    private static final Shape CIRCLE = new AbstractObsStationSetGlyph$Circle(12.5);
    private GeometryFactory _geometryFactory = new GeometryFactory();
    private WQObsStation _selectedStation;

    AbstractObsStationSetGlyph(MapPanel mapPanel, ObsDatasetManager obsDatasetManager) {
        super(mapPanel, (MapObjectInterface)obsDatasetManager);
    }

    public WorldRect getBounds() {
        WorldRect worldRect = super.getBounds();
        MapScale mapScale = this._mapPanel.scale((MapGlyph)this);
        worldRect = mapScale.wr2lr(worldRect);
        worldRect.l -= 25;
        worldRect.r += 25;
        worldRect.t -= 25;
        worldRect.b += 25;
        return mapScale.lr2wr((LocalRect)worldRect);
    }

    public boolean objectPopupMenu(LocalPt localPt, int n) {
        WQObsStation wQObsStation = this.findStation(localPt);
        if (wQObsStation != null) {
            this.objectSelect(localPt, n);
            HecClientFrame hecClientFrame = ClientApp.frame();
            hecClientFrame = hecClientFrame.getCurrentMode();
            return hecClientFrame.objectPopupMenu((NamedType)new ObservedStationNamedType(wQObsStation), localPt);
        }
        return false;
    }

    public String getToolTipText(WorldPt worldPt, MouseEvent mouseEvent) {
        worldPt = this.getMapPanel().scale((MapGlyph)this).wp2lp(worldPt);
        if ((worldPt = this.findStation((LocalPt)worldPt)) == null) {
            return null;
        }
        return "Observed Station: " + worldPt.getName();
    }

    public WQObsStation findStation(LocalPt object) {
        Object object2 = new Point2D.Double(((LocalPt)object).x, ((LocalPt)object).y);
        object = arg_0 -> this.lambda$findStation$0((LocalPt)object, (Point2D)object2, arg_0);
        object2 = (ObsDatasetManager)this.getMap();
        object = ((ObsDatasetManager)object2).getStations((Predicate<WQObsStation>)object);
        if (!object.isEmpty()) {
            return (WQObsStation)object.get(0);
        }
        return null;
    }

    private LocalRect computeLocalBoundRect(WorldPt worldPt, int n) {
        if (worldPt == null) {
            return new LocalRect(0, 0, 0, 0);
        }
        worldPt = new WorldRect(worldPt.e, worldPt.n, worldPt.e, worldPt.n);
        MapScale mapScale = this.getMapPanel().scale((MapGlyph)this);
        worldPt = mapScale.wr2lr((WorldRect)worldPt);
        int n2 = worldPt.l;
        int n3 = worldPt.r;
        int n4 = worldPt.t;
        int n5 = worldPt.b;
        if (worldPt.width() == 0) {
            n2 = worldPt.l - n;
            n3 = worldPt.l + n;
        }
        if (worldPt.height() == 0) {
            n4 = worldPt.t - n;
            n5 = worldPt.t + n;
        }
        worldPt = new LocalRect(n2, n4, n3, n5);
        return worldPt;
    }

    public List<Action> getMenuActions(LocalPt localPt) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        if ((localPt = this.findStation(localPt)) == null) {
            return arrayList;
        }
        if (localPt.isObserved()) {
            AbstractObsStationSetGlyph$OpenObsEditorAction abstractObsStationSetGlyph$OpenObsEditorAction = new AbstractObsStationSetGlyph$OpenObsEditorAction(this);
            abstractObsStationSetGlyph$OpenObsEditorAction.setSelectedStation((WQObsStation)localPt);
            arrayList.add(abstractObsStationSetGlyph$OpenObsEditorAction);
        }
        return arrayList;
    }

    public void setSelectedStation(WQObsStation wQObsStation) {
        this._selectedStation = wQObsStation;
    }

    private Shape computeLocalBoundGeometry(WQObsStation object) {
        if (object == null) {
            return new ShapeWriter().toShape((Geometry)this._geometryFactory.createPoint(new Coordinate(0.0, 0.0)));
        }
        Object object2 = object.getGeometry().getCentroid();
        object2 = this.getMapPanel().scale((MapGlyph)this).wp2lp(new WorldPt(object2.getX(), object2.getY()));
        if ((object = this.stationToShape((WQObsStation)object)) == null) {
            return new ShapeWriter().toShape((Geometry)this._geometryFactory.createPoint(new Coordinate(0.0, 0.0)));
        }
        int[] nArray = new int[2];
        int[] nArray2 = nArray;
        nArray[0] = object2.x;
        nArray2[1] = object2.y;
        object2 = AffineTransform.getTranslateInstance(nArray2[0] - 12, nArray2[1] - 12);
        object = object2.createTransformedShape((Shape)object);
        return object;
    }

    protected abstract Predicate<WQObsStation> stationDrawQuery();

    private Shape stationToShape(WQObsStation wQObsStation) {
        if (!wQObsStation.isMetStation() && wQObsStation.isObserved()) {
            return DIAMOND;
        }
        if (wQObsStation.isMetStation() && wQObsStation.isObserved()) {
            return HALF_DIAMOND_LEFT;
        }
        return null;
    }

    public void draw(Graphics graphics, MapScale mapScale) {
        Object object = (GeometryMapGlyph)this.getMapPanel().findGlyphOfClass(GeometryMapGlyph.class, true);
        RssSystem rssSystem = null;
        RssSystemGlyph rssSystemGlyph = null;
        if (object != null) {
            rssSystemGlyph = ((GeometryMapGlyph)((Object)object)).getSystemGlyph();
            object = rssSystemGlyph.getMap();
            rssSystem = (RssSystem)object;
        }
        object = (ObsDatasetManager)this.getMap();
        object = ((ObsDatasetManager)object).getObsStationSet().getStations(this.stationDrawQuery());
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        WorldPt worldPt = new WorldPt();
        int[] nArray = new int[2];
        Color color = new Color(37, 143, 203);
        int n = WaterQualityDPData.b();
        Serializable serializable = StationSetDrawPropData.b(n);
        if (serializable != null) {
            color = serializable.getObservedStationColor();
        }
        if ((serializable = serializable.getNameFont()) == null) {
            serializable = new Font("SansSerif", 0, 10);
        }
        object = object.iterator();
        while (object.hasNext()) {
            WQObsStation wQObsStation = (WQObsStation)object.next();
            arrayList.clear();
            arrayList2.clear();
            if (!wQObsStation.isActive()) continue;
            Object object2 = wQObsStation.getGeometry();
            WorldPt worldPt2 = wQObsStation.getStationIconLocation();
            Shape shape = this.stationToShape(wQObsStation);
            try {
                object2 = object2.getCentroid();
                worldPt.e = object2.getX();
                worldPt.n = object2.getY();
                object2 = this.transformPointToLocal(worldPt);
                if (worldPt2 != null && (worldPt2.e != 0.0 || worldPt2.n != 0.0)) {
                    object2 = this.transformPointToLocal(worldPt2);
                }
                nArray[0] = object2.x;
                nArray[1] = object2.y;
            }
            catch (CRSException cRSException) {
                object2 = cRSException;
                cRSException.printStackTrace();
                return;
            }
            object2 = AffineTransform.getTranslateInstance((double)nArray[0] - 12.5, (double)nArray[1] - 12.5);
            object2 = object2.createTransformedShape(shape);
            graphics.setColor(color);
            if (this._selectedStation != null && this._selectedStation.equals(wQObsStation)) {
                graphics.setColor(Color.yellow);
                ((Graphics2D)graphics).fill((Shape)object2);
                graphics.setColor(Color.black);
                ((Graphics2D)graphics).setStroke(new BasicStroke(1.0f));
                ((Graphics2D)graphics).draw((Shape)object2);
            } else {
                ((Graphics2D)graphics).fill((Shape)object2);
            }
            if (rssSystem != null && (object2 = rssSystem.findJunction(worldPt, 5.0)) != null) {
                rssSystemGlyph.drawJunction(graphics, mapScale, (JunctionElement)object2);
            }
            if (worldPt2 != null && (worldPt2.e != 0.0 || worldPt2.n != 0.0)) {
                object2 = mapScale.wp2lp(worldPt2);
                worldPt2 = wQObsStation.getGeometry().getCentroid();
                worldPt2 = mapScale.wp2lp(new WorldPt(worldPt2.getX(), worldPt2.getY()));
                graphics.setColor(color);
                graphics.drawLine(object2.x, object2.y, worldPt2.x, worldPt2.y);
            }
            float f = this._glyphLevel + 0.5f;
            this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(wQObsStation.getName(), nArray[0], nArray[1], 0, 16, f, (Font)serializable, Color.black, null, false, graphics));
        }
    }

    public WQObsStation getSelectedStation() {
        return this._selectedStation;
    }

    private /* synthetic */ boolean lambda$findStation$0(LocalPt localPt, Point2D point2D, WQObsStation wQObsStation) {
        WorldPt worldPt = wQObsStation.getStationIconLocation();
        if (worldPt != null) {
            return this.computeLocalBoundRect(worldPt, 25).contains(localPt);
        }
        return this.computeLocalBoundGeometry(wQObsStation).contains(point2D);
    }
}

