/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.observeddataset;

import hec.rss.wq.client.observeddataset.AddConstituentDialog$1;
import hec.rss.wq.client.observeddataset.AddConstituentPanel;
import hec.rss.wq.client.observeddataset.AddConstituentTableRowItem;
import hec.rss.wq.client.observeddataset.ObsStationDataSource;
import hec.rss.wq.model.ObsDatasetManager;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.observed.ObsVariable;
import hec.wqengineimpl.observed.WQObsConstituentVariable;
import hec.wqengineimpl.observed.WQObsUserVariable;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import rma.swing.ButtonCmdPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;

public class AddConstituentDialog
extends RmaJDialog {
    private final ObsDatasetManager _manager;
    private final ObsStationDataSource _selectedStationDataSource;
    private final List<ObsStationDataSource> _allStationDataSources;
    private AddConstituentPanel _addConstituentPanel;
    private ButtonCmdPanel _cmdPanel;
    protected boolean _canceled;
    private JButton _addConButton;
    private JButton _removeConButton;

    AddConstituentDialog(RmaJDialog rmaJDialog, ObsDatasetManager obsDatasetManager, ObsStationDataSource obsStationDataSource, List<ObsStationDataSource> list) {
        super((Dialog)rmaJDialog, true);
        this._allStationDataSources = list;
        this._manager = obsDatasetManager;
        this._selectedStationDataSource = obsStationDataSource;
        this.buildControls();
        this.addListeners();
        this.pack();
        this.setLocationRelativeTo((Component)rmaJDialog);
        this.fillPanel();
        this.setTitle(WqI18n.a("ObsData.AddConstituent.Title").getText());
    }

    private void buildControls() {
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this._addConstituentPanel = new AddConstituentPanel();
        this.getContentPane().add((Component)this._addConstituentPanel, gridBagConstraints);
        this._addConButton = new JButton(WqI18n.a("ObsData.AddConstituent.AddButton").getText());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)this._addConButton, gridBagConstraints);
        this._removeConButton = new JButton(WqI18n.a("ObsData.AddConstituent.RemoveButton").getText());
        this._removeConButton.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)this._removeConButton, gridBagConstraints);
        this._cmdPanel = new ButtonCmdPanel(12);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)this._cmdPanel, gridBagConstraints);
    }

    boolean isAddToAllStations() {
        return this._addConstituentPanel.isAllStationsChecked();
    }

    private void fillPanel() {
        this._addConstituentPanel.fillPanel(this._manager, this._selectedStationDataSource);
    }

    protected void addListeners() {
        this._addConstituentPanel.getTable().getSelectionModel().addListSelectionListener(listSelectionEvent -> this.tableRowSelected());
        this._addConButton.addActionListener(actionEvent -> this._addConstituentPanel.addUserDefinedConstituentRow());
        this._removeConButton.addActionListener(actionEvent -> this._addConstituentPanel.removeUserDefinedConstituentRow());
        this._cmdPanel.addCmdPanelListener(actionEvent -> {
            switch (actionEvent.getID()) {
                case 8: {
                    this._addConstituentPanel.commitEdits();
                    boolean bl = this.validateUserDefinedRows();
                    if (!bl) {
                        String string = WqI18n.a("ObsData.AddConstituent.Table.Error").getText();
                        JOptionPane.showMessageDialog(this._addConstituentPanel, this.getUserDefinedRowErrors(), string, 0);
                        return;
                    }
                    bl = this.validateUserDefinedNameUniqueness();
                    if (!bl) {
                        String string = WqI18n.a("ObsData.AddConstituent.Table.Error").getText();
                        JOptionPane.showMessageDialog(this._addConstituentPanel, this.getNamesNotUniqueErrorMessage(), string, 0);
                        return;
                    }
                    this.saveForm();
                    this._canceled = false;
                    this.setVisible(false);
                    return;
                }
                case 4: {
                    this._canceled = true;
                    this.editorClosing();
                    this.setVisible(false);
                }
            }
        });
        this.addWindowListener(new AddConstituentDialog$1(this));
    }

    private void tableRowSelected() {
        this._removeConButton.setEnabled(this._addConstituentPanel.isUserDefinedRowSelected());
    }

    private String getUserDefinedRowErrors() {
        Object object;
        Object object2 = this._addConstituentPanel.getTableRows();
        Object object3 = new ArrayList<String>();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            object = (AddConstituentTableRowItem)object2.next();
            if (!((AddConstituentTableRowItem)object).c() || ((AddConstituentTableRowItem)object).d()) continue;
            object3.add(((AddConstituentTableRowItem)object).e());
        }
        object2 = new StringBuilder();
        object = object3.iterator();
        while (object.hasNext()) {
            object3 = (String)object.next();
            ((StringBuilder)object2).append((String)object3).append(System.lineSeparator());
        }
        return ((StringBuilder)object2).toString();
    }

    private boolean validateUserDefinedRows() {
        boolean bl = true;
        Object object = this._addConstituentPanel.getTableRows();
        object = object.iterator();
        while (object.hasNext()) {
            AddConstituentTableRowItem addConstituentTableRowItem = (AddConstituentTableRowItem)object.next();
            if (!addConstituentTableRowItem.c() || addConstituentTableRowItem.d()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean validateUserDefinedNameUniqueness() {
        boolean bl = true;
        List<AddConstituentTableRowItem> list = this._addConstituentPanel.getTableRows();
        for (AddConstituentTableRowItem addConstituentTableRowItem : list) {
            if (this.isUniqueNameInRow(addConstituentTableRowItem, list)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private String getNamesNotUniqueErrorMessage() {
        List<AddConstituentTableRowItem> list = this._addConstituentPanel.getTableRows();
        StringBuilder stringBuilder = new StringBuilder();
        for (AddConstituentTableRowItem addConstituentTableRowItem : list) {
            String string;
            if (!addConstituentTableRowItem.c() || "".equals(string = this.getUniqueErrorMsg(addConstituentTableRowItem, list))) continue;
            stringBuilder.append(this.getUniqueErrorMsg(addConstituentTableRowItem, list));
            stringBuilder.append(System.lineSeparator());
        }
        return stringBuilder.toString();
    }

    private String getUniqueErrorMsg(AddConstituentTableRowItem addConstituentTableRowItem, List<AddConstituentTableRowItem> object) {
        Object object2 = new ArrayList<AddConstituentTableRowItem>();
        object2.addAll(object);
        object2.remove(addConstituentTableRowItem);
        object = "";
        object2 = object2.iterator();
        while (object2.hasNext()) {
            AddConstituentTableRowItem addConstituentTableRowItem2 = (AddConstituentTableRowItem)object2.next();
            if (addConstituentTableRowItem.b().getName().equals(addConstituentTableRowItem2.b().getName())) {
                object = "User defined variable does not have a unique constituent name: " + addConstituentTableRowItem.b().getName();
                continue;
            }
            if (!addConstituentTableRowItem.b().getDisplayName().equals(addConstituentTableRowItem2.b().getDisplayName())) continue;
            object = "User defined variable does not have a unique display name: " + addConstituentTableRowItem.b().getDisplayName();
        }
        return object;
    }

    private boolean isUniqueNameInRow(AddConstituentTableRowItem addConstituentTableRowItem, List<AddConstituentTableRowItem> object) {
        Object object2 = new ArrayList<AddConstituentTableRowItem>();
        object2.addAll(object);
        object2.remove(addConstituentTableRowItem);
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = (AddConstituentTableRowItem)object.next();
            if (!addConstituentTableRowItem.b().getName().equals(((AddConstituentTableRowItem)object2).b().getName()) && !addConstituentTableRowItem.b().getDisplayName().equals(((AddConstituentTableRowItem)object2).b().getDisplayName())) continue;
            return false;
        }
        return true;
    }

    private void editorClosing() {
        if (this.isModified() && this.isVisible()) {
            String string;
            String string2 = WqI18n.a("Geo.Editors.Msg.DataChanged").getText();
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), string2, string = WqI18n.a("Geo.Editors.Msg.DataChanged.Title").getText(), 0);
            if (n == 0) {
                this.saveForm();
            } else {
                this._canceled = true;
            }
        } else {
            this._canceled = true;
        }
        this.setVisible(false);
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    private void saveForm() {
        List<AddConstituentTableRowItem> list = this._addConstituentPanel.getTableRows();
        List<ObsVariable> list2 = this.createVariablesFromRows(list);
        if (this._addConstituentPanel.isAllStationsChecked()) {
            for (ObsStationDataSource obsStationDataSource : this._allStationDataSources) {
                this.updateStationVariables(obsStationDataSource, list2);
            }
        } else {
            AddConstituentDialog addConstituentDialog = this;
            addConstituentDialog.updateStationVariables(addConstituentDialog._selectedStationDataSource, list2);
        }
        this.addAllUserDefinedRowsToStationSet(list);
    }

    private void addAllUserDefinedRowsToStationSet(List<AddConstituentTableRowItem> object) {
        ArrayList<AddConstituentTableRowItem> arrayList = new ArrayList<AddConstituentTableRowItem>();
        object = object.iterator();
        while (object.hasNext()) {
            AddConstituentTableRowItem addConstituentTableRowItem = (AddConstituentTableRowItem)object.next();
            if (!"User Defined".equals((addConstituentTableRowItem = addConstituentTableRowItem.b()).getLibraryName())) continue;
            addConstituentTableRowItem = new WQObsUserVariable(addConstituentTableRowItem.getName(), addConstituentTableRowItem.getDisplayName(), addConstituentTableRowItem.getUnit());
            arrayList.add(addConstituentTableRowItem);
        }
        this._manager.getObsStationSet().setUserDefinedVariables(arrayList);
    }

    private void updateStationVariables(ObsStationDataSource obsStationDataSource, List<ObsVariable> obsVariable22) {
        List list = obsStationDataSource.a().getVariables();
        this.updateStationVarsThatStayedSelected(list, (List<ObsVariable>)obsVariable22);
        List<ObsVariable> list2 = this.getNewlyAddedConstituents(list, (List<ObsVariable>)obsVariable22);
        for (ObsVariable object : list2) {
            obsStationDataSource.a().addVariable(object);
        }
        list2 = this.getOriginalConstituentsToRemove(list, (List<ObsVariable>)obsVariable22);
        for (ObsVariable obsVariable22 : list2) {
            obsStationDataSource.a().removeVariable(obsVariable22);
        }
    }

    private void updateStationVarsThatStayedSelected(List<ObsVariable> list, List<ObsVariable> object) {
        object = object.iterator();
        while (object.hasNext()) {
            ObsVariable obsVariable = (ObsVariable)object.next();
            if (!(obsVariable instanceof WQObsUserVariable)) continue;
            for (ObsVariable obsVariable2 : list) {
                if (!obsVariable2.getDisplayName().equals(obsVariable.getDisplayName()) || !(obsVariable2 instanceof WQObsUserVariable)) continue;
                obsVariable2 = (WQObsUserVariable)obsVariable2;
                obsVariable2.setConstituentName(((WQObsUserVariable)obsVariable).getConstituentName());
                obsVariable2.setUnits(obsVariable.getUnits());
            }
        }
    }

    private List<ObsVariable> getNewlyAddedConstituents(List<ObsVariable> list, List<ObsVariable> object) {
        ArrayList<ObsVariable> arrayList = new ArrayList<ObsVariable>();
        object = object.iterator();
        while (object.hasNext()) {
            ObsVariable obsVariable = (ObsVariable)object.next();
            boolean bl = true;
            ObsVariable obsVariable2 = list.iterator();
            while (obsVariable2.hasNext()) {
                ObsVariable obsVariable3 = obsVariable2.next();
                if (!obsVariable3.getDisplayName().equals(obsVariable.getDisplayName())) continue;
                bl = false;
                break;
            }
            if (!bl || (obsVariable2 = this.cloneObsVariable(obsVariable)) == null) continue;
            arrayList.add(obsVariable2);
        }
        return arrayList;
    }

    private ObsVariable cloneObsVariable(ObsVariable obsVariable) {
        WQObsConstituentVariable wQObsConstituentVariable = null;
        if (obsVariable instanceof WQObsConstituentVariable) {
            wQObsConstituentVariable = new WQObsConstituentVariable(((WQObsConstituentVariable)obsVariable).getConstituentId(), obsVariable.getDisplayName());
        } else if (obsVariable instanceof WQObsUserVariable) {
            wQObsConstituentVariable = new WQObsUserVariable(((WQObsUserVariable)obsVariable).getConstituentName(), obsVariable.getDisplayName(), obsVariable.getUnits());
        }
        return wQObsConstituentVariable;
    }

    private List<ObsVariable> getOriginalConstituentsToRemove(List<ObsVariable> object, List<ObsVariable> list) {
        ArrayList<ObsVariable> arrayList = new ArrayList<ObsVariable>();
        object = object.iterator();
        while (object.hasNext()) {
            ObsVariable obsVariable = (ObsVariable)object.next();
            boolean bl = true;
            for (ObsVariable obsVariable2 : list) {
                if (!obsVariable2.getDisplayName().equals(obsVariable.getDisplayName())) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(obsVariable);
        }
        return arrayList;
    }

    private List<ObsVariable> createVariablesFromRows(List<AddConstituentTableRowItem> object) {
        ArrayList<ObsVariable> arrayList = new ArrayList<ObsVariable>();
        object = object.iterator();
        while (object.hasNext()) {
            AddConstituentTableRowItem addConstituentTableRowItem = (AddConstituentTableRowItem)object.next();
            if (!addConstituentTableRowItem.a()) continue;
            if ("User Defined".equals((addConstituentTableRowItem = addConstituentTableRowItem.b()).getLibraryName())) {
                addConstituentTableRowItem = new WQObsUserVariable(addConstituentTableRowItem.getName(), addConstituentTableRowItem.getDisplayName(), addConstituentTableRowItem.getUnit());
                arrayList.add((ObsVariable)addConstituentTableRowItem);
                continue;
            }
            addConstituentTableRowItem = new WQObsConstituentVariable(addConstituentTableRowItem.getId(), addConstituentTableRowItem.getDisplayName());
            arrayList.add((ObsVariable)addConstituentTableRowItem);
        }
        return arrayList;
    }
}

