/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.observeddataset;

import hec.rss.wq.client.observeddataset.AddConstituentTableModel;
import hec.rss.wq.client.observeddataset.AddConstituentTableRowItem;
import hec.rss.wq.client.observeddataset.ObsStationDataSource;
import hec.rss.wq.model.ConstituentSetManager;
import hec.rss.wq.model.ObsDatasetManager;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.ConstituentSet;
import hec.wqenginecore.observed.ObsVariable;
import hec.wqengineimpl.WQConstituent;
import hec.wqengineimpl.observed.WQObsConstituentVariable;
import hec.wqengineimpl.observed.WQObsUserVariable;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJTable;
import rma.swing.table.MleHeadRenderer;

public class AddConstituentPanel
extends JPanel {
    private RmaJTable _constituentTable;
    private AddConstituentTableModel _tableModel;
    private RmaJCheckBox _allStationsCheckbox;

    AddConstituentPanel() {
        super(new GridBagLayout());
        this.buildControls();
    }

    private void buildControls() {
        Serializable serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 0.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5555;
        this._allStationsCheckbox = new RmaJCheckBox(WqI18n.a("ObsData.AddConstituent.Checkbox").getText());
        AddConstituentPanel addConstituentPanel = this;
        addConstituentPanel.add((Component)addConstituentPanel._allStationsCheckbox, serializable);
        this._constituentTable = new RmaJTable();
        this._constituentTable.removePopuMenuFillOptions();
        this._constituentTable.removePopupMenuRowEditingOptions();
        this._constituentTable.removePopupMenuSumOptions();
        this._constituentTable.setRowSelectionAllowed(true);
        this._constituentTable.getTableHeader().setDefaultRenderer((TableCellRenderer)new MleHeadRenderer());
        serializable = UIManager.getFont("ToolTip.font");
        Font font = this._constituentTable.getFont();
        serializable = new Font(((Font)serializable).getName(), font.getStyle(), font.getSize());
        this._constituentTable.setFont((Font)serializable);
        this._constituentTable.setCheckBoxCellEditor(0);
        this._constituentTable.setRowHeight(this._constituentTable.getRowHeight() + 5);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5555;
        AddConstituentPanel addConstituentPanel2 = this;
        addConstituentPanel2.add((Component)addConstituentPanel2._constituentTable.getScrollPane(), serializable);
    }

    RmaJTable getTable() {
        return this._constituentTable;
    }

    boolean isUserDefinedRowSelected() {
        AddConstituentTableRowItem addConstituentTableRowItem;
        boolean bl = false;
        int n = this._constituentTable.getSelectedRow();
        if (n >= 0 && n < this._tableModel.getRows().size() && (addConstituentTableRowItem = this._tableModel.getRows().get(n)).c()) {
            bl = true;
        }
        return bl;
    }

    boolean isAllStationsChecked() {
        return this._allStationsCheckbox.isSelected();
    }

    void commitEdits() {
        this._constituentTable.commitEdit(true);
    }

    void addUserDefinedConstituentRow() {
        this._tableModel.addUserDefinedConstituentRow();
    }

    void removeUserDefinedConstituentRow() {
        int n = this._constituentTable.getSelectedRow();
        if (n >= 0 && n < this._tableModel.getRows().size()) {
            Object object = this._tableModel.getRows().get(n);
            if (((AddConstituentTableRowItem)object).c()) {
                this._tableModel.getRows().remove(object);
                int n2 = n;
                this._tableModel.fireTableRowsDeleted(n2, n2);
                return;
            }
            String string = "Only user defined rows can be removed.";
            object = "Unable to Remove";
            JOptionPane.showMessageDialog(this, string, (String)object, 1);
        }
    }

    private void fillTable(Collection<Constituent> iterator, List<Integer> list, List<WQObsUserVariable> list2, List<WQObsUserVariable> list3) {
        ArrayList<AddConstituentTableRowItem> arrayList = new ArrayList<AddConstituentTableRowItem>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Constituent constituent = (Constituent)iterator.next();
            if (!(constituent instanceof WQConstituent)) continue;
            boolean bl = list.contains(constituent.getId());
            arrayList.add(new AddConstituentTableRowItem(bl, ((WQConstituent)constituent).copy()));
        }
        for (WQObsUserVariable wQObsUserVariable : list3) {
            WQConstituent wQConstituent = new WQConstituent();
            wQConstituent.setLibraryName("User Defined");
            wQConstituent.setDisplayName(wQObsUserVariable.getDisplayName());
            wQConstituent.setName(wQObsUserVariable.getConstituentName());
            wQConstituent.setUnit(wQObsUserVariable.getUnits());
            boolean bl = this.isUserVarInTheSelectedList(list2, wQObsUserVariable);
            arrayList.add(new AddConstituentTableRowItem(bl, (Constituent)wQConstituent));
        }
        this._constituentTable.setRowSorter(null);
        this._tableModel = new AddConstituentTableModel(arrayList);
        this._constituentTable.setModel((TableModel)((Object)this._tableModel));
        this._constituentTable.setCheckBoxCellEditor(0);
        this._constituentTable.setRowSorter(new TableRowSorter<AddConstituentTableModel>(this._tableModel));
        this._constituentTable.setColumnVisible(1, false, 0);
    }

    private boolean isUserVarInTheSelectedList(List<WQObsUserVariable> object, WQObsUserVariable wQObsUserVariable) {
        boolean bl = false;
        object = object.iterator();
        while (object.hasNext()) {
            WQObsUserVariable wQObsUserVariable2 = (WQObsUserVariable)object.next();
            if (!wQObsUserVariable2.getDisplayName().equals(wQObsUserVariable.getDisplayName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void fillPanel(ObsDatasetManager object, ObsStationDataSource iterator) {
        List<ConstituentSet> list = ConstituentSetManager.a(object.getProxyList());
        list = ConstituentSetManager.a(list);
        object = ((ObsDatasetManager)object).getObsStationSet().getUserDefinedVariables();
        iterator = ((ObsStationDataSource)((Object)iterator)).a().getVariables();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<WQObsUserVariable> arrayList2 = new ArrayList<WQObsUserVariable>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            ObsVariable obsVariable = (ObsVariable)iterator.next();
            if (obsVariable instanceof WQObsConstituentVariable) {
                arrayList.add(((WQObsConstituentVariable)obsVariable).getConstituentId());
                continue;
            }
            if (!(obsVariable instanceof WQObsUserVariable)) continue;
            arrayList2.add((WQObsUserVariable)obsVariable);
        }
        this.fillTable(list, arrayList, arrayList2, (List<WQObsUserVariable>)object);
    }

    public List<AddConstituentTableRowItem> getTableRows() {
        return this._tableModel.getRows();
    }
}

