/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.observeddataset;

import hec.gfx2d.G2dLabel;
import hec.gfx2d.G2dLabelDrawProp;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.PlotLayout;
import hec.gfx2d.TimeSeriesDataSet;
import hec.gfx2d.ViewportLayout;
import hec.io.TimeSeriesContainer;
import hec.rss.wq.client.observeddataset.ObsDataEditorPanel$1;
import hec.rss.wq.client.observeddataset.ObsDataEditorPanel$2;
import hec.rss.wq.client.observeddataset.ObsDataEditorPanel$3;
import hec.rss.wq.client.observeddataset.ObsDataEditorPanel$4;
import hec.rss.wq.client.observeddataset.ObsDataEditorPanel$DataSourceCellRenderer;
import hec.rss.wq.client.observeddataset.ObsDataEditorPanel$TimeSeriesPropertyListener;
import hec.rss.wq.dataSources.constant.ConstantDataSource;
import hec.rss.wq.dataSources.elevation.ElevationDataSource;
import hec.rss.wq.dataSources.excel.ExcelDataSource;
import hec.rss.wq.dataSources.latlong.LatLongDataSource;
import hec.rss.wq.dataSources.obs.ComputedCloudinessDataSource;
import hec.rss.wq.dataSources.table.TableDataSource;
import hec.rss.wq.ui.DataSource;
import hec.rss.wq.ui.TimeSeriesDataSource;
import hec.wqenginecore.dataSource.constant.ConstantData;
import hec.wqenginecore.dataSource.elevation.ElevationData;
import hec.wqenginecore.dataSource.excel.ExcelData;
import hec.wqenginecore.dataSource.latlong.LatLongData;
import hec.wqenginecore.dataSource.obs.ObservedData;
import hec.wqenginecore.dataSource.table.TableData;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import rma.swing.list.RmaListModel;

public class ObsDataEditorPanel
extends JPanel {
    private G2dPanel _plotPanel;
    private ComboBoxModel<TimeSeriesDataSource> _dataSourceListModel;
    private TimeSeriesDataSource _selectedDataSource = null;
    private String _parameterLabel = "";
    private MessageFormat _yaxisFormat = new MessageFormat("{0} ({1})");
    Map<DataSource, JComponent> componentMap = new HashMap<DataSource, JComponent>();
    private static final JPanel a = new JPanel();
    private ButtonGroup buttonGroup1;
    private JComboBox<TimeSeriesDataSource> jComboBox1;
    private JLabel jLabel1;
    private JRadioButton jRadioButton1;
    private JPanel mDataSourceEditorPanel;
    private JRadioButton mPlotAllDataSourcesRadioButton;
    private JPanel mPlotAreaPanel;
    private ObsDataEditorPanel$TimeSeriesPropertyListener tsPropertyListener = new ObsDataEditorPanel$TimeSeriesPropertyListener(this);

    private ObsDataEditorPanel(List<TimeSeriesDataSource> list) {
        Objects.requireNonNull(list, "Null Data Source List in MetDataEditorPanel. Please use an empty list if there are no data sources.");
        this.initComponents();
        this._dataSourceListModel = new RmaListModel(false, list);
        this.jComboBox1.setModel(this._dataSourceListModel);
        if (!list.isEmpty()) {
            this.jComboBox1.setSelectedIndex(0);
        }
        this.jComboBox1.setRenderer(new ObsDataEditorPanel$DataSourceCellRenderer());
        this.mDataSourceEditorPanel.add((Component)a, "NoEditorPanel");
        this._plotPanel = new G2dPanel();
        this.mPlotAreaPanel.setLayout(new BorderLayout());
        this.mPlotAreaPanel.add((Component)this._plotPanel, "Center");
        this.jRadioButton1.setSelected(true);
    }

    public void setParameterLabel(String string) {
        this._parameterLabel = string != null ? string : "";
    }

    public void validateData() throws IOException {
        Object object = this.componentMap.keySet();
        object = object.iterator();
        while (object.hasNext()) {
            DataSource dataSource = (DataSource)object.next();
            dataSource.validateData();
        }
    }

    public void save() throws IOException {
        Object object = this.componentMap.keySet();
        object = object.iterator();
        while (object.hasNext()) {
            DataSource dataSource = (DataSource)object.next();
            dataSource.save();
        }
    }

    public String getSelectedDataSourceName() {
        TimeSeriesDataSource timeSeriesDataSource = (TimeSeriesDataSource)this.jComboBox1.getSelectedItem();
        if (timeSeriesDataSource != null) {
            return timeSeriesDataSource.getName();
        }
        return "";
    }

    public void setSelectedDataSourceName(String string) {
        for (int i = 0; i < this._dataSourceListModel.getSize(); ++i) {
            TimeSeriesDataSource timeSeriesDataSource = (TimeSeriesDataSource)this._dataSourceListModel.getElementAt(i);
            if (!timeSeriesDataSource.getName().equalsIgnoreCase(string)) continue;
            this.jComboBox1.setSelectedItem(timeSeriesDataSource);
            return;
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jComboBox1 = new JComboBox();
        this.jRadioButton1 = new JRadioButton();
        this.mPlotAllDataSourcesRadioButton = new JRadioButton();
        this.mDataSourceEditorPanel = new JPanel();
        this.mPlotAreaPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBox1.addItemListener(new ObsDataEditorPanel$1(this));
        this.jComboBox1.addActionListener(new ObsDataEditorPanel$2(this));
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setText("Plot Selected Data Source");
        this.jRadioButton1.addActionListener(new ObsDataEditorPanel$3(this));
        this.buttonGroup1.add(this.mPlotAllDataSourcesRadioButton);
        this.mPlotAllDataSourcesRadioButton.setText("Plot All Defined Data Sources");
        this.mPlotAllDataSourcesRadioButton.addActionListener(new ObsDataEditorPanel$4(this));
        this.mDataSourceEditorPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.mDataSourceEditorPanel.setLayout(new CardLayout());
        this.mPlotAreaPanel.setMinimumSize(new Dimension(600, 375));
        this.mPlotAreaPanel.setPreferredSize(new Dimension(600, 375));
        GroupLayout groupLayout = new GroupLayout(this.mPlotAreaPanel);
        this.mPlotAreaPanel.setLayout(groupLayout);
        GroupLayout groupLayout2 = groupLayout;
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout groupLayout3 = groupLayout;
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 375, Short.MAX_VALUE));
        this.jLabel1.setText("Data Source:");
        groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        GroupLayout groupLayout4 = groupLayout;
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mPlotAreaPanel, -1, 648, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, 0, 219, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mPlotAllDataSourcesRadioButton)).addComponent(this.mDataSourceEditorPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout groupLayout5 = groupLayout;
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jRadioButton1).addComponent(this.mPlotAllDataSourcesRadioButton).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mDataSourceEditorPanel, -2, 109, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mPlotAreaPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void mPlotAllDataSourcesRadioButtonActionPerformed(ActionEvent actionEvent) {
        ObsDataEditorPanel obsDataEditorPanel = this;
        obsDataEditorPanel.plotSelectedDataSource(obsDataEditorPanel._selectedDataSource);
    }

    private void jComboBox1ActionPerformed(ActionEvent object) {
        List<Component> list;
        object = (TimeSeriesDataSource)this._dataSourceListModel.getSelectedItem();
        String string = "NoEditorPanel";
        if (object != null) {
            JComponent jComponent;
            string = object.getName();
            list = Arrays.asList(this.mDataSourceEditorPanel.getComponents());
            if (!list.contains(jComponent = object.getComponent())) {
                this.mDataSourceEditorPanel.add((Component)jComponent, string);
                this.componentMap.put((DataSource)object, jComponent);
            }
        }
        this._selectedDataSource = object;
        list = (CardLayout)this.mDataSourceEditorPanel.getLayout();
        ((CardLayout)((Object)list)).show(this.mDataSourceEditorPanel, string);
        this.plotSelectedDataSource((TimeSeriesDataSource)object);
    }

    private void jComboBox1ItemStateChanged(ItemEvent itemEvent) {
        TimeSeriesDataSource timeSeriesDataSource = (TimeSeriesDataSource)itemEvent.getItem();
        if (itemEvent.getStateChange() == 2) {
            timeSeriesDataSource.removePropertyChangeListener(this.tsPropertyListener);
            return;
        }
        timeSeriesDataSource.addPropertyChangeListener(this.tsPropertyListener);
    }

    private void jRadioButton1ActionPerformed(ActionEvent actionEvent) {
        ObsDataEditorPanel obsDataEditorPanel = this;
        obsDataEditorPanel.plotSelectedDataSource(obsDataEditorPanel._selectedDataSource);
    }

    /*
     * WARNING - void declaration
     */
    private void plotSelectedDataSource(TimeSeriesDataSource timeSeriesDataSource) {
        G2dLabelDrawProp g2dLabelDrawProp2;
        Object object;
        if (timeSeriesDataSource == null) {
            return;
        }
        List<TimeSeriesContainer> object22 = timeSeriesDataSource.getTimeSeries();
        this._plotPanel.setVisible(false);
        this._plotPanel.clearPanel();
        PlotLayout plotLayout = new PlotLayout();
        HashMap hashMap = new HashMap();
        for (TimeSeriesContainer timeSeriesContainer : object22) {
            void var2_6;
            object = timeSeriesContainer.units != null ? timeSeriesContainer.units : "";
            List list = (List)hashMap.get(object);
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                hashMap.put(object, arrayList);
            }
            var2_6.add(timeSeriesContainer);
        }
        if (this.mPlotAllDataSourcesRadioButton.isSelected()) {
            int n = this._dataSourceListModel.getSize();
            for (int i = 0; i < n; ++i) {
                object = (TimeSeriesDataSource)this._dataSourceListModel.getElementAt(i);
                if (object == timeSeriesDataSource) continue;
                List<TimeSeriesContainer> list = object.getTimeSeries();
                for (G2dLabelDrawProp g2dLabelDrawProp2 : list) {
                    object = g2dLabelDrawProp2.units != null ? g2dLabelDrawProp2.units : "";
                    ArrayList<G2dLabelDrawProp> arrayList = (ArrayList<G2dLabelDrawProp>)hashMap.get(object);
                    if (arrayList == null) {
                        arrayList = new ArrayList<G2dLabelDrawProp>();
                        hashMap.put(object, arrayList);
                    }
                    arrayList.add(g2dLabelDrawProp2);
                }
            }
        }
        Iterator<Object> iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            ViewportLayout viewportLayout = plotLayout.addViewport();
            object = (Map.Entry)iterator.next();
            String string = this._yaxisFormat.format(new String[]{this._parameterLabel, (String)object.getKey()});
            viewportLayout.setAxisLabel("Y1", string);
            Iterator iterator2 = ((List)object.getValue()).iterator();
            while (iterator2.hasNext()) {
                g2dLabelDrawProp2 = new TimeSeriesDataSet((TimeSeriesContainer)iterator2.next());
                g2dLabelDrawProp2.setName(timeSeriesDataSource.getName());
                viewportLayout.addCurve("Y1", (Object)g2dLabelDrawProp2);
            }
        }
        this._plotPanel.buildComponents(plotLayout);
        ObsDataEditorPanel obsDataEditorPanel = this;
        List<G2dLabel> list = obsDataEditorPanel.collectLabels((Container)obsDataEditorPanel._plotPanel);
        for (G2dLabel g2dLabel : list) {
            g2dLabelDrawProp2 = g2dLabel.getProperties();
            g2dLabelDrawProp2.setMaxFontSize(12);
            g2dLabelDrawProp2.setFontSize(12);
            g2dLabelDrawProp2.setMinFontSize(12);
            g2dLabel.setProperties(g2dLabelDrawProp2);
        }
        this._plotPanel.setVisible(true);
        this._plotPanel.revalidate();
    }

    private List<G2dLabel> collectLabels(Container componentArray) {
        ArrayList<G2dLabel> arrayList = new ArrayList<G2dLabel>();
        Component[] componentArray2 = componentArray.getComponents();
        componentArray = componentArray2;
        componentArray = componentArray2;
        int n = componentArray2.length;
        for (int i = 0; i < n; ++i) {
            Component component = componentArray[i];
            if (component instanceof G2dLabel) {
                arrayList.add((G2dLabel)component);
                continue;
            }
            if (!(component instanceof Container)) continue;
            arrayList.addAll(this.collectLabels((Container)component));
        }
        return arrayList;
    }

    public static void a(String[] object) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            Logger.getLogger(ObsDataEditorPanel.class.getName()).log(Level.SEVERE, null, exception);
        }
        object = new ObsDataEditorPanel(Arrays.asList(new ConstantDataSource(new ConstantData()), new ExcelDataSource(new ExcelData()), new TableDataSource(new TableData()), new ElevationDataSource(new ElevationData()), new ComputedCloudinessDataSource(new ObservedData()), new LatLongDataSource(new LatLongData())));
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add((Component)object, "Center");
        jFrame.setLocation(500, 500);
        jFrame.setSize(750, 400);
        jFrame.setVisible(true);
    }
}

