/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.observeddataset;

import hec.clientapp.client.ClientApp;
import hec.gui.SelectorPanel;
import hec.heclib.dss.DSSPathname;
import hec.io.DSSIdentifier;
import hec.rss.wq.client.observeddataset.ObsDataSetEditorPanel$1;
import hec.rss.wq.client.observeddataset.ObsDataSetEditorPanel$CaseInsenstiveStringCompare;
import hec.rss.wq.client.observeddataset.ObsDataSetEditorPanel$CollapseAllActionListener;
import hec.rss.wq.client.observeddataset.ObsDataSetEditorPanel$ExpandAllActionListener;
import hec.rss.wq.client.observeddataset.ObsDataSetEditorPanel$ObsStationSetCellRenderer;
import hec.rss.wq.client.observeddataset.ObsDataSetEditorPanel$ObsStationTreeCellRenderer;
import hec.rss.wq.client.observeddataset.ObsDataSetEditorPanel$PreventRootNodeFromCollapseListener;
import hec.rss.wq.client.observeddataset.ObsDataSetEditorPanel$TreeMouseListener;
import hec.rss.wq.client.observeddataset.ObsDataSetEditorPanel$TreeSelectorPanelActionListener;
import hec.rss.wq.client.observeddataset.ObsDataSetEditorPanel$VariableStationWrapper;
import hec.rss.wq.client.observeddataset.ObsDataSetEditorPanel$ViewSelectionListener;
import hec.rss.wq.client.observeddataset.ObsStationDataSource;
import hec.rss.wq.client.observeddataset.ObsStationSetEditorStationTreeModel;
import hec.rss.wq.model.ObsDatasetManager;
import hec.rss.wq.ui.TreeView;
import hec.rss.wq.ui.View$SelectionListener;
import hec.rss.wq.ui.ViewPanel;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.metstation.Station;
import hec.wqenginecore.observed.ObsStation;
import hec.wqenginecore.observed.ObsStationSet;
import hec.wqenginecore.observed.ObsVariable;
import hec.wqengineimpl.observed.WQObsConstituentVariable;
import hec.wqengineimpl.observed.WQObsStation;
import hec.wqengineimpl.observed.WQObsStationSet;
import hec.wqengineimpl.observed.WQObsVariable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import rma.swing.RmaJPanel;
import rma.swing.list.RmaListModel;

public class ObsDataSetEditorPanel
extends RmaJPanel {
    private String _treeState = "CollapseAll";
    private final SelectorPanel _observedDataSelectorPanel;
    private final ViewPanel _viewPanel;
    private TreeView _treeView;
    private final SelectorPanel _treeSelectorPanel;
    private boolean _ignoreTreeSelectorEvents = false;
    private static final MessageFormat a = new MessageFormat("Time Series Variable: {0}");
    private MessageFormat _titledSeperatorFormat;
    private JLabel _titledSeperatorLabel;
    private JSeparator _titledSeperator;
    ObsStationSet _stationSet;
    private ObsDatasetManager _obsDataManager;
    private List<ObsDatasetManager> _obsStationList;
    private JPanel _panelEditorContainer;
    private JPanel _viewPanelContainer;
    private ButtonGroup buttonGroup1;

    public ObsDataSetEditorPanel() {
        this.initComponents();
        this._observedDataSelectorPanel = new SelectorPanel();
        this._observedDataSelectorPanel.getComboBox().setRenderer((ListCellRenderer)new ObsDataSetEditorPanel$ObsStationSetCellRenderer());
        this._panelEditorContainer.add((Component)this._observedDataSelectorPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this._panelEditorContainer.setPreferredSize(this._observedDataSelectorPanel.getPreferredSize());
        this._viewPanel = new ViewPanel();
        Object object = new TreeView(new DefaultTreeModel(null));
        this.configureTreeView((TreeView)object);
        this._viewPanel.setView(object);
        this._treeView = object;
        this._treeView.a(new ObsDataSetEditorPanel$TreeMouseListener(this));
        this._viewPanelContainer.add((Component)this._viewPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        object = new JPanel();
        this._treeSelectorPanel = new SelectorPanel();
        this._treeSelectorPanel.setNameLabel("Obs Station:");
        this._treeSelectorPanel.setDescriptionPanelVisible(false);
        ((Container)object).setLayout(new GridBagLayout());
        ((Container)object).add((Component)this._treeSelectorPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this._titledSeperator = new JSeparator();
        this._titledSeperatorLabel = new JLabel("");
        ((Container)object).add((Component)this._titledSeperatorLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
        ((Container)object).add((Component)this._titledSeperator, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this._viewPanel.setDisplayHeader(new ObsDataSetEditorPanel$1(this, (JPanel)object));
        this._observedDataSelectorPanel.getComboBox().addItemListener(this::obsStationComboChanged);
        this._treeSelectorPanel.getComboBox().addActionListener((ActionListener)new ObsDataSetEditorPanel$TreeSelectorPanelActionListener(this));
        this.setModified(false);
    }

    private void obsStationComboChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2 && this.isModified()) {
            Object object = itemEvent.getItem();
            if (object == null) {
                return;
            }
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), object.toString() + " has changed.\nWould you like to save?", "Save", 0);
            if (n == 0) {
                this.savePanel();
            }
            this.setModified(false);
        }
        if (itemEvent.getStateChange() == 1) {
            ObsDatasetManager obsDatasetManager = (ObsDatasetManager)this._observedDataSelectorPanel.getComboBox().getSelectedItem();
            this.fillPanel(obsDatasetManager);
        }
    }

    void updateCurrentRenamed() {
        this._observedDataSelectorPanel.getComboBox().repaint();
        this._observedDataSelectorPanel.setDescription(this._stationSet.getDescription());
        this._treeView.a().repaint();
    }

    String getCurrentDescription() {
        return this._observedDataSelectorPanel.getDescription();
    }

    private void configureTreeView(TreeView treeView) {
        treeView.a().addTreeWillExpandListener(new ObsDataSetEditorPanel$PreventRootNodeFromCollapseListener());
        treeView.addSelectionListener((View$SelectionListener)new ObsDataSetEditorPanel$ViewSelectionListener(this));
        treeView.a(new ObsDataSetEditorPanel$TreeMouseListener(this));
        treeView.a(new ObsDataSetEditorPanel$ObsStationTreeCellRenderer());
    }

    void updateView() {
        Object object;
        TreeModel treeModel = this._treeView.a().getModel();
        if (treeModel instanceof ObsStationSetEditorStationTreeModel) {
            ((ObsStationSetEditorStationTreeModel)treeModel).b();
            object = this._stationSet != null ? this._stationSet.getStations().stream().filter(ObsStation::isActive).map(Station::getName).collect(Collectors.toList()) : Collections.EMPTY_LIST;
            object.sort(new ObsDataSetEditorPanel$CaseInsenstiveStringCompare());
            this._treeSelectorPanel.getComboBox().setModel(new DefaultComboBoxModel<Object>(object.toArray()));
        }
        switch (this._treeState) {
            case "ExpandAll": {
                ObsDataSetEditorPanel obsDataSetEditorPanel = this;
                new ObsDataSetEditorPanel$ExpandAllActionListener(obsDataSetEditorPanel, obsDataSetEditorPanel._treeView.a()).actionPerformed(null);
                break;
            }
            case "CollapseAll": {
                ObsDataSetEditorPanel obsDataSetEditorPanel = this;
                new ObsDataSetEditorPanel$CollapseAllActionListener(obsDataSetEditorPanel, obsDataSetEditorPanel._treeView.a()).actionPerformed(null);
            }
        }
        object = treeModel.getRoot();
        if (object != null) {
            this._treeView.a().setSelectionPath(new TreePath(object));
        }
    }

    public void fillPanel(List<ObsDatasetManager> list, ObsDatasetManager obsDatasetManager) {
        if (this._obsDataManager == null || obsDatasetManager != null && !obsDatasetManager.getName().equalsIgnoreCase(this._obsDataManager.getName()) || !list.contains(this._obsDataManager)) {
            this.clearPanel();
            this._stationSet = null;
            this._obsDataManager = null;
            this._obsStationList = list;
            this._observedDataSelectorPanel.getComboBox().setModel((ComboBoxModel)new RmaListModel(true, list));
            if (obsDatasetManager != null) {
                this._observedDataSelectorPanel.getComboBox().setSelectedItem((Object)obsDatasetManager);
            } else {
                int n = list.isEmpty() ? -1 : 0;
                this._observedDataSelectorPanel.getComboBox().setSelectedIndex(n);
            }
        } else if (this.obsDataListChanged(list)) {
            obsDatasetManager = (RmaListModel)this._observedDataSelectorPanel.getComboBox().getModel();
            for (ObsDatasetManager obsDatasetManager2 : list) {
                if (obsDatasetManager.contains(obsDatasetManager2)) continue;
                obsDatasetManager.addElement(obsDatasetManager2);
            }
        }
        this._obsStationList = list;
    }

    private boolean obsDataListChanged(List<ObsDatasetManager> object) {
        if (Objects.equals(this._obsStationList, object)) {
            return false;
        }
        if (this._obsStationList == null || object == null) {
            return true;
        }
        if (this._obsStationList.size() != object.size()) {
            return true;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (this._obsStationList.contains(e)) continue;
            return true;
        }
        return false;
    }

    void removeFromPanel(List<String> object) {
        RmaListModel rmaListModel = (RmaListModel)this._observedDataSelectorPanel.getComboBox().getModel();
        Object object2 = rmaListModel.getSelectedItem();
        boolean bl = false;
        object = object.iterator();
        block0: while (object.hasNext()) {
            String string = (String)object.next();
            for (int i = rmaListModel.getSize() - 1; i >= 0; --i) {
                ObsDatasetManager obsDatasetManager = (ObsDatasetManager)rmaListModel.get(i);
                if (!obsDatasetManager.getName().equals(string)) continue;
                rmaListModel.removeElement((Object)obsDatasetManager);
                if (obsDatasetManager != object2) continue block0;
                bl = true;
                continue block0;
            }
        }
        if (bl) {
            if (this.isModified()) {
                this.setModified(false);
            }
            int n = rmaListModel.size() > 0 ? 0 : -1;
            this._observedDataSelectorPanel.getComboBox().setSelectedIndex(n);
            if (n == -1) {
                this._obsDataManager = null;
                this.clearPanel();
            }
        }
    }

    void addToPanel(List<ObsDatasetManager> list, ObsDatasetManager obsDatasetManager) {
        this._stationSet = null;
        ((RmaListModel)this._observedDataSelectorPanel.getComboBox().getModel()).addAll(list.toArray());
        if (obsDatasetManager != null) {
            this._observedDataSelectorPanel.getComboBox().setSelectedItem((Object)obsDatasetManager);
            return;
        }
        this._stationSet = (WQObsStationSet)this._observedDataSelectorPanel.getComboBox().getSelectedItem();
    }

    ObsDatasetManager getSelectedObsData() {
        return this._obsDataManager;
    }

    private void fillPanel(ObsDatasetManager object) {
        this._stationSet = object != null ? ((ObsDatasetManager)object).getObsStationSet() : null;
        this._obsDataManager = object;
        this._observedDataSelectorPanel.setDescription(object != null ? object.getDescription() : "");
        new ArrayList();
        Object object2 = new ObsStationSetEditorStationTreeModel();
        ((ObsStationSetEditorStationTreeModel)object2).a(this._stationSet);
        this._treeSelectorPanel.setNameLabel("Obs Station:");
        this._titledSeperatorFormat = a;
        object = object != null ? this._stationSet.getStations().stream().filter(ObsStation::isActive).map(Station::getName).collect(Collectors.toList()) : Collections.EMPTY_LIST;
        object.sort(new ObsDataSetEditorPanel$CaseInsenstiveStringCompare());
        object2 = new TreeView((TreeModel)object2);
        this.configureTreeView((TreeView)object2);
        this._treeView = object2;
        this._viewPanel.setView(object2);
        switch (this._treeState) {
            case "ExpandAll": {
                ObsDataSetEditorPanel obsDataSetEditorPanel = this;
                new ObsDataSetEditorPanel$ExpandAllActionListener(obsDataSetEditorPanel, obsDataSetEditorPanel._treeView.a()).actionPerformed(null);
                break;
            }
            case "CollapseAll": {
                ObsDataSetEditorPanel obsDataSetEditorPanel = this;
                new ObsDataSetEditorPanel$CollapseAllActionListener(obsDataSetEditorPanel, obsDataSetEditorPanel._treeView.a()).actionPerformed(null);
            }
        }
        this._treeSelectorPanel.getComboBox().setModel(new DefaultComboBoxModel<Object>(object.toArray()));
    }

    public void savePanel() {
        this._viewPanel.save();
        if (this._stationSet != null) {
            this._stationSet.setDescription(this._observedDataSelectorPanel.getDescription());
            this.notifyDuplicateDSSDataSourcesUsed();
        }
        if (this._obsDataManager != null) {
            this._obsDataManager.setDescription(this._observedDataSelectorPanel.getDescription());
            this._obsDataManager.setModified(true);
        }
        this.setModified(false);
    }

    private void notifyDuplicateDSSDataSourcesUsed() {
        if (this._obsDataManager != null) {
            WQObsStationSet wQObsStationSet = this._obsDataManager.getObsStationSet();
            HashMap<DSSIdentifier, List<ObsDataSetEditorPanel$VariableStationWrapper>> hashMap = new HashMap<DSSIdentifier, List<ObsDataSetEditorPanel$VariableStationWrapper>>();
            for (ObsStation obsStation : wQObsStationSet.getActiveStations()) {
                if (!(obsStation instanceof WQObsStation)) continue;
                Object object = obsStation.getVariables();
                object = object.iterator();
                while (object.hasNext()) {
                    ObsVariable obsVariable = (ObsVariable)object.next();
                    obsVariable = (WQObsVariable)obsVariable;
                    Object object2 = obsVariable.getSelectedData();
                    if (!(obsVariable instanceof WQObsConstituentVariable)) continue;
                    String string = null;
                    Object object3 = null;
                    if (object2 instanceof DssData) {
                        string = ((DssData)object2).getDssFilePath();
                        object3 = ((DssData)object2).getDssPath();
                        if (((WQObsStation)obsStation).isProfileStation()) {
                            object2 = new DSSPathname((String)object3);
                            object2.setEPart("*");
                            object2.setDPart("*");
                            object3 = object2.getPathname();
                        }
                    }
                    if (string == null || object3 == null) continue;
                    string = ClientApp.Workspace().getRelativePath(string);
                    string = Paths.get(string, new String[0]).normalize().toString();
                    object2 = new DSSIdentifier(string, (String)object3);
                    string = hashMap.keySet().stream().filter(arg_0 -> ObsDataSetEditorPanel.a((DSSIdentifier)object2, arg_0)).findFirst().orElse(null);
                    object3 = new ArrayList();
                    if (string != null) {
                        object2 = string;
                        object3 = (List)hashMap.get(string);
                    }
                    object3.add(new ObsDataSetEditorPanel$VariableStationWrapper((WQObsConstituentVariable)obsVariable, obsStation));
                    hashMap.put((DSSIdentifier)object2, (List<ObsDataSetEditorPanel$VariableStationWrapper>)object3);
                }
            }
            this.checkAndNotifyIfDuplicateRecordsUsed(hashMap);
        }
    }

    private void checkAndNotifyIfDuplicateRecordsUsed(Map<DSSIdentifier, List<ObsDataSetEditorPanel$VariableStationWrapper>> object) {
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry object3 : object.entrySet()) {
            object2 = (List)object3.getValue();
            if (object2.size() <= 1) continue;
            boolean bl = ((WQObsStation)((ObsDataSetEditorPanel$VariableStationWrapper)object2.get((int)0)).b).isProfileStation();
            if (!stringBuilder.toString().isEmpty()) {
                stringBuilder.append("\n\n");
            }
            object2 = object2.stream().map(Object::toString).collect(Collectors.toList());
            object2 = String.join((CharSequence)"\n", object2);
            String bl2 = bl ? WqI18n.a("ObsData.Editor.DuplicateRecordsUsed.Profile").getText() : WqI18n.a("ObsData.Editor.DuplicateRecordsUsed.TimeSeries").getText();
            stringBuilder.append(WqI18n.a("ObsData.Editor.DuplicateRecordsUsed.Message").format(new Object[]{bl2, ((DSSIdentifier)object3.getKey()).toString(), object2}));
        }
        if (!stringBuilder.toString().isEmpty()) {
            object = WqI18n.a("ObsData.Editor.DuplicateRecordsUsed.Title").getText();
            JTextArea jTextArea = new JTextArea(stringBuilder.toString());
            jTextArea.setEditable(false);
            object2 = new JScrollPane(jTextArea);
            ((JScrollPane)object2).setVerticalScrollBarPolicy(22);
            JOptionPane.showMessageDialog((Component)((Object)this), object2, (String)object, 2);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this._panelEditorContainer = new JPanel();
        this._viewPanelContainer = new JPanel();
        this._panelEditorContainer.setPreferredSize(new Dimension(0, 50));
        this._panelEditorContainer.setLayout(new GridBagLayout());
        this._viewPanelContainer.setLayout(new GridBagLayout());
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        GroupLayout groupLayout2 = groupLayout;
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._panelEditorContainer, -1, 843, Short.MAX_VALUE).addComponent(this._viewPanelContainer, -1, -1, Short.MAX_VALUE));
        GroupLayout groupLayout3 = groupLayout;
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this._panelEditorContainer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._viewPanelContainer, -1, 241, Short.MAX_VALUE)));
    }

    public void clearPanel() {
        TreeView treeView = new TreeView(new DefaultTreeModel(null));
        this.configureTreeView(treeView);
        this._viewPanel.setView(treeView);
        this._treeView = treeView;
        this._viewPanel.clearPanel();
        this._treeSelectorPanel.getComboBox().setModel(new DefaultComboBoxModel());
        this._observedDataSelectorPanel.setDescription("");
    }

    public void setSelectedStation(WQObsStation object) {
        if (object == null) {
            return;
        }
        TreeModel treeModel = this._treeView.a().getModel();
        if (treeModel instanceof ObsStationSetEditorStationTreeModel) {
            treeModel = (ObsStationSetEditorStationTreeModel)treeModel;
            int n = ((ObsStationSetEditorStationTreeModel)treeModel).getChildCount(((ObsStationSetEditorStationTreeModel)treeModel).getRoot());
            for (int i = 0; i < n; ++i) {
                TreeModel treeModel2 = treeModel;
                Object object2 = ((ObsStationSetEditorStationTreeModel)treeModel2).getChild(((ObsStationSetEditorStationTreeModel)treeModel2).getRoot(), i);
                if (!(object2 instanceof ObsStationDataSource)) continue;
                object2 = (ObsStationDataSource)object2;
                if ((object2 = ((ObsStationDataSource)object2).a()) != object) continue;
                object = this._treeView.a().getPathForRow(i + 1);
                if (object == null) break;
                this._treeView.a().setSelectionPath((TreePath)object);
                return;
            }
        }
    }

    private static /* synthetic */ boolean a(DSSIdentifier dSSIdentifier, DSSIdentifier dSSIdentifier2) {
        return dSSIdentifier2.toString().equalsIgnoreCase(dSSIdentifier.toString());
    }
}

