/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.observeddataset;

import hec.data.TimeWindow;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.PlotLayout;
import hec.io.TimeSeriesContainer;
import hec.rss.wq.client.TimeSeriesDataSourcePlotUtil;
import hec.rss.wq.client.observeddataset.ObsStationEditorPanel$RefreshRunnable;
import hec.rss.wq.client.observeddataset.ObsStationEditorSummaryTableModel;
import hec.rss.wq.dataSources.DataSourceFactory;
import hec.rss.wq.dataSources.timeSeries.DssDataSource;
import hec.rss.wq.ui.ParameterMap;
import hec.rss.wq.ui.TimeSeriesDataSource;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.observed.ObsStation;
import hec.wqengineimpl.observed.WQObsStation;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import rma.swing.RmaInsets;
import rma.swing.RmaJPanel;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.swing.table.MleHeadRenderer;

public class ObsStationEditorPanel
extends JPanel {
    private JTable _summaryTable;
    private JPanel _summaryPlotPanel;
    private G2dPanel _g2dPanel;
    private JPanel _cardPanel;
    private JRadioButton _stackedPlotRadioButton;
    private JRadioButton _summaryRadioButton;
    ObsStation _selectedStation;
    private Map<String, String[]> _indexMap = new HashMap<String, String[]>();
    private static final String[][] a = new String[][]{{"-165", "165W Zone X (-11 hours)"}, {"-150", "150W Zone W (-10 hours) "}, {"-135", "135W Zone V (-9 hours)"}, {"-120", "120W Zone U (-8 hours) HEC, Davis CA"}, {"-105", "105W Zone T (-7 hours)"}, {"-90", " 90W Zone S (-6 hours)"}, {"-75", " 75W Zone R (-5 hours)"}, {"-60", " 60W Zone Q (-4 hours)"}, {"-45", " 45W Zone P (-3 hours)"}, {"-30", " 30W Zone O (-2 hours)"}, {"-15", " 15W Zone N (-1 hours)"}, {"0", "  0W Zone Z (0 hours) Greenwich Mean Time"}, {"15", " 15E Zone A (1 hours)"}, {"30", " 30E Zone B (2 hours)"}, {"45", " 45E Zone C (3 hours)"}, {"60", " 60E Zone D (4 hours)"}, {"75", " 75E Zone E (5 hours) Karachi"}, {"90", " 90E Zone F (6 hours) Dhaka"}, {"105", "105E Zone G (7 hours) Bangkok"}, {"120", "120E Zone H (8 hours) Hong Kong"}, {"135", "135E Zone I (9 hours) Tokyo"}, {"150", "150E Zone K (10 hours) AU Eastern Standard"}, {"165", "165E Zone L (11 hours)"}, {"180", "180E Zone M (12 hours) Wellington"}};

    ObsStationEditorPanel() {
        Object object;
        this.initComponents();
        this._g2dPanel = new G2dPanel();
        String[][] stringArray = a;
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            object = stringArray[i];
            this._indexMap.put(object[0], (String[])object);
        }
        new DefaultComboBoxModel((E[])a);
        this._summaryTable = new RmaJTable();
        this._summaryTable.getTableHeader().setDefaultRenderer((TableCellRenderer)new MleHeadRenderer());
        JScrollPane jScrollPane = new JScrollPane(this._summaryTable);
        jScrollPane.setPreferredSize(new Dimension(650, 150));
        jScrollPane.setMinimumSize(new Dimension(650, 150));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        this._summaryPlotPanel = new JPanel();
        this._cardPanel.add((Component)jPanel, "SUMMARY");
        this._cardPanel.add((Component)this._summaryPlotPanel, "PLOT");
        object = new ButtonGroup();
        ((ButtonGroup)object).add(this._stackedPlotRadioButton);
        ((ButtonGroup)object).add(this._summaryRadioButton);
        this._stackedPlotRadioButton.setSelected(true);
        this._stackedPlotRadioButton.addActionListener(actionEvent -> this.stackedPlotRadioButtonActionPerformed());
    }

    private void initComponents() {
        this._summaryRadioButton = new RmaJRadioButton("Summary");
        this._stackedPlotRadioButton = new RmaJRadioButton("Stacked Plot");
        this._cardPanel = new RmaJPanel((LayoutManager)new CardLayout());
        this._summaryRadioButton.addActionListener(this::summaryRadioButtonActionPerformed);
        this.setLayout(new GridBagLayout());
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)this._summaryRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)this._stackedPlotRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this.add((Component)rmaJPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        ObsStationEditorPanel obsStationEditorPanel = this;
        obsStationEditorPanel.add((Component)obsStationEditorPanel._cardPanel, gridBagConstraints);
    }

    private void summaryRadioButtonActionPerformed(ActionEvent actionEvent) {
        ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, "SUMMARY");
    }

    private void stackedPlotRadioButtonActionPerformed() {
        ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, "PLOT");
    }

    public void fillPanel(ObsStation object) {
        this._selectedStation = object;
        this.clearPanel();
        if (this._selectedStation == null) {
            return;
        }
        this._summaryRadioButton.setSelected(true);
        this._summaryPlotPanel.setLayout(new BorderLayout());
        object = new JScrollPane((Component)this._g2dPanel);
        this._summaryPlotPanel.add((Component)object, "Center");
        ObsStationEditorPanel obsStationEditorPanel = this;
        obsStationEditorPanel.fillSummaryTable(obsStationEditorPanel._selectedStation);
        ObsStationEditorPanel obsStationEditorPanel2 = this;
        obsStationEditorPanel2.plotTimeSeries(obsStationEditorPanel2._selectedStation);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            ObsStationEditorPanel obsStationEditorPanel = this;
            obsStationEditorPanel.plotTimeSeries(obsStationEditorPanel._selectedStation);
        }
        super.setVisible(bl);
    }

    private void clearPanel() {
    }

    public void savePanel() {
        SwingUtilities.invokeLater(new ObsStationEditorPanel$RefreshRunnable(this));
    }

    private void fillSummaryTable(ObsStation obsStation) {
        ObsStationEditorSummaryTableModel obsStationEditorSummaryTableModel = new ObsStationEditorSummaryTableModel();
        obsStationEditorSummaryTableModel.setObsStation(obsStation);
        this._summaryTable.setModel(obsStationEditorSummaryTableModel);
    }

    private void plotTimeSeries(ObsStation obsStation) {
        this._g2dPanel.setVisible(false);
        PlotLayout plotLayout = new PlotLayout();
        if (obsStation == null) {
            return;
        }
        List data2 = obsStation.getVariables();
        TimeWindow timeWindow = null;
        block0: for (Object object : data2) {
            List list = object.getDataSources();
            for (Object object2 : list) {
                if (!object2.getName().equals(object.getSelectedDataSourceName())) continue;
                timeWindow = TimeSeriesDataSourcePlotUtil.a((Data)object2);
                continue block0;
            }
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (List list : data2) {
            List<TimeSeriesDataSource<?>> list2 = list.getDataSources();
            for (Data data : list2) {
                if (!data.getName().equals(list.getSelectedDataSourceName()) || !((list2 = DataSourceFactory.a(data)) instanceof TimeSeriesDataSource)) continue;
                ArrayList<TimeSeriesContainer> arrayList = new ArrayList<TimeSeriesContainer>();
                linkedHashMap.put(list.getDisplayName(), arrayList);
                TimeSeriesDataSource timeSeriesDataSource2 = (TimeSeriesDataSource)((Object)list2);
                if (timeWindow != null) {
                    list2 = new ParameterMap();
                    ((ParameterMap)((Object)list2)).a(TimeSeriesDataSource.TIME_WINDOW_PARAMETER, timeWindow);
                    if (data instanceof DssData && (((DssData)data).isProfileData() || ((WQObsStation)obsStation).isProfileStation())) {
                        List<TimeSeriesDataSource<?>> list3 = TimeSeriesDataSourcePlotUtil.a((DssData)data);
                        list3.forEach(timeSeriesDataSource -> arrayList.add((TimeSeriesContainer)((DssDataSource)timeSeriesDataSource).getPairedData((ParameterMap)((Object)list2))));
                        continue;
                    }
                    arrayList.addAll(timeSeriesDataSource2.getTimeSeries((ParameterMap)((Object)list2)));
                    continue;
                }
                if (data instanceof DssData && (((DssData)data).isProfileData() || ((WQObsStation)obsStation).isProfileStation())) {
                    list2 = TimeSeriesDataSourcePlotUtil.a((DssData)data);
                    list2.forEach(timeSeriesDataSource -> arrayList.add((TimeSeriesContainer)((DssDataSource)timeSeriesDataSource).e()));
                    continue;
                }
                arrayList.addAll(((TimeSeriesDataSource)((Object)list2)).getTimeSeries());
            }
        }
        TimeSeriesDataSourcePlotUtil.a(this._g2dPanel, plotLayout, linkedHashMap);
    }
}

