/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.observeddataset;

import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.constant.ConstantData;
import hec.wqenginecore.dataSource.elevation.ElevationData;
import hec.wqenginecore.dataSource.excel.ExcelData;
import hec.wqenginecore.dataSource.table.TableData;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.observed.ObsStation;
import hec.wqenginecore.observed.ObsVariable;
import javax.swing.table.AbstractTableModel;
import rma.util.RMAIO;

public class ObsStationEditorSummaryTableModel
extends AbstractTableModel {
    private static final String[] a = new String[]{"Constituents", "Data Source", "Value or Pathname"};
    private ObsStation _station;

    ObsStationEditorSummaryTableModel() {
    }

    void setObsStation(ObsStation obsStation) {
        this._station = obsStation;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this._station.getVariables().size();
    }

    @Override
    public int getColumnCount() {
        return a.length;
    }

    @Override
    public String getColumnName(int n) {
        return a[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ObsVariable obsVariable = (ObsVariable)this._station.getVariables().get(n);
        if (n2 == 0) {
            return obsVariable.getDisplayName();
        }
        if (n2 == 1) {
            String string = obsVariable.getSelectedDataSourceName();
            if (string != null) {
                return string;
            }
            return "";
        }
        if (n2 == 2) {
            Object object = obsVariable.getDataSources();
            object = object.iterator();
            while (object.hasNext()) {
                Data data = (Data)object.next();
                if (!data.getName().equals(obsVariable.getSelectedDataSourceName())) continue;
                obsVariable = data;
                if (!(obsVariable instanceof TableData)) {
                    if (obsVariable instanceof ConstantData) {
                        double d = ((ConstantData)obsVariable).getConstantValue();
                        return RMAIO.toTable((double)d);
                    }
                    if (obsVariable instanceof ElevationData) {
                        return RMAIO.toTable((double)((ElevationData)obsVariable).getElevation());
                    }
                    if (obsVariable instanceof DssData) {
                        return ((DssData)obsVariable).getDssFilePath();
                    }
                    if (obsVariable instanceof ExcelData) {
                        return ((ExcelData)obsVariable).getExcelFilePath() + ":" + ((ExcelData)obsVariable).getWorksheetName();
                    }
                }
                return "";
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }
}

