/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.observeddataset;

import hec.rss.model.Element;
import hec.rss.model.RssSystem;
import hec.rss.wq.client.observeddataset.FilterKeyAdapter;
import hec.rss.wq.client.observeddataset.ObsStationMappingSelectionDialog$1;
import hec.rss.wq.client.observeddataset.ObsStationMappingSelectionDialog$ElementWrapper;
import hec.rss.wq.client.observeddataset.ObsStationMappingsPanel$ObservedStationRef;
import hec.rss.wq.util.WqI18n;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableRowSorter;
import rma.swing.ButtonCmdPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.table.RmaTableModel;

final class ObsStationMappingSelectionDialog
extends RmaJDialog {
    private static String a = WqI18n.a("ObsData.Mappings.Selection.Title").getText();
    private final Consumer<ObsStationMappingsPanel$ObservedStationRef> _postSelectionAction;
    private final Window _parent;
    private RmaJTable _table;
    private TableRowSorter<RmaTableModel> _sorter;
    private ObsStationMappingsPanel$ObservedStationRef _observedStationRef;
    private RmaJTextField _nameFilterField;
    private JCheckBox _tableCheckBox;
    private int _selectedRow;
    private ButtonCmdPanel _btnCmdPanel;
    private RssSystem _selectedNetwork;

    ObsStationMappingSelectionDialog(Window window, Consumer<ObsStationMappingsPanel$ObservedStationRef> consumer) {
        super(window, true);
        this.setTitle(a);
        this._postSelectionAction = consumer;
        this._parent = window;
        this.setLayout(new GridBagLayout());
        this.setSize(500, 500);
        this.buildComponents();
        this.addListeners();
        this.setDefaultCloseOperation(0);
        this.setLocationRelativeTo(window);
    }

    private void addListeners() {
        this._nameFilterField.addKeyListener((KeyListener)new FilterKeyAdapter(this._sorter, (JTextField)this._nameFilterField, 1));
        this._tableCheckBox.addActionListener(actionEvent -> this.checkBoxSelected());
        this._btnCmdPanel.getButton(8).addActionListener(actionEvent -> this.okAction());
        this._btnCmdPanel.getButton(4).addActionListener(actionEvent -> this.cancelAction());
        this.addWindowListener(new ObsStationMappingSelectionDialog$1(this));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void cancelAction() {
        if (!this.isModified()) {
            this.dispose();
            return;
        }
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), WqI18n.a("ObsData.Mappings.Selection.Save.Confirm.msg").getText(), WqI18n.a("ObsData.Mappings.Selection.Save.Confirm.title").getText(), 1);
        if (n == 0) {
            this.okAction();
            return;
        }
        if (n != 1) return;
        this.dispose();
    }

    private void okAction() {
        Element element = this.getSelectedElement();
        this._observedStationRef.a(element);
        this._postSelectionAction.accept(this._observedStationRef);
        this.dispose();
    }

    private Element getSelectedElement() {
        Element element = null;
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            Object object = this._table.getValueAt(i, 0);
            if (object == null || !Boolean.parseBoolean(object.toString())) continue;
            ObsStationMappingSelectionDialog$ElementWrapper obsStationMappingSelectionDialog$ElementWrapper = (ObsStationMappingSelectionDialog$ElementWrapper)this._table.getValueAt(i, 1);
            if (obsStationMappingSelectionDialog$ElementWrapper == null) break;
            element = obsStationMappingSelectionDialog$ElementWrapper.a;
            break;
        }
        return element;
    }

    private void checkBoxSelected() {
        int n = this._table.getSelectedRow();
        SwingUtilities.invokeLater(() -> {
            Object object = this._table.getValueAt(n, 0);
            boolean bl = false;
            if (object instanceof Boolean) {
                bl = (Boolean)object;
            }
            if (bl && this._selectedRow >= 0 && this._selectedRow != n) {
                this._table.setValueAt((Object)Boolean.FALSE, this._selectedRow, 0);
            }
            this._selectedRow = n;
        });
    }

    private void buildComponents() {
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        this._nameFilterField = new RmaJTextField();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)new JLabel(WqI18n.a("ObsData.Mappings.Selection.NameFilter.Label").getText()), gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)this._nameFilterField, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this.add((Component)rmaJPanel, gridBagConstraints);
        this._table = new RmaJTable((Component)((Object)this), (Object[])new String[]{"", WqI18n.a("ObsData.Mappings.Selection.TableColumn.Name").getText(), WqI18n.a("ObsData.Mappings.Selection.TableColumn.Type").getText()});
        this._table.removePopupMenuRowEditingOptions();
        this._table.removePopupMenuSumOptions();
        this._tableCheckBox = this._table.setCheckBoxCellEditor(0);
        this._sorter = new TableRowSorter<RmaTableModel>((RmaTableModel)this._table.getModel());
        this._table.setColumnEnabled(false, 1);
        this._table.setColumnEnabled(false, 2);
        this._table.setColumnWidth(0, 18);
        this._table.getColumnModel().getColumn(0).setMaxWidth(18);
        this._sorter.setSortable(0, false);
        this._table.setColumnEnabled(true, 0);
        this._table.setRowSorter(this._sorter);
        this._table.setSelectionMode(0);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ObsStationMappingSelectionDialog obsStationMappingSelectionDialog = this;
        obsStationMappingSelectionDialog.add(obsStationMappingSelectionDialog._table.getScrollPane(), gridBagConstraints);
        this._btnCmdPanel = new ButtonCmdPanel();
        this._btnCmdPanel.getButton(8).setText(WqI18n.a("ObsData.Mappings.Selection.SelectButton").getText());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        ObsStationMappingSelectionDialog obsStationMappingSelectionDialog2 = this;
        obsStationMappingSelectionDialog2.add((Component)obsStationMappingSelectionDialog2._btnCmdPanel, gridBagConstraints);
    }

    final void fillTable(RssSystem iterator, Set<Element> object) {
        this._selectedNetwork = iterator;
        this._table.deleteCells();
        if (iterator != null) {
            iterator = this.filterElements((Set<Element>)object);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                Vector<Object> vector = new Vector<Object>();
                vector.add(Boolean.FALSE);
                vector.add(new ObsStationMappingSelectionDialog$ElementWrapper(this, (Element)object));
                object = ((Element)object).getElementType();
                vector.add(object);
                this._table.appendRow(vector);
            }
        }
        this.setModified(false);
    }

    private Set<Element> filterElements(Set<Element> set) {
        return set.stream().filter(element -> this.getIdentifiersToFilterOut().stream().noneMatch(string -> element.getDisplayName().contains((CharSequence)string))).collect(Collectors.toSet());
    }

    private List<String> getIdentifiersToFilterOut() {
        return List.of("L&O");
    }

    final void setObservedStation(ObsStationMappingsPanel$ObservedStationRef obsStationMappingsPanel$ObservedStationRef) {
        this._observedStationRef = obsStationMappingsPanel$ObservedStationRef;
        if (obsStationMappingsPanel$ObservedStationRef != null) {
            for (int i = 0; i < this._table.getRowCount(); ++i) {
                ObsStationMappingSelectionDialog$ElementWrapper obsStationMappingSelectionDialog$ElementWrapper = (ObsStationMappingSelectionDialog$ElementWrapper)this._table.getValueAt(i, 1);
                if (obsStationMappingSelectionDialog$ElementWrapper != null && obsStationMappingSelectionDialog$ElementWrapper.a.equals(obsStationMappingsPanel$ObservedStationRef.a())) {
                    this._table.setValueAt((Object)Boolean.TRUE, i, 0);
                    this._selectedRow = i;
                    continue;
                }
                this._table.setValueAt((Object)Boolean.FALSE, i, 0);
            }
        }
    }
}

