/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.observeddataset;

import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.StreamAlignment;
import hec.io.Identifier;
import hec.model.StreamElement;
import hec.rss.model.Element;
import hec.rss.model.JunctionElement;
import hec.rss.model.ReachElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import hec.rss.wq.client.observeddataset.ObsStationMappingSelectionDialog;
import hec.rss.wq.client.observeddataset.ObsStationMappingsPanel$1;
import hec.rss.wq.client.observeddataset.ObsStationMappingsPanel$ObservedStationRef;
import hec.rss.wq.client.observeddataset.ObservedStationSetDialog;
import hec.rss.wq.model.ObsDatasetManager;
import hec.rss.wq.ui.OkApplyCancelDialog;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.observed.ObsStation;
import hec.wqenginecore.observed.ObsStationSet;
import hec.wqengineimpl.observed.WQObsStation;
import hec.wqengineimpl.observed.WQObsStationNetworkElement;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.HierarchyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTable;
import rma.swing.list.RmaListModel;
import rma.swing.table.MleHeadRenderer;
import rma.util.RMAConst;

final class ObsStationMappingsPanel
extends RmaJPanel {
    private final ManagerProxyListContainer _context;
    private RmaJTable _mappingTable;
    private JButton _chooserButton;
    private RssSystem _selectedNetwork;
    private ObsStationMappingSelectionDialog _chooserDialog;
    private RmaJComboBox<ManagerProxy> _networkComboBox;
    private RmaJButton _fillWithNearestButton;
    private final Map<Integer, RssSystem> _networkMap = new HashMap<Integer, RssSystem>();
    private final Map<RssSystem, List<ObsStationMappingsPanel$ObservedStationRef>> _networkToStationRefMap = new HashMap<RssSystem, List<ObsStationMappingsPanel$ObservedStationRef>>();
    private ObsStationSet _obsStationSet;
    private Map<RssSystem, Set<Element>> _networkToElementsMap = new HashMap<RssSystem, Set<Element>>();
    private boolean _chooserNeedsRefresh = false;
    private String _errorMsg;

    ObsStationMappingsPanel(ManagerProxyListContainer managerProxyListContainer) {
        super((LayoutManager)new GridBagLayout());
        this._context = managerProxyListContainer;
        this.buildComponents();
        this.fillNetworks();
        this.addListeners();
    }

    private void addListeners() {
        this._networkComboBox.addActionListener(actionEvent -> {
            ObsStationMappingsPanel obsStationMappingsPanel = this;
            obsStationMappingsPanel.setSelectedNetwork((ManagerProxy)obsStationMappingsPanel._networkComboBox.getSelectedItem());
        });
        this._chooserButton.addActionListener(actionEvent -> this.chooserButtonClicked());
        this._fillWithNearestButton.addActionListener(actionEvent -> this.fillWithNearest());
        ObsStationMappingsPanel obsStationMappingsPanel = this;
        obsStationMappingsPanel.addHierarchyListener(hierarchyEvent -> this.hierarchyChanged(hierarchyEvent));
    }

    private void hierarchyChanged(HierarchyEvent object) {
        if (object.getChangeFlags() == 1L && (object = SwingUtilities.windowForComponent((Component)((Object)this))) instanceof ObservedStationSetDialog) {
            object = (ObservedStationSetDialog)((Object)object);
            ((OkApplyCancelDialog)((Object)object)).setErrorMessage(this._errorMsg);
        }
    }

    private void fillWithNearest() {
        int n = 1;
        if (this.hasValuesToOverwrite()) {
            n = JOptionPane.showConfirmDialog((Component)((Object)this), WqI18n.a("ObsData.Mappings.FillWithNearest.Confirm.msg").getText(), WqI18n.a("ObsData.Mappings.FillWithNearest.Confirm.title").getText(), 0);
            int n2 = n = n == 0 ? 1 : 0;
        }
        if (n != 0) {
            Object object = this._networkToStationRefMap.get(this._selectedNetwork);
            object = object.iterator();
            while (object.hasNext()) {
                ObsStationMappingsPanel$ObservedStationRef obsStationMappingsPanel$ObservedStationRef = (ObsStationMappingsPanel$ObservedStationRef)object.next();
                Element element = this.findNearestElement(obsStationMappingsPanel$ObservedStationRef);
                obsStationMappingsPanel$ObservedStationRef.a(element);
            }
            ObsStationMappingsPanel obsStationMappingsPanel = this;
            obsStationMappingsPanel.fillTable(obsStationMappingsPanel._selectedNetwork);
            this.setModified(true);
        }
    }

    private Element findNearestElement(ObsStationMappingsPanel$ObservedStationRef obsStationMappingsPanel$ObservedStationRef) {
        StreamElement streamElement;
        Element element = null;
        StreamAlignment streamAlignment = this._selectedNetwork.getAlignment();
        if (obsStationMappingsPanel$ObservedStationRef.a.getStreamName() != null && (streamElement = (StreamElement)streamAlignment.getElementVector().stream().filter(object -> object instanceof StreamElement && ((StreamElement)object).getName().equalsIgnoreCase(obsStationMappingsPanel$ObservedStationRef.a.getStreamName())).findFirst().orElse(null)) != null) {
            element = this.findNearestElement(streamAlignment, streamElement, obsStationMappingsPanel$ObservedStationRef.a);
        }
        return element;
    }

    private Element findNearestElement(StreamAlignment streamAlignment, StreamElement streamElement, WQObsStation object) {
        Element element = null;
        double d = Double.MAX_VALUE;
        double d2 = streamElement.getCoordByStation(object.getStreamStation());
        for (Element element2 : this._networkToElementsMap.get(this._selectedNetwork)) {
            double d3;
            StreamElement streamElement2;
            double d4;
            RssNode rssNode;
            StreamElement streamElement3;
            RssNode rssNode2;
            boolean bl = element2 instanceof ReachElement;
            boolean bl2 = element2 instanceof JunctionElement;
            boolean bl3 = element2 instanceof ReservoirElement;
            if (!bl && !bl2 && !bl3 || (rssNode2 = element2.getDownstreamNode()) == null || (streamElement3 = rssNode2.getStream()) == null) continue;
            double d5 = rssNode2.getStreamCoord();
            if (bl && (rssNode2 = (rssNode = element2.getUpstreamNode()).getStream()) == streamElement3) {
                d5 = 0.5 * (d5 + rssNode.getStreamCoord());
            }
            if (!RMAConst.isValidValue((double)(d4 = streamAlignment.findDistanceBetween(streamElement2 = streamElement, d2, (StreamElement)(rssNode2 = streamElement3), d3 = d5)))) {
                d4 = streamAlignment.findDistanceBetween((StreamElement)rssNode2, d3, streamElement2, d2);
            }
            if (!RMAConst.isValidValue((double)d4) || !(Math.abs(d4) < d)) continue;
            d = Math.abs(d4);
            element = element2;
        }
        return element;
    }

    private boolean hasValuesToOverwrite() {
        List<ObsStationMappingsPanel$ObservedStationRef> list = this._networkToStationRefMap.get(this._selectedNetwork);
        return list.stream().anyMatch(obsStationMappingsPanel$ObservedStationRef -> obsStationMappingsPanel$ObservedStationRef.a() != null);
    }

    private void chooserButtonClicked() {
        int n = this._mappingTable.getSelectedRow();
        if (n >= 0) {
            ObsStationMappingsPanel$ObservedStationRef obsStationMappingsPanel$ObservedStationRef = (ObsStationMappingsPanel$ObservedStationRef)this._mappingTable.getValueAt(n, 0);
            if (this._chooserDialog == null) {
                this._chooserDialog = new ObsStationMappingSelectionDialog(SwingUtilities.getWindowAncestor((Component)((Object)this)), this::observedStationChanged);
            }
            if (this._chooserNeedsRefresh) {
                Set<Element> set = this._networkToElementsMap.get(this._selectedNetwork);
                this._chooserDialog.fillTable(this._selectedNetwork, set);
            }
            this._chooserNeedsRefresh = false;
            this._chooserDialog.setObservedStation(obsStationMappingsPanel$ObservedStationRef);
            this._chooserDialog.setVisible(true);
        }
    }

    private void buildComponents() {
        this.setLayout(new GridBagLayout());
        this._networkComboBox = new RmaJComboBox();
        ObsStationMappingsPanel obsStationMappingsPanel = this;
        this._mappingTable = new ObsStationMappingsPanel$1(obsStationMappingsPanel, (Component)((Object)obsStationMappingsPanel), new String[]{WqI18n.a("ObsData.Mappings.TableColumn.ObsStation").getText(), WqI18n.a("ObsData.Mappings.TableColumn.NetworkElem").getText(), ""});
        this._mappingTable.removePopupMenuSumOptions();
        this._chooserButton = this._mappingTable.setButtonCellEditor(2);
        this._chooserButton.setToolTipText(WqI18n.a("ObsData.Mappings.Table.Button.Chooser.Tooltip").getText());
        this._mappingTable.setColumnEnabled(false, 0);
        this._mappingTable.setColumnEnabled(false, 1);
        this._mappingTable.setColumnWidth(2, 30);
        this._mappingTable.getTableHeader().setDefaultRenderer((TableCellRenderer)new MleHeadRenderer());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)new JLabel(WqI18n.a("ObsData.Mappings.Network.Label").getText()), gridBagConstraints);
        ManagerProxy managerProxy = new ManagerProxy();
        Identifier identifier = new Identifier();
        identifier.setName("XXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        managerProxy.setId(identifier);
        this._networkComboBox.setPrototypeDisplayValue((Object)managerProxy);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)this._networkComboBox, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this.add((Component)rmaJPanel, gridBagConstraints);
        this._fillWithNearestButton = new RmaJButton(WqI18n.a("ObsData.Mappings.FillWithNearest.Label").getText());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ObsStationMappingsPanel obsStationMappingsPanel2 = this;
        obsStationMappingsPanel2.add((Component)obsStationMappingsPanel2._fillWithNearestButton, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        ObsStationMappingsPanel obsStationMappingsPanel3 = this;
        obsStationMappingsPanel3.add(obsStationMappingsPanel3._mappingTable.getScrollPane(), gridBagConstraints);
    }

    private void fillNetworks() {
        this._networkMap.clear();
        this._networkToStationRefMap.clear();
        this._networkToElementsMap.clear();
        Vector vector = this._context.getManagerProxyList("rss", RssSystem.class.getName());
        Object object = new RmaListModel();
        object.addAll((Collection)vector);
        this._networkComboBox.setModel((ComboBoxModel)object);
        if (!vector.isEmpty()) {
            object = (RssSystem)((ManagerProxy)vector.get(0)).loadManager(null, null);
            this._networkMap.put(object.getIndex(), (RssSystem)object);
            Object object2 = object;
            this._networkToElementsMap.put((RssSystem)object2, ObsDatasetManager.a((RssSystem)object2));
            this._selectedNetwork = object;
            this._networkComboBox.setSelectedItem(vector.get(0));
        }
    }

    private void observedStationChanged(ObsStationMappingsPanel$ObservedStationRef obsStationMappingsPanel$ObservedStationRef) {
        for (int i = 0; i < this._mappingTable.getRowCount(); ++i) {
            if (!this._mappingTable.getValueAt(i, 0).equals(obsStationMappingsPanel$ObservedStationRef)) continue;
            this._mappingTable.setValueAt((Object)obsStationMappingsPanel$ObservedStationRef.a().getDisplayName(), i, 1);
            this.setModified(true);
            return;
        }
    }

    private void setSelectedNetwork(ManagerProxy object) {
        if (object != null) {
            if (this._networkMap.keySet().stream().noneMatch(arg_0 -> ObsStationMappingsPanel.a((ManagerProxy)object, arg_0))) {
                object = (RssSystem)object.loadManager(null, null);
                this._networkMap.put(object.getIndex(), (RssSystem)object);
                Object object2 = object;
                this._networkToElementsMap.put((RssSystem)object2, ObsDatasetManager.a((RssSystem)object2));
                this.initializeStationRefsForNetwork((RssSystem)object);
            } else {
                object = this._networkMap.get(object.getIndex());
            }
            if (object == this._selectedNetwork) {
                return;
            }
            this._chooserNeedsRefresh = true;
            this.fillTable((RssSystem)object);
            this._selectedNetwork = object;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void fillTable(RssSystem object) {
        boolean bl = this.isModified();
        try {
            void var3_8;
            void list2;
            int i = this._mappingTable.getRowCount() - 1;
            while (list2 >= 0) {
                this._mappingTable.deleteRow((int)list2);
                --list2;
            }
            List<ObsStationMappingsPanel$ObservedStationRef> list = this._networkToStationRefMap.get(object);
            if (list == null) {
                List<ObsStationMappingsPanel$ObservedStationRef> list3 = this.initializeStationRefsForNetwork((RssSystem)((Object)object));
            }
            for (ObsStationMappingsPanel$ObservedStationRef obsStationMappingsPanel$ObservedStationRef : var3_8) {
                Vector<Object> vector = new Vector<Object>();
                vector.add(obsStationMappingsPanel$ObservedStationRef);
                Element element = obsStationMappingsPanel$ObservedStationRef.a();
                if (element != null) {
                    vector.add(element.getDisplayName());
                }
                this._mappingTable.appendRow(vector);
            }
            return;
        }
        finally {
            this.setModified(bl);
        }
    }

    private List<ObsStationMappingsPanel$ObservedStationRef> initializeStationRefsForNetwork(RssSystem rssSystem) {
        ArrayList<ObsStationMappingsPanel$ObservedStationRef> arrayList = new ArrayList<ObsStationMappingsPanel$ObservedStationRef>();
        Object object = this._obsStationSet.getActiveStations();
        List<ObsStationMappingsPanel$ObservedStationRef> list = this._networkToStationRefMap.get(rssSystem);
        object = object.iterator();
        while (object.hasNext()) {
            ObsStation obsStation = (ObsStation)object.next();
            ObsStationMappingsPanel$ObservedStationRef obsStationMappingsPanel$ObservedStationRef2 = null;
            if (list != null) {
                obsStationMappingsPanel$ObservedStationRef2 = list.stream().filter(obsStationMappingsPanel$ObservedStationRef -> obsStationMappingsPanel$ObservedStationRef.a == obsStation).findFirst().orElse(null);
            }
            if (obsStationMappingsPanel$ObservedStationRef2 == null) {
                obsStationMappingsPanel$ObservedStationRef2 = new ObsStationMappingsPanel$ObservedStationRef((WQObsStation)obsStation);
            }
            arrayList.add(obsStationMappingsPanel$ObservedStationRef2);
        }
        this._networkToStationRefMap.put(rssSystem, arrayList);
        return arrayList;
    }

    final ObsStationSet getSelectedSet() {
        return this._obsStationSet;
    }

    final void fillPanel(ObsStationSet obsStationSet) {
        this._obsStationSet = obsStationSet;
        Object object = obsStationSet.getActiveStations();
        this._errorMsg = null;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        object = object.iterator();
        while (object.hasNext()) {
            ObsStation obsStation = (ObsStation)object.next();
            Object object2 = ((WQObsStation)obsStation).getNetworkElements();
            object2 = object2.iterator();
            while (object2.hasNext()) {
                Object object3;
                Object object4 = (WQObsStationNetworkElement)object2.next();
                int n = object4.getNetworkId();
                RssSystem rssSystem = this._networkMap.get(n);
                if (rssSystem == null) {
                    object3 = this._context.getManagerProxy("rss", RssSystem.class.getName(), n);
                    if (object3 != null) {
                        rssSystem = (RssSystem)object3.loadManager(null, null);
                        if (rssSystem != null) {
                            this._networkMap.put(n, rssSystem);
                            RssSystem rssSystem2 = rssSystem;
                            this._networkToElementsMap.put(rssSystem2, ObsDatasetManager.a(rssSystem2));
                        }
                    } else {
                        hashSet.add(n);
                    }
                }
                if (this._networkToStationRefMap.get(rssSystem) == null) {
                    this.initializeStationRefsForNetwork(rssSystem);
                }
                if ((object3 = (ObsStationMappingsPanel$ObservedStationRef)this._networkToStationRefMap.get(rssSystem).stream().filter(obsStationMappingsPanel$ObservedStationRef -> obsStationMappingsPanel$ObservedStationRef.a == obsStation).findFirst().orElse(null)) == null || rssSystem == null) continue;
                object4 = rssSystem.getElement(object4.getElementId());
                ((ObsStationMappingsPanel$ObservedStationRef)object3).a((Element)object4);
            }
        }
        if (hashSet.size() > 1) {
            this._errorMsg = WqI18n.a("ObsData.Mappings.Msg.FailedToFindMultipleNetworks").format((Object)obsStationSet.getName());
        } else if (hashSet.size() == 1) {
            this._errorMsg = WqI18n.a("ObsData.Mappings.Msg.FailedToFindNetwork").format((Object)obsStationSet.getName());
        }
        this._chooserNeedsRefresh = true;
        ObsStationMappingsPanel obsStationMappingsPanel = this;
        obsStationMappingsPanel.fillTable(obsStationMappingsPanel._selectedNetwork);
    }

    final boolean savePanel() {
        this.clearOldNetworkElements();
        for (Map.Entry<RssSystem, List<ObsStationMappingsPanel$ObservedStationRef>> entry : this._networkToStationRefMap.entrySet()) {
            RssSystem rssSystem = entry.getKey();
            List<ObsStationMappingsPanel$ObservedStationRef> list = entry.getValue();
            for (ObsStationMappingsPanel$ObservedStationRef obsStationMappingsPanel$ObservedStationRef : list) {
                Element element = obsStationMappingsPanel$ObservedStationRef.a();
                if (element == null) continue;
                element = new WQObsStationNetworkElement(obsStationMappingsPanel$ObservedStationRef.a().getIndex(), rssSystem.getIndex());
                obsStationMappingsPanel$ObservedStationRef.a.addNetworkElement((WQObsStationNetworkElement)element);
            }
        }
        return true;
    }

    private void clearOldNetworkElements() {
        for (ObsStation obsStation : this._obsStationSet.getStations()) {
            ((WQObsStation)obsStation).clearNetworkElements();
        }
    }

    private static /* synthetic */ boolean a(ManagerProxy managerProxy, Integer n) {
        return n.intValue() == managerProxy.getIndex();
    }
}

