/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.observeddataset;

import com.google.common.flogger.FluentLogger;
import com.vividsolutions.jts.geom.Geometry;
import hec.clientapp.client.ClientApp;
import hec.gui.MoverDialog;
import hec.io.FilePath;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.model.DataStruct;
import hec.rss.wq.client.observeddataset.ObsDataSetEditorPanel;
import hec.rss.wq.client.observeddataset.ObservedStationSetDialog$MenuListenerImpl;
import hec.rss.wq.client.observeddataset.ObservedStationSetDialog$ObsStationListCellRenderer;
import hec.rss.wq.client.observeddataset.ObservedStationSetDialog$ObsStationSetCreator;
import hec.rss.wq.client.observeddataset.ObservedStationSetDialog$ObsStationSetDeleter;
import hec.rss.wq.client.observeddataset.ObservedStationSetDialog$ObsStationSetRename;
import hec.rss.wq.client.observeddataset.ObservedStationSetDialog$ObsStationSetSaveAs;
import hec.rss.wq.model.ObsDatasetManager;
import hec.rss.wq.ui.OkApplyCancelDialog;
import hec.rss.wq.util.WqI18n;
import hec.watershed.model.Station;
import hec.watershed.model.StationSet;
import hec.watershed.model.StationSetDataObject;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.observed.ObsStation;
import hec.wqenginecore.observed.ObsVariable;
import hec.wqengineimpl.observed.WQObsStation;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import mil.army.usace.hec.rmi.io.HecFileImpl;
import rma.swing.RmaJButton;

public class ObservedStationSetDialog
extends OkApplyCancelDialog {
    private JMenuItem _deleteStationSetMenuItem;
    private JMenuItem _selectActiveStationsMenuItem;
    private JMenuItem _saveAsStationSetMenuItem;
    private ObservedStationSetDialog$ObsStationSetCreator _obsStationCreator;
    private ObservedStationSetDialog$ObsStationSetDeleter _obsStationDeleter;
    private ObservedStationSetDialog$ObsStationSetSaveAs _obsStationSaveAs;
    private ObservedStationSetDialog$ObsStationSetRename _obsStationSetRename;
    private JMenu _obsStationMenu;
    private List<ObsDatasetManager> _obsDataList = new ArrayList<ObsDatasetManager>();
    private RmaJButton _updateFromWSModuleButton;

    public ObservedStationSetDialog(Window container, Dialog.ModalityType object2) {
        super((Window)container, (JComponent)((Object)new ObsDataSetEditorPanel()), (Dialog.ModalityType)((Object)object2));
        this.addComponents();
        container = new JMenuBar();
        this.setJMenuBar((JMenuBar)container);
        this._obsStationMenu = new JMenu("Observed Dataset");
        this._obsStationMenu.addMenuListener(new ObservedStationSetDialog$MenuListenerImpl(this));
        object2 = new JMenuItem("New...");
        ((AbstractButton)object2).addActionListener(object -> {
            if (this._obsStationCreator != null) {
                object = this._obsStationCreator.createObsStationSet();
                if (object == null) {
                    return;
                }
                this._obsDataList.add((ObsDatasetManager)((Object)object));
                ((ObsDataSetEditorPanel)((Object)((Object)this._payload))).addToPanel(Collections.singletonList(object), (ObsDatasetManager)((Object)object));
            }
        });
        this._obsStationMenu.add((JMenuItem)object2);
        this._selectActiveStationsMenuItem = WqI18n.a("ObsData.SelectActive.Menu").createMenuItem();
        this._selectActiveStationsMenuItem.addActionListener(actionEvent -> this.selectActiveStations());
        this._obsStationMenu.add(this._selectActiveStationsMenuItem);
        this._saveAsStationSetMenuItem = WqI18n.a("MetData.Menu.SaveAs").createMenuItem();
        this._saveAsStationSetMenuItem.addActionListener(actionEvent -> this.saveAs());
        this._obsStationMenu.add(this._saveAsStationSetMenuItem);
        this._deleteStationSetMenuItem = new JMenuItem("Delete...");
        this._deleteStationSetMenuItem.addActionListener(actionEvent -> this.delete());
        this._obsStationMenu.add(this._deleteStationSetMenuItem);
        ((JMenuBar)container).add(this._obsStationMenu);
        this.addListeners();
    }

    private void addListeners() {
        this._updateFromWSModuleButton.addActionListener(actionEvent -> this.updateFromWSModule());
    }

    private void updateFromWSModule() {
        Object object = ((ObsDataSetEditorPanel)((Object)this._payload))._stationSet;
        if (object == null) {
            return;
        }
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), WqI18n.a("ObsData.UpdateFromWatershed.Confirm.msg").format((Object)object.getName()), WqI18n.a("ObsData.UpdateFromWatershed.Confirm.title").getText(), 0);
        if (n == 0) {
            Object object2 = (StationSetDataObject)ClientApp.Workspace().getDataListContainer().getDataList(StationSet.class.getName());
            if ((object2 = object2.getObjectArray()) != null && ((DataStruct[])object2).length > 0) {
                object2 = (StationSetDataObject)object2[0];
                object2 = object2.getStationSet();
                Object object3 = new ArrayList();
                if (object2 != null) {
                    object3 = Station::isObservedStation;
                    object2 = new ArrayList(object2.getFeatures((Predicate)object3));
                    object3 = object.getActiveStations();
                    object3.removeIf(arg_0 -> ObservedStationSetDialog.a((List)object2, arg_0));
                    object = object3.iterator();
                    while (object.hasNext()) {
                        ObsStation obsStation = (ObsStation)object.next();
                        if (!(obsStation instanceof WQObsStation)) continue;
                        obsStation = (WQObsStation)obsStation;
                        object2.stream().filter(arg_0 -> ObservedStationSetDialog.a((WQObsStation)obsStation, arg_0)).findFirst().ifPresent(arg_0 -> this.lambda$updateFromWSModule$8((WQObsStation)obsStation, arg_0));
                        obsStation.getVariables().forEach(arg_0 -> ObservedStationSetDialog.a((WQObsStation)obsStation, arg_0));
                    }
                }
                ((ObsDataSetEditorPanel)((Object)this._payload)).getSelectedObsData().getObsStationSet().setObsStations((List)object3);
                ((ObsDataSetEditorPanel)((Object)this._payload)).updateView();
                ClientApp.app().getFrame().getMapPanel().paintMap();
                ObservedStationSetDialog observedStationSetDialog = this;
                observedStationSetDialog.fillForm(observedStationSetDialog._obsDataList, ((ObsDataSetEditorPanel)((Object)this._payload)).getSelectedObsData());
                this.setModified(true);
            }
        }
    }

    private void updatedWqStationFromWatershed(WQObsStation wQObsStation, Station station) {
        wQObsStation.setName(station.getName());
        wQObsStation.setDescription(station.getDescription());
        wQObsStation.setGeometry((Geometry)station.getGeometry().clone());
        wQObsStation.setStationIconLocation(station.getStationIconLocation());
        wQObsStation.setIsProfileStation(station.isProfileStation());
        wQObsStation.setStreamStation(station.getStreamStation());
        wQObsStation.setNearestMeridian(station.getNearestMeridian());
        wQObsStation.setLatitude(station.getLatitude());
        wQObsStation.setLongitude(station.getLongitude());
        wQObsStation.setReferenceElevation(station.getElevation());
        wQObsStation.setIsMetStation(station.isMetStation());
        wQObsStation.setIsObserved(station.isObservedStation());
        wQObsStation.setStreamName(station.getStreamName());
    }

    private void addComponents() {
        this._updateFromWSModuleButton = new RmaJButton(WqI18n.a("ObsData.Button.UpdateFromWatershed").getText());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.gridwidth = -1;
        this._buttonCmdPanel.add((Component)this._updateFromWSModuleButton, (Object)gridBagConstraints);
    }

    private void updateToSimulationMenu() {
        this._selectActiveStationsMenuItem.setVisible(true);
        this._selectActiveStationsMenuItem.setEnabled(true);
        for (int i = 0; i < this._obsStationMenu.getMenuComponentCount(); ++i) {
            if (this._obsStationMenu.getItem(i) == this._selectActiveStationsMenuItem) continue;
            this._obsStationMenu.getItem(i).setVisible(false);
        }
    }

    private void delete() {
        if (this._obsStationDeleter != null) {
            Object object = ((ObsDataSetEditorPanel)((Object)this._payload)).getSelectedObsData();
            if ((object = this._obsStationDeleter.deleteObsStationSet((ObsDatasetManager)object)) == null || object.isEmpty()) {
                return;
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                for (int i = this._obsDataList.size() - 1; i >= 0; --i) {
                    if (!this._obsDataList.get(i).getName().equalsIgnoreCase(string)) continue;
                    this._obsDataList.remove(i);
                }
            }
            ((ObsDataSetEditorPanel)((Object)this._payload)).removeFromPanel((List<String>)object);
        }
    }

    private void rename() {
        if (this._obsStationSetRename != null) {
            ObsDatasetManager obsDatasetManager;
            ObsDatasetManager obsDatasetManager2 = obsDatasetManager = ((ObsDataSetEditorPanel)((Object)this._payload)).getSelectedObsData();
            obsDatasetManager = this._obsStationSetRename.renameObsStationSet(obsDatasetManager2, obsDatasetManager2.getName(), ((ObsDataSetEditorPanel)((Object)this._payload)).getCurrentDescription());
            if (obsDatasetManager == null) {
                return;
            }
            ((ObsDataSetEditorPanel)((Object)this._payload)).updateCurrentRenamed();
        }
    }

    private void saveAs() {
        if (this._obsStationSaveAs != null) {
            int n;
            String string;
            ObsDatasetManager obsDatasetManager = ((ObsDataSetEditorPanel)((Object)this._payload)).getSelectedObsData();
            boolean bl = false;
            Identifier identifier = obsDatasetManager.getIdentifier();
            if (obsDatasetManager.isModified()) {
                try {
                    File file = File.createTempFile("ObsData" + Long.toString(System.currentTimeMillis()), null);
                    file.delete();
                    string = file.getAbsolutePath();
                    identifier = new Identifier(string, (HecFile)new HecFileImpl(new FilePath(string)));
                    obsDatasetManager.writeFile(identifier);
                }
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                }
            }
            if (this.isModified() && (n = JOptionPane.showConfirmDialog(this._payload, obsDatasetManager.toString() + " has changed.\nWould you like to save?", "Save", 0)) == 0) {
                bl = true;
            }
            ((ObsDataSetEditorPanel)((Object)this._payload)).savePanel();
            this.setModified(false);
            ObsDatasetManager obsDatasetManager2 = obsDatasetManager;
            ObsDatasetManager obsDatasetManager3 = this._obsStationSaveAs.saveAsObsStationSet(obsDatasetManager2, obsDatasetManager2.getName(), ((ObsDataSetEditorPanel)((Object)this._payload)).getCurrentDescription());
            if (!bl) {
                obsDatasetManager.readFile(identifier);
            }
            if (obsDatasetManager3 == null) {
                return;
            }
            string = ClientApp.Workspace();
            if (string != null) {
                string.saveWorkspace();
            }
            this._obsDataList.add(obsDatasetManager3);
            ((ObsDataSetEditorPanel)((Object)this._payload)).clearPanel();
            ((ObsDataSetEditorPanel)((Object)this._payload)).addToPanel(Collections.singletonList(obsDatasetManager3), obsDatasetManager3);
        }
    }

    public void addNewObsStationCreator(ObservedStationSetDialog$ObsStationSetCreator observedStationSetDialog$ObsStationSetCreator) {
        this._obsStationCreator = observedStationSetDialog$ObsStationSetCreator;
    }

    public void addObsStationDeleter(ObservedStationSetDialog$ObsStationSetDeleter observedStationSetDialog$ObsStationSetDeleter) {
        this._obsStationDeleter = observedStationSetDialog$ObsStationSetDeleter;
    }

    public void addObsStationRename(ObservedStationSetDialog$ObsStationSetRename observedStationSetDialog$ObsStationSetRename) {
        this._obsStationSetRename = observedStationSetDialog$ObsStationSetRename;
    }

    public void addSaveAsObsStation(ObservedStationSetDialog$ObsStationSetSaveAs observedStationSetDialog$ObsStationSetSaveAs) {
        this._obsStationSaveAs = observedStationSetDialog$ObsStationSetSaveAs;
    }

    public void fillForm(List<ObsDatasetManager> list, ObsDatasetManager obsDatasetManager) {
        this._obsDataList = list;
        ((ObsDataSetEditorPanel)((Object)this._payload)).fillPanel(list, obsDatasetManager);
        this._updateFromWSModuleButton.setEnabled(list != null && !list.isEmpty());
    }

    public void fillFormForSimulation(List<ObsDatasetManager> list, ObsDatasetManager obsDatasetManager) {
        this.updateToSimulationMenu();
        this._obsDataList = list;
        ((ObsDataSetEditorPanel)((Object)this._payload)).fillPanel(list, obsDatasetManager);
        this._updateFromWSModuleButton.setEnabled(list != null && !list.isEmpty());
    }

    public void saveForm() {
        ((ObsDataSetEditorPanel)((Object)this._payload)).savePanel();
    }

    public void setSelectedStation(WQObsStation wQObsStation) {
        ((ObsDataSetEditorPanel)((Object)this._payload)).setSelectedStation(wQObsStation);
    }

    public ObsDatasetManager getSelectedObsData() {
        return ((ObsDataSetEditorPanel)((Object)this._payload)).getSelectedObsData();
    }

    private void selectActiveStations() {
        Object[] objectArray;
        Object object;
        if (((ObsDataSetEditorPanel)((Object)this._payload))._stationSet == null) {
            return;
        }
        Object object2 = (StationSetDataObject)ClientApp.Workspace().getDataListContainer().getDataList("hec.watershed.model.StationSet");
        object2 = object2.getObjectArray();
        object2 = (StationSetDataObject)object2[0];
        object2 = object2.getStationSet();
        Object object3 = Station::isObservedStation;
        object2 = new ArrayList(object2.getFeatures(object3));
        object3 = new MoverDialog((JDialog)((Object)this), true, "Set Active Observed Stations");
        object3.setAvailableListLabel("Inactive Obs Stations");
        object3.setSelectedListLabel("Active Obs Stations");
        object3.setSelectionType(100);
        object3.setDescVisible(false);
        List object4 = ((ObsDataSetEditorPanel)((Object)this._payload))._stationSet.getStations();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            object = (Station)object2.next();
            objectArray = ((ObsDataSetEditorPanel)((Object)this._payload)).getSelectedObsData().getObsStationSet();
            if (!objectArray.getStations().stream().noneMatch(arg_0 -> ObservedStationSetDialog.a((Station)object, arg_0))) continue;
            objectArray.addStation(this.createWQObsStation((Station)object));
        }
        object2 = object4.stream().filter(WQObsStation.class::isInstance).map(WQObsStation.class::cast).collect(Collectors.toSet());
        object = object2.stream().filter(WQObsStation::isActive).collect(Collectors.toSet());
        object3.setSelectedCellRenderer((ListCellRenderer)new ObservedStationSetDialog$ObsStationListCellRenderer());
        object3.setAvailableCellRenderer((ListCellRenderer)new ObservedStationSetDialog$ObsStationListCellRenderer());
        object3.clearForm();
        object3.setData(Arrays.asList(object2.toArray()), Arrays.asList(object.toArray()));
        object3.setLocationRelativeTo((Component)((Object)this));
        object3.setVisible(true);
        if (!object3.isCanceled()) {
            objectArray = object3.getSelectedObjects();
            object2 = object3.getAvailableObjects();
            object3 = ((ObsDataSetEditorPanel)((Object)this._payload)).getSelectedObsData();
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object5 = objectArray2[i];
                if (!(object5 instanceof WQObsStation)) continue;
                object5 = (WQObsStation)object5;
                if (((ObsDatasetManager)object3).getObsStationSet().getActiveStations().stream().noneMatch(arg_0 -> ObservedStationSetDialog.b((WQObsStation)object5, arg_0))) {
                    ((ObsDatasetManager)object3).getObsStationSet().getStations().stream().filter(arg_0 -> ObservedStationSetDialog.a((WQObsStation)object5, arg_0)).findFirst().ifPresent(obsStation -> obsStation.isActive());
                }
                object5.setActive(true);
            }
            for (Object object5 : object2) {
                if (!(object5 instanceof WQObsStation)) continue;
                object5 = (WQObsStation)object5;
                object5.setActive(false);
            }
            ((ObsDataSetEditorPanel)((Object)this._payload)).updateView();
            ClientApp.app().getFrame().getMapPanel().paintMap();
            ObservedStationSetDialog observedStationSetDialog = this;
            observedStationSetDialog.fillForm(observedStationSetDialog._obsDataList, ((ObsDataSetEditorPanel)((Object)this._payload)).getSelectedObsData());
            this.setModified(true);
        }
    }

    private WQObsStation createWQObsStation(Station station) {
        WQObsStation wQObsStation = new WQObsStation();
        wQObsStation.setActive(false);
        this.updatedWqStationFromWatershed(wQObsStation, station);
        return wQObsStation;
    }

    private static /* synthetic */ boolean a(WQObsStation wQObsStation, ObsStation obsStation) {
        return obsStation.getName().equalsIgnoreCase(wQObsStation.getName());
    }

    private static /* synthetic */ boolean b(WQObsStation wQObsStation, ObsStation obsStation) {
        return obsStation.getName().equalsIgnoreCase(wQObsStation.getName());
    }

    private static /* synthetic */ boolean a(Station station, ObsStation obsStation) {
        return obsStation.getName().equalsIgnoreCase(station.getName());
    }

    private static /* synthetic */ void a(WQObsStation wQObsStation, ObsVariable obsVariable) {
        obsVariable.getDataSources().stream().filter(data -> data instanceof DssData).findFirst().ifPresent(data -> ((DssData)data).setIsProfile(wQObsStation.isProfileStation()));
    }

    private /* synthetic */ void lambda$updateFromWSModule$8(WQObsStation wQObsStation, Station station) {
        this.updatedWqStationFromWatershed(wQObsStation, station);
    }

    private static /* synthetic */ boolean a(WQObsStation wQObsStation, Station station) {
        return station.getName().equalsIgnoreCase(wQObsStation.getName());
    }

    private static /* synthetic */ boolean a(List list, ObsStation obsStation) {
        return list.stream().noneMatch(station -> station.getName().equalsIgnoreCase(obsStation.getName()));
    }

    static {
        FluentLogger.forEnclosingClass();
    }
}

