/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.results;

import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.TimeSeriesDataSet;
import hec.heclib.util.HecTime;
import hec.io.TimeSeriesContainer;
import hec.rss.wq.client.results.ColdWaterPoolVolumeDialog$1;
import hec.rss.wq.client.results.ColdWaterPoolVolumeDialog$PiecewisePredicate;
import hec.rss.wq.client.results.ColdWaterPoolVolumeDialog$ReservoirActionListener;
import hec.rss.wq.client.results.ColdWaterPoolVolumeDialog$ReservoirElevationStorageProvider;
import hec.rss.wq.client.results.ColdWaterPoolVolumeDialog$SimpleReservoirElevationProvider;
import hec.rss.wq.client.results.ColdWaterPoolVolumeDialog$SliderScaleToTempFunction;
import hec.rss.wq.client.results.WaterQualityColdWaterPoolData;
import hec.rss.wq.model.pv.CurryFunction;
import hec.rss.wq.model.pv.DiscreteFunctionLookup;
import hec.rss.wq.model.pv.PairedDataContinuousFunction;
import hec.rss.wq.model.pv.PiecewiseFunction;
import hec.rss.wq.ui.FileChooserField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.function.Function;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.list.RmaListModel;
import rma.util.RMAIO;

public class ColdWaterPoolVolumeDialog
extends RmaJDialog {
    private ColdWaterPoolVolumeDialog$ReservoirElevationStorageProvider _elevationStorageProvider;
    private File _outputFile;
    Function<Object, Double> _coldPoolFunction;
    Function<Double, Double> _sliderScaleToTempFunction;
    CurryFunction _thresholdTemperature;
    private String _temperatureUnits;
    private double _minStorage;
    private double _maxStorage;
    private FileChooserField _fileChooserField;
    private RmaJComboBox<String> _reservoirComboBox;
    private G2dPanel _plotPanel;
    private JSlider _temperatureSlider;
    WaterQualityColdWaterPoolData data = null;
    boolean fillForm = false;
    double _zoomMax = Double.NEGATIVE_INFINITY;
    double _zoomMin = Double.NEGATIVE_INFINITY;

    public ColdWaterPoolVolumeDialog(Window window, boolean bl) {
        super(window, bl);
        this.setTitle("Cold Water Pool Volume");
        this.buildComponents();
    }

    private void buildComponents() {
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Water Quality Output");
        container.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, RmaInsets.INSETS5500, 0, 0));
        this._fileChooserField = new FileChooserField();
        container.add((Component)((Object)this._fileChooserField), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, RmaInsets.INSETS5505, 0, 0));
        this._fileChooserField.setEnabled(false);
        this._reservoirComboBox = new RmaJComboBox();
        this._reservoirComboBox.addActionListener((ActionListener)new ColdWaterPoolVolumeDialog$ReservoirActionListener(this));
        jLabel = new JLabel("Reservoir Names");
        container.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, RmaInsets.INSETS5505, 0, 0));
        container.add((Component)this._reservoirComboBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, RmaInsets.INSETS5505, 0, 0));
        this._plotPanel = new ColdWaterPoolVolumeDialog$1(this);
        this._plotPanel.buildDefaultComponents();
        container.add((Component)this._plotPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, RmaInsets.INSETS5555, 0, 0));
        this._temperatureSlider = new JSlider();
        this._temperatureSlider.addChangeListener(changeEvent -> this.tempSliderChanged());
        this._temperatureSlider.setBorder(new TitledBorder("Threshold Temperature Selector"));
        container.add((Component)this._temperatureSlider, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 15, 2, RmaInsets.INSETS5555, 0, 0));
    }

    public void setData(File file, List<String> list, ColdWaterPoolVolumeDialog$ReservoirElevationStorageProvider coldWaterPoolVolumeDialog$ReservoirElevationStorageProvider, String string) {
        this._outputFile = file;
        this._fileChooserField.setText(this._outputFile.getAbsolutePath());
        this.data = new WaterQualityColdWaterPoolData(this._outputFile);
        this._elevationStorageProvider = coldWaterPoolVolumeDialog$ReservoirElevationStorageProvider;
        this._reservoirComboBox.setModel((ComboBoxModel)new RmaListModel(true, list));
        if (string != null && !string.isEmpty()) {
            this._reservoirComboBox.setSelectedItem((Object)string);
            return;
        }
        this._reservoirComboBox.setSelectedIndex(list.size() > 0 ? 0 : -1);
    }

    private void tempSliderChanged() {
        if (this.fillForm) {
            return;
        }
        double d = this._sliderScaleToTempFunction.apply(Double.valueOf(this._temperatureSlider.getValue()));
        d = RMAIO.round((double)d, (int)1);
        this._thresholdTemperature.a(d);
        this._zoomMin = this._plotPanel.getAxisTics(2).getAxis().getActMin();
        this._zoomMax = this._plotPanel.getAxisTics(2).getAxis().getActMax();
        this.plotFunction(d, this._temperatureUnits, this.data.a, this._coldPoolFunction, false);
    }

    private void fillForm(String object) throws IOException {
        this.fillForm = true;
        try {
            String string;
            Object object2 = this.data.getElevations((String)object);
            Object object3 = this.data.getWaterSurfaceElevations((String)object);
            Object[] objectArray = this.data.getElevationTemperatureDates();
            double[][] dArray = this.data.getElevationTemperatures((String)object);
            this._temperatureUnits = string = this.data.getTemperatureUnits((String)object);
            double d2 = Double.MAX_VALUE;
            double d3 = Double.MIN_VALUE;
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray[i].length; ++j) {
                    if (dArray[i][j] == -9999.0 || !(object2[j] < object3[i])) continue;
                    d2 = Double.min(d2, dArray[i][j]);
                    d3 = Double.max(d3, dArray[i][j]);
                }
            }
            double[] dArray2 = this.data.getWaterSurfaceElevations((String)object);
            double[][] dArray3 = this._elevationStorageProvider.getElevationStorage((String)object);
            object = new PairedDataContinuousFunction(dArray3[0], dArray3[1]);
            this._minStorage = dArray3[1][0];
            this._zoomMax = this._maxStorage = dArray3[1][dArray3[1].length - 1];
            this._zoomMin = this._minStorage;
            object3 = new ArrayList();
            int n = 0;
            while (n < dArray.length) {
                Function<Double, Double> function = new PairedDataContinuousFunction(dArray[n], (double[])object2);
                int n2 = n++;
                ColdWaterPoolVolumeDialog$PiecewisePredicate coldWaterPoolVolumeDialog$PiecewisePredicate = new ColdWaterPoolVolumeDialog$PiecewisePredicate(dArray[n2]);
                Function<Double, Double> function2 = d -> dArray2[n2];
                function = new PiecewiseFunction<Double, Double>(coldWaterPoolVolumeDialog$PiecewisePredicate, function2, function);
                object3.add(function);
            }
            object2 = new DiscreteFunctionLookup(objectArray, object3);
            this._thresholdTemperature = new CurryFunction(d2);
            this._coldPoolFunction = object2.andThen(this._thresholdTemperature).andThen(object);
            this.plotFunction(d2, string, (HecTime[])objectArray, this._coldPoolFunction, true);
            this._temperatureSlider.setMinimum(0);
            this._temperatureSlider.setMaximum(100);
            this._temperatureSlider.setValue(0);
            this._sliderScaleToTempFunction = new ColdWaterPoolVolumeDialog$SliderScaleToTempFunction(this._temperatureSlider.getMinimum(), this._temperatureSlider.getMaximum(), d2, d3);
            return;
        }
        finally {
            this.fillForm = false;
        }
    }

    private void plotFunction(double d, String object, HecTime[] g2dLineProperties, Function<Object, Double> function, boolean bl) {
        object = new double[((HecTime[])g2dLineProperties).length];
        long[] lArray = new long[((HecTime[])g2dLineProperties).length];
        int n = 0;
        TimeSeriesContainer timeSeriesContainer = new TimeSeriesContainer();
        for (HecTime hecTime : g2dLineProperties) {
            if (hecTime == null) continue;
            lArray[n] = hecTime.value();
            Double d2 = function.apply(hecTime);
            object[n++] = d2 != null ? d2 : -3.4028234663852886E38;
        }
        timeSeriesContainer.set((double[])object, lArray);
        timeSeriesContainer.units = "Storage(ac-ft)";
        g2dLineProperties = new G2dLineProperties();
        g2dLineProperties.setDrawLine(false);
        g2dLineProperties.setDrawPoints(true);
        g2dLineProperties.setPointLineColor(Color.red);
        g2dLineProperties.setSymbolType(33);
        Vector<G2dLineProperties> vector = new Vector<G2dLineProperties>();
        vector.add(g2dLineProperties);
        TimeSeriesDataSet timeSeriesDataSet = new TimeSeriesDataSet(timeSeriesContainer);
        timeSeriesDataSet.setName("Cold Water Pool Storage at or below " + d + " " + this._temperatureUnits);
        double d3 = this._plotPanel.getAxisTics(2).getAxis().getViewMin();
        double d4 = this._plotPanel.getAxisTics(2).getAxis().getViewMax();
        double d5 = this._plotPanel.getAxisTics(0).getAxis().getViewMin();
        double d6 = this._plotPanel.getAxisTics(0).getAxis().getViewMax();
        this._plotPanel.setVisible(false);
        this._plotPanel.buildComponents(Collections.singletonList(timeSeriesDataSet), vector);
        this._plotPanel.getAxisTics(2).getAxis().setMinMax(this._minStorage, this._maxStorage);
        this._plotPanel.getAxisTics(2).getAxis().computeTicInterval();
        if (!bl) {
            this._plotPanel.getAxisTics(2).getAxis().zoomIn(d3, d4);
            this._plotPanel.getAxisTics(0).getAxis().zoomIn(d5, d6);
            this._plotPanel.getAxisTics(2).getAxis().setAutomaticMaximumOff();
            this._plotPanel.getAxisTics(2).getAxis().setAutomaticMinimumOff();
        }
        this._plotPanel.setVisible(true);
    }

    public static void a(String[] object) {
        object = new ColdWaterPoolVolumeDialog(null, true);
        object.setData(new File("J:\\temp\\WaterQuality\\WS05_HEC_RussianRiver\\rss\\S1\\rss\\RT-Normal-0.h5"), Arrays.asList("Lake Mendocino", "Lake Sonoma"), new ColdWaterPoolVolumeDialog$SimpleReservoirElevationProvider(), "");
        object.setLocation(500, 500);
        object.setSize(500, 500);
        object.setVisible(true);
    }
}

