/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.results;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.client.ClientApp;
import hec.clientapp.model.TSRecordProxy;
import hec.data.TimeWindow;
import hec.data.Units;
import hec.gfx2d.PlotLayout;
import hec.gfx2d.TimeSeriesDataSet;
import hec.heclib.dss.CondensedReference;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.io.DSSIdentifier;
import hec.io.TimeSeriesContainer;
import hec.model.RunTimeWindow;
import hec.model.TSLocation;
import hec.rss.model.JunctionElement;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssNode;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.wq.client.results.AbstractTimeSeriesResultsDialog;
import hec.rss.wq.client.results.DssTimeSeriesResultsDialog$DisplayConstituentAction;
import hec.rss.wq.model.AltWaterQualityOptions;
import hec.rss.wq.model.ConstituentSetManager;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.ConstituentSet;
import java.awt.Component;
import java.awt.Frame;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import mil.army.usace.hec.metadata.UnitUtil;

public class DssTimeSeriesResultsDialog
extends AbstractTimeSeriesResultsDialog {
    private static final FluentLogger a = FluentLogger.forEnclosingClass();
    private RunTimeWindow _runTimeWindow;
    private JunctionElement _elem;
    private DssTimeSeriesResultsDialog$DisplayConstituentAction _displayConstituentAction;
    private Vector<RssRun> _rssRuns;
    SimpleDateFormat _dateFormat = new SimpleDateFormat("ddMMMyyyy, HH:mm");

    public DssTimeSeriesResultsDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
    }

    public void setData(Vector<RssRun> serializable, JunctionElement object) throws IOException {
        ConstituentSet constituentSet;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this._rssRuns = serializable;
        this._elem = object;
        object = new HashSet();
        serializable = ((Vector)serializable).iterator();
        while (serializable.hasNext()) {
            object5 = (RssRun)serializable.next();
            ((RssRun)object5).getNetwork().updateTSProxyList();
            object4 = ((RssRun)object5).getAlternative();
            if (object4 != null) {
                object3 = ((RssAlt)object4).getWaterQualityOptions();
                object2 = ((AltWaterQualityOptions)object3).getConstituentSetManager((RssAlt)object4);
                constituentSet = ((ConstituentSetManager)((Object)object2)).getSet();
                object.addAll(constituentSet.getConstituentList());
            }
            object3 = ((RssRun)object5).getRunTimeWindow();
            if (this._runTimeWindow == null) {
                this._runTimeWindow = object3;
                continue;
            }
            if (object3.getStartTime().compareTo((Object)this._runTimeWindow.getStartTime()) < 0) {
                this._runTimeWindow.setStartTime(object3.getStartTime());
            }
            if (object3.getEndTime().compareTo((Object)this._runTimeWindow.getEndTime()) <= 0) continue;
            this._runTimeWindow.setEndTime(object3.getEndTime());
        }
        serializable = new ArrayList(object);
        object5 = serializable.stream().filter(Constituent::getIsAdvected).collect(Collectors.toList());
        try {
            object4 = new JMenu(WqI18n.a("WQDssTSResultsPanel.Menu.Constituent.Name").getText());
            this.getJMenuBar().add((JMenu)object4);
            object3 = new ArrayList();
            this._displayConstituentAction = new DssTimeSeriesResultsDialog$DisplayConstituentAction(this, (List<Constituent>)object5);
            object2 = object5.iterator();
            while (object2.hasNext()) {
                constituentSet = (Constituent)object2.next();
                serializable = new JCheckBoxMenuItem(constituentSet.getDisplayName());
                object3.add(serializable);
                ((JMenu)object4).add((JMenuItem)serializable);
                ((AbstractButton)serializable).addActionListener(this._displayConstituentAction);
                this._displayConstituentAction.a((JCheckBoxMenuItem)serializable);
            }
            this.selectDefault((List<JCheckBoxMenuItem>)object3, (List<Constituent>)object5);
            return;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage(), exception);
        }
    }

    private void selectDefault(List<JCheckBoxMenuItem> list, List<Constituent> list2) {
        for (int i = 0; i < list.size(); ++i) {
            if (!"Water Temperature".equalsIgnoreCase(list2.get(i).getDisplayName())) continue;
            list.get(i).setSelected(true);
            this._displayConstituentAction.actionPerformed(null);
            return;
        }
        if (!list.isEmpty()) {
            list.get(0).setSelected(true);
            this._displayConstituentAction.actionPerformed(null);
        }
    }

    private Date toDate(HecTime hecTime) {
        try {
            return this._dateFormat.parse(hecTime.dateAndTime(4));
        }
        catch (ParseException parseException) {
            ((FluentLogger.Api)((FluentLogger.Api)a.atWarning()).withCause((Throwable)parseException)).log("Error converting HecTime" + String.valueOf(hecTime));
            return null;
        }
    }

    private void plotConstituent(List<Constituent> object) {
        RssAlt rssAlt;
        PlotLayout plotLayout = new PlotLayout();
        for (RssRun rssRun : this._rssRuns) {
            Object object2 = rssRun.getNetwork();
            if (object2 == null || (rssAlt = rssRun.getAlternative()) == null) continue;
            ((RssSystem)object2).updateTSProxyList();
            object2 = rssAlt.getWaterQualityOptions();
            Collection collection = ((AltWaterQualityOptions)object2).getConstituentSetManager(rssAlt).getSet().getConstituentList();
            rssRun.getNetwork().addWQModelVariables(collection);
        }
        Iterator<RssRun> iterator = object.iterator();
        while (iterator.hasNext()) {
            RssRun rssRun;
            rssRun = (Constituent)iterator.next();
            rssAlt = plotLayout.addViewport();
            for (RssRun rssRun2 : this._rssRuns) {
                object = this.findModelTsRecordProxy(rssRun2, (Constituent)rssRun);
                DssTimeSeriesResultsDialog dssTimeSeriesResultsDialog = this;
                Object object3 = dssTimeSeriesResultsDialog.toDate(dssTimeSeriesResultsDialog._runTimeWindow.getLookbackTime());
                DssTimeSeriesResultsDialog dssTimeSeriesResultsDialog2 = this;
                Cloneable cloneable = dssTimeSeriesResultsDialog2.toDate(dssTimeSeriesResultsDialog2._runTimeWindow.getEndTime());
                object3 = new TimeWindow((Date)object3, true, (Date)cloneable, true);
                cloneable = new ArrayList();
                if (object == null || object.getDSSPathname().isEmpty()) {
                    JOptionPane.showMessageDialog((Component)((Object)this), WqI18n.a("WQObsTSResultsPanel.NoModelData.Label").format(new Object[]{this._elem.getName(), rssRun.getDisplayName()}), WqI18n.a("WQObsTSResultsPanel.NoModelData.Title").getText(), 2);
                } else if ((object = this.buildTimeSeriesDataSet(rssRun2, (TSRecordProxy)object, (TimeWindow)object3, (Constituent)rssRun)) != null) {
                    cloneable.add(object);
                }
                cloneable.removeIf(timeSeriesDataSet -> timeSeriesDataSet.getXValues() == null || timeSeriesDataSet.getXValues().length == 0);
                object = UnitUtil.getBestMatch((String)rssRun.getUnit());
                int n = UnitUtil.getUnitSystemForUnits((String)object);
                int n2 = ClientApp.Workspace().getUnitSystem();
                object3 = n2 == 1 ? "English" : "SI";
                Object object4 = object;
                try {
                    object4 = UnitUtil.getUnitsInUnitSystem((String)object3, (String)object);
                }
                catch (Exception exception) {
                    ((FluentLogger.Api)((FluentLogger.Api)a.atWarning()).withCause((Throwable)exception)).log("Error converting units");
                }
                object = cloneable.iterator();
                while (object.hasNext()) {
                    object3 = (TimeSeriesDataSet)object.next();
                    Units.convertUnits((TimeSeriesContainer)((TimeSeriesDataSet)object3)._timeSeries, (int)n);
                    rssAlt.addCurve("Y1", object3);
                    if (!object3.getYAxisName().contains("%S")) continue;
                    object3 = object3.getYAxisName().replace("%S", (CharSequence)object4);
                    rssAlt.setAxisLabel("Y1", (String)object3);
                }
            }
        }
        this._gfxPanel.setVisible(false);
        this._gfxPanel.removeAll();
        this._gfxPanel.buildComponents(plotLayout);
        this._gfxPanel.setVisible(true);
    }

    private TSRecordProxy findModelTsRecordProxy(RssRun rssRun, Constituent constituent) {
        TSRecordProxy tSRecordProxy = null;
        if (rssRun != null) {
            int n = constituent.getId();
            n += 2000;
            Object object = this._elem.getDownstreamNode();
            if (object == null) {
                object = this._elem.getUpstreamNode();
            }
            if (object != null) {
                String string = rssRun.getDSSOutputFile();
                tSRecordProxy = ((RssNode)object).getTSRecordProxy(n);
                if (tSRecordProxy == null) {
                    tSRecordProxy = RssModelVariableSet.newTSRecordProxy(rssRun.getNetwork(), (TSLocation)object, n);
                }
                if (tSRecordProxy != null) {
                    try {
                        Object object2 = new ArrayList(rssRun.getDSSFileManager().getCondensedCatalog(string));
                        object2 = object2.iterator();
                        while (object2.hasNext()) {
                            object = (CondensedReference)object2.next();
                            object = object.getNominalPathname();
                            DSSPathname dSSPathname = new DSSPathname((String)object);
                            if (!this._elem.getName().equalsIgnoreCase(dSSPathname.getBPart()) || !dSSPathname.getFPart().equalsIgnoreCase(rssRun.getName()) || !dSSPathname.getCPart().equalsIgnoreCase(tSRecordProxy.getParamName())) continue;
                            tSRecordProxy.setDSSPathname((String)object);
                            tSRecordProxy.setDSSFilename(string);
                            break;
                        }
                    }
                    catch (RemoteException remoteException) {
                        ((FluentLogger.Api)((FluentLogger.Api)a.atWarning()).withCause((Throwable)remoteException)).log("Error reading dss pathnames from " + string);
                    }
                }
            }
        }
        return tSRecordProxy;
    }

    private TimeSeriesDataSet buildTimeSeriesDataSet(RssRun rssRun, TSRecordProxy object, TimeWindow timeWindow, Constituent constituent) {
        TimeSeriesDataSet timeSeriesDataSet = null;
        if (object != null && rssRun != null) {
            String string = rssRun.getDSSOutputFile();
            object = object.getDSSPathname();
            object = new DSSIdentifier(string, (String)object);
            object.setTimeWindow(new HecTime(timeWindow.getStartDate(), 0), new HecTime(timeWindow.getEndDate(), 0));
            try {
                timeWindow = rssRun.getDSSFileManager().readTS((DSSIdentifier)object, false);
                timeSeriesDataSet = new TimeSeriesDataSet((TimeSeriesContainer)timeWindow);
                timeSeriesDataSet.setName(constituent.getDisplayName() + " - " + rssRun.getName());
            }
            catch (FileNotFoundException | RemoteException iOException) {
                ((FluentLogger.Api)((FluentLogger.Api)a.atWarning()).withCause((Throwable)iOException)).log("Error reading " + String.valueOf(object));
            }
        }
        return timeSeriesDataSet;
    }
}

