/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.results;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.data.Parameter;
import hec.data.TimeWindow;
import hec.data.Units;
import hec.gfx2d.PlotLayout;
import hec.gfx2d.TimeSeriesDataSet;
import hec.heclib.dss.CondensedReference;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.io.DSSIdentifier;
import hec.io.TimeSeriesContainer;
import hec.model.RunTimeWindow;
import hec.model.TSLocation;
import hec.model.TSRecord;
import hec.rss.model.Element;
import hec.rss.model.ReachElement;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssNode;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.wq.client.results.AbstractTimeSeriesResultsDialog;
import hec.rss.wq.client.results.ObservedTimeSeriesResultsDialog$DisplayConstituentAction;
import hec.rss.wq.client.results.ResultsPanel;
import hec.rss.wq.dataSources.DataSourceFactory;
import hec.rss.wq.model.WQRun;
import hec.rss.wq.ui.ParameterMap;
import hec.rss.wq.ui.TimeSeriesDataSource;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.WQException;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.observed.ObsVariable;
import hec.wqengineimpl.observed.WQObsConstituentVariable;
import hec.wqengineimpl.observed.WQObsStation;
import hec.wqengineimpl.observed.WQObsStationNetworkElement;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import mil.army.usace.hec.metadata.UnitUtil;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import rma.util.RMAIO;

public class ObservedTimeSeriesResultsDialog
extends AbstractTimeSeriesResultsDialog {
    private static final FluentLogger a = FluentLogger.forEnclosingClass();
    WQObsStation _wqStation;
    private RunTimeWindow _runTimeWindow;
    private TSDataSet _obsDataSet;
    private ObservedTimeSeriesResultsDialog$DisplayConstituentAction _displayConstituentAction;
    private RssRun _rssRun;
    SimpleDateFormat _dateFormat = new SimpleDateFormat("ddMMMyyyy, HH:mm");

    public ObservedTimeSeriesResultsDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
    }

    public void setData(WQObsStation object, RssRun serializable, RunTimeWindow object2) throws IOException {
        this._wqStation = object;
        this._rssRun = serializable;
        this._runTimeWindow = object2;
        try {
            object = new JMenu(WqI18n.a("WQObsTSResultsPanel.Menu.Constituent.Name").getText());
            this.getJMenuBar().add((JMenu)object);
            serializable = new ArrayList();
            object2 = this._wqStation.getVariables();
            ObservedTimeSeriesResultsDialog observedTimeSeriesResultsDialog = this;
            this._displayConstituentAction = new ObservedTimeSeriesResultsDialog$DisplayConstituentAction(observedTimeSeriesResultsDialog, observedTimeSeriesResultsDialog._wqStation.getVariables());
            for (int i = 0; i < object2.size(); ++i) {
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(((ObsVariable)object2.get(i)).getDisplayName());
                serializable.add(jCheckBoxMenuItem);
                ((JMenu)object).add(jCheckBoxMenuItem);
                jCheckBoxMenuItem.addActionListener(this._displayConstituentAction);
                this._displayConstituentAction.a(jCheckBoxMenuItem);
            }
            this.selectDefault((List<JCheckBoxMenuItem>)((Object)serializable), (List<ObsVariable>)object2);
            return;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage(), exception);
        }
    }

    private void selectDefault(List<JCheckBoxMenuItem> list, List<ObsVariable> list2) {
        for (int i = 0; i < list.size(); ++i) {
            if (!"Water Temperature".equalsIgnoreCase(list2.get(i).getDisplayName())) continue;
            list.get(i).setSelected(true);
            this._displayConstituentAction.actionPerformed(null);
            return;
        }
        if (!list.isEmpty()) {
            list.get(0).setSelected(true);
            this._displayConstituentAction.actionPerformed(null);
        }
    }

    public void setObsTSDataSet(TSDataSet tSDataSet) {
        this._obsDataSet = tSDataSet;
    }

    private Date toDate(HecTime hecTime) {
        try {
            return this._dateFormat.parse(hecTime.dateAndTime(4));
        }
        catch (ParseException parseException) {
            ((FluentLogger.Api)((FluentLogger.Api)a.atWarning()).withCause((Throwable)parseException)).log("Error converting HecTime" + String.valueOf(hecTime));
            return null;
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void plotConstituent(List<ObsVariable> object) {
        Object object2;
        Object object32;
        Object object4;
        PlotLayout plotLayout = new PlotLayout();
        RssSystem rssSystem = null;
        if (this._rssRun != null) {
            rssSystem = this._rssRun.getNetwork();
        }
        if (rssSystem != null) {
            rssSystem.updateTSProxyList();
            object4 = this._rssRun.getAlternative();
            if (object4 != null) {
                object32 = ((RssAlt)object4).getWaterQualityOptions();
                object2 = object32.getConstituentSetManager((RssAlt)object4).getSet().getConstituentList();
                this._rssRun.getNetwork().addWQModelVariables((Collection<Constituent>)object2);
            }
        }
        object4 = object.iterator();
        while (object4.hasNext()) {
            Object object5;
            int n;
            Object object6;
            object32 = (ObsVariable)object4.next();
            object2 = this.getModelTSRecordProxy(rssSystem, (ObsVariable)object32);
            object = object32.getSelectedData();
            if (!((object = DataSourceFactory.a((Data)object)) instanceof TimeSeriesDataSource)) continue;
            ObservedTimeSeriesResultsDialog observedTimeSeriesResultsDialog = this;
            Object object7 = observedTimeSeriesResultsDialog.toDate(observedTimeSeriesResultsDialog._runTimeWindow.getLookbackTime());
            ObservedTimeSeriesResultsDialog observedTimeSeriesResultsDialog2 = this;
            Date date = observedTimeSeriesResultsDialog2.toDate(observedTimeSeriesResultsDialog2._runTimeWindow.getEndTime());
            date = new TimeWindow((Date)object7, true, date, true);
            object7 = new ParameterMap();
            object7.a(TimeSeriesDataSource.TIME_WINDOW_PARAMETER, date);
            object7 = ((TimeSeriesDataSource)object).getTimeSeries((ParameterMap)object7);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (this._obsDataSet != null) {
                object6 = this._obsDataSet.getTSRecords();
                if (!object7.isEmpty()) {
                    var11_12 = new TimeSeriesDataSet(object7.get(0));
                    var11_12.setName(WqI18n.a("WQObsTSResultsPanel.Observed.Label").getText() + " - " + object32.getDisplayName() + " - " + object.getName());
                    arrayList.add(var11_12);
                } else {
                    for (n = 0; n < ((Vector)object6).size(); ++n) {
                        object7 = (TSRecord)((Vector)object6).get(n);
                        if (object7.getDSSPathname() == null || !object32.getDisplayName().equalsIgnoreCase(object7.getName())) continue;
                        object7.loadTSData(this._runTimeWindow.getLookbackTime(), this._runTimeWindow.getEndTime());
                        var11_12 = new TimeSeriesDataSet(object7.getTimeSeriesContainer());
                        var11_12.setName(WqI18n.a("WQObsTSResultsPanel.Observed.Label").getText() + " - " + object32.getDisplayName() + " - " + object.getName());
                        int n2 = var11_12.getYParameterId();
                        if (n2 < 0 && (object5 = Parameter.getParameterForUnitsString((String)((TimeSeriesDataSet)var11_12).yunits)) != null) {
                            var11_12.setYParameterId(object5.getParameterId());
                        }
                        arrayList.add(var11_12);
                    }
                }
            }
            if (object2 == null || object2.getDSSPathname().isEmpty()) {
                JOptionPane.showMessageDialog((Component)((Object)this), WqI18n.a("WQObsTSResultsPanel.NoModelData.Label").format(new Object[]{this._wqStation.getName(), object32.getDisplayName()}), WqI18n.a("WQObsTSResultsPanel.NoModelData.Title").getText(), 2);
            } else {
                object6 = this.getModelTSRecordElem(rssSystem);
                if (object6 instanceof ReachElement) {
                    object7 = null;
                    try {
                        object7 = this.buildTimeSeriesDataSetHDF(rssSystem, (ObsVariable)object32);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog((Component)((Object)this), WqI18n.a("WQObsTSResultsPanel.HDFError.Label").format((Object)exception.getMessage()), WqI18n.a("WQObsTSResultsPanel.HDFError.Title").getText(), 2);
                    }
                } else {
                    object7 = this.buildTimeSeriesDataSet((TSRecordProxy)object2, (TimeWindow)date, (ObsVariable)object32);
                }
                if (object7 != null) {
                    arrayList.add(object7);
                }
            }
            object6 = plotLayout.addViewport();
            arrayList.removeIf(timeSeriesDataSet -> timeSeriesDataSet.getXValues() == null || timeSeriesDataSet.getXValues().length == 0);
            if (object32.getDisplayName().equals("Water Temperature") || object32.getDisplayName().equals("Sediment Temperature")) {
                object7 = UnitUtil.getBestMatch((String)object32.getUnits());
                int n3 = UnitUtil.getUnitSystemForUnits((String)object7);
                n = ClientApp.Workspace().getUnitSystem();
                String string = n == 1 ? "English" : "SI";
                object5 = object7;
                try {
                    object5 = UnitUtil.getUnitsInUnitSystem((String)string, (String)object7);
                }
                catch (Exception exception) {
                    ((FluentLogger.Api)((FluentLogger.Api)a.atWarning()).withCause((Throwable)exception)).log("Error converting units");
                }
                for (Object object32 : arrayList) {
                    Units.convertUnits((TimeSeriesContainer)object32._timeSeries, (int)n3);
                    object6.addCurve("Y1", object32);
                    if (!object32.getYAxisName().contains("%S")) continue;
                    object32 = object32.getYAxisName().replace("%S", (CharSequence)object5);
                    object6.setAxisLabel("Y1", (String)object32);
                }
                continue;
            }
            object7 = object32.getUnits();
            for (TimeSeriesDataSet timeSeriesDataSet2 : arrayList) {
                object6.addCurve("Y1", (Object)timeSeriesDataSet2);
                if (!timeSeriesDataSet2.getYAxisName().contains("%S")) continue;
                String string = timeSeriesDataSet2.getYAxisName().replace("%S", (CharSequence)object7);
                object6.setAxisLabel("Y1", string);
            }
        }
        this._gfxPanel.setVisible(false);
        this._gfxPanel.removeAll();
        this._gfxPanel.buildComponents(plotLayout);
        this._gfxPanel.setVisible(true);
    }

    private TSRecordProxy getModelTSRecordProxy(RssSystem rssReturnStatusConstants, ObsVariable obsVariable) {
        TSRecordProxy tSRecordProxy = null;
        if ((rssReturnStatusConstants = this.getModelTSRecordElem((RssSystem)rssReturnStatusConstants)) != null && obsVariable instanceof WQObsConstituentVariable) {
            tSRecordProxy = this.findModelTsRecordProxy((Element)rssReturnStatusConstants, obsVariable);
        }
        return tSRecordProxy;
    }

    private Element getModelTSRecordElem(RssSystem rssSystem) {
        int n;
        WQObsStationNetworkElement wQObsStationNetworkElement;
        Element element = null;
        if (rssSystem != null && (wQObsStationNetworkElement = this._wqStation.getNetworkElement(n = rssSystem.getIndex())) != null) {
            element = rssSystem.getElement(wQObsStationNetworkElement.getElementId());
        }
        return element;
    }

    private TSRecordProxy findModelTsRecordProxy(Element element, ObsVariable obsVariable) {
        TSRecordProxy tSRecordProxy = null;
        if (this._rssRun != null) {
            int n = ((WQObsConstituentVariable)obsVariable).getConstituentId();
            n += 2000;
            Object object = element.getDownstreamNode();
            if (object == null) {
                object = element.getUpstreamNode();
            }
            if (object != null) {
                String string = this._rssRun.getDSSOutputFile();
                tSRecordProxy = ((RssNode)object).getTSRecordProxy(n);
                if (tSRecordProxy == null) {
                    tSRecordProxy = RssModelVariableSet.newTSRecordProxy(this._rssRun.getNetwork(), (TSLocation)object, n);
                }
                if (tSRecordProxy != null) {
                    try {
                        Object object2 = new ArrayList(this._rssRun.getDSSFileManager().getCondensedCatalog(string));
                        object2 = object2.iterator();
                        while (object2.hasNext()) {
                            object = (CondensedReference)object2.next();
                            object = object.getNominalPathname();
                            DSSPathname dSSPathname = new DSSPathname((String)object);
                            if (!element.getName().equalsIgnoreCase(dSSPathname.getBPart()) || !dSSPathname.getFPart().equalsIgnoreCase(this._rssRun.getName()) || !dSSPathname.getCPart().equalsIgnoreCase(tSRecordProxy.getParamName())) continue;
                            tSRecordProxy.setDSSPathname((String)object);
                            tSRecordProxy.setDSSFilename(string);
                            break;
                        }
                    }
                    catch (RemoteException remoteException) {
                        ((FluentLogger.Api)((FluentLogger.Api)a.atWarning()).withCause((Throwable)remoteException)).log("Error reading dss pathnames from " + string);
                    }
                }
            }
        }
        return tSRecordProxy;
    }

    private TimeSeriesDataSet buildTimeSeriesDataSet(TSRecordProxy object, TimeWindow timeWindow, ObsVariable obsVariable) {
        TimeSeriesDataSet timeSeriesDataSet = null;
        if (object != null && this._rssRun != null) {
            String string = this._rssRun.getDSSOutputFile();
            object = object.getDSSPathname();
            object = new DSSIdentifier(string, (String)object);
            object.setTimeWindow(new HecTime(timeWindow.getStartDate(), 0), new HecTime(timeWindow.getEndDate(), 0));
            try {
                timeWindow = this._rssRun.getDSSFileManager().readTS((DSSIdentifier)object, false);
                timeSeriesDataSet = new TimeSeriesDataSet((TimeSeriesContainer)timeWindow);
                timeSeriesDataSet.setName(WqI18n.a("WQObsTSResultsPanel.Model.Label").getText() + " - " + obsVariable.getDisplayName());
            }
            catch (FileNotFoundException | RemoteException iOException) {
                ((FluentLogger.Api)((FluentLogger.Api)a.atWarning()).withCause((Throwable)iOException)).log("Error reading " + String.valueOf(object));
            }
        }
        return timeSeriesDataSet;
    }

    private TimeSeriesDataSet buildTimeSeriesDataSetHDF(RssSystem rssReturnStatusConstants, ObsVariable obsVariable) throws Exception {
        HecTime hecTime = null;
        if ((rssReturnStatusConstants = this.getModelTSRecordElem((RssSystem)rssReturnStatusConstants)) != null && this._rssRun != null) {
            hecTime = this._rssRun.getOutputFile(false);
            hecTime = new File(new File((String)hecTime).getParentFile(), RMAIO.userNameToFileName((String)this._rssRun.getName()) + ".h5");
            int n = -1;
            try {
                n = H5.H5Fopen((String)hecTime.getAbsolutePath(), (int)HDF5Constants.H5F_ACC_RDONLY, (int)HDF5Constants.H5P_DEFAULT);
                if (n < 0) {
                    IOException iOException = new IOException("Unable to open Water Quality Output file: " + hecTime.getAbsolutePath());
                    ((FluentLogger.Api)((FluentLogger.Api)a.atWarning()).withCause((Throwable)iOException)).log(iOException.getMessage());
                    throw iOException;
                }
                hecTime = ResultsPanel.a(n);
                Object object = DateTimeFormatter.ofPattern("yyyy-MM-dd, HH:mm");
                if (((String[])hecTime).length == 0) {
                    object = new WQException("Empty date/time strings dataset in HDF5 file");
                    ((FluentLogger.Api)((FluentLogger.Api)a.atWarning()).withCause((Throwable)object)).log(object.getMessage());
                    throw object;
                }
                object = LocalDateTime.parse(hecTime[0], object);
                int n2 = ((String[])hecTime).length;
                double[] dArray = ResultsPanel.a(n, "/Results/Subdomains/Time", (String[])hecTime);
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("ddMMMyyyy");
                Object object2 = DateTimeFormatter.ofPattern("HHmm");
                object = new HecTime(dateTimeFormatter.format((TemporalAccessor)object), ((DateTimeFormatter)object2).format((TemporalAccessor)object));
                dateTimeFormatter = new HecTime((HecTime)object);
                object2 = new int[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    object = new HecTime((HecTime)dateTimeFormatter);
                    object.addSeconds((int)(86400.0 * dArray[i]));
                    object2[i] = object.value();
                }
                object = "/Results/Subdomains/" + String.valueOf(rssReturnStatusConstants) + "/" + obsVariable.getDisplayName();
                hecTime = (HecTime)ResultsPanel.a(n, (String)object, (String[])hecTime, true);
                int n3 = this.getCellIndex((Element)rssReturnStatusConstants);
                dArray = new double[n2];
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = (double)hecTime[i][n3];
                    if (dArray[i] != -9999.0) continue;
                    dArray[i] = -3.4028234663852886E38;
                }
                TimeSeriesContainer timeSeriesContainer = new TimeSeriesContainer();
                new TimeSeriesContainer().numberValues = n2;
                timeSeriesContainer.times = (int[])object2;
                timeSeriesContainer.values = dArray;
                if (ClientApp.app() != null && ClientApp.app().getWorkspace() != null) {
                    timeSeriesContainer.timeZoneRawOffset = ((ClientWorkspace)ClientApp.app().getWorkspace()).getWatershedTimeZone().getRawOffset();
                }
                String string = ResultsPanel.a(n, (String)object);
                timeSeriesContainer.units = obsVariable.getDisplayName() + " (" + string + ")";
                string = new HecTime((int)object2[0]);
                hecTime = new HecTime((int)object2[n2 - 1]);
                timeSeriesContainer.setStartTime((HecTime)string);
                timeSeriesContainer.setEndTime(hecTime);
                hecTime = new TimeSeriesDataSet(timeSeriesContainer);
                hecTime.setName(WqI18n.a("WQObsTSResultsPanel.Model.Label").getText() + " - " + obsVariable.getDisplayName());
            }
            catch (Exception exception) {
                ((FluentLogger.Api)((FluentLogger.Api)a.atWarning()).withCause((Throwable)exception)).log(exception.getMessage());
                throw exception;
            }
            finally {
                try {
                    if (n >= 0) {
                        H5.H5Fclose((int)n);
                    }
                }
                catch (HDF5LibraryException hDF5LibraryException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "Exception occurred closing HDF Results file", hDF5LibraryException);
                }
            }
        }
        return hecTime;
    }

    private int getCellIndex(Element element) {
        int n = -1;
        Object object = this._rssRun.getWQRun();
        if (object != null) {
            RssAlt rssAlt = this._rssRun.getAlternative();
            ((WQRun)object).setAlternative(rssAlt);
            object = ((WQRun)object).getRssWQGeometry();
            if (object != null && (object = ((RssWQGeometry)object).getWQSubdomain(element)) != null) {
                double d = this._wqStation.getStreamStation();
                double d2 = element.getUpstreamNode().getStreamStation();
                double d3 = element.getDownstreamNode().getStreamStation();
                double d4 = (d - d3) / (d2 - d3);
                n = object.getCellIdxForStation(d4);
            }
        }
        if (n == -1) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "Unable to find cell index for element " + element.getName());
            n = 0;
        }
        return n;
    }
}

