/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.results;

import com.rma.paint.isoclineg2dplot.IsoclineContoursG2dObject;
import com.rma.paint.isoclineg2dplot.IsoclineG2dObject;
import com.rma.paint.isoclineg2dplot.PointerMouseAdapter;
import com.rma.paint.isoclinepaint.BiFunction;
import com.rma.paint.isoclinepaint.DoubleArrayFunction;
import com.rma.paint.isoclinepaint.Gradient;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.TSDataSet;
import hec.data.Parameter;
import hec.data.Units;
import hec.data.UnitsConversionException;
import hec.geometry.LocalPt;
import hec.geometry.WorldPt;
import hec.geometry.WorldRect;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.PairedDataSet;
import hec.gfx2d.PlotLayout;
import hec.gfx2d.TimeSeriesDataSet;
import hec.gfx2d.TitleDrawProp;
import hec.gfx2d.ToolbarButtonProp;
import hec.gfx2d.ViewportToolbarProp;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecTimeSeriesBase;
import hec.heclib.util.HecTime;
import hec.io.DSSIdentifier;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import hec.model.RunTimeWindow;
import hec.model.TSRecord;
import hec.rss.client.RSimSimulationMode;
import hec.rss.model.Element;
import hec.rss.model.RssAlt;
import hec.rss.model.RssRun;
import hec.rss.wq.client.results.ColorGradientPanel;
import hec.rss.wq.client.results.IsoclineFunction;
import hec.rss.wq.client.results.ResultsPanel$1;
import hec.rss.wq.client.results.ResultsPanel$2;
import hec.rss.wq.client.results.ResultsPanel$3;
import hec.rss.wq.client.results.ResultsPanel$4;
import hec.rss.wq.client.results.ResultsPanel$5;
import hec.rss.wq.client.results.ResultsPanel$6;
import hec.rss.wq.client.results.ResultsPanel$Listener;
import hec.rss.wq.client.results.ResultsPanel$NiceScale;
import hec.rss.wq.client.results.ResultsPanel$WQToolTipProvider;
import hec.rss.wq.client.results.WQConstituentTSProfilePoint;
import hec.rss.wq.client.results.WQIsoclineG2dObject;
import hec.rss.wq.client.results.WaterQualityColorContour;
import hec.rss.wq.client.results.WaterQualityIsoclineGlyph;
import hec.rss.wq.client.results.WaterQualityProfileDotGlyph;
import hec.rss.wq.dataSources.pairedData.SelectionTypeUtils;
import hec.rss.wq.model.ObsDatasetManager;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.observed.ObsStation;
import hec.wqenginecore.observed.ObsVariable;
import hec.wqengineimpl.observed.WQObsStation;
import hec.wqengineimpl.observed.WQObsStationNetworkElement;
import hec.wqengineimpl.observed.WQObsStationSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import mil.army.usace.hec.metadata.UnitUtil;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import ncsa.hdf.hdf5lib.structs.H5A_info_t;
import rma.services.ServiceLookup;
import rma.services.units.UnitsComponent;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJPanel;
import rma.swing.RmaNavigationPanel;
import rma.swing.list.RmaListModel;
import rma.util.RMAIO;

public class ResultsPanel
extends JPanel
implements UnitsComponent {
    public static final String DEPTH = "DEPTH";
    public static final String GEOMETRY_SUBDOMAINS = "/Geometry/Subdomains/";
    public static final String CELL_CENTER_COORDINATE = "Cell Center Coordinate";
    public static final String RESULTS_SUBDOMAINS = "/Results/Subdomains/";
    public static final String WATER_SURFACE_ELEVATION = "Water Surface Elevation";
    public static final String TIME = "Time";
    private double[][] _zvalues = new double[0][0];
    private LocalDateTime _startDate;
    private LocalDateTime _endDate;
    private double[] _elevations = new double[0];
    private double[] _times = new double[0];
    private double[] _wse = new double[0];
    double _invalidDataValue = 0.0;
    MessageFormat _legendFormat = new MessageFormat("<b>" + WqI18n.a("WqContourPlot.Legend.Simulation.Label").getText() + "</b> {0}<br><b>" + WqI18n.a("WqContourPlot.Legend.Alternative.Label").getText() + "</b> {1}<br><b>" + WqI18n.a("WqContourPlot.Legend.Reservoir.Label").getText() + "</b> {2}<br><b>" + WqI18n.a("WqContourPlot.Legend.Hdf5File.Label").getText() + "</b> {3}<br><b>" + WqI18n.a("WqContourPlot.Legend.Constituent.Label").getText() + "</b> {4}<br><b>" + WqI18n.a("WqContourPlot.Legend.ConstituentUnit.Label").getText() + "</b> {5}<br>");
    private RssAlt _alternative;
    private WQObsStationSet _obsStationSet;
    private List<PairedDataSet> _obsPairedDataSets = new ArrayList<PairedDataSet>();
    private List<Element> _locationElems;
    private HashMap<String, List<PairedDataSet>> _obsPDCsForConstituents = new HashMap();
    private RmaNavigationPanel _obsNaviationPanel;
    private PairedDataSet _selectedObsPDSet;
    private Double _prevGradientPlotX;
    private Double _prevGradientPlotY;
    private RssRun _rssRun;
    private String _location = "";
    private WaterQualityIsoclineGlyph _wqIsoGlyph;
    private RmaJCheckBox _showProfilesCheckBox;
    private ResultsPanel$Listener _listener;
    private List<Double> _obsTimes = new ArrayList<Double>();
    private double _selectedObsTime;
    private RmaJCheckBox _showPlotLegendCheckBox;
    JCheckBox showContourLines;
    String waterQualityValueParameter = "";
    JEditorPane htmlPane;
    JPanel legendPanel;
    G2dPanel tempGradientPanel;
    G2dPanel depthTempPanel;
    G2dPanel tempTimeSeriesPanel;
    IsoclineContoursG2dObject contours;
    double minDepthBounds;
    double maxDepthBounds;
    double minDepthElevationBounds;
    double maxDepthElevationBounds;
    double minZValue;
    double maxZValue;
    NavigableMap<LocalDateTime, double[][]> dateToDepthTemperature = new TreeMap<LocalDateTime, double[][]>();
    NavigableMap<Double, TimeSeriesContainer> depthTempTs;
    DoubleArrayFunction wseFunction = null;
    String waterQualityValueUnits;
    String waterQualityLocationUnits;
    ColorGradientPanel colorBarLegend;
    PairedDataSet depthTempPDC = null;
    TimeSeriesDataSet constituentTimeSeries = null;
    String displayUnitsString;
    int displayUnitsSystem = 1;
    double pointOverDepth = 0.0;
    MessageFormat timeSeriesPlotTitleFormat = new MessageFormat("{0} at {1} : {2} {3}");

    public ResultsPanel() {
        this.buildComponents();
        this.addListeners();
        this._showProfilesCheckBox.setSelected(true);
    }

    private void addListeners() {
        this._showProfilesCheckBox.addActionListener(actionEvent -> this.showProfilesChecked());
        this._showPlotLegendCheckBox.addActionListener(actionEvent -> this.showPlotLegendChecked());
    }

    private void showPlotLegendChecked() {
        this.depthTempPanel.setLegendVisible(this._showPlotLegendCheckBox.isSelected());
        if (this._showPlotLegendCheckBox.isSelected()) {
            this.depthTempPanel.moveLegendToPosition(7);
        }
    }

    private void buildComponents() {
        this.setLayout(new GridBagLayout());
        JComponent jComponent = new JSplitPane();
        ((JSplitPane)jComponent).setDividerLocation(0.33);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jComponent, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        ((JSplitPane)jComponent).setTopComponent(jPanel);
        ((JSplitPane)jComponent).setBottomComponent(jPanel2);
        this.legendPanel = new ResultsPanel$1(this);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)this.legendPanel, gridBagConstraints);
        this.legendPanel.setLayout(new GridBagLayout());
        this.htmlPane = new JEditorPane();
        this.htmlPane.setEditable(false);
        jComponent = new JScrollPane(this.htmlPane);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.legendPanel.add((Component)jComponent, gridBagConstraints);
        this.htmlPane.setContentType("text/html");
        jComponent = new RmaJPanel((LayoutManager)new GridBagLayout());
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        rmaJPanel.add((Component)new JLabel(WqI18n.a("WqContourPlot.ObsData.ObsDataControl.Label").getText()), gridBagConstraints);
        this._obsNaviationPanel = new RmaNavigationPanel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)this._obsNaviationPanel, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        jComponent.add((Component)rmaJPanel, gridBagConstraints);
        rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        this._showProfilesCheckBox = new RmaJCheckBox(WqI18n.a("WqContourPlot.ObsData.ShowProfiles.Label").getText());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = RmaInsets.INSETS0555;
        rmaJPanel.add((Component)this._showProfilesCheckBox, (Object)gridBagConstraints);
        this._showPlotLegendCheckBox = new RmaJCheckBox(WqI18n.a("WqContourPlot.ObsData.ShowPlotLegend.Label").getText());
        this._showPlotLegendCheckBox.setSelected(true);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = RmaInsets.INSETS0555;
        rmaJPanel.add((Component)this._showPlotLegendCheckBox, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        jComponent.add((Component)rmaJPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)jComponent, gridBagConstraints);
        this.depthTempPanel = new ResultsPanel$2(this);
        this.depthTempPanel.setTitle("");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        jPanel.add((Component)this.depthTempPanel, gridBagConstraints);
        this.tempGradientPanel = new G2dPanel();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        jPanel2.add((Component)this.tempGradientPanel, gridBagConstraints);
        this.colorBarLegend = new ColorGradientPanel();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel2.add((Component)this.colorBarLegend, gridBagConstraints);
        this.tempTimeSeriesPanel = new G2dPanel();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel2.add((Component)this.tempTimeSeriesPanel, gridBagConstraints);
    }

    private void showProfilesChecked() {
        boolean bl = this._showProfilesCheckBox.isSelected();
        if (this._wqIsoGlyph != null) {
            this._wqIsoGlyph.setShowProfiles(bl);
        }
        this._obsNaviationPanel.setEnabled(bl);
        if (this._listener != null) {
            this._listener.pointOver(this._prevGradientPlotX, this._prevGradientPlotY);
        }
    }

    public void setData(File file, String string, String object, String string2, String string3) throws IOException {
        object = ClientApp.frame().getCurrentMode();
        if (object instanceof RSimSimulationMode) {
            object = ((RSimSimulationMode)object).getRssRun();
            this.setData(file, string, (RssRun)object, string2, string3);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setData(File file, String string, RssRun object, String string2, String string3) throws IOException {
        this._selectedObsPDSet = null;
        this.waterQualityValueParameter = string3;
        this._alternative = ((RssRun)object).getAlternative();
        this._rssRun = object;
        object = this._alternative.getWaterQualityOptions().getObservedDataSetManager(this._alternative);
        if (object != null) {
            this._obsStationSet = ((ObsDatasetManager)object).getObsStationSet();
        }
        this.waterQualityLocationUnits = "ft";
        object = DateTimeFormatter.ofPattern("yyyy-MM-dd, HH:mm");
        int n = -1;
        try {
            Object object2;
            Object object3;
            Object object4;
            n = H5.H5Fopen((String)file.getAbsolutePath(), (int)HDF5Constants.H5F_ACC_RDONLY, (int)HDF5Constants.H5P_DEFAULT);
            if (n < 0) {
                throw new IOException("Unable to open Water Quality Output file: " + file.getAbsolutePath());
            }
            Object object5 = ResultsPanel.a(n);
            if (((String[])object5).length == 0) {
                JOptionPane.showMessageDialog(this, WqI18n.a("WqContourPlot.Legend.NoHDF5Data.Label").format((Object)file.getName()), WqI18n.a("WqContourPlot.Legend.NoHDF5Data.Title").getText(), 0);
                object4 = this._rssRun.getRunTimeWindow();
                LocalDateTime localDateTime = object4.getStartTime().getLocalDateTime();
                object4 = object4.getEndTime().getLocalDateTime();
                object5 = new String[]{localDateTime.format((DateTimeFormatter)object), ((LocalDateTime)object4).format((DateTimeFormatter)object)};
            }
            this._startDate = LocalDateTime.parse(object5[0], (DateTimeFormatter)object);
            this._endDate = LocalDateTime.parse(object5[((String[])object5).length - 1], (DateTimeFormatter)object);
            object4 = RMAIO.concatPath((String)(RESULTS_SUBDOMAINS + string2), (String)WATER_SURFACE_ELEVATION);
            this._wse = ResultsPanel.a(n, (String)object4, (String[])object5);
            this._times = ResultsPanel.a(n, "/Results/Subdomains/Time", (String[])object5);
            int n2 = H5.H5Dopen((int)n, (String)object4, (int)HDF5Constants.H5P_DEFAULT);
            int n3 = H5.H5Aopen((int)n2, (String)"Units", (int)HDF5Constants.H5T_NATIVE_DOUBLE);
            int n4 = H5.H5Aget_type((int)n3);
            Object object6 = H5.H5Aget_info((int)n3);
            object6 = new byte[(int)((H5A_info_t)object6).data_size];
            H5.H5Aread((int)n3, (int)n4, (byte[])object6);
            this.waterQualityLocationUnits = new String((byte[])object6);
            this.displayUnitsString = this.waterQualityLocationUnits = this.waterQualityLocationUnits.trim();
            H5.H5Aclose((int)n3);
            H5.H5Dclose((int)n2);
            String string4 = "/Results";
            n3 = -1;
            n2 = -1;
            try {
                n3 = H5.H5Gopen((int)n, (String)string4, (int)HDF5Constants.H5P_DEFAULT);
                n2 = H5.H5Aopen((int)n3, (String)"Invalid data flag", (int)HDF5Constants.H5T_NATIVE_DOUBLE);
                int n5 = H5.H5Aget_type((int)n2);
                double[] dArray = new double[1];
                H5.H5Aread((int)n2, (int)n5, (Object)dArray);
                this._invalidDataValue = dArray[0];
            }
            finally {
                if (n2 > 0) {
                    H5.H5Aclose((int)n2);
                }
                if (n3 > 0) {
                    H5.H5Gclose((int)n3);
                }
            }
            Object object7 = ResultsPanel.a(n, RMAIO.concatPath((String)(GEOMETRY_SUBDOMAINS + string2), (String)CELL_CENTER_COORDINATE), (String[])object5, false);
            this._elevations = new double[((double[][])object7).length];
            double d = Double.NEGATIVE_INFINITY;
            double d2 = Double.POSITIVE_INFINITY;
            for (n3 = 0; n3 < ((double[][])object7).length; ++n3) {
                this._elevations[n3] = object7[n3][object7[n3].length - 1];
                d = Math.max(this._elevations[n3], d);
                d2 = Math.min(this._elevations[n3], d2);
            }
            if (d2 == Double.POSITIVE_INFINITY) {
                d2 = 0.0;
            }
            if (d == Double.NEGATIVE_INFINITY) {
                double d3;
                d = Math.max(d2, 0.0);
                if (d3 < d2) {
                    d = d2;
                }
            }
            object7 = RESULTS_SUBDOMAINS + string2 + "/" + this.waterQualityValueParameter;
            this._zvalues = ResultsPanel.a(n, (String)object7, (String[])object5, true);
            this.waterQualityValueUnits = ResultsPanel.a(n, (String)object7);
            this.maxZValue = Double.NEGATIVE_INFINITY;
            this.minZValue = Double.POSITIVE_INFINITY;
            boolean bl = string3.contains("boundary");
            object5 = new ArrayList();
            for (int i = 0; i < this._zvalues.length; ++i) {
                for (int j = 0; j < this._zvalues[i].length; ++j) {
                    if (this._zvalues[i][j] == this._invalidDataValue || !(this._elevations[j] < this._wse[i])) continue;
                    this.maxZValue = Math.max(this._zvalues[i][j], this.maxZValue);
                    this.minZValue = Math.min(this._zvalues[i][j], this.minZValue);
                    if (!bl) continue;
                    object5.add(this._zvalues[i][j]);
                }
            }
            double d4 = 1.0;
            double d5 = 0.0;
            if (bl) {
                Collections.sort(object5);
                n2 = (int)Math.ceil(1.0 / 100.0 * (double)object5.size());
                d5 = (Double)object5.get(n2);
                n2 = (int)Math.ceil(99.0 / 100.0 * (double)object5.size());
                d4 = (Double)object5.get(n2);
            }
            if (this.minZValue == Double.POSITIVE_INFINITY) {
                this.minZValue = 0.0;
            }
            if (this.maxZValue == Double.NEGATIVE_INFINITY) {
                this.maxZValue = Math.max(this.minZValue, 0.0);
                if (this.maxZValue < this.minZValue) {
                    this.maxZValue = this.minZValue;
                }
            }
            object5 = DateTimeFormatter.ofPattern("ddMMMyyyy");
            Object object8 = DateTimeFormatter.ofPattern("HHmm");
            Object object9 = new HecTime(((DateTimeFormatter)object5).format(this._startDate), ((DateTimeFormatter)object8).format(this._startDate));
            object6 = new HecTime(object9);
            object9 = new HecTime(((DateTimeFormatter)object5).format(this._endDate), ((DateTimeFormatter)object8).format(this._endDate));
            object5 = new HecTime(object9);
            object8 = new int[this._times.length];
            for (int i = 0; i < this._times.length; ++i) {
                object9 = new HecTime((HecTime)object6);
                object9.addSeconds((int)(86400.0 * this._times[i]));
                object8[i] = object9.value();
            }
            String string5 = this.waterQualityValueParameter + " (" + this.waterQualityValueUnits + ")";
            object9 = new ResultsPanel$3();
            object9.setYAxisName(WqI18n.a("WqContourPlot.Elevation.Label").getText());
            object9.setYParameterId(Parameter.PARAMID_ELEV);
            this._listener = new ResultsPanel$Listener(this);
            object9.addPointOverListener((IsoclineG2dObject.PointOverListener)this._listener);
            object9.setName(string5);
            Object object10 = new IsoclineFunction(this._elevations, this._startDate, this._endDate, this._zvalues, this._wse);
            ((IsoclineFunction)object10).a(this._invalidDataValue);
            Object object11 = new WorldRect((double)this._startDate.toEpochSecond(ZoneOffset.UTC), d, (double)this._endDate.toEpochSecond(ZoneOffset.UTC), d2);
            object9.setData((BiFunction)object10, (WorldRect)object11);
            this._listener.pointOver(Double.valueOf(this._startDate.toEpochSecond(ZoneOffset.UTC)), this._elevations.length > 0 ? this._elevations[0] : 0.0);
            object10 = new Color(0, 0, 0, 0);
            object11 = new ArrayList();
            Object object12 = new HecTime((HecTime)object6);
            object12.subtractHours(1);
            object5 = new RunTimeWindow((HecTime)object6, (HecTime)object5, (HecTime)object12);
            object5 = this._alternative.getObsWQPairedData((RunTimeWindow)object5);
            this._location = string2;
            if (this._locationElems == null) {
                this._locationElems = new ArrayList<Element>();
                object6 = ObsDatasetManager.a(this._alternative.getSystem()).stream().filter(element -> element.getDisplayName().equalsIgnoreCase(string2)).findFirst().orElse(null);
                if (object6 != null) {
                    this._locationElems.add((Element)object6);
                    object12 = ObsDatasetManager.a((Element)object6);
                    this._locationElems.addAll((Collection<Element>)object12);
                }
            }
            this._obsPairedDataSets = this.buildObsPairedDataSets((List<PairedDataContainer>)object5);
            if (this._obsStationSet != null && this._locationElems != null && this._obsPDCsForConstituents.get(this.waterQualityValueParameter) == null) {
                this._obsPDCsForConstituents.put(this.waterQualityValueParameter, new ArrayList());
                object6 = this._obsStationSet.getStations().iterator();
                while (object6.hasNext()) {
                    object12 = (ObsStation)object6.next();
                    if (!(object12 instanceof WQObsStation)) continue;
                    object3 = (WQObsStation)object12;
                    this.buildObsPDCsForConstituent((WQObsStation)object3, (List<PairedDataContainer>)object5);
                }
            }
            if ((object6 = this._obsPDCsForConstituents.get(this.waterQualityValueParameter)) == null) {
                object6 = new ArrayList();
            }
            this._obsTimes = new ArrayList<Double>();
            object12 = object6.iterator();
            while (object12.hasNext()) {
                object3 = (PairedDataSet)object12.next();
                object5 = object3._pairedData;
                if (object5 == null) continue;
                object3 = new DSSPathname(((PairedDataContainer)object5).fullName);
                object5 = object3.getEPart();
                object5 = SelectionTypeUtils.a((String)object5, ZoneId.of("UTC"));
                long l = ResultsPanel.a(((Instant)object5).atZone(ZoneId.of("UTC")).toLocalDateTime());
                this._obsTimes.add(Double.valueOf(l));
            }
            this.sortPairedDataSet((List<PairedDataSet>)object6, this._obsTimes);
            if (string3.equals("q_latent") || string3.equals("q_sensible") || string3.equals("q_solar_in") || string3.equals("q_sediment")) {
                double d6 = Math.max(Math.abs(this.minZValue), Math.abs(this.maxZValue));
                object12 = new ResultsPanel$NiceScale(this, 0.0, d6, 3.0);
                double d7 = ((ResultsPanel$NiceScale)object12).g;
                ((ArrayList)object11).add(-d7);
                ((ArrayList)object11).add(0.0);
                ((ArrayList)object11).add(d7);
                object2 = new WaterQualityColorContour((List<Double>)object11, Arrays.asList(Color.BLUE, Color.LIGHT_GRAY, Color.RED), (Color)object10, Color.BLUE, Color.RED);
            } else if (bl) {
                double d8 = (d4 - d5) / 6.0;
                object3 = Arrays.asList(Color.BLUE, Color.CYAN, Color.GREEN, Color.YELLOW, Color.ORANGE, Color.RED);
                for (int i = 0; i < 7; ++i) {
                    ((ArrayList)object11).add(d5 + (double)i * d8);
                }
                object2 = new WaterQualityColorContour((List<Double>)object11, (List<Color>)object3, (Color)object10, Color.BLUE, Color.RED);
            } else {
                if (this.minZValue == 0.0 && this.maxZValue == 0.0) {
                    ((ArrayList)object11).add(0.0);
                    ((ArrayList)object11).add(0.001);
                    ((ArrayList)object11).add(0.002);
                    ((ArrayList)object11).add(0.003);
                } else {
                    ResultsPanel resultsPanel = this;
                    object12 = new ResultsPanel$NiceScale(resultsPanel, resultsPanel.minZValue, this.maxZValue, 4.0);
                    double d9 = ((ResultsPanel$NiceScale)object12).d;
                    ((ArrayList)object11).add(((ResultsPanel$NiceScale)object12).f);
                    ((ArrayList)object11).add(((ResultsPanel$NiceScale)object12).f + d9);
                    ((ArrayList)object11).add(((ResultsPanel$NiceScale)object12).f + d9 * 2.0);
                    ((ArrayList)object11).add(((ResultsPanel$NiceScale)object12).f + d9 * 3.0);
                }
                object2 = new WaterQualityColorContour((List<Double>)object11, Arrays.asList(Color.BLUE, Color.GREEN, Color.YELLOW, Color.RED), (Color)object10, Color.BLUE, Color.RED);
            }
            ((WaterQualityColorContour)object2).a(this._invalidDataValue);
            object9.setColorGradient((Gradient)object2);
            this.colorBarLegend.setColorGradient((WaterQualityColorContour)object2);
            object12 = new TimeSeriesContainer();
            new TimeSeriesContainer().numberValues = this._wse.length;
            ((TimeSeriesContainer)object12).times = (int[])object8;
            ((TimeSeriesContainer)object12).values = this._wse;
            if (ClientApp.app() != null && ClientApp.app().getWorkspace() != null) {
                ((TimeSeriesContainer)object12).timeZoneRawOffset = ((ClientWorkspace)ClientApp.app().getWorkspace()).getWatershedTimeZone().getRawOffset();
            }
            ((TimeSeriesContainer)object12).units = this.waterQualityValueParameter + " (" + this.waterQualityValueUnits + ")";
            object3 = new ResultsPanel$4(this, (TimeSeriesContainer)object12);
            object3.setXParameterId(Parameter.PARAMID_ELEV);
            object3.setUnitSystem(Units.getUnitSystemForUnits((String)this.waterQualityLocationUnits));
            object3.setName(WATER_SURFACE_ELEVATION);
            PlotLayout plotLayout = new PlotLayout();
            object3 = plotLayout.addViewport();
            object3.addCurve("Y1", object9);
            this.tempGradientPanel.setVisible(false);
            this.tempGradientPanel.buildComponents(plotLayout);
            this.tempGradientPanel.setLegendVisible(false);
            this._wqIsoGlyph = (WaterQualityIsoclineGlyph)this.tempGradientPanel.getViewports()[0].getGlyphForObject((G2dObject)object9);
            ResultsPanel resultsPanel = this;
            this._wqIsoGlyph.setToolTipProvider(new ResultsPanel$WQToolTipProvider(resultsPanel, resultsPanel.tempGradientPanel, (G2dObject)object9, this.waterQualityValueParameter, this.waterQualityValueUnits));
            this._wqIsoGlyph.setObsProfileTimes(this._obsTimes);
            this._wqIsoGlyph.setBounds(d2, d);
            plotLayout = new TitleDrawProp();
            plotLayout.setLabel(string5);
            plotLayout.setFontSize(14);
            plotLayout.setMaxFontSize(14);
            plotLayout.setMinFontSize(14);
            plotLayout.setDrawTitle(true);
            this.tempGradientPanel.getTitlePanel().setProperties((TitleDrawProp)plotLayout);
            plotLayout = this.tempGradientPanel.getViewportToolbar();
            ViewportToolbarProp viewportToolbarProp = new ViewportToolbarProp();
            ToolbarButtonProp toolbarButtonProp = new ToolbarButtonProp();
            new ToolbarButtonProp().up = "Images/Point.gif";
            toolbarButtonProp.down = "Images/Point.gif";
            toolbarButtonProp.over = "Images/Point.gif";
            toolbarButtonProp.on = "Images/Point.gif";
            toolbarButtonProp.adapter = PointerMouseAdapter.class.getName();
            viewportToolbarProp.addButtonProp(toolbarButtonProp);
            toolbarButtonProp = new ToolbarButtonProp();
            new ToolbarButtonProp().up = "Images/ZoomUp.gif";
            toolbarButtonProp.down = "Images/ZoomDown.gif";
            toolbarButtonProp.over = "Images/ZoomUp.gif";
            toolbarButtonProp.on = "Images/ZoomDown.gif";
            toolbarButtonProp.adapter = "hec.gfx2d.G2dZoomAdapter";
            viewportToolbarProp.addButtonProp(toolbarButtonProp);
            plotLayout.configureToolbar(viewportToolbarProp);
            this.tempGradientPanel.setVisible(true);
            this.updateNavigationPanel((List<PairedDataSet>)object6);
            this.showProfilesChecked();
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("<html><head><style>div.a {     text-indent: 10px;    white-space: nowrap}</style></head><body>");
            string = this._legendFormat.format(new String[]{string, this._alternative.getName(), string2, file.getName(), string3, this.waterQualityValueUnits});
            ((StringBuilder)object2).append(string);
            ((StringBuilder)object2).append("</body></html>");
            this.htmlPane.setText(((StringBuilder)object2).toString());
            System.out.println("Finished.");
        }
        catch (Exception exception) {
            try {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Exception ocurred during plotting of WQ Contour Plot", exception);
                throw new IOException(exception.getMessage(), exception);
            }
            catch (Throwable throwable) {
                try {
                    if (n < 0) throw throwable;
                    H5.H5Fclose((int)n);
                    throw throwable;
                }
                catch (HDF5LibraryException hDF5LibraryException) {
                    throw new IOException("error closing results file: " + file.getAbsolutePath() + "\n" + hDF5LibraryException.getMessage());
                }
            }
        }
        try {
            if (n < 0) return;
            H5.H5Fclose((int)n);
            return;
        }
        catch (HDF5LibraryException hDF5LibraryException) {
            throw new IOException("error closing results file: " + file.getAbsolutePath() + "\n" + hDF5LibraryException.getMessage());
        }
    }

    public static String a(int n, String string) throws HDF5LibraryException, UnsupportedEncodingException {
        n = H5.H5Dopen((int)n, (String)string, (int)HDF5Constants.H5P_DEFAULT);
        int n2 = H5.H5Aopen((int)n, (String)"Units", (int)HDF5Constants.H5T_C_S1);
        int n3 = H5.H5Aget_type((int)n2);
        long l = H5.H5Aget_storage_size((int)n2);
        byte[] byArray = new byte[(int)l];
        H5.H5Aread((int)n2, (int)n3, (byte[])byArray);
        String string2 = new String(byArray, "UTF8").trim();
        H5.H5Aclose((int)n2);
        H5.H5Dclose((int)n);
        return string2;
    }

    public static String[] a(int n) throws HDF5Exception {
        Object[] objectArray = new long[1];
        long[] lArray = new long[1];
        String string = "/Results/Subdomains/Time Date Stamp";
        n = H5.H5Dopen((int)n, (String)string, (int)HDF5Constants.H5P_DEFAULT);
        int n2 = H5.H5Dget_type((int)n);
        int n3 = H5.H5Tget_size((int)n2);
        int n4 = H5.H5Dget_space((int)n);
        H5.H5Sget_simple_extent_dims((int)n4, (long[])objectArray, (long[])lArray);
        int n5 = H5.H5Tcopy((int)HDF5Constants.H5T_FORTRAN_S1);
        H5.H5Tset_size((int)n5, (int)n3);
        int n6 = H5.H5Screate_simple((int)1, (long[])objectArray, (long[])lArray);
        objectArray = new String[(int)objectArray[0]];
        H5.H5Dread_string((int)n, (int)n5, (int)n6, (int)n4, (int)HDF5Constants.H5P_DEFAULT, (String[])objectArray);
        H5.H5Sclose((int)n6);
        H5.H5Dclose((int)n);
        H5.H5Tclose((int)n2);
        String[] stringArray = ResultsPanel.a((String[])objectArray);
        objectArray = stringArray;
        return stringArray;
    }

    private void sortPairedDataSet(List<PairedDataSet> list, List<Double> list2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list2.size());
        for (int i = 0; i < list2.size(); ++i) {
            arrayList.add(i);
        }
        Object object = new ResultsPanel$5(list2);
        arrayList.sort((Comparator<Integer>)object);
        object = new ArrayList<Object>(Collections.nCopies(list2.size(), null));
        ArrayList<Object> arrayList2 = new ArrayList<Object>(Collections.nCopies(list2.size(), null));
        for (int i = 0; i < list2.size(); ++i) {
            int n = (Integer)arrayList.get(i);
            object.set(i, list2.get(n));
            arrayList2.set(i, list.get(n));
        }
        list2.clear();
        list2.addAll((Collection<Double>)object);
        list.clear();
        list.addAll(arrayList2);
    }

    public static String[] a(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if (string.trim().isEmpty()) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    private void updateNavigationPanel(List<PairedDataSet> list) {
        RmaListModel rmaListModel = new RmaListModel();
        rmaListModel.addAll(list);
        rmaListModel = new RmaJComboBox((ComboBoxModel)rmaListModel);
        rmaListModel.addActionListener(this::obsDataSelectionChanged);
        this._obsNaviationPanel.fillForm((JComboBox)rmaListModel);
        this._obsNaviationPanel.repaint();
        if (!list.isEmpty()) {
            rmaListModel.setSelectedIndex(0);
        }
    }

    private void buildObsPDCsForConstituent(WQObsStation wQObsStation, List<PairedDataContainer> list) {
        for (ObsVariable obsVariable : wQObsStation.getVariables()) {
            if (!obsVariable.getDisplayName().equalsIgnoreCase(this.waterQualityValueParameter) || !((obsVariable = obsVariable.getSelectedData()) instanceof DssData)) continue;
            obsVariable = (DssData)obsVariable;
            WQObsStationNetworkElement wQObsStationNetworkElement2 = wQObsStation.getNetworkElements().stream().filter(wQObsStationNetworkElement -> wQObsStationNetworkElement.getNetworkId() == this._alternative.getSystem().getIndex()).findFirst().orElse(null);
            if (wQObsStationNetworkElement2 == null) continue;
            this.buildObsPDCsForElementAndConstituent(wQObsStationNetworkElement2, list, (DssData)obsVariable);
        }
    }

    private void buildObsPDCsForElementAndConstituent(WQObsStationNetworkElement object, List<PairedDataContainer> pairedDataContainer2, DssData dssData) {
        Object object2 = this._locationElems.iterator();
        while (object2.hasNext()) {
            Element element = object2.next();
            if (element.getIndex() != object.getElementId()) continue;
            for (PairedDataContainer pairedDataContainer2 : pairedDataContainer2) {
                if (!pairedDataContainer2.fileName.equalsIgnoreCase(dssData.getDssFilePath()) || !this.profilePathsMatchIgnoreEAndDPart(pairedDataContainer2.fullName, dssData.getDssPath()) || !(object2 = this._obsPDCsForConstituents.get(this.waterQualityValueParameter)).stream().noneMatch(pairedDataSet -> pairedDataSet._pairedData.fileName.equalsIgnoreCase(pairedDataContainer.fileName) && pairedDataSet._pairedData.fullName.equalsIgnoreCase(pairedDataContainer.fullName))) continue;
                pairedDataContainer2 = this.buildObsPDC(pairedDataContainer2);
                object2.add(pairedDataContainer2);
            }
            return;
        }
    }

    private boolean profilePathsMatchIgnoreEAndDPart(String string, String string2) {
        string = new DSSPathname(string);
        string2 = new DSSPathname(string2);
        string.setEPart("");
        string2.setEPart("");
        string.setDPart("");
        string2.setDPart("");
        return string.getPathname().equalsIgnoreCase(string2.getPathname());
    }

    private void obsDataSelectionChanged(ActionEvent object) {
        if (object != null && ((EventObject)object).getSource() instanceof RmaJComboBox && (object = ((RmaJComboBox)((EventObject)object).getSource()).getSelectedItem()) instanceof PairedDataSet) {
            this._selectedObsPDSet = (PairedDataSet)object;
            object = new DSSPathname(this._selectedObsPDSet._pairedData.fullName);
            object = object.getEPart();
            this._selectedObsTime = ResultsPanel.a((String)object);
            this._wqIsoGlyph.setSelectedProfileTime(this._selectedObsTime);
            double d = 0.0;
            if (this._elevations.length > 0) {
                int n = this._elevations.length / 2;
                d = this._elevations[n];
            }
            WorldPt worldPt = new WorldPt(this._selectedObsTime, d);
            worldPt = new LocalPt(this._wqIsoGlyph.getScale().e2x(worldPt.e), this._wqIsoGlyph.getScale().n2y(worldPt.n));
            this._wqIsoGlyph.pointerOver((LocalPt)worldPt);
        }
    }

    public static double a(String object) {
        object = SelectionTypeUtils.a((String)object, ZoneId.of("UTC"));
        return ResultsPanel.a(((Instant)object).atZone(ZoneId.of("UTC")).toLocalDateTime());
    }

    private static long a(LocalDateTime comparable) {
        LocalDateTime localDateTime = new HecTime(0, 11).getLocalDateTime();
        comparable = Duration.between(localDateTime, comparable);
        return ((Duration)comparable).toMinutes();
    }

    private HecTime getHecTimeFromString(String hecTime) {
        hecTime = ((String[])(hecTime = hecTime.split(" "))).length > 1 ? new HecTime(hecTime[0], (String)hecTime[1]) : new HecTime(hecTime[0]);
        return hecTime;
    }

    private List<PairedDataSet> buildObsPairedDataSets(List<PairedDataContainer> object) {
        ArrayList<PairedDataSet> arrayList = new ArrayList<PairedDataSet>();
        object = object.iterator();
        while (object.hasNext()) {
            PairedDataContainer pairedDataContainer = (PairedDataContainer)object.next();
            arrayList.add(this.buildObsPDC(pairedDataContainer));
        }
        return arrayList;
    }

    private PairedDataSet buildObsPDC(PairedDataContainer pairedDataContainer) {
        boolean bl = DEPTH.equalsIgnoreCase(pairedDataContainer.xparameter);
        boolean bl2 = bl || Parameter.getParameter((int)Parameter.PARAMID_ELEV).getParameter().equalsIgnoreCase(pairedDataContainer.xparameter);
        if (bl2) {
            pairedDataContainer.switchXyAxis = true;
        }
        Object object = this._rssRun.getOutputTSData();
        object = object.getTSRecords();
        Object object2 = -1.0;
        object = object.iterator();
        while (object.hasNext()) {
            Object object3 = object.next();
            if (!(object3 instanceof TSRecord)) continue;
            object3 = (TSRecord)object3;
            DSSPathname dSSPathname = new DSSPathname(object3.getDSSPathname());
            DSSPathname dSSPathname2 = new DSSPathname(pairedDataContainer.fullName);
            if (!dSSPathname.getBPart().equalsIgnoreCase(this._location + "-pool") || !dSSPathname.getCPart().equalsIgnoreCase("Elev")) continue;
            object = dSSPathname2.getEPart();
            DSSIdentifier dSSIdentifier = new DSSIdentifier();
            dSSIdentifier.setFileName(object3.getDSSFilename());
            dSSIdentifier.setDSSPath(object3.getDSSPathname());
            object = this.getHecTimeFromString((String)object);
            int n = HecTimeSeriesBase.getIntervalFromEPart((String)dSSPathname.getEPart());
            dSSPathname = new HecTime((HecTime)object);
            dSSPathname.subtract(n);
            object = new HecTime((HecTime)object);
            object.add(n);
            dSSIdentifier.setTimeWindow((HecTime)dSSPathname, (HecTime)object);
            try {
                TimeSeriesContainer timeSeriesContainer = ClientApp.Workspace().getDssFileManager().readTS(dSSIdentifier, false);
                object = timeSeriesContainer;
                object = timeSeriesContainer.values;
                object2 = timeSeriesContainer.values[0];
                if (((TSDataSet)object).length != 3) break;
                object2 = object[1];
                break;
            }
            catch (FileNotFoundException | RemoteException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.convertObsPdcUnits(pairedDataContainer);
        if (bl) {
            for (int i = 0; i < pairedDataContainer.xOrdinates.length; ++i) {
                pairedDataContainer.xOrdinates[i] = object2 - pairedDataContainer.xOrdinates[i];
            }
        }
        ResultsPanel$6 resultsPanel$6 = new ResultsPanel$6(this, pairedDataContainer);
        resultsPanel$6.setYParameterId(Parameter.PARAMID_ELEV);
        resultsPanel$6.setUnitSystem(Units.getUnitSystemForUnits((String)this.waterQualityLocationUnits));
        return resultsPanel$6;
    }

    private void convertObsPdcUnits(PairedDataContainer pairedDataContainer) {
        try {
            Object object = pairedDataContainer.yOrdinates[0];
            String string = UnitUtil.getBestMatch((String)pairedDataContainer.yunits);
            Parameter parameter = Parameter.getParameterForUnitsString((String)string);
            int n = UnitUtil.getUnitSystemForUnits((String)string);
            int n2 = UnitUtil.getUnitSystemForUnits((String)UnitUtil.getBestMatch((String)this.waterQualityValueUnits));
            if (n2 == 1 || n2 == 2) {
                UnitUtil.convertUnits((double[])object, (int)parameter.getParameterId(), (int)n, (int)n2);
                object = n2 == 1 ? "English" : "SI";
                pairedDataContainer.yunits = UnitUtil.getUnitsInUnitSystem((String)object, (String)string);
            }
            return;
        }
        catch (mil.army.usace.hec.metadata.UnitsConversionException unitsConversionException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Could not determine units to convert to. Plotting without unit conversion", unitsConversionException);
            return;
        }
    }

    public String getDisplayUnitsString(int n) {
        return null;
    }

    public void setDisplayUnitsSystem(int n) {
        this.displayUnitsSystem = n;
        this.displayUnitsString = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ELEV, (int)n);
        int n2 = Units.getUnitSystemForUnits((String)this.waterQualityLocationUnits);
        double d = 0.0;
        try {
            d = Units.convertUnits((double)this.pointOverDepth, (int)Parameter.PARAMID_ELEV, (int)n2, (int)n);
        }
        catch (UnitsConversionException unitsConversionException) {
            UnitsConversionException unitsConversionException2 = unitsConversionException;
            unitsConversionException.printStackTrace();
        }
        String string = this.timeSeriesPlotTitleFormat.format(new String[]{this.waterQualityValueParameter, "Elevation", new DecimalFormat("###.00").format(d), this.displayUnitsString});
        this.tempTimeSeriesPanel.setTitle(string);
        this.tempTimeSeriesPanel.repaint();
        ServiceLookup.getUnitsDisplayService().updateUnitSystem((Container)this);
    }

    public void setDisplayScaleFactor(int n, double d) {
    }

    public static double[][] a(int n, String string, String[] stringArray, boolean bl) throws IOException {
        try {
            n = H5.H5Dopen((int)n, (String)string, (int)HDF5Constants.H5P_DEFAULT);
            if (n < 0) {
                throw new IOException("Unable to open dataset at path: " + string);
            }
            long[] lArray = new long[2];
            Object object = new long[2];
            int n2 = H5.H5Dget_space((int)n);
            H5.H5Sget_simple_extent_dims((int)n2, (long[])lArray, (long[])object);
            object = new double[(int)lArray[0]][(int)lArray[1]];
            double[] dArray = new double[(int)(lArray[0] * lArray[1])];
            int n3 = HDF5Constants.H5S_ALL;
            int n4 = H5.H5Dread((int)n, (int)HDF5Constants.H5T_NATIVE_DOUBLE, (int)n3, (int)n3, (int)HDF5Constants.H5P_DEFAULT, (Object)dArray);
            H5.H5Dclose((int)n);
            double[][] dArray2 = bl ? new double[stringArray.length][(int)lArray[1]] : new double[(int)lArray[0]][(int)lArray[1]];
            if (n4 < 0) {
                throw new IOException("Unable to read dataset at path: " + string);
            }
            for (int i = 0; i < ((long[])object).length; ++i) {
                if (bl && i >= stringArray.length) continue;
                for (int j = 0; j < ((long)object[i]).length; ++j) {
                    double d;
                    dArray2[i][j] = d = dArray[i * ((long)object[i]).length + j];
                }
            }
            return dArray2;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage(), exception);
        }
    }

    public static double[] a(int n, String stringArray, String[] object) throws IOException {
        try {
            n = H5.H5Dopen((int)n, (String)stringArray, (int)HDF5Constants.H5P_DEFAULT);
            if (n < 0) {
                throw new IOException("Unable to open dataset at path: " + (String)stringArray);
            }
            int n2 = H5.H5Dget_space((int)n);
            H5.H5Dget_type((int)n);
            long[] lArray = new long[2];
            long[] lArray2 = new long[2];
            H5.H5Sget_simple_extent_dims((int)n2, (long[])lArray, (long[])lArray2);
            double[] dArray = new double[(int)lArray[0]];
            int n3 = HDF5Constants.H5S_ALL;
            int n4 = H5.H5Dread((int)n, (int)HDF5Constants.H5T_NATIVE_DOUBLE, (int)n3, (int)n3, (int)HDF5Constants.H5P_DEFAULT, (Object)dArray);
            if (n4 < 0) {
                throw new IOException("Unable to read dataset at path: " + (String)stringArray);
            }
            H5.H5Dclose((int)n);
            stringArray = object;
            double[] dArray2 = dArray;
            object = new ArrayList();
            for (int i = 0; i < stringArray.length; ++i) {
                object.add(dArray2[i]);
            }
            double[] dArray3 = object.stream().mapToDouble(Double::doubleValue).toArray();
            return dArray3;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage(), exception);
        }
    }

    static {
        G2dGlyphFactory.addMapping((String)WQIsoclineG2dObject.class.getName(), (String)WaterQualityIsoclineGlyph.class.getName());
        G2dGlyphFactory.addMapping((String)WQConstituentTSProfilePoint.class.getName(), (String)WaterQualityProfileDotGlyph.class.getName());
    }
}

