/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.results;

import hec.gfx2d.G2dPanel;
import hec.gfx2d.TimeSeriesDataSet;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.io.TimeSeriesContainer;
import hec.rss.wq.client.results.AbstractTimeSeriesResultsDialog;
import hec.rss.wq.client.results.TimeSeriesResultsDialog$AcceptAll;
import hec.rss.wq.client.results.TimeSeriesResultsDialog$DisplayConstituentAction;
import hec.rss.wq.client.results.TimeSeriesResultsDialog$Filter;
import hec.rss.wq.client.results.TimeSeriesResultsDialog$SetFilter;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import ncsa.hdf.hdf5lib.structs.H5G_info_t;

public class TimeSeriesResultsDialog
extends AbstractTimeSeriesResultsDialog {
    File _outputFile;
    String _location;
    private LocalDateTime _startDate;
    private LocalDateTime _endDate;
    TimeSeriesResultsDialog$Filter<Integer> _cells = new TimeSeriesResultsDialog$AcceptAll<Integer>();
    Set<String> _selectedConstituents = new TreeSet<String>();
    private static final MessageFormat a = new MessageFormat("/Results/Subdomains/{0}/{1}");

    public TimeSeriesResultsDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setData(File file, String arrayList, TimeSeriesResultsDialog$Filter<Integer> timeSeriesResultsDialog$AcceptAll) throws IOException {
        this._outputFile = file;
        this._location = arrayList;
        this._cells = timeSeriesResultsDialog$AcceptAll != null ? timeSeriesResultsDialog$AcceptAll : new TimeSeriesResultsDialog$AcceptAll();
        int n2 = -1;
        try {
            int n;
            n2 = H5.H5Fopen((String)file.getAbsolutePath(), (int)HDF5Constants.H5F_ACC_RDONLY, (int)HDF5Constants.H5P_DEFAULT);
            int n3 = H5.H5Gopen((int)n2, (String)("/Results/Subdomains/" + arrayList), (int)HDF5Constants.H5P_DEFAULT);
            Object object = H5.H5Gget_info((int)n3);
            H5.H5Gn_members((int)n2, (String)("/Results/Subdomains/" + arrayList));
            String[] stringArray = new String[(int)((H5G_info_t)object).nlinks];
            Object object2 = new long[(int)((H5G_info_t)object).nlinks];
            int[] nArray = new int[(int)((H5G_info_t)object).nlinks];
            object = new int[(int)((H5G_info_t)object).nlinks];
            H5.H5Gget_obj_info_all((int)n2, (String)("/Results/Subdomains/" + arrayList), (String[])stringArray, (int[])nArray, (int[])object, (long[])object2, (int)HDF5Constants.H5_INDEX_NAME);
            H5.H5Gclose((int)n3);
            JMenu jMenu = new JMenu("Constituent");
            this.getJMenuBar().add(jMenu);
            new ButtonGroup();
            arrayList = new ArrayList();
            object2 = new ArrayList();
            int n4 = -1;
            for (n = 0; n < stringArray.length; ++n) {
                object = stringArray[n].toLowerCase();
                if (((String)object).contains("water surface elevation") || ((String)object).contains("face")) continue;
                if (((String)object).contains("Water Temperature".toLowerCase())) {
                    n4 = arrayList.size();
                }
                object = new JCheckBoxMenuItem(stringArray[n]);
                arrayList.add(object);
                jMenu.add((JMenuItem)object);
                TimeSeriesResultsDialog$DisplayConstituentAction timeSeriesResultsDialog$DisplayConstituentAction = new TimeSeriesResultsDialog$DisplayConstituentAction(this, stringArray[n]);
                object2.add(timeSeriesResultsDialog$DisplayConstituentAction);
                ((AbstractButton)object).addActionListener(timeSeriesResultsDialog$DisplayConstituentAction);
            }
            if (!arrayList.isEmpty()) {
                n = n4 >= 0 ? n4 : 0;
                ((JCheckBoxMenuItem)arrayList.get(n)).setSelected(true);
                this._selectedConstituents.add(((TimeSeriesResultsDialog$DisplayConstituentAction)object2.get(n)).a());
                TimeSeriesResultsDialog timeSeriesResultsDialog = this;
                timeSeriesResultsDialog.plotConstituent(timeSeriesResultsDialog._location, Collections.singletonList(((TimeSeriesResultsDialog$DisplayConstituentAction)object2.get(n)).a()));
            }
            if (n2 == -1) return;
        }
        catch (HDF5LibraryException hDF5LibraryException) {
            try {
                throw new IOException(hDF5LibraryException.getMessage(), hDF5LibraryException);
            }
            catch (Throwable throwable) {
                if (n2 == -1) throw throwable;
                try {
                    H5.H5Fclose((int)n2);
                    throw throwable;
                }
                catch (HDF5LibraryException hDF5LibraryException2) {
                    throw new IOException(hDF5LibraryException2.getMessage(), hDF5LibraryException2);
                }
            }
        }
        try {
            H5.H5Fclose((int)n2);
            return;
        }
        catch (HDF5LibraryException hDF5LibraryException) {
            throw new IOException(hDF5LibraryException.getMessage(), hDF5LibraryException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void plotConstituent(String string, Collection<String> object) throws IOException {
        int n = -1;
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd, HH:mm");
        try {
            n = H5.H5Fopen((String)this._outputFile.getAbsolutePath(), (int)HDF5Constants.H5F_ACC_RDONLY, (int)HDF5Constants.H5P_DEFAULT);
            if (n < 0) {
                throw new IOException("Unable to open Water Quality Output file: " + this._outputFile.getAbsolutePath());
            }
            Vector<byte[]> vector = new Vector<byte[]>();
            G2dPanel g2dPanel = object.iterator();
            while (g2dPanel.hasNext()) {
                String string2 = (String)g2dPanel.next();
                long[] lArray = new long[2];
                Object[] objectArray = new long[2];
                long[] lArray2 = new long[1];
                Object[] objectArray2 = new long[1];
                String string3 = "/Results/Subdomains/Time Date Stamp";
                int n2 = H5.H5Dopen((int)n, (String)string3, (int)HDF5Constants.H5P_DEFAULT);
                int n3 = H5.H5Dget_type((int)n2);
                int n4 = H5.H5Tget_size((int)n3);
                int n5 = H5.H5Dget_space((int)n2);
                H5.H5Sget_simple_extent_dims((int)n5, (long[])lArray2, (long[])objectArray2);
                int n6 = H5.H5Tcopy((int)HDF5Constants.H5T_FORTRAN_S1);
                H5.H5Tset_size((int)n6, (int)n4);
                n4 = H5.H5Screate_simple((int)1, (long[])lArray2, (long[])objectArray2);
                String[] stringArray = new String[(int)lArray2[0]];
                H5.H5Dread_string((int)n2, (int)n6, (int)n4, (int)n5, (int)HDF5Constants.H5P_DEFAULT, (String[])stringArray);
                H5.H5Sclose((int)n4);
                H5.H5Tclose((int)n3);
                H5.H5Dclose((int)n2);
                this._startDate = LocalDateTime.parse(stringArray[0], dateTimeFormatter);
                this._endDate = LocalDateTime.parse(stringArray[stringArray.length - 1], dateTimeFormatter);
                Object object2 = "/Results/Subdomains/Time";
                n2 = H5.H5Dopen((int)n, (String)object2, (int)HDF5Constants.H5P_DEFAULT);
                if (n2 < 0) {
                    throw new IOException("Unable to open dataset at path: " + (String)object2);
                }
                n4 = H5.H5Dget_space((int)n2);
                H5.H5Dget_type((int)n2);
                H5.H5Sget_simple_extent_dims((int)n4, (long[])lArray2, (long[])objectArray2);
                objectArray2 = new double[(int)lArray2[0]];
                int n7 = HDF5Constants.H5S_ALL;
                int n8 = H5.H5Dread((int)n2, (int)HDF5Constants.H5T_NATIVE_DOUBLE, (int)n7, (int)n7, (int)HDF5Constants.H5P_DEFAULT, (Object)objectArray2);
                if (n8 < 0) {
                    throw new IOException("Unable to read dataset at path: " + (String)object2);
                }
                H5.H5Dclose((int)n2);
                object2 = "/Geometry/Subdomains/" + string + "/Cell Center Coordinate";
                n2 = H5.H5Dopen((int)n, (String)object2, (int)HDF5Constants.H5P_DEFAULT);
                if (n2 < 0) {
                    throw new IOException("Unable to open dataset at path: " + (String)object2);
                }
                n8 = H5.H5Dget_space((int)n2);
                H5.H5Sget_simple_extent_dims((int)n8, (long[])lArray, (long[])objectArray);
                int[][] nArray = new int[(int)lArray[0]][(int)lArray[1]];
                int n9 = HDF5Constants.H5S_ALL;
                int n10 = H5.H5Dread((int)n2, (int)HDF5Constants.H5T_NATIVE_INT, (int)n9, (int)n9, (int)HDF5Constants.H5P_DEFAULT, (Object)nArray);
                if (n10 < 0) {
                    throw new IOException("Unable to read dataset at path: " + (String)object2);
                }
                H5.H5Dclose((int)n2);
                object2 = "/Results/Subdomains/" + string + "/" + string2;
                n2 = H5.H5Dopen((int)n, (String)object2, (int)HDF5Constants.H5P_DEFAULT);
                if (n2 < 0) {
                    throw new IOException("Unable to open dataset at path: " + (String)object2);
                }
                n10 = H5.H5Dget_space((int)n2);
                n4 = H5.H5Sget_simple_extent_ndims((int)n10);
                H5.H5Sget_simple_extent_dims((int)n10, (long[])lArray, (long[])objectArray);
                long l = 0L;
                for (n5 = 0; n5 < n4; ++n5) {
                    l = n5 == 0 ? lArray[n5] : l * lArray[n5];
                }
                objectArray = new double[(int)l];
                n5 = (int)lArray[0];
                int n11 = n4 == 1 ? 1 : (int)lArray[1];
                int n12 = HDF5Constants.H5S_ALL;
                n10 = H5.H5Dread((int)n2, (int)HDF5Constants.H5T_NATIVE_DOUBLE, (int)n12, (int)n12, (int)HDF5Constants.H5P_DEFAULT, (Object)objectArray);
                if (n10 < 0) {
                    throw new IOException("Unable to read dataset at path: " + (String)object2);
                }
                H5.H5Dclose((int)n2);
                object2 = "/Results";
                n10 = H5.H5Gopen((int)n, (String)object2, (int)HDF5Constants.H5P_DEFAULT);
                int n13 = H5.H5Aopen((int)n10, (String)"Invalid data flag", (int)HDF5Constants.H5T_NATIVE_DOUBLE);
                n6 = H5.H5Aget_type((int)n13);
                Object object3 = new double[1];
                H5.H5Aread((int)n13, (int)n6, (Object)object3);
                double d = object3[0];
                H5.H5Aclose((int)n13);
                H5.H5Gclose((int)n10);
                Object object4 = a.format(new String[]{string, string2});
                n10 = H5.H5Dopen((int)n, (String)object4, (int)HDF5Constants.H5P_DEFAULT);
                int n14 = H5.H5Aopen((int)n10, (String)"Units", (int)HDF5Constants.H5T_C_S1);
                int n15 = H5.H5Aget_type((int)n14);
                long l2 = H5.H5Aget_storage_size((int)n14);
                Object object5 = new byte[(int)l2];
                H5.H5Aread((int)n14, (int)n15, (byte[])object5);
                H5.H5Aclose((int)n14);
                H5.H5Dclose((int)n10);
                object = new String((byte[])object5, "UTF8").trim();
                DateTimeFormatter dateTimeFormatter2 = DateTimeFormatter.ofPattern("ddMMMyyyy");
                object4 = DateTimeFormatter.ofPattern("HHmm");
                HecTime hecTime = new HecTime(dateTimeFormatter2.format(this._startDate), ((DateTimeFormatter)object4).format(this._startDate));
                new HecTime(hecTime);
                for (int i = 0; i < n11; ++i) {
                    if (!this._cells.accept(i)) continue;
                    TimeSeriesContainer timeSeriesContainer = new TimeSeriesContainer();
                    double[] dArray = new double[n5];
                    int[] cfr_ignored_0 = new int[n5];
                    HecTimeArray hecTimeArray = new HecTimeArray(dArray.length);
                    for (int j = 0; j < n5; ++j) {
                        long l3 = objectArray[j * n11 + i];
                        if (l3 == d) {
                            l3 = (long)-3.4028234663852886E38;
                        }
                        dArray[j] = l3;
                        HecTime hecTime2 = new HecTime(hecTime);
                        object3 = hecTime2;
                        hecTime2.addSeconds((int)(86400.0 * objectArray2[j]));
                        hecTimeArray.set(j, (HecTime)object3);
                    }
                    timeSeriesContainer.numberValues = dArray.length;
                    timeSeriesContainer.values = dArray;
                    timeSeriesContainer.units = string2 + " (" + (String)object + ")";
                    timeSeriesContainer.setTimes(hecTimeArray);
                    TimeSeriesDataSet timeSeriesDataSet = new TimeSeriesDataSet(timeSeriesContainer);
                    object5 = timeSeriesDataSet;
                    timeSeriesDataSet.setName(string + " " + i + " : " + string2);
                    vector.add((byte[])object5);
                }
            }
            g2dPanel = this.getPlotpanel();
            g2dPanel.setVisible(false);
            g2dPanel.clearPanel();
            g2dPanel.buildComponents(vector);
            g2dPanel.setVisible(true);
            this.revalidate();
            this.repaint();
        }
        catch (Exception exception) {
            try {
                Exception exception2 = exception;
                exception.printStackTrace();
                throw new IOException(exception2.getMessage(), exception2);
            }
            catch (Throwable throwable) {
                try {
                    if (n < 0) throw throwable;
                    H5.H5Fclose((int)n);
                    throw throwable;
                }
                catch (HDF5LibraryException hDF5LibraryException) {
                    throw new IOException("error closing results file: " + this._outputFile.getAbsolutePath() + "\n" + hDF5LibraryException.getMessage());
                }
            }
        }
        try {
            if (n < 0) return;
            H5.H5Fclose((int)n);
            return;
        }
        catch (HDF5LibraryException hDF5LibraryException) {
            throw new IOException("error closing results file: " + this._outputFile.getAbsolutePath() + "\n" + hDF5LibraryException.getMessage());
        }
    }

    public static void a(String[] object) throws IOException {
        object = new TimeSeriesResultsDialog(new JFrame(), "SJN Test", true);
        TimeSeriesResultsDialog$SetFilter<Integer> timeSeriesResultsDialog$SetFilter = new TimeSeriesResultsDialog$SetFilter<Integer>(Collections.singleton(7));
        ((TimeSeriesResultsDialog)((Object)object)).setData(new File("J:\\temp\\WaterQuality\\TestPlots\\V2260_WQ--0.h5"), "Healdsburg to Dry Creek RR", timeSeriesResultsDialog$SetFilter);
        object.setLocation(500, 500);
        object.setSize(1500, 750);
        object.setVisible(true);
        System.out.println("Done");
    }
}

