/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.results;

import hec.gfx2d.profilePlot.ProfileDataRecords;
import hec.heclib.util.HecTime;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import ncsa.hdf.hdf5lib.structs.H5G_info_t;
import rma.util.RMAConst;

public class WQProfileDataRecords
extends ProfileDataRecords {
    private double a;
    private double b;
    private final File c;
    private final String d;
    private String[] e;
    private String[] f;
    private String[] g;
    private double[][] h;
    private float[] i;
    private double[] j;
    private String k;
    private HecTime l;
    private HecTime m;
    private double n;
    private DateTimeFormatter o = DateTimeFormatter.ofPattern("ddMMMyyyy");
    private DateTimeFormatter p = DateTimeFormatter.ofPattern("HHmm");
    private static final MessageFormat q = new MessageFormat("/Results/Subdomains/{0}/{1}");
    private static final MessageFormat r = new MessageFormat("/Results/Subdomains/{0}");
    private static final MessageFormat s = new MessageFormat("{0} ({1})");
    private List<Integer> t = new ArrayList<Integer>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WQProfileDataRecords(File object, String string) throws IOException {
        this.c = object;
        this.d = string;
        this._name = string;
        object = this;
        int n = -1;
        try {
            n = H5.H5Fopen((String)((WQProfileDataRecords)((Object)object)).c.getAbsolutePath(), (int)HDF5Constants.H5F_ACC_RDONLY, (int)HDF5Constants.H5P_DEFAULT);
            Object object2 = r.format(new String[]{((WQProfileDataRecords)((Object)object)).d});
            int n2 = H5.H5Gopen((int)n, (String)object2, (int)HDF5Constants.H5P_DEFAULT);
            H5G_info_t h5G_info_t = H5.H5Gget_info((int)n2);
            String[] stringArray = new String[(int)h5G_info_t.nlinks];
            long[] lArray = new long[(int)h5G_info_t.nlinks];
            int[] nArray = new int[(int)h5G_info_t.nlinks];
            int[] nArray2 = new int[(int)h5G_info_t.nlinks];
            H5.H5Gget_obj_info_all((int)n, (String)object2, (String[])stringArray, (int[])nArray, (int[])nArray2, (long[])lArray, (int)HDF5Constants.H5_INDEX_NAME);
            H5.H5Gclose((int)n2);
            object2 = new ArrayList();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                String string2 = stringArray[n2].toLowerCase();
                if (string2.contains("water surface elevation") || string2.contains("face")) continue;
                object2.add(stringArray[n2]);
            }
            ((WQProfileDataRecords)((Object)object)).e = new String[object2.size()];
            object2.toArray(((WQProfileDataRecords)((Object)object)).e);
            ((WQProfileDataRecords)((Object)object)).f = ((WQProfileDataRecords)((Object)object)).a(n, ((WQProfileDataRecords)((Object)object)).d, (List<String>)object2);
            ((WQProfileDataRecords)((Object)object)).g = new String[((WQProfileDataRecords)((Object)object)).e.length];
            n2 = 0;
            String[] stringArray2 = ((WQProfileDataRecords)((Object)((Object)object))).e;
            int n3 = ((WQProfileDataRecords)((Object)((Object)object))).e.length;
            for (int i = 0; i < n3; ++n2, ++i) {
                String cfr_ignored_0 = stringArray2[i];
                ((WQProfileDataRecords)((Object)object)).g[n2] = s.format(new String[]{((WQProfileDataRecords)((Object)object)).e[n2], ((WQProfileDataRecords)((Object)object)).f[n2]});
            }
            ((WQProfileDataRecords)((Object)object)).j = ((WQProfileDataRecords)((Object)object)).b(n, "/Results/Subdomains/Time");
            long[] cfr_ignored_1 = new long[2];
            long[] cfr_ignored_2 = new long[2];
            long[] lArray2 = new long[1];
            long[] lArray3 = new long[1];
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd, HH:mm");
            String string3 = "/Results/Subdomains/Time Date Stamp";
            int n4 = H5.H5Dopen((int)n, (String)string3, (int)HDF5Constants.H5P_DEFAULT);
            int n5 = H5.H5Dget_type((int)n4);
            int n6 = H5.H5Tget_size((int)n5);
            int n7 = H5.H5Dget_space((int)n4);
            H5.H5Sget_simple_extent_dims((int)n7, (long[])lArray2, (long[])lArray3);
            ((WQProfileDataRecords)((Object)object)).n = -9999.0;
            string3 = "/Results";
            int n8 = H5.H5Gopen((int)n, (String)string3, (int)HDF5Constants.H5P_DEFAULT);
            int n9 = H5.H5Aopen((int)n8, (String)"Invalid data flag", (int)HDF5Constants.H5T_NATIVE_DOUBLE);
            int n10 = H5.H5Aget_type((int)n9);
            double[] dArray = new double[1];
            try {
                H5.H5Aread((int)n9, (int)n10, (Object)dArray);
            }
            catch (HDF5Exception hDF5Exception) {
                throw new IOException(hDF5Exception.getMessage(), hDF5Exception);
            }
            ((WQProfileDataRecords)((Object)object)).n = dArray[0];
            H5.H5Aclose((int)n9);
            H5.H5Gclose((int)n8);
            n8 = H5.H5Tcopy((int)HDF5Constants.H5T_FORTRAN_S1);
            H5.H5Tset_size((int)n8, (int)n6);
            try {
                n9 = H5.H5Screate_simple((int)1, (long[])lArray2, (long[])lArray3);
                String[] stringArray3 = new String[(int)lArray2[0]];
                H5.H5Dread_string((int)n4, (int)n8, (int)n9, (int)n7, (int)HDF5Constants.H5P_DEFAULT, (String[])stringArray3);
                H5.H5Sclose((int)n9);
                H5.H5Tclose((int)n5);
                LocalDateTime localDateTime = LocalDateTime.parse(stringArray3[0], dateTimeFormatter);
                ((WQProfileDataRecords)((Object)object)).l = new HecTime(((WQProfileDataRecords)((Object)object)).o.format(localDateTime), ((WQProfileDataRecords)((Object)object)).p.format(localDateTime));
                LocalDateTime localDateTime2 = LocalDateTime.parse(stringArray3[stringArray3.length - 1], dateTimeFormatter);
                ((WQProfileDataRecords)((Object)object)).m = new HecTime(((WQProfileDataRecords)((Object)object)).o.format(localDateTime2), ((WQProfileDataRecords)((Object)object)).p.format(localDateTime2));
            }
            catch (HDF5Exception hDF5Exception) {
                throw new IOException(hDF5Exception.getMessage(), hDF5Exception);
            }
            H5.H5Dclose((int)n4);
            ((WQProfileDataRecords)((Object)object)).t = new ArrayList<Integer>();
            HecTime hecTime = new HecTime();
            for (int i = 0; i < ((WQProfileDataRecords)((Object)object)).j.length; ++i) {
                hecTime.set(((WQProfileDataRecords)((Object)object)).l);
                hecTime.addSeconds((int)Math.round(86400.0 * ((WQProfileDataRecords)((Object)object)).j[i]));
                ((WQProfileDataRecords)((Object)object)).t.add(hecTime.value());
            }
            if (n == -1) return;
        }
        catch (HDF5LibraryException hDF5LibraryException) {
            try {
                throw new IOException(hDF5LibraryException.getMessage(), hDF5LibraryException);
            }
            catch (Throwable throwable) {
                if (n == -1) throw throwable;
                try {
                    H5.H5Fclose((int)n);
                    throw throwable;
                }
                catch (HDF5LibraryException hDF5LibraryException2) {
                    throw new IOException(hDF5LibraryException2.getMessage(), hDF5LibraryException2);
                }
            }
        }
        try {
            H5.H5Fclose((int)n);
            return;
        }
        catch (HDF5LibraryException hDF5LibraryException) {
            throw new IOException(hDF5LibraryException.getMessage(), hDF5LibraryException);
        }
    }

    public double[][] a(int n, String string) throws IOException {
        try {
            n = H5.H5Dopen((int)n, (String)string, (int)HDF5Constants.H5P_DEFAULT);
            if (n < 0) {
                throw new IOException("Unable to open dataset at path: " + string);
            }
            Object[] objectArray = new long[2];
            Object object = new long[2];
            int n2 = H5.H5Dget_space((int)n);
            H5.H5Sget_simple_extent_dims((int)n2, (long[])objectArray, (long[])object);
            object = new double[(int)objectArray[0]][(int)objectArray[1]];
            objectArray = new double[(int)(objectArray[0] * objectArray[1])];
            int n3 = HDF5Constants.H5S_ALL;
            n2 = H5.H5Dread((int)n, (int)HDF5Constants.H5T_NATIVE_DOUBLE, (int)n3, (int)n3, (int)HDF5Constants.H5P_DEFAULT, (Object)objectArray);
            H5.H5Dclose((int)n);
            if (n2 < 0) {
                throw new IOException("Unable to read dataset at path: " + string);
            }
            for (n = 0; n < ((long[])object).length; ++n) {
                for (int i = 0; i < ((long)object[n]).length; ++i) {
                    long l = objectArray[n * ((long)object[n]).length + i];
                    object[n][i] = l != this.n ? l : (long)-3.4028234663852886E38;
                }
            }
            return object;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage(), exception);
        }
    }

    public double[] b(int n, String string) throws IOException {
        try {
            n = H5.H5Dopen((int)n, (String)string, (int)HDF5Constants.H5P_DEFAULT);
            if (n < 0) {
                throw new IOException("Unable to open dataset at path: " + string);
            }
            int n2 = H5.H5Dget_space((int)n);
            H5.H5Dget_type((int)n);
            long[] lArray = new long[2];
            long[] lArray2 = new long[2];
            H5.H5Sget_simple_extent_dims((int)n2, (long[])lArray, (long[])lArray2);
            double[] dArray = new double[(int)lArray[0]];
            int n3 = HDF5Constants.H5S_ALL;
            int n4 = H5.H5Dread((int)n, (int)HDF5Constants.H5T_NATIVE_DOUBLE, (int)n3, (int)n3, (int)HDF5Constants.H5P_DEFAULT, (Object)dArray);
            if (n4 < 0) {
                throw new IOException("Unable to read dataset at path: " + string);
            }
            H5.H5Dclose((int)n);
            for (n = 0; n < dArray.length; ++n) {
                if (dArray[n] != this.n) continue;
                dArray[n] = -3.4028234663852886E38;
            }
            return dArray;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage(), exception);
        }
    }

    public int getType() {
        return this.type;
    }

    public void a(int n) {
        if (n != 2 && n != 1 && n != 3) {
            throw new IllegalArgumentException("Invalid Profile Record Type : " + n);
        }
        this.type = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void a(String object) throws IOException {
        int n = -1;
        int n2 = ((String)object).indexOf("(");
        if (((String)(object = ((String)object).substring(0, n2).trim())).equals(this.k)) {
            return;
        }
        this.k = object;
        try {
            n = H5.H5Fopen((String)this.c.getAbsolutePath(), (int)HDF5Constants.H5F_ACC_RDONLY, (int)HDF5Constants.H5P_DEFAULT);
            if (n < 0) {
                throw new IOException("Unable to open Water Quality Output file: " + this.c.getAbsolutePath());
            }
            object = "/Geometry/Subdomains/" + this.d + "/Cell Center Coordinate";
            object = this.a(n, (String)object);
            this.i = new float[((Object)object).length];
            double d = Double.NEGATIVE_INFINITY;
            double d2 = Double.POSITIVE_INFINITY;
            for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                int n3 = n2;
                this.i[n3] = n3;
                d = Math.max((double)this.i[n2], d);
                d2 = Math.min((double)this.i[n2], d2);
            }
            if (d2 == Double.POSITIVE_INFINITY) {
                d2 = 0.0;
            }
            if (d == Double.NEGATIVE_INFINITY) {
                Math.max(d2, 0.0);
            }
            object = q.format(new String[]{this.d, this.k});
            this.h = this.a(n, (String)object);
            this.b = Double.MAX_VALUE;
            this.a = Double.MIN_VALUE;
            if (this.h == null || this.h.length == 0) {
                this.b = 0.0;
                this.a = 0.0;
            } else {
                for (n2 = 0; n2 < this.h.length; ++n2) {
                    for (int i = 0; i < this.h[n2].length; ++i) {
                        if (!RMAConst.isValidValue((double)this.h[n2][i])) continue;
                        this.b = Math.min(this.b, this.h[n2][i]);
                        this.a = Math.max(this.a, this.h[n2][i]);
                    }
                }
            }
            if (n == -1) return;
        }
        catch (HDF5Exception hDF5Exception) {
            try {
                throw new IOException(hDF5Exception.getMessage(), hDF5Exception);
            }
            catch (Throwable throwable) {
                if (n == -1) throw throwable;
                try {
                    H5.H5Fclose((int)n);
                    throw throwable;
                }
                catch (HDF5LibraryException hDF5LibraryException) {
                    throw new IOException(hDF5LibraryException.getMessage(), hDF5LibraryException);
                }
            }
        }
        try {
            H5.H5Fclose((int)n);
            return;
        }
        catch (HDF5LibraryException hDF5LibraryException) {
            throw new IOException(hDF5LibraryException.getMessage(), hDF5LibraryException);
        }
    }

    protected String[] a(int n, String string, List<String> object) throws HDF5LibraryException {
        String[] stringArray = new String[object.size()];
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            string2 = q.format(new String[]{string, string2});
            int n3 = H5.H5Dopen((int)n, (String)string2, (int)HDF5Constants.H5P_DEFAULT);
            int n4 = H5.H5Aopen((int)n3, (String)"Units", (int)HDF5Constants.H5T_C_S1);
            int n5 = H5.H5Aget_type((int)n4);
            long l = H5.H5Aget_storage_size((int)n4);
            byte[] byArray = new byte[(int)l << 1];
            H5.H5Aread((int)n4, (int)n5, (byte[])byArray);
            H5.H5Aclose((int)n4);
            H5.H5Dclose((int)n3);
            try {
                stringArray[n2] = new String(byArray, "UTF8").trim();
            }
            catch (Exception exception) {
                stringArray[n2] = "";
            }
            ++n2;
        }
        return stringArray;
    }

    public int getRecordCount() {
        return this.t.size();
    }

    public float[] getXData(int n) {
        return this.i;
    }

    public float[] getYData(int n) {
        if (n < 0 || n >= this.h.length) {
            throw new RuntimeException("Time Step " + n + "is out of bounds");
        }
        float[] fArray = new float[this.i.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)this.h[n][i];
        }
        return fArray;
    }

    public float[] getYData(int n, String string) {
        try {
            if (string == null || string.isEmpty()) {
                return new float[0];
            }
            if (this.k == null || !string.contains(this.k)) {
                this.a(string);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return this.getYData(n);
    }

    public HecTime getTime(int n) {
        HecTime hecTime = new HecTime(this.l);
        hecTime.addSeconds((int)(86400.0 * this.j[n]));
        return hecTime;
    }

    public List getParameterNames() {
        return Arrays.asList(this.g);
    }

    public float[] getParameterBounds(String string) {
        try {
            if (!string.equals(this.k)) {
                this.a(string);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
        return new float[]{(float)this.b, (float)this.a};
    }

    public int getTimeStepPosition(int n) {
        if ((n = Collections.binarySearch(this.t, n)) < 0) {
            return -1;
        }
        return n;
    }

    public int getTimeStepPosition(HecTime hecTime) {
        return this.getTimeStepPosition(hecTime.value());
    }

    public String getTimeStep() {
        return "1Day";
    }

    public HecTime getStartTime() {
        return this.l;
    }

    public HecTime getEndTime() {
        return this.m;
    }

    public List<Integer> getTimeList() {
        return new ArrayList<Integer>(this.t);
    }
}

