/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.results;

import hec.heclib.util.HecTime;
import hec.rss.wq.client.results.ColdWaterPoolData;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;

public class WaterQualityColdWaterPoolData
implements ColdWaterPoolData {
    private static final Logger b = Logger.getLogger(WaterQualityColdWaterPoolData.class.getName());
    private final File c;
    HecTime[] a = new HecTime[0];

    public WaterQualityColdWaterPoolData(File object) {
        this.c = object;
        try {
            object = this;
            int n = H5.H5Fopen((String)((WaterQualityColdWaterPoolData)object).c.getAbsolutePath(), (int)HDF5Constants.H5F_ACC_RDONLY, (int)HDF5Constants.H5P_DEFAULT);
            if (n < 0) {
                throw new IOException("Unable to open Water Quality Output file: " + ((WaterQualityColdWaterPoolData)object).c.getAbsolutePath());
            }
            Object object2 = "/Results/Subdomains/Time Date Stamp";
            String[] stringArray = ((WaterQualityColdWaterPoolData)object).a(n, (String)object2);
            object2 = DateTimeFormatter.ofPattern("yyyy-MM-dd, HH:mm");
            ((WaterQualityColdWaterPoolData)object).a = new HecTime[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                Object object3 = stringArray[i];
                object3 = LocalDateTime.parse((CharSequence)object3, (DateTimeFormatter)object2);
                object3 = object3.toInstant(ZoneOffset.UTC);
                ((WaterQualityColdWaterPoolData)object).a[i] = HecTime.fromInstant((Instant)object3, (ZoneId)ZoneId.of("UTC"));
            }
            return;
        }
        catch (IOException | HDF5Exception throwable) {
            object = throwable;
            throwable.printStackTrace();
            return;
        }
    }

    public String[] a(int n, String string) throws IOException, HDF5Exception {
        try {
            long[] objectArray = new long[1];
            long[] lArray = new long[1];
            int n2 = H5.H5Dopen((int)n, (String)string, (int)HDF5Constants.H5P_DEFAULT);
            int n3 = H5.H5Dget_type((int)n2);
            int n4 = H5.H5Tget_size((int)n3);
            int n5 = H5.H5Dget_space((int)n2);
            H5.H5Sget_simple_extent_dims((int)n5, (long[])objectArray, (long[])lArray);
            int n6 = H5.H5Tcopy((int)HDF5Constants.H5T_FORTRAN_S1);
            H5.H5Tset_size((int)n6, (int)n4);
            int n7 = H5.H5Screate_simple((int)1, (long[])objectArray, (long[])lArray);
            String[] stringArray = new String[(int)objectArray[0]];
            H5.H5Dread_string((int)n2, (int)n6, (int)n7, (int)n5, (int)HDF5Constants.H5P_DEFAULT, (String[])stringArray);
            H5.H5Sclose((int)n7);
            H5.H5Dclose((int)n2);
            H5.H5Tclose((int)n3);
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray2 = stringArray;
            n7 = stringArray.length;
            for (n3 = 0; n3 < n7; ++n3) {
                String string2 = stringArray2[n3];
                if (string2 == null || (string2 = string2.trim()).isEmpty()) continue;
                arrayList.add(string2);
            }
            String[] stringArray3 = arrayList.toArray(new String[0]);
            return stringArray3;
        }
        finally {
            WaterQualityColdWaterPoolData.a(n);
        }
    }

    public double[][] b(int n, String string) throws IOException {
        try {
            int n2 = H5.H5Dopen((int)n, (String)string, (int)HDF5Constants.H5P_DEFAULT);
            if (n2 < 0) {
                throw new IOException("Unable to open dataset at path: " + string);
            }
            Object[] objectArray = new long[2];
            Object object = new long[2];
            int n3 = H5.H5Dget_space((int)n2);
            H5.H5Sget_simple_extent_dims((int)n3, (long[])objectArray, (long[])object);
            object = new double[(int)objectArray[0]][(int)objectArray[1]];
            objectArray = new double[(int)(objectArray[0] * objectArray[1])];
            int n4 = HDF5Constants.H5S_ALL;
            n3 = H5.H5Dread((int)n2, (int)HDF5Constants.H5T_NATIVE_DOUBLE, (int)n4, (int)n4, (int)HDF5Constants.H5P_DEFAULT, (Object)objectArray);
            H5.H5Dclose((int)n2);
            if (n3 < 0) {
                throw new IOException("Unable to read dataset at path: " + string);
            }
            for (int i = 0; i < ((long[])object).length; ++i) {
                for (n2 = 0; n2 < ((long)object[i]).length; ++n2) {
                    long l;
                    object[i][n2] = l = objectArray[i * ((long)object[i]).length + n2];
                }
            }
            Object object2 = object;
            return object2;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage(), exception);
        }
        finally {
            WaterQualityColdWaterPoolData.a(n);
        }
    }

    public double[] c(int n, String object) throws IOException {
        try {
            int n2 = H5.H5Dopen((int)n, (String)object, (int)HDF5Constants.H5P_DEFAULT);
            if (n2 < 0) {
                throw new IOException("Unable to open dataset at path: " + (String)object);
            }
            int n3 = H5.H5Dget_space((int)n2);
            long[] lArray = new long[2];
            long[] lArray2 = new long[2];
            H5.H5Sget_simple_extent_dims((int)n3, (long[])lArray, (long[])lArray2);
            double[] dArray = new double[(int)lArray[0]];
            int n4 = HDF5Constants.H5S_ALL;
            int n5 = H5.H5Dread((int)n2, (int)HDF5Constants.H5T_NATIVE_DOUBLE, (int)n4, (int)n4, (int)HDF5Constants.H5P_DEFAULT, (Object)dArray);
            if (n5 < 0) {
                throw new IOException("Unable to read dataset at path: " + (String)object);
            }
            H5.H5Dclose((int)n2);
            object = dArray;
            return object;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage(), exception);
        }
        finally {
            WaterQualityColdWaterPoolData.a(n);
        }
    }

    @Override
    public HecTime[] getElevationTemperatureDates() {
        return this.a;
    }

    @Override
    public double[] getElevations(String string) {
        try {
            int n = H5.H5Fopen((String)this.c.getAbsolutePath(), (int)HDF5Constants.H5F_ACC_RDONLY, (int)HDF5Constants.H5P_DEFAULT);
            if (n < 0) {
                System.out.println("Unable to open Water Quality Output file: " + this.c.getAbsolutePath());
            }
            Object object = "/Geometry/Subdomains/" + string + "/Cell Center Coordinate";
            double[][] dArray = this.b(n, (String)object);
            object = new double[dArray.length];
            for (int i = (v899567).length - 1; i >= 0; --i) {
                object[i] = dArray[i][2];
            }
            return object;
        }
        catch (Exception exception) {
            b.log(Level.WARNING, "Failed to get elevations for reservoir: " + string, exception);
            return new double[0];
        }
    }

    @Override
    public List<String> getReservoirNames() {
        return Arrays.asList("Lake Mendocino", "Lake Sonoma");
    }

    @Override
    public String getTemperatureUnits(String string) throws IOException {
        int n;
        try {
            n = H5.H5Fopen((String)this.c.getAbsolutePath(), (int)HDF5Constants.H5F_ACC_RDONLY, (int)HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5LibraryException hDF5LibraryException) {
            throw new IOException(hDF5LibraryException.getMessage());
        }
        if (n < 0) {
            throw new IOException("Unable to open Water Quality Output file: " + this.c.getAbsolutePath());
        }
        String string2 = "";
        try {
            int n2 = H5.H5Dopen((int)n, (String)("/Results/Subdomains/" + string + "/Water Temperature"), (int)HDF5Constants.H5P_DEFAULT);
            int n3 = H5.H5Aopen((int)n2, (String)"Units", (int)HDF5Constants.H5T_C_S1);
            int n4 = H5.H5Aget_type((int)n3);
            long l = H5.H5Aget_storage_size((int)n3);
            byte[] byArray = new byte[(int)l];
            H5.H5Aread((int)n3, (int)n4, (byte[])byArray);
            string2 = new String(byArray, "UTF8").trim();
            H5.H5Aclose((int)n3);
            H5.H5Dclose((int)n2);
        }
        catch (HDF5LibraryException hDF5LibraryException) {
            HDF5LibraryException hDF5LibraryException2 = hDF5LibraryException;
            hDF5LibraryException.printStackTrace();
        }
        finally {
            WaterQualityColdWaterPoolData.a(n);
        }
        return string2;
    }

    @Override
    public double[] getWaterSurfaceElevations(String object) throws IOException {
        int n;
        object = "/Results/Subdomains/" + (String)object + "/Water Surface Elevation";
        try {
            n = H5.H5Fopen((String)this.c.getAbsolutePath(), (int)HDF5Constants.H5F_ACC_RDONLY, (int)HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5LibraryException hDF5LibraryException) {
            throw new IOException(hDF5LibraryException.getMessage());
        }
        if (n < 0) {
            throw new IOException("Unable to open Water Quality Output file: " + this.c.getAbsolutePath());
        }
        return this.c(n, (String)object);
    }

    private static void a(int n) {
        try {
            if (n >= 0) {
                H5.H5Fclose((int)n);
            }
            return;
        }
        catch (HDF5LibraryException hDF5LibraryException) {
            b.log(Level.WARNING, "Failed to close HDF5 file with id: " + n, hDF5LibraryException);
            return;
        }
    }

    @Override
    public double[][] getElevationTemperatures(String string) throws IOException {
        int n;
        try {
            n = H5.H5Fopen((String)this.c.getAbsolutePath(), (int)HDF5Constants.H5F_ACC_RDONLY, (int)HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5LibraryException hDF5LibraryException) {
            throw new IOException(hDF5LibraryException.getMessage());
        }
        if (n < 0) {
            throw new IOException("Unable to open Water Quality Output file: " + this.c.getAbsolutePath());
        }
        return this.b(n, "/Results/Subdomains/" + string + "/Water Temperature");
    }
}

