/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.results;

import com.rma.paint.isoclineg2dplot.IcoclineG2dGlyph;
import com.rma.paint.isoclineg2dplot.IsoclineG2dObject;
import hec.geometry.LocalPt;
import hec.geometry.Scale;
import hec.gfx2d.Viewport;
import hec.rss.wq.client.results.WQIsoclineG2dObject;
import hec.rss.wq.client.results.WaterQualityIsoclineGlyph$ToolTipProvider;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Objects;

public class WaterQualityIsoclineGlyph
extends IcoclineG2dGlyph {
    private static final int VERTICAL_LINE_BUFFER = 100;
    private static final float SELECTED_LINE_THICKNESS = 3.0f;
    private List<Double> _obsProfileTimes;
    private Double _selectedProfileTime;
    private boolean _showProfiles;
    private double _minElevation;
    private double _maxElevation;
    WaterQualityIsoclineGlyph$ToolTipProvider _toolTipProvder = null;

    public WaterQualityIsoclineGlyph(Viewport viewport, WQIsoclineG2dObject wQIsoclineG2dObject, Scale scale) {
        super(viewport, (IsoclineG2dObject)wQIsoclineG2dObject, scale);
    }

    void setObsProfileTimes(List<Double> list) {
        this._obsProfileTimes = list;
    }

    void setSelectedProfileTime(Double d) {
        this._selectedProfileTime = d;
    }

    void setShowProfiles(boolean bl) {
        this._showProfiles = bl;
    }

    void setBounds(double d, double d2) {
        this._minElevation = d;
        this._maxElevation = d2;
    }

    public void setToolTipProvider(WaterQualityIsoclineGlyph$ToolTipProvider waterQualityIsoclineGlyph$ToolTipProvider) {
        this._toolTipProvder = waterQualityIsoclineGlyph$ToolTipProvider;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this._toolTipProvder != null) {
            return this._toolTipProvder.getToolTipText(mouseEvent);
        }
        return super.getToolTipText(mouseEvent);
    }

    public void draw(Graphics graphics) {
        super.draw(graphics);
        if (this._obsProfileTimes != null && this._showProfiles) {
            for (Double d : this._obsProfileTimes) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setColor(Color.BLACK);
                if (Objects.equals(d, this._selectedProfileTime)) {
                    graphics2D.setStroke(new BasicStroke(3.0f));
                }
                LocalPt localPt = new LocalPt(this._scale.e2x(d.doubleValue()), this._scale.n2y(this._minElevation - 100.0));
                d = new LocalPt(this._scale.e2x(d.doubleValue()), this._scale.n2y(this._maxElevation + 100.0));
                graphics2D.drawLine(localPt.x, localPt.y, ((LocalPt)d).x, ((LocalPt)d).y);
            }
        }
    }
}

