/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.results;

import hec.geometry.Scale;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.TimeSeriesDataSet;
import hec.gfx2d.TimeSeriesGlyph;
import hec.gfx2d.Viewport;
import hec.io.TimeSeriesContainer;
import hec.rss.wq.client.results.WQConstituentTSProfilePoint;
import java.awt.Color;
import java.awt.Graphics;

public class WaterQualityProfileDotGlyph
extends TimeSeriesGlyph {
    private final TimeSeriesContainer _tsc;
    private boolean _initialized;
    private boolean _showProfiles;
    private double _selectedObsTime;
    private static final G2dLineProperties LINE_PROPERTIES_SELECTED = WaterQualityProfileDotGlyph.buildLineProps(true);
    private static final G2dLineProperties LINE_PROPERTIES_UNSELECTED = WaterQualityProfileDotGlyph.buildLineProps(false);

    public WaterQualityProfileDotGlyph(Viewport viewport, WQConstituentTSProfilePoint wQConstituentTSProfilePoint, Scale scale) {
        super(viewport, (TimeSeriesDataSet)wQConstituentTSProfilePoint, scale);
        this._tsc = wQConstituentTSProfilePoint._timeSeries;
        this._initialized = false;
    }

    private static G2dLineProperties buildLineProps(boolean bl) {
        G2dLineProperties g2dLineProperties = new G2dLineProperties();
        new G2dLineProperties()._drawPoints = true;
        g2dLineProperties._drawLine = false;
        g2dLineProperties._pointLineColor = Color.BLACK;
        g2dLineProperties._pointFillColor = Color.BLACK;
        g2dLineProperties._symbolType = bl ? 1 : 7;
        g2dLineProperties._symbolSize = 10.0f;
        return g2dLineProperties;
    }

    private void useSelectedDrawProp() {
        if (this._drawProp.lineProperties != null && !this._drawProp.lineProperties.isEmpty()) {
            G2dLineProperties g2dLineProperties = (G2dLineProperties)this._drawProp.lineProperties.get(0);
            ((G2dLineProperties)this._drawProp.lineProperties.get(0))._drawPoints = true;
            g2dLineProperties._drawLine = false;
            g2dLineProperties._pointLineColor = WaterQualityProfileDotGlyph.LINE_PROPERTIES_SELECTED._pointLineColor;
            g2dLineProperties._pointFillColor = WaterQualityProfileDotGlyph.LINE_PROPERTIES_SELECTED._pointLineColor;
            g2dLineProperties._symbolType = WaterQualityProfileDotGlyph.LINE_PROPERTIES_SELECTED._symbolType;
            g2dLineProperties._symbolSize = WaterQualityProfileDotGlyph.LINE_PROPERTIES_SELECTED._symbolSize;
            WaterQualityProfileDotGlyph waterQualityProfileDotGlyph = this;
            waterQualityProfileDotGlyph.setProperties(waterQualityProfileDotGlyph._drawProp);
        }
    }

    private void useUnselectedDrawProp() {
        if (this._drawProp.lineProperties != null && !this._drawProp.lineProperties.isEmpty()) {
            G2dLineProperties g2dLineProperties = (G2dLineProperties)this._drawProp.lineProperties.get(0);
            ((G2dLineProperties)this._drawProp.lineProperties.get(0))._drawPoints = true;
            g2dLineProperties._drawLine = false;
            g2dLineProperties._pointLineColor = WaterQualityProfileDotGlyph.LINE_PROPERTIES_UNSELECTED._pointLineColor;
            g2dLineProperties._pointFillColor = WaterQualityProfileDotGlyph.LINE_PROPERTIES_UNSELECTED._pointLineColor;
            g2dLineProperties._symbolType = WaterQualityProfileDotGlyph.LINE_PROPERTIES_UNSELECTED._symbolType;
            g2dLineProperties._symbolSize = WaterQualityProfileDotGlyph.LINE_PROPERTIES_UNSELECTED._symbolSize;
            WaterQualityProfileDotGlyph waterQualityProfileDotGlyph = this;
            waterQualityProfileDotGlyph.setProperties(waterQualityProfileDotGlyph._drawProp);
        }
    }

    public void draw(Graphics graphics) {
        if (this._showProfiles) {
            if (this._initialized && (this._selectedObsTime == (double)this._tsc.times[0] && this.hasEdits(LINE_PROPERTIES_SELECTED) || this._selectedObsTime != (double)this._tsc.times[0] && this.hasEdits(LINE_PROPERTIES_UNSELECTED))) {
                this.updatedLineProperties();
            }
            if (this._selectedObsTime == (double)this._tsc.times[0]) {
                this.useSelectedDrawProp();
            } else {
                this.useUnselectedDrawProp();
            }
            this._initialized = true;
            super.draw(graphics);
        }
    }

    private boolean hasEdits(G2dLineProperties g2dLineProperties) {
        if (this._drawProp.lineProperties != null && !this._drawProp.lineProperties.isEmpty()) {
            G2dLineProperties g2dLineProperties2 = (G2dLineProperties)this._drawProp.lineProperties.get(0);
            return g2dLineProperties2._pointLineColor != g2dLineProperties._pointLineColor || g2dLineProperties2._pointFillColor != g2dLineProperties._pointFillColor || g2dLineProperties2._symbolSize != g2dLineProperties._symbolSize || g2dLineProperties2._symbolType != g2dLineProperties._symbolType;
        }
        return true;
    }

    private void updatedLineProperties() {
        if (this._drawProp.lineProperties != null && !this._drawProp.lineProperties.isEmpty()) {
            G2dLineProperties g2dLineProperties = (G2dLineProperties)this._drawProp.lineProperties.get(0);
            if (this._selectedObsTime == (double)this._tsc.times[0]) {
                WaterQualityProfileDotGlyph.LINE_PROPERTIES_SELECTED._pointLineColor = g2dLineProperties._pointLineColor;
                WaterQualityProfileDotGlyph.LINE_PROPERTIES_SELECTED._pointFillColor = g2dLineProperties._pointFillColor;
                WaterQualityProfileDotGlyph.LINE_PROPERTIES_SELECTED._symbolSize = g2dLineProperties._symbolSize;
                WaterQualityProfileDotGlyph.LINE_PROPERTIES_SELECTED._symbolType = g2dLineProperties._symbolType;
                return;
            }
            WaterQualityProfileDotGlyph.LINE_PROPERTIES_UNSELECTED._pointLineColor = g2dLineProperties._pointLineColor;
            WaterQualityProfileDotGlyph.LINE_PROPERTIES_UNSELECTED._pointFillColor = g2dLineProperties._pointFillColor;
            WaterQualityProfileDotGlyph.LINE_PROPERTIES_UNSELECTED._symbolSize = g2dLineProperties._symbolSize;
            WaterQualityProfileDotGlyph.LINE_PROPERTIES_UNSELECTED._symbolType = g2dLineProperties._symbolType;
        }
    }

    void setShowProfiles(boolean bl) {
        this._showProfiles = bl;
    }

    void setSelectedTime(double d) {
        this._selectedObsTime = d;
    }
}

