/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.wqParameters;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.gui.AbstractEditorPanel;
import hec.gui.SelectorPanelEditor;
import hec.io.Identifier;
import hec.lang.NamedType;
import hec.rss.wq.client.ImageDlg;
import hec.rss.wq.client.wqParameters.ParameterSetPanel;
import hec.rss.wq.client.wqParameters.actions.DeleteParameterSetAction;
import hec.rss.wq.client.wqParameters.actions.NewParameterSetAction;
import hec.rss.wq.client.wqParameters.actions.RenameParameterSetAction;
import hec.rss.wq.client.wqParameters.actions.SaveParameterSetAsAction;
import hec.rss.wq.model.ConstituentSetManager;
import hec.rss.wq.model.JsonManager;
import hec.rss.wq.model.ManagerProxyWrapper;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.model.wqParameters.ParameterSetManager;
import hec.rss.wq.util.WqI18n;
import hec.util.I18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import rma.swing.RmaInsets;
import rma.swing.RmaJTextField;

public class ParameterSetEditor
extends SelectorPanelEditor {
    private static final FluentLogger a = FluentLogger.forEnclosingClass();
    private static final I18n b = WqI18n.a("Param.ParamSetEditor.Image.Nsm1Sediment");
    private static final I18n c = WqI18n.a("Param.ParamSetEditor.Image.Nsm1Nutrient");
    private static final I18n d = WqI18n.a("Param.ParamSetEditor.Image.Temp");
    private String _title;
    private JMenuItem _menuItemNew;
    private JMenuItem _menuItemSaveAs;
    private JMenuItem _menuItemDelete;
    private JMenuItem _menuItemSchTemp;
    private JMenuItem _menuItemSchNsm1Nutrient;
    private JMenuItem _menuItemSchNsm1Sediment;
    private ManagerProxyListContainer _wksp;
    private JButton _restoreDefaultsBtn;
    private JMenu _wqSetMenu;
    private RmaJTextField _geoFld;
    private JPanel _msgPanel;
    private RmaJTextField _msgText;

    public ParameterSetEditor(Frame frame) {
        super(frame, false);
        this.setAlwaysUseTabs(true);
        this.createControls();
        this.buildMenuBar();
        this.addListeners();
        this.pack();
        this.setSize(800, 500);
        ParameterSetEditor parameterSetEditor = this;
        parameterSetEditor.setMinimumSize(parameterSetEditor.getSize());
        this.setLocationRelativeTo(frame);
    }

    private void createControls() {
        this._title = WqI18n.a("Param.ParamSetEditor.Title").getText();
        ParameterSetEditor parameterSetEditor = this;
        parameterSetEditor.setTitle(parameterSetEditor._title);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this.getSelectorPanel().add((Component)jPanel, (Object)gridBagConstraints);
        JLabel jLabel = WqI18n.a("Param.ParamSetPanel.Label.Geometry").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._geoFld = new RmaJTextField();
        this._geoFld.setEditable(false);
        jLabel.setLabelFor((Component)this._geoFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._geoFld, gridBagConstraints);
        this._msgPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this._panelContainer.add((Component)this._msgPanel, "South");
        this._msgText = new RmaJTextField();
        this._msgText.setEditable(false);
        this._msgText.setBorder(null);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this._msgPanel.add((Component)this._msgText, gridBagConstraints);
        jPanel = this.getBottomPanel();
        this._restoreDefaultsBtn = WqI18n.a("Param.ParamSetEditor.Button.RestoreDefaults").createJButton();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._restoreDefaultsBtn, gridBagConstraints);
    }

    private void buildMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        this._wqSetMenu = WqI18n.a("Param.ParamSetEditor.Menu.ParamSet").createMenu();
        this._menuItemNew = WqI18n.a("Constituent.Menu.New").createMenuItem();
        this._wqSetMenu.add(this._menuItemNew);
        this._menuItemSaveAs = WqI18n.a("Constituent.Menu.SaveAs").createMenuItem();
        this._wqSetMenu.add(this._menuItemSaveAs);
        this._menuItemDelete = WqI18n.a("Constituent.Menu.Delete").createMenuItem();
        this._wqSetMenu.add(this._menuItemDelete);
        jMenuBar.add(this._wqSetMenu);
        JMenu jMenu = WqI18n.a("Param.ParamSetEditor.Menu.Schematics").createMenu();
        jMenuBar.add(jMenu);
        this._menuItemSchTemp = WqI18n.a("Param.ParamSetEditor.Menu.Schematic.Temp").createMenuItem();
        jMenu.add(this._menuItemSchTemp);
        this._menuItemSchNsm1Nutrient = WqI18n.a("Param.ParamSetEditor.Menu.Schematic.Nsm1Nutrient").createMenuItem();
        jMenu.add(this._menuItemSchNsm1Nutrient);
        this._menuItemSchNsm1Sediment = WqI18n.a("Param.ParamSetEditor.Menu.Schematic.Nsm1Sediment").createMenuItem();
        if (Boolean.getBoolean("WqParamEditor.HasNsm1Sediment")) {
            jMenu.add(this._menuItemSchNsm1Sediment);
        }
        this.setJMenuBar(jMenuBar);
    }

    private void addListeners() {
        this._menuItemNew.addActionListener(actionEvent -> this.newParameterSetAction());
        this._menuItemSaveAs.addActionListener(actionEvent -> this.saveParameterSetAsAction());
        this._menuItemDelete.addActionListener(actionEvent -> this.deleteParameterSetAction());
        this._menuItemSchTemp.addActionListener(actionEvent -> this.showTemperatureSchematicAction());
        this._menuItemSchNsm1Nutrient.addActionListener(actionEvent -> this.showNsm1NutrientAction());
        this._menuItemSchNsm1Sediment.addActionListener(actionEvent -> this.showNsm1SedimentAction());
        this._restoreDefaultsBtn.addActionListener(actionEvent -> this.restoreDefaultsAction());
    }

    public void restoreDefaultsAction() {
        ParameterSetPanel parameterSetPanel = (ParameterSetPanel)((Object)this.getTabbedPane().getSelectedComponent());
        parameterSetPanel.restoreDefaultsAction();
    }

    private void showNsm1SedimentAction() {
        this.showImageDialog(b);
    }

    private void showNsm1NutrientAction() {
        this.showImageDialog(c);
    }

    private void showTemperatureSchematicAction() {
        this.showImageDialog(d);
    }

    private void showImageDialog(I18n object) {
        object = new ImageDlg((Dialog)((Object)this), object.getText(), object.getName());
        object.setVisible(true);
    }

    private void deleteParameterSetAction() {
        ManagerProxyWrapper managerProxyWrapper = (ManagerProxyWrapper)((Object)this.getSelectorPanel().getSelectedItem());
        if (managerProxyWrapper == null) {
            return;
        }
        ManagerProxy managerProxy = managerProxyWrapper.getManagerProxy();
        managerProxy = managerProxy.getId();
        DeleteParameterSetAction deleteParameterSetAction = new DeleteParameterSetAction((Dialog)((Object)this));
        if ((managerProxy = deleteParameterSetAction.a((Identifier)managerProxy)) != null) {
            this.setModified(false);
            this.getSelectorPanel().getComboBox().removeItem((Object)managerProxyWrapper);
            if (this.getSelectorPanel().getSelectedItem() == null && this.getSelectorPanel().getSelectorItems().size() > 0) {
                this.getSelectorPanel().setSelectedIndex(0);
                return;
            }
            this.clearForm();
            this.setModified(false);
        }
    }

    private void renameParameterSetAction() {
        Object object = (ManagerProxyWrapper)((Object)this.getSelectorPanel().getSelectedItem());
        if (object == null) {
            return;
        }
        object = object.getManagerProxy();
        object = (ParameterSetManager)object.loadManager(null, null);
        RenameParameterSetAction renameParameterSetAction = new RenameParameterSetAction((Dialog)((Object)this));
        if ((object = renameParameterSetAction.a((ParameterSetManager)object, this.getSelectorPanel().getDescription())) != null) {
            this.getSelectorPanel().getComboBox().repaint();
            this.getSelectorPanel().setDescription(((JsonManager)((Object)object)).getDescription());
        }
    }

    private void saveParameterSetAsAction() {
        SaveParameterSetAsAction saveParameterSetAsAction;
        Object object;
        Object object2 = (ManagerProxyWrapper)((Object)this.getSelectorPanel().getSelectedItem());
        if (object2 == null) {
            return;
        }
        object2 = object2.getManagerProxy();
        object2 = (ParameterSetManager)object2.loadManager(null, null);
        if (this.isModified() && object2 != null) {
            String string = WqI18n.a("Param.ParamSetEditor.Msg.SaveMgr").format(object2);
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), string, (String)(object = WqI18n.a("Param.ParamSetEditor.Msg.SaveMgr.Title").getText()), 1);
            if (n == 0) {
                this.saveForm();
            } else if (2 == n) {
                return;
            }
        }
        if ((object = (saveParameterSetAsAction = new SaveParameterSetAsAction((Dialog)((Object)this))).a((ParameterSetManager)object2, this.getSelectorPanel().getDescription())) != null) {
            this.saveForm((NamedType)object);
            this.setModified(false);
            object2 = ClientApp.Workspace().getManagerProxy("rss", object.getIdentifier());
            this.getSelectorPanel().addSelectionItem((Object)new ManagerProxyWrapper((ManagerProxy)object2), true);
        }
    }

    private void newParameterSetAction() {
        Object object = new NewParameterSetAction((Dialog)((Object)this));
        if ((object = ((NewParameterSetAction)object).h()) != null) {
            object = ClientApp.Workspace().getManagerProxy("rss", object.getIdentifier());
            this.getSelectorPanel().addSelectionItem((Object)new ManagerProxyWrapper((ManagerProxy)object), true);
        }
    }

    public void setModified(boolean bl) {
        super.setModified(bl);
        String string = this._title;
        if (bl) {
            string = string.concat("*");
        }
        this.setTitle(string);
    }

    public void fillForm(NamedType object) {
        super.fillForm((NamedType)object);
        if (object instanceof ManagerProxyWrapper) {
            this.setEnabled(true);
            object = (ManagerProxyWrapper)((Object)object);
            object = ((ManagerProxyWrapper)((Object)object)).getManagerProxy();
            object = (ParameterSetManager)object.loadManager(null, null);
            if (object != null) {
                int n = ((ParameterSetManager)object).getGeometryId();
                ManagerProxy managerProxy = this._wksp.getManagerProxy("rss", WqGeometry.class.getName(), n);
                if (managerProxy != null) {
                    this._geoFld.setText(managerProxy.getName());
                    return;
                }
                object = WqI18n.a("Param.ParamSetEditor.Msg.MissingGeometry").format((Object)((JsonManager)((Object)object)).getName());
                this.setErrorMessage((String)object);
            }
        }
        this._geoFld.setText("");
    }

    public void fillForm(ManagerProxyListContainer managerProxyListContainer) {
        this._wksp = managerProxyListContainer;
        this.buildPanels();
        Object object = this.getTabbedPane();
        if (object != null) {
            int n = object.getTabCount();
            for (int i = 0; i < n; ++i) {
                ParameterSetPanel parameterSetPanel = (ParameterSetPanel)((Object)this.getTabbedPane().getComponent(i));
                parameterSetPanel.setWorkspace(managerProxyListContainer);
            }
        }
        this._wqSetMenu.setVisible(this._wksp instanceof ClientWorkspace);
        object = managerProxyListContainer.getManagerProxyList("rss", ParameterSetManager.class.getName());
        List list = object.stream().map(managerProxy -> new ManagerProxyWrapper((ManagerProxy)managerProxy)).collect(Collectors.toList());
        this.getSelectorPanel().setSelectionList(list);
        if (object.isEmpty()) {
            this.getSelectorPanel().setSelectedIndex(-1);
            return;
        }
        this.getSelectorPanel().setSelectedIndex(0);
    }

    protected void buildPanels() {
        Vector vector = this._wksp.getManagerProxyList("rss", ConstituentSetManager.class.getName());
        for (int i = 0; i < vector.size(); ++i) {
            Object object = new ParameterSetPanel(this, (ManagerProxy)vector.get(i));
            this.addPanel((AbstractEditorPanel)object);
            object = ((ManagerProxy)vector.get(i)).getDescription();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            stringBuilder.append(WqI18n.a("Param.ParamSetPanel.Label.Constituent").getText());
            stringBuilder.append(((ManagerProxy)vector.get(i)).getName());
            if (object != null && !((String)object).isEmpty()) {
                stringBuilder.append("<br>");
                stringBuilder.append((String)object);
            }
            stringBuilder.append("</html>");
            this.getTabbedPane().setToolTipTextAt(i, stringBuilder.toString());
        }
    }

    public void setSelectedParameterSetManager(ParameterSetManager object) {
        object = object.getProxyList().getManagerProxy(object.getIdentifier());
        object = new ManagerProxyWrapper((ManagerProxy)object);
        this.selectorPanel.setSelectedItem(object);
    }

    public void setSelectedConstitientSet(ManagerProxy managerProxy) {
        int n = this.getTabbedPane().getTabCount();
        for (int i = 0; i < n; ++i) {
            ParameterSetPanel parameterSetPanel = (ParameterSetPanel)((Object)this.getTabbedPane().getComponent(i));
            if (managerProxy != parameterSetPanel.getConstituentSetProxy()) continue;
            this.getTabbedPane().setSelectedIndex(i);
            return;
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.checkForGeometryAndConstituentSet();
        }
        super.setVisible(bl);
    }

    private void checkForGeometryAndConstituentSet() {
        Object object = this._wksp.getManagerProxyList("rss", WqGeometry.class.getName());
        Object object2 = this._wksp.getManagerProxyList("rss", ConstituentSetManager.class.getName());
        if (!object.isEmpty() && !object2.isEmpty()) {
            return;
        }
        String string = WqI18n.a("Param.ParamSetEditor.Msg.UnableToCreatePsMgr").getText();
        if (object.isEmpty() && object2.isEmpty()) {
            string = string.concat(WqI18n.a("Param.ParamSetEditor.Msg.CreateGeoAndCsetMgr").getText());
        } else if (object.isEmpty()) {
            string = string.concat(WqI18n.a("Param.ParamSetEditor.Msg.CreateGeoMgr").getText());
        } else if (object2.isEmpty()) {
            string = string.concat(WqI18n.a("Param.ParamSetEditor.Msg.CreateCsetMgr").getText());
        }
        object = string;
        object2 = WqI18n.a("Param.ParamSetEditor.Msg.UnableToCreatePsMgr.Title").getText();
        SwingUtilities.invokeLater(() -> this.lambda$checkForGeometryAndConstituentSet$8((String)object, (String)object2));
    }

    public void setErrorMessage(String string) {
        this._msgPanel.setVisible(string != null);
        if (string != null) {
            this._msgText.setText(string);
            ((FluentLogger.Api)a.atWarning()).log(string);
            this._msgText.setForeground(Color.RED);
            return;
        }
        this._msgText.setText("");
    }

    public void setMessage(String string) {
        this._msgPanel.setVisible(string != null);
        if (string != null) {
            this._msgText.setText(string);
            ((FluentLogger.Api)a.atInfo()).log(string);
            this._msgText.setForeground(UIManager.getColor("TextField.foreground"));
            return;
        }
        this._msgText.setText("");
    }

    private /* synthetic */ void lambda$checkForGeometryAndConstituentSet$8(String string, String string2) {
        JOptionPane.showMessageDialog((Component)((Object)this), string, string2, 1);
    }
}

