/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.wqParameters;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.client.ClientApp;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.rss.model.RssSystem;
import hec.rss.model.StateVariable;
import hec.rss.wq.client.WaterQualityMode;
import hec.rss.wq.client.wqParameters.ParamOptSelection;
import hec.rss.wq.client.wqParameters.ParameterSetEditor;
import hec.rss.wq.client.wqParameters.ParameterSetPanel$1;
import hec.rss.wq.client.wqParameters.ParameterSetPanel$2;
import hec.rss.wq.client.wqParameters.ParameterSetPanel$3;
import hec.rss.wq.client.wqParameters.ParameterSetPanel$RegionColumnGroup;
import hec.rss.wq.client.wqParameters.ParameterSetSeasonalVariationEditor;
import hec.rss.wq.client.wqParameters.ParameterSetTableModel;
import hec.rss.wq.client.wqParameters.ParameterSetTimeSeriesEditor;
import hec.rss.wq.model.ConstituentSetManager;
import hec.rss.wq.model.JsonManager;
import hec.rss.wq.model.ManagerProxyWrapper;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.model.wqParameters.ParameterSetManager;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.Region;
import hec.wqenginecore.SeasonalVariationData;
import hec.wqenginecore.StateVariableIdentifier;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.geometry.RegionRef;
import hec.wqenginecore.parameter.ParameterOption;
import hec.wqenginecore.parameter.WQParameterType;
import hec.wqengineimpl.parameter.WQParameter;
import hec.wqengineimpl.parameter.WQParameterOption;
import hec.wqengineimpl.parameter.WQParameterOptionSetting;
import hec.wqengineimpl.parameter.WQParameterSet;
import hec.wqengineimpl.parameter.WQParameterSetting;
import hec.wqengineimpl.parameter.WQParameterSettingDSSValue;
import hec.wqengineimpl.parameter.WQParameterSettingDoubleValue;
import hec.wqengineimpl.parameter.WQParameterSettingSeasonalVariationValue;
import hec.wqengineimpl.parameter.WQParameterSettingStateVariableValue;
import hec.wqengineimpl.parameter.WQParameterSettingValue;
import hec.wqengineimpl.region.WQDefaultRegion;
import hec.wqengineimpl.region.WQRegion;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJTable;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeader;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class ParameterSetPanel
extends AbstractEditorPanel {
    private static final FluentLogger a = FluentLogger.forEnclosingClass();
    private ParameterSetEditor _editor;
    private RmaJTable _paramTable;
    private ManagerProxyListContainer _wksp;
    private ParameterSetManager _currentParamSet;
    private final ConstituentSetManager _selectedConstituentSet;
    private final ManagerProxy _constituentSetProxy;
    private Map<ConstituentSetManager, ParameterSetTableModel> _tableModelMap = new HashMap<ConstituentSetManager, ParameterSetTableModel>();
    private ParameterSetTableModel _tableModel;
    private final RmaJButton _chooserButton = new RmaJButton("...");
    private List<StateVariable> _stateVariables;

    public ParameterSetPanel(ParameterSetEditor parameterSetEditor, ManagerProxy managerProxy) {
        super((LayoutManager)new GridBagLayout());
        this._editor = parameterSetEditor;
        this._constituentSetProxy = managerProxy;
        this._selectedConstituentSet = (ConstituentSetManager)managerProxy.loadManager(null, null);
        this.buildControls();
        this.addListeners();
    }

    private void buildControls() {
        Object object = new String[]{WqI18n.a("Param.ParamSetPanel.Header.Group").getText(), WqI18n.a("Param.ParamSetPanel.Header.Name").getText(), WqI18n.a("Param.ParamSetPanel.Header.Units").getText(), WqI18n.a("Param.ParamSetPanel.Header.Type").getText(), WqI18n.a("Param.ParamSetPanel.Header.Value").getText(), WqI18n.a("Param.ParamSetPanel.Header.Theta").getText()};
        ParameterSetPanel parameterSetPanel = this;
        this._paramTable = new ParameterSetPanel$1(parameterSetPanel, (Component)((Object)parameterSetPanel), (Object[])object);
        this._paramTable.getScrollPane().setHorizontalScrollBarPolicy(32);
        this._paramTable.setAutoResizeMode(0);
        this._paramTable.setRowHeight(this._paramTable.getRowHeight() + 5);
        this._paramTable.setAddRemoveEnabled(false);
        this._paramTable.removePopupMenuSumOptions();
        this._paramTable.removePopupMenuRowEditingOptions();
        this._paramTable.removePopupMenuInsertAppendOnly();
        this._paramTable.setModifiedForegroundColor(Color.BLUE);
        object = UIManager.getFont("ToolTip.font");
        Font font = this._paramTable.getFont();
        object = new Font(((Font)object).getName(), font.getStyle(), font.getSize());
        this._paramTable.setFont((Font)object);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        ((GridBagConstraints)object).gridy = -1;
        ((GridBagConstraints)object).gridwidth = 0;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS5505;
        ParameterSetPanel parameterSetPanel2 = this;
        parameterSetPanel2.add(parameterSetPanel2._paramTable.getScrollPane(), object);
        this.buildGroupableHeaders();
        this.setEnabled(false);
    }

    private TableCellEditor buildButtonEditor() {
        ParameterSetPanel parameterSetPanel = this;
        return new ParameterSetPanel$2(parameterSetPanel, (JButton)parameterSetPanel._chooserButton);
    }

    private TableCellRenderer buildButtonRenderer() {
        return new ParameterSetPanel$3(this, (JButton)new RmaJButton("..."));
    }

    private void buildGroupableHeaders() {
        TableColumnModel tableColumnModel = this._paramTable.getColumnModel();
        GroupableTableHeader groupableTableHeader = new GroupableTableHeader(tableColumnModel);
        Object object = new ColumnGroup(WqI18n.a("Param.ParamSetPanel.Header.Parameter").getText());
        object.add((Object)tableColumnModel.getColumn(0));
        object.add((Object)tableColumnModel.getColumn(1));
        object.add((Object)tableColumnModel.getColumn(2));
        groupableTableHeader.addColumnGroup(object);
        object = new ColumnGroup(WqI18n.a("Param.ParamSetPanel.Header.BaseValue").getText());
        object.add((Object)tableColumnModel.getColumn(3));
        object.add((Object)tableColumnModel.getColumn(4));
        object.add((Object)tableColumnModel.getColumn(5));
        groupableTableHeader.addColumnGroup(object);
        if (this._currentParamSet != null && (object = this._currentParamSet.getGeometry()) != null && (object = object.getRssWqGeometry()) != null && (object = object.getRegionSet()) != null) {
            object = object.getRegions();
            Iterator iterator = object.iterator();
            int n = 6;
            while (iterator.hasNext()) {
                object = (Region)iterator.next();
                if (!(object instanceof WQDefaultRegion) && (object.getElements() == null || object.getElements().isEmpty())) continue;
                object = new ParameterSetPanel$RegionColumnGroup((Region)object);
                object.add((Object)tableColumnModel.getColumn(n++));
                object.add((Object)tableColumnModel.getColumn(n++));
                object.add((Object)tableColumnModel.getColumn(n++));
                groupableTableHeader.addColumnGroup(object);
            }
        }
        for (int i = 3; i < this._paramTable.getColumnCount(); i += 3) {
            this._paramTable.setColumnWidth(i, 100);
        }
        this._paramTable.setTableHeader((JTableHeader)groupableTableHeader);
    }

    private void addListeners() {
        this.addConstituentPopup();
        this._chooserButton.addActionListener(actionEvent -> this.displayValueChooserEditor());
    }

    private void displayValueChooserEditor() {
        int n = this._paramTable.getSelectedRow();
        int n2 = this._paramTable.getSelectedColumn();
        if (n >= 0 && n2 >= 0) {
            WQParameterType wQParameterType = this._tableModel.getType(n, n2);
            if (wQParameterType == WQParameterType.Table) {
                this.displayTableEditor(n, n2);
                return;
            }
            if (wQParameterType == WQParameterType.TimeSeries) {
                this.displayTimeSeriesEditor(n, n2);
            }
        }
    }

    private void displayTableEditor(int n, int n2) {
        ParameterSetSeasonalVariationEditor parameterSetSeasonalVariationEditor = new ParameterSetSeasonalVariationEditor(this.getParentWindow(), WqI18n.a("Parameter.SeasonalTableEditor.Title").getText(), true);
        parameterSetSeasonalVariationEditor.addDoubleCellColumn(WqI18n.a("Parameter.SeasonalTableEditor.Column.Value").getText());
        parameterSetSeasonalVariationEditor.setOkConsumer(seasonalVariationData -> this.seasonalVariationDataSelected((SeasonalVariationData)seasonalVariationData, n, n2));
        Object object = this._tableModel.getValueAt(n, n2);
        if (object instanceof SeasonalVariationData) {
            object = (SeasonalVariationData)object;
            parameterSetSeasonalVariationEditor.fillForm((SeasonalVariationData)object);
        } else {
            parameterSetSeasonalVariationEditor.fillForm((int[])null);
        }
        parameterSetSeasonalVariationEditor.setLocationRelativeTo((Component)((Object)this));
        parameterSetSeasonalVariationEditor.setVisible(true);
    }

    private void seasonalVariationDataSelected(SeasonalVariationData seasonalVariationData, int n, int n2) {
        this._tableModel.setValueAt(seasonalVariationData, n, n2);
    }

    private void displayTimeSeriesEditor(int n, int n2) {
        ParameterSetTimeSeriesEditor parameterSetTimeSeriesEditor = new ParameterSetTimeSeriesEditor(this.getParentWindow(), this._stateVariables, dssData -> this.dssIdSelected((DssData)dssData, n, n2), stateVariable -> this.stateVariableSelected((StateVariable)stateVariable, n, n2));
        Object object = this._tableModel.getValueAt(n, n2);
        if (object instanceof StateVariableIdentifier) {
            object = (StateVariableIdentifier)object;
            parameterSetTimeSeriesEditor.fill((StateVariableIdentifier)object);
        } else if (object instanceof DssData) {
            object = (DssData)object;
            parameterSetTimeSeriesEditor.fill((DssData)object);
        }
        parameterSetTimeSeriesEditor.setLocationRelativeTo((Component)((Object)this));
        parameterSetTimeSeriesEditor.setVisible(true);
    }

    private void stateVariableSelected(StateVariable stateVariable, int n, int n2) {
        this._tableModel.setValueAt(stateVariable, n, n2);
    }

    private void dssIdSelected(DssData dssData, int n, int n2) {
        this._tableModel.setValueAt(dssData, n, n2);
    }

    private void typeComboChanged() {
        this._paramTable.repaint();
        this._paramTable.setModified(true);
    }

    protected void addConstituentPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = WqI18n.a("Param.ParamSetPanel.Menu.EditConstituentSet").createMenuItem();
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionEvent -> this.displayConstituentEditor());
        this.setComponentPopupMenu(jPopupMenu);
    }

    private void displayConstituentEditor() {
        WaterQualityMode waterQualityMode = (WaterQualityMode)ClientApp.frame().getModeByClass(WaterQualityMode.class);
        waterQualityMode.displayWqConstituentsEditor();
        this.updateTableForConstituent();
    }

    private void updateTableForConstituent() {
        String string;
        Object object;
        int n;
        if (this._currentParamSet == null) {
            return;
        }
        if (this._paramTable.isModified() && this._tableModel.getConstituentSet() != null && (n = JOptionPane.showConfirmDialog((Component)((Object)this), object = WqI18n.a("Param.ParamSetPanel.Msg.ParamSettingsChanged").format((Object)this._tableModel.getConstituentSet()), string = WqI18n.a("Param.ParamSetPanel.Msg.ParamSettingsChanged.Title").getText(), 0)) == 0) {
            this.savePanel();
        }
        object = this._selectedConstituentSet;
        ParameterSetTableModel cfr_ignored_0 = (ParameterSetTableModel)((Object)this._paramTable.getModel());
        this._paramTable.commitEdit(true);
        ParameterSetTableModel parameterSetTableModel = this._tableModelMap.get(object);
        if (parameterSetTableModel == null) {
            parameterSetTableModel = new ParameterSetTableModel(this._paramTable, this._currentParamSet, (ConstituentSetManager)((Object)object));
            this._tableModelMap.put(this._selectedConstituentSet, parameterSetTableModel);
        }
        this._tableModel = parameterSetTableModel;
        this._paramTable.setRowSorter(null);
        this._paramTable.setModel((TableModel)((Object)parameterSetTableModel));
        this._paramTable.repaint();
        this.setTableEditors(parameterSetTableModel);
        this._paramTable.setRowSorter(new TableRowSorter<ParameterSetTableModel>(this._tableModel));
        this._paramTable.setModified(false);
    }

    private void setTableEditors(ParameterSetTableModel object) {
        Object object2;
        int n;
        for (n = 2; n < this._paramTable.getColumnCount(); ++n) {
            this._paramTable.setDoubleCellEditor(n);
        }
        for (n = 3; n < this._paramTable.getColumnCount(); n += 3) {
            object2 = this._paramTable.setComboBoxEditor(n, (Object[])WQParameterType.values());
            ((JComboBox)object2).addActionListener(actionEvent -> this.typeComboChanged());
        }
        Map<Integer, ParameterOption> map = ((ParameterSetTableModel)((Object)object)).getParameterOptionsRows();
        object2 = map.entrySet();
        object = object2.iterator();
        while (object.hasNext()) {
            List<ParamOptSelection> list = (Map.Entry)object.next();
            int n2 = (Integer)list.getKey();
            list = (ParameterOption)list.getValue();
            Vector<ParamOptSelection> vector = new Vector<ParamOptSelection>();
            list = list.getOptions();
            list = this.getParamOptList((Map<Integer, String>)((Object)list));
            vector.addAll(list);
            this._paramTable.setComboBoxRowEditor(n2, 4, vector);
            for (int i = 7; i < this._paramTable.getColumnCount(); i += 3) {
                this._paramTable.setComboBoxRowEditor(n2, i, vector);
            }
        }
    }

    private List<ParamOptSelection> getParamOptList(Map<Integer, String> iterator) {
        iterator = iterator.entrySet();
        iterator = iterator.iterator();
        ArrayList<ParamOptSelection> arrayList = new ArrayList<ParamOptSelection>();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            object = new ParamOptSelection(object.getKey(), object.getValue());
            arrayList.add((ParamOptSelection)object);
        }
        return arrayList;
    }

    public String getTabname() {
        if (this._selectedConstituentSet != null) {
            return ((JsonManager)this._selectedConstituentSet).getName();
        }
        return "unknown";
    }

    public void fillPanel(NamedType object) {
        this._editor.getTabbedPane().getTabComponentAt(0);
        this._currentParamSet = null;
        this._tableModelMap.clear();
        this._paramTable.setRowSorter(null);
        if (object instanceof ManagerProxyWrapper) {
            RssSystem rssSystem;
            this.setEnabled(true);
            object = (ManagerProxyWrapper)((Object)object);
            object = ((ManagerProxyWrapper)((Object)object)).getManagerProxy();
            object = (ParameterSetManager)object.loadManager(null, null);
            this._stateVariables = new ArrayList<StateVariable>();
            if (object != null && ((ParameterSetManager)object).getGeometry() != null && (rssSystem = ((ParameterSetManager)object).getGeometry().getNetwork()) != null) {
                this._stateVariables = rssSystem.getStateVariableList();
            }
            this._currentParamSet = object;
            this._tableModel = new ParameterSetTableModel(this._paramTable, this._currentParamSet, this._selectedConstituentSet);
            this._paramTable.setModel((TableModel)((Object)this._tableModel));
            this._tableModelMap.put(this._selectedConstituentSet, this._tableModel);
            ParameterSetPanel parameterSetPanel = this;
            parameterSetPanel.setTableEditors(parameterSetPanel._tableModel);
            this.buildGroupableHeaders();
            this.setModified(false);
        } else {
            this._tableModel = new ParameterSetTableModel(this._paramTable, null, this._selectedConstituentSet);
            this._paramTable.setModel((TableModel)((Object)this._tableModel));
            ParameterSetPanel parameterSetPanel = this;
            parameterSetPanel.setTableEditors(parameterSetPanel._tableModel);
            this.setEnabled(false);
        }
        this._paramTable.setRowSorter(new TableRowSorter<ParameterSetTableModel>(this._tableModel));
        this.updateTableForConstituent();
    }

    private ConstituentSetManager getConstituentSet() {
        return this._selectedConstituentSet;
    }

    public boolean savePanel(NamedType object) {
        Object object2;
        ParameterSetManager parameterSetManager = this._currentParamSet;
        if (object instanceof ParameterSetManager) {
            parameterSetManager = (ParameterSetManager)object;
        }
        if (parameterSetManager == null) {
            return true;
        }
        this._paramTable.commitEdit(true);
        object = this._tableModel.getConstituentSet();
        if (object == null) {
            ((FluentLogger.Api)a.atInfo()).log("savePanel:no selected ConstituentSet to save for");
            return false;
        }
        this._tableModelMap.put((ConstituentSetManager)((Object)object), (ParameterSetTableModel)((Object)this._paramTable.getModel()));
        WQParameterSet wQParameterSet = (WQParameterSet)parameterSetManager.getSet(((JsonManager)((Object)object)).getIndex());
        wQParameterSet.setName("ParameterSet for " + ((JsonManager)((Object)object)).getName());
        Object object3 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = this._paramTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            object2 = this._tableModel.getParameterForRow(i);
            if (object2 instanceof WQParameter) {
                object3.add(((WQParameter)object2).getId());
                continue;
            }
            if (!(object2 instanceof WQParameterOption)) continue;
            arrayList.add(((WQParameterOption)object2).getId());
        }
        wQParameterSet.setParameterOptionIds(arrayList);
        wQParameterSet.setParameterIds(object3);
        object3 = this._tableModel.getGeometry();
        if (object3 == null) {
            ((FluentLogger.Api)a.atInfo()).log("savePanel:no selected Geometry to save for " + String.valueOf(parameterSetManager));
            return false;
        }
        object2 = ((WqGeometry)((Object)object3)).getRssWqGeometry();
        if (object2 == null) {
            ((FluentLogger.Api)a.atInfo()).log("savePanel:no selected WQ Geometry to save for " + String.valueOf(parameterSetManager));
            return false;
        }
        for (n = 3; n < this._paramTable.getColumnCount(); n += 3) {
            ArrayList<WQParameterSetting> arrayList2 = new ArrayList<WQParameterSetting>();
            object3 = new ArrayList();
            int n2 = n + 1;
            this.saveTableData(arrayList2, (List<WQParameterOptionSetting>)object3, n2);
            if (n == 3) {
                wQParameterSet.setParameterSettings(arrayList2);
                wQParameterSet.setParameterOptionSettings((Collection)object3);
                continue;
            }
            WQRegion wQRegion = this.getRegionFor(n);
            wQRegion = object2.getRegionSet().buildRef((Region)wQRegion);
            wQParameterSet.setParameterOptionSettings((RegionRef)wQRegion, (Collection)object3);
            wQParameterSet.setParameterSettings((RegionRef)wQRegion, arrayList2);
        }
        parameterSetManager.setSet(((JsonManager)((Object)object)).getIndex(), wQParameterSet);
        parameterSetManager.setModified(true);
        this.setModified(false);
        return true;
    }

    private WQRegion getRegionFor(int n) {
        ColumnGroup columnGroup;
        JTableHeader jTableHeader = this._paramTable.getTableHeader();
        if (jTableHeader instanceof GroupableTableHeader && (columnGroup = (jTableHeader = (GroupableTableHeader)jTableHeader).getColumnGroup(n /= 3)) instanceof ParameterSetPanel$RegionColumnGroup) {
            columnGroup = (ParameterSetPanel$RegionColumnGroup)columnGroup;
            return (WQRegion)columnGroup.a();
        }
        return null;
    }

    private void saveTableData(List<WQParameterSetting> list, List<WQParameterOptionSetting> list2, int n) {
        int n2 = this._paramTable.getRowCount();
        this._paramTable.getColumnModel();
        for (int i = 0; i < n2; ++i) {
            ParamOptSelection paramOptSelection;
            Object object;
            Object object2 = this._tableModel.getParameterForRow(i);
            if (object2 instanceof WQParameter) {
                double d;
                object2 = (WQParameter)object2;
                boolean bl = false;
                WQParameterSetting wQParameterSetting = new WQParameterSetting(object2.getId());
                object2 = this._tableModel.getValueAt(i, n);
                object = this._tableModel.getValueAt(i, n + 1);
                paramOptSelection = (WQParameterType)this._tableModel.getValueAt(i, n - 1);
                boolean bl2 = this.setParameterSettingValue((WQParameterType)paramOptSelection, object2, wQParameterSetting, false);
                if (object != null && RMAConst.isValidValue((double)(d = RMAIO.parseDouble((Object)object)))) {
                    wQParameterSetting.setTheta(Double.valueOf(d));
                    bl = true;
                }
                if (!bl2 && !bl) continue;
                list.add(wQParameterSetting);
                continue;
            }
            if (!(object2 instanceof WQParameterOption)) continue;
            object = (WQParameterOption)object2;
            object2 = this._tableModel.getValueAt(i, n);
            if (!(object2 instanceof ParamOptSelection)) continue;
            paramOptSelection = (ParamOptSelection)object2;
            object2 = new WQParameterOptionSetting(object.getId());
            object2.setOption(Integer.valueOf(paramOptSelection.a()));
            list2.add((WQParameterOptionSetting)object2);
        }
    }

    private boolean setParameterSettingValue(WQParameterType wQParameterType, Object object, WQParameterSetting wQParameterSetting, boolean bl) {
        WQParameterSettingValue wQParameterSettingValue = wQParameterSetting.getParameterValue();
        if (WQParameterType.Value == wQParameterType) {
            double d = RMAIO.parseDouble((Object)object);
            if (RMAConst.isValidValue((double)d)) {
                if (wQParameterSettingValue instanceof WQParameterSettingDoubleValue) {
                    if (d != (Double)((WQParameterSettingDoubleValue)wQParameterSettingValue).getValue()) {
                        ((WQParameterSettingDoubleValue)wQParameterSettingValue).setValue((Object)d);
                    }
                } else {
                    wQParameterSetting.setParameterValue((WQParameterSettingValue)new WQParameterSettingDoubleValue(Double.valueOf(d)));
                    bl = true;
                }
            }
        } else if (WQParameterType.Table == wQParameterType) {
            SeasonalVariationData seasonalVariationData = (SeasonalVariationData)object;
            if (wQParameterSettingValue instanceof WQParameterSettingSeasonalVariationValue) {
                ((WQParameterSettingSeasonalVariationValue)wQParameterSettingValue).setValue((Object)seasonalVariationData);
            } else {
                WQParameterSettingSeasonalVariationValue wQParameterSettingSeasonalVariationValue = new WQParameterSettingSeasonalVariationValue();
                wQParameterSettingSeasonalVariationValue.setValue((Object)seasonalVariationData);
                wQParameterSetting.setParameterValue((WQParameterSettingValue)wQParameterSettingSeasonalVariationValue);
            }
            bl = true;
        } else if (WQParameterType.TimeSeries == wQParameterType) {
            if (wQParameterSettingValue instanceof WQParameterSettingDSSValue) {
                DssData dssData = (DssData)object;
                ((WQParameterSettingDSSValue)wQParameterSettingValue).setValue((Object)dssData);
            } else if (wQParameterSettingValue instanceof WQParameterSettingStateVariableValue) {
                StateVariableIdentifier stateVariableIdentifier = (StateVariableIdentifier)object;
                ((WQParameterSettingStateVariableValue)wQParameterSettingValue).setValue((Object)stateVariableIdentifier);
            } else if (object instanceof DssData) {
                WQParameterSettingDSSValue wQParameterSettingDSSValue = new WQParameterSettingDSSValue();
                wQParameterSettingDSSValue.setValue((Object)((DssData)object));
                wQParameterSetting.setParameterValue((WQParameterSettingValue)wQParameterSettingDSSValue);
            } else {
                WQParameterSettingStateVariableValue wQParameterSettingStateVariableValue = new WQParameterSettingStateVariableValue();
                wQParameterSettingStateVariableValue.setValue((Object)((StateVariableIdentifier)object));
                wQParameterSetting.setParameterValue((WQParameterSettingValue)wQParameterSettingStateVariableValue);
            }
            bl = true;
        }
        return bl;
    }

    public void setWorkspace(ManagerProxyListContainer managerProxyListContainer) {
        this._wksp = managerProxyListContainer;
    }

    public void restoreDefaultsAction() {
        this._paramTable.commitEdit(true);
        ParameterSetTableModel parameterSetTableModel = (ParameterSetTableModel)((Object)this._paramTable.getModel());
        parameterSetTableModel.resetDefaults();
        this.setModified(true);
    }

    public ManagerProxy getConstituentSetProxy() {
        return this._constituentSetProxy;
    }
}

