/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.wqParameters;

import hec.rss.model.StateVariable;
import hec.rss.wq.client.wqParameters.ParamOptSelection;
import hec.rss.wq.client.wqParameters.ParameterSetEditor;
import hec.rss.wq.client.wqParameters.ParameterSetTableModel$DefaultTypeValuesFactory;
import hec.rss.wq.client.wqParameters.ParameterSetTableModel$TableParameter;
import hec.rss.wq.client.wqParameters.ParameterSetTableModel$TableParameterOption;
import hec.rss.wq.client.wqParameters.ParameterSetTableModel$TableRow;
import hec.rss.wq.model.ConstituentSetManager;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.model.wqParameters.ParameterSetManager;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.ConstituentSet;
import hec.wqenginecore.Region;
import hec.wqenginecore.SeasonalVariationData;
import hec.wqenginecore.StateVariableIdentifier;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.parameter.Parameter;
import hec.wqenginecore.parameter.ParameterOption;
import hec.wqenginecore.parameter.ParameterSet;
import hec.wqenginecore.parameter.ParameterSettingValue;
import hec.wqenginecore.parameter.WQParameterTimeSeriesType;
import hec.wqenginecore.parameter.WQParameterType;
import hec.wqengineimpl.WQLibraryRegistryImpl;
import hec.wqengineimpl.libraries.BaseWQLibrary;
import hec.wqengineimpl.parameter.WQParameter;
import hec.wqengineimpl.parameter.WQParameterOption;
import hec.wqengineimpl.parameter.WQParameterSetting;
import hec.wqengineimpl.parameter.WQParameterSettingDSSValue;
import hec.wqengineimpl.parameter.WQParameterSettingDoubleValue;
import hec.wqengineimpl.parameter.WQParameterSettingSeasonalVariationValue;
import hec.wqengineimpl.parameter.WQParameterSettingStateVariableValue;
import hec.wqengineimpl.parameter.WQParameterSettingTimeSeriesValue;
import hec.wqengineimpl.parameter.WQParameterSettingValue;
import hec.wqengineimpl.region.WQDefaultRegion;
import hec.wqengineimpl.region.WQRegionSet;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringEscapeUtils;
import rma.swing.RmaJTable;
import rma.swing.table.AbstractRmaTableModel;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class ParameterSetTableModel
extends AbstractRmaTableModel {
    public static final int NUM_OF_VALUE_COLS = 3;
    public static final int GROUP_COL = 0;
    public static final int PARAMETER_COL = 1;
    public static final int UNITS_COL = 2;
    public static final int COMBO_COL = 4;
    public static final int TYPE_COL_INDEX = 0;
    public static final int VALUE_COL_INDEX = 1;
    public static final int THETA_COL_INDEX = 2;
    public static final int BASE_TYPE_COL = 3;
    public static final int BASE_VALUE_COL = 4;
    public static final int BASE_THETA_COL = 5;
    private ParameterSetManager _paramSet;
    private WqGeometry _geometry;
    private ConstituentSetManager _constituentSet;
    private List<ParameterSetTableModel$TableRow> _rows = new ArrayList<ParameterSetTableModel$TableRow>();
    private Map<Integer, ParameterSetTableModel$TableParameter> _parameters = new HashMap<Integer, ParameterSetTableModel$TableParameter>();
    private Map<Integer, ParameterSetTableModel$TableParameterOption> _parameterOptions = new HashMap<Integer, ParameterSetTableModel$TableParameterOption>();
    private WQLibraryRegistryImpl _library;
    private Map<Integer, Region> _col2RegionMap = new HashMap<Integer, Region>();
    private RmaJTable _table;

    public ParameterSetTableModel(RmaJTable rmaJTable, ParameterSetManager parameterSetManager, ConstituentSetManager constituentSetManager) {
        this._table = rmaJTable;
        this._paramSet = parameterSetManager;
        if (this._paramSet != null) {
            this._geometry = this._paramSet.getGeometry();
        }
        this.setConstituentSet(constituentSetManager);
        this.buildHeaders();
        this.fillModel();
    }

    public WqGeometry getGeometry() {
        return this._geometry;
    }

    public void setConstituentSet(ConstituentSetManager constituentSetManager) {
        this._constituentSet = constituentSetManager;
        this.fillModel();
    }

    public boolean isCellEditable(int n, int n2) {
        if (n >= this._rows.size()) {
            return false;
        }
        if (n2 > 2) {
            Object object = this._rows.get(n);
            if (object.b() != null) {
                return n2 == 4 || n2 > 4 && n2 % 3 == 1;
            }
            return n2 % 3 != 2 || (object = object.a()) == null || object.getDefaultTheta() != -9999.0;
        }
        return false;
    }

    private void fillModel() {
        WQRegionSet wQRegionSet;
        Iterator<Object> iterator;
        this._rows.clear();
        if (this._constituentSet == null || this._paramSet == null) {
            this.fireTableDataChanged();
            return;
        }
        ConstituentSet constituentSet = this._constituentSet.getSet();
        Object object = constituentSet.getConstituentList();
        int n = 0;
        if (this._geometry != null && (iterator = this._geometry.getRssWqGeometry()) != null && (wQRegionSet = iterator.getRegionSet()) != null) {
            n = wQRegionSet.getRegions().size();
        }
        iterator = new TreeSet();
        wQRegionSet = object.iterator();
        while (wQRegionSet.hasNext()) {
            object = (Constituent)wQRegionSet.next();
            object = object.getLibraryName();
            iterator.add(object);
        }
        iterator = iterator.iterator();
        wQRegionSet = this._paramSet.getSet(this._constituentSet.getIndex());
        while (iterator.hasNext()) {
            Object object2;
            Object object3;
            Object object4;
            Parameter parameter;
            Iterator iterator2;
            object = (String)iterator.next();
            BaseWQLibrary baseWQLibrary = this.getLibrary((String)object);
            if (baseWQLibrary != null && (object = baseWQLibrary.getParameters(constituentSet)) != null) {
                iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    parameter = (Parameter)iterator2.next();
                    object = wQRegionSet.getParameterSetting(parameter.getId());
                    if (object == null) {
                        object = new WQParameterSetting(parameter.getId());
                        object.setParameterValue((WQParameterSettingValue)new WQParameterSettingDoubleValue(parameter.getDefaultValue()));
                        ((WQParameterSetting)object).setTheta(parameter.getDefaultTheta());
                    }
                    if (!(object instanceof WQParameterSetting)) continue;
                    object4 = (WQParameterSetting)object;
                    object3 = this._parameters.get(parameter.getId());
                    object2 = object4.getParameterValue();
                    if (object3 == null) {
                        object4 = baseWQLibrary.getParameterGroupName(Integer.valueOf(parameter.getGroupId()));
                        object3 = new ParameterSetTableModel$TableParameter((WQParameter)parameter, (String)object4);
                        if (object2 != null) {
                            ((ParameterSetTableModel$TableParameter)((Object)object3)).a((ParameterSettingValue<?>)object2);
                        }
                        if ((object = object.getTheta()) != null) {
                            ((ParameterSetTableModel$TableParameter)((Object)object3)).a((Double)object);
                        }
                        this._parameters.put(parameter.getId(), (ParameterSetTableModel$TableParameter)((Object)object3));
                    }
                    object = new ParameterSetTableModel$TableRow((ParameterSetTableModel$TableParameter)((Object)object3));
                    ((ParameterSetTableModel$TableRow)object).a(n);
                    this.fillParameterRegionValues((ParameterSetTableModel$TableRow)object);
                    this._rows.add((ParameterSetTableModel$TableRow)object);
                }
            }
            if ((object = baseWQLibrary.getParameterOptions(constituentSet)) == null) continue;
            iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                parameter = (ParameterOption)iterator2.next();
                object4 = this._parameterOptions.get(parameter.getId());
                if (object4 == null) {
                    object4 = baseWQLibrary.getParameterGroupName(Integer.valueOf(parameter.getGroupId()));
                    object = wQRegionSet.getParameterOptionSetting(parameter.getId());
                    object4 = new ParameterSetTableModel$TableParameterOption((WQParameterOption)parameter, (String)object4);
                    if (object != null && (object3 = object.getOption()) != null) {
                        object2 = parameter.getOptions();
                        object = (String)object2.get(object3);
                        object = new ParamOptSelection((Integer)object3, (String)object);
                        object4.a((ParamOptSelection)object);
                    }
                    this._parameterOptions.put(parameter.getId(), (ParameterSetTableModel$TableParameterOption)((Object)object4));
                }
                object3 = new ParameterSetTableModel$TableRow((ParameterSetTableModel$TableParameterOption)((Object)object4));
                this.fillParameterOptionRegionValues((ParameterSetTableModel$TableRow)object3);
                ((ParameterSetTableModel$TableRow)object3).a(n);
                this._rows.add((ParameterSetTableModel$TableRow)object3);
            }
        }
        this.fireTableDataChanged();
    }

    private void fillParameterOptionRegionValues(ParameterSetTableModel$TableRow parameterSetTableModel$TableRow) {
        Iterator iterator;
        ParameterSetTableModel$TableParameterOption parameterSetTableModel$TableParameterOption = parameterSetTableModel$TableRow.b();
        ParameterSet parameterSet = this._paramSet.getSet(this._constituentSet.getIndex());
        WQRegionSet wQRegionSet = null;
        if (this._geometry != null && (iterator = this._geometry.getRssWqGeometry()) != null) {
            wQRegionSet = iterator.getRegionSet();
        }
        if (wQRegionSet != null) {
            iterator = wQRegionSet.getRegions();
            iterator = iterator.iterator();
            ParameterSetTableModel$TableParameterOption parameterSetTableModel$TableParameterOption2 = parameterSetTableModel$TableRow.b();
            while (iterator.hasNext()) {
                Region region = (Region)iterator.next();
                ParameterSetTableModel$TableParameterOption parameterSetTableModel$TableParameterOption3 = new ParameterSetTableModel$TableParameterOption(parameterSetTableModel$TableParameterOption2, parameterSetTableModel$TableParameterOption.b());
                Object object = parameterSet.getParameterOptionSetting(parameterSetTableModel$TableParameterOption.getId(), wQRegionSet.buildRef(region));
                if (object != null && (object = object.getOption()) != null) {
                    Object object2 = parameterSetTableModel$TableParameterOption2.getOptions();
                    object2 = (String)object2.get(object);
                    object = new ParamOptSelection((Integer)object, (String)object2);
                    parameterSetTableModel$TableParameterOption3.a((ParamOptSelection)object);
                }
                parameterSetTableModel$TableRow.a(region.getId(), parameterSetTableModel$TableParameterOption3);
            }
        }
    }

    private void fillParameterRegionValues(ParameterSetTableModel$TableRow parameterSetTableModel$TableRow) {
        Iterator iterator;
        ParameterSetTableModel$TableParameter parameterSetTableModel$TableParameter = parameterSetTableModel$TableRow.a();
        ParameterSet parameterSet = this._paramSet.getSet(this._constituentSet.getIndex());
        WQRegionSet wQRegionSet = null;
        if (this._geometry != null && (iterator = this._geometry.getRssWqGeometry()) != null) {
            wQRegionSet = iterator.getRegionSet();
        }
        if (wQRegionSet != null) {
            iterator = wQRegionSet.getRegions();
            iterator = iterator.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Object object = (WQParameterSetting)parameterSet.getParameterSetting(parameterSetTableModel$TableParameter.getId(), wQRegionSet.buildRef((Region)iterator.next()));
                if (object != null) {
                    WQParameterType wQParameterType = object.getType();
                    WQParameterSettingValue wQParameterSettingValue = object.getParameterValue();
                    object = object.getTheta();
                    if (wQParameterType != null) {
                        parameterSetTableModel$TableRow.a(n, wQParameterType);
                    }
                    if (object != null) {
                        parameterSetTableModel$TableRow.a(n, (Double)object);
                    }
                    if (wQParameterSettingValue != null) {
                        parameterSetTableModel$TableRow.a(n, (ParameterSettingValue<?>)wQParameterSettingValue);
                    }
                }
                ++n;
            }
        }
    }

    public void clearAll() {
        this._rows.clear();
        this.fireTableDataChanged();
    }

    private BaseWQLibrary getLibrary(String string) {
        if (this._library == null) {
            this._library = new WQLibraryRegistryImpl();
        }
        return (BaseWQLibrary)this._library.getLibrary(string);
    }

    public void resetDefaults() {
        int n;
        ArrayList<Runnable> arrayList = new ArrayList<Runnable>();
        for (n = 0; n < this._rows.size(); ++n) {
            Object object;
            Object object2;
            Object object3 = this._rows.get(n);
            ParameterSetTableModel$TableParameter parameterSetTableModel$TableParameter = ((ParameterSetTableModel$TableRow)object3).a();
            int n2 = n;
            if (parameterSetTableModel$TableParameter != null) {
                object3 = parameterSetTableModel$TableParameter.d();
                object2 = parameterSetTableModel$TableParameter.getDefaultTheta();
                object = parameterSetTableModel$TableParameter.getDefaultValue();
                if ((Double)object2 != -9999.0 && ((Double)object2).doubleValue() != parameterSetTableModel$TableParameter.b()) {
                    parameterSetTableModel$TableParameter.a((Double)object2);
                    arrayList.add(() -> this.fireTableCellUpdated(n2, 5));
                }
                if (parameterSetTableModel$TableParameter.a().getValue() == object && parameterSetTableModel$TableParameter.a().getType() == object3) continue;
                object2 = new WQParameterSettingDoubleValue();
                object2.setValue(object);
                parameterSetTableModel$TableParameter.a((ParameterSettingValue<?>)object2);
                arrayList.add(() -> this.fireTableCellUpdated(n2, 3));
                arrayList.add(() -> this.fireTableCellUpdated(n2, 4));
                continue;
            }
            if (((ParameterSetTableModel$TableRow)object3).b() == null) continue;
            object3 = ((ParameterSetTableModel$TableRow)object3).b();
            int n3 = object3.getDefaultOption();
            object = (String)object3.getOptions().get(n3);
            object2 = new ParamOptSelection(n3, (String)object);
            if (((ParameterSetTableModel$TableParameterOption)((Object)object3)).a().equals(object2)) continue;
            ((ParameterSetTableModel$TableParameterOption)((Object)object3)).a((ParamOptSelection)object2);
            arrayList.add(() -> this.fireTableCellUpdated(n2, 3));
            arrayList.add(() -> this.fireTableCellUpdated(n2, 4));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            EventQueue.invokeLater((Runnable)arrayList.get(n));
        }
    }

    protected String getParamFile(String string) {
        MessageFormat messageFormat = new MessageFormat("resources/WQDLL_{0}.param");
        return messageFormat.format(new Object[]{string});
    }

    public int getRowCount() {
        return this._rows.size();
    }

    public String getToolTipText(boolean bl, int n, int n2) {
        ParameterSetTableModel$TableParameter parameterSetTableModel$TableParameter;
        if (n < 0 || n >= this._rows.size()) {
            return null;
        }
        if (n2 < 0 || n2 >= this.getColumnCount()) {
            return null;
        }
        if (bl && n2 < 2) {
            Object object = this._rows.get(n);
            parameterSetTableModel$TableParameter = ((ParameterSetTableModel$TableRow)object).a();
            if (parameterSetTableModel$TableParameter != null) {
                return "Parameter=" + parameterSetTableModel$TableParameter.getName() + " ID=" + parameterSetTableModel$TableParameter.getId() + " GroupID=" + parameterSetTableModel$TableParameter.getGroupId();
            }
            if ((object = ((ParameterSetTableModel$TableRow)object).b()) != null) {
                return "Parameter Option=" + object.getName() + " ID=" + object.getId() + " GroupId=" + object.getGroupId() + " Selection ID=" + ((ParameterSetTableModel$TableParameterOption)((Object)object)).a().a();
            }
        }
        if (n2 > 2 && this.isValueColumn(n2)) {
            Object object = this._rows.get(n);
            parameterSetTableModel$TableParameter = ((ParameterSetTableModel$TableRow)object).a();
            object = "";
            if (parameterSetTableModel$TableParameter != null && WQParameterType.Value == this.getType(n, n2)) {
                if (parameterSetTableModel$TableParameter.getNormalMin() != null && parameterSetTableModel$TableParameter.getNormalMin() != -9999.0) {
                    object = "<html>Normal Range: " + parameterSetTableModel$TableParameter.getNormalMin() + " to " + parameterSetTableModel$TableParameter.getNormalMax();
                }
                if (parameterSetTableModel$TableParameter.getAbsMin() != null && parameterSetTableModel$TableParameter.getAbsMin() != -9999.0) {
                    if (!((String)object).isEmpty()) {
                        object = (String)object + "<br>";
                    }
                    object = (String)object + "Absolute Range: " + parameterSetTableModel$TableParameter.getAbsMin() + " to " + parameterSetTableModel$TableParameter.getAbsMax();
                }
                if (!((String)object).isEmpty()) {
                    return object;
                }
            } else if ((WQParameterType.Table == this.getType(n, n2) || WQParameterType.TimeSeries == this.getType(n, n2)) && (object = this.getValueAt(n, n2)) != null) {
                return object.toString();
            }
        }
        return null;
    }

    WQParameterType getType(int n, int n2) {
        return (WQParameterType)this.getValueAt(n, n2 - 1);
    }

    boolean isValueColumn(int n) {
        return n % 3 == 1;
    }

    public Object getParameterForRow(int n) {
        if (n < 0 || n >= this._rows.size()) {
            return null;
        }
        ParameterSetTableModel$TableRow parameterSetTableModel$TableRow = this._rows.get(n);
        ParameterSetTableModel$TableParameter parameterSetTableModel$TableParameter = parameterSetTableModel$TableRow.a();
        if (parameterSetTableModel$TableParameter != null) {
            return parameterSetTableModel$TableParameter;
        }
        return parameterSetTableModel$TableRow.b();
    }

    public Object getValueAt(int n, int n2) {
        if (n < 0 || n >= this._rows.size()) {
            return null;
        }
        if (n2 < 0 || n2 >= this.getColumnCount()) {
            return null;
        }
        ParameterSetTableModel$TableRow parameterSetTableModel$TableRow = this._rows.get(n);
        ParameterSetTableModel$TableParameter parameterSetTableModel$TableParameter = parameterSetTableModel$TableRow.a();
        switch (n2) {
            case 0: {
                if (parameterSetTableModel$TableParameter != null) {
                    return parameterSetTableModel$TableParameter.c();
                }
                return parameterSetTableModel$TableRow.b().b();
            }
            case 1: {
                if (parameterSetTableModel$TableParameter != null) {
                    return parameterSetTableModel$TableParameter.getDescription();
                }
                return parameterSetTableModel$TableRow.b().getName();
            }
            case 2: {
                if (parameterSetTableModel$TableParameter != null) {
                    String string = parameterSetTableModel$TableParameter.getUnits();
                    return StringEscapeUtils.unescapeJava((String)string);
                }
                return "";
            }
            case 3: {
                if (parameterSetTableModel$TableParameter != null) {
                    return parameterSetTableModel$TableParameter.e();
                }
                return WQParameterType.Value;
            }
            case 4: {
                if (parameterSetTableModel$TableParameter != null) {
                    return this.getParamValueInTable(parameterSetTableModel$TableParameter.a(), parameterSetTableModel$TableParameter.e());
                }
                if (parameterSetTableModel$TableRow.b() != null) {
                    ParameterSetTableModel$TableParameterOption parameterSetTableModel$TableParameterOption = parameterSetTableModel$TableRow.b();
                    return parameterSetTableModel$TableParameterOption.a();
                }
                return null;
            }
            case 5: {
                double d;
                if (parameterSetTableModel$TableParameter != null && (d = parameterSetTableModel$TableParameter.b()) != -9999.0) {
                    return d;
                }
                return null;
            }
        }
        if (n2 > 3 && parameterSetTableModel$TableRow.b() != null) {
            if (n2 % 3 == 1) {
                int n3 = this.getRegionIdForCol(n2);
                ParameterSetTableModel$TableParameterOption parameterSetTableModel$TableParameterOption = parameterSetTableModel$TableRow.e(n3);
                if (parameterSetTableModel$TableParameterOption != null) {
                    return parameterSetTableModel$TableParameterOption.a();
                }
            } else if (n2 % 3 == 0) {
                int n4 = this.getRegionIdForCol(n2);
                WQParameterType wQParameterType = parameterSetTableModel$TableRow.d(n4);
                return wQParameterType;
            }
        } else if (parameterSetTableModel$TableRow.a() != null) {
            int n5 = n2 - 6;
            if (n2 % 3 == 0) {
                n2 = n5 / 3;
                return parameterSetTableModel$TableRow.d(n2);
            }
            if (n2 % 3 == 1) {
                n2 = n5 / 3;
                return this.getValueForRegion(parameterSetTableModel$TableRow, n2);
            }
            if (n2 % 3 != 2) {
                throw new IllegalArgumentException("Invalid column index: " + n2);
            }
            n2 = n5 / 3;
            double d = parameterSetTableModel$TableRow.c(n2);
            if (RMAConst.isValidValue((double)d)) {
                return d;
            }
        }
        return null;
    }

    private Object getValueForRegion(ParameterSetTableModel$TableRow parameterSetTableModel$TableRow, int n) {
        ParameterSettingValue<?> parameterSettingValue = parameterSetTableModel$TableRow.b(n);
        parameterSetTableModel$TableRow = parameterSetTableModel$TableRow.d(n);
        return this.getParamValueInTable(parameterSettingValue, (WQParameterType)parameterSetTableModel$TableRow);
    }

    private Object getParamValueInTable(ParameterSettingValue<?> parameterSettingValue, WQParameterType wQParameterType) {
        Object object = null;
        if (parameterSettingValue != null) {
            switch (wQParameterType) {
                case Value: {
                    if (parameterSettingValue.getValue() == null || !RMAConst.isValidValue((double)((Double)parameterSettingValue.getValue()))) break;
                }
                default: {
                    object = parameterSettingValue.getValue();
                }
            }
        }
        return object;
    }

    private int getRegionIdForCol(int n) {
        Region region = this._col2RegionMap.get(n = n / 3 * 3);
        if (region != null) {
            return region.getId();
        }
        return -1;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 <= 2) {
            return;
        }
        ParameterSetTableModel$TableRow parameterSetTableModel$TableRow = this._rows.get(n);
        if (n2 == 4 && parameterSetTableModel$TableRow.b() != null) {
            if (object instanceof ParamOptSelection) {
                parameterSetTableModel$TableRow.b().a((ParamOptSelection)object);
            }
        } else if (n2 > 4 && n2 % 3 == 1 && parameterSetTableModel$TableRow.b() != null) {
            if (object instanceof ParamOptSelection) {
                int n3 = this.getRegionIdForCol(n2);
                ParameterSetTableModel$TableParameterOption parameterSetTableModel$TableParameterOption = parameterSetTableModel$TableRow.e(n3);
                parameterSetTableModel$TableParameterOption.a((ParamOptSelection)object);
            }
        } else if (n2 == 3) {
            ParameterSetTableModel$TableParameter parameterSetTableModel$TableParameter = parameterSetTableModel$TableRow.a();
            WQParameterType wQParameterType = parameterSetTableModel$TableParameter.e();
            if (wQParameterType != object) {
                WQParameterSettingValue<?> wQParameterSettingValue = ParameterSetTableModel$DefaultTypeValuesFactory.a((WQParameterType)object);
                parameterSetTableModel$TableParameter.a((ParameterSettingValue<?>)wQParameterSettingValue);
            }
        } else if (n2 == 4) {
            WQParameterSettingTimeSeriesValue wQParameterSettingTimeSeriesValue;
            ParameterSetTableModel$TableParameter parameterSetTableModel$TableParameter = parameterSetTableModel$TableRow.a();
            WQParameterType wQParameterType = parameterSetTableModel$TableParameter.e();
            if (wQParameterType == WQParameterType.Value) {
                double d = RMAIO.parseDouble((Object)object);
                if (this.isValidValue(parameterSetTableModel$TableParameter, d)) {
                    object = (WQParameterSettingDoubleValue)parameterSetTableModel$TableParameter.a();
                    object.setValue((Object)d);
                }
            } else if (wQParameterType == WQParameterType.Table && object instanceof SeasonalVariationData) {
                SeasonalVariationData seasonalVariationData = (SeasonalVariationData)object;
                WQParameterSettingSeasonalVariationValue wQParameterSettingSeasonalVariationValue = (WQParameterSettingSeasonalVariationValue)parameterSetTableModel$TableParameter.a();
                wQParameterSettingSeasonalVariationValue.setValue((Object)seasonalVariationData);
            } else if (wQParameterType == WQParameterType.TimeSeries && (wQParameterSettingTimeSeriesValue = (WQParameterSettingTimeSeriesValue)parameterSetTableModel$TableParameter.a()) != null) {
                this.updateTimeSeriesValue(wQParameterSettingTimeSeriesValue, object, parameterSetTableModel$TableParameter::a);
            }
        } else if (n2 == 5) {
            ParameterSetTableModel$TableParameter parameterSetTableModel$TableParameter = parameterSetTableModel$TableRow.a();
            double d = RMAIO.parseDouble((Object)object);
            parameterSetTableModel$TableParameter.a(d);
        } else {
            int n4 = n2 - 6;
            if (n2 % 3 == 0) {
                this.changeRegionType(parameterSetTableModel$TableRow, n4 /= 3, (WQParameterType)object);
                parameterSetTableModel$TableRow.setModified(true);
            } else if (n2 % 3 == 2) {
                double d = RMAIO.parseDouble((Object)object);
                --n4;
                parameterSetTableModel$TableRow.a(n4 /= 3, d);
                parameterSetTableModel$TableRow.setModified(true);
            } else {
                this.setRegionValue(parameterSetTableModel$TableRow, n4 /= 3, object);
                parameterSetTableModel$TableRow.setModified(true);
            }
        }
        this.fireTableCellUpdated(n, n2);
    }

    private void changeRegionType(ParameterSetTableModel$TableRow parameterSetTableModel$TableRow, int n, WQParameterType wQParameterType) {
        WQParameterType wQParameterType2 = parameterSetTableModel$TableRow.d(n);
        if (wQParameterType2 != wQParameterType) {
            parameterSetTableModel$TableRow.a(n, wQParameterType);
        }
    }

    private void setRegionValue(ParameterSetTableModel$TableRow parameterSetTableModel$TableRow, int n, Object object) {
        WQParameterSettingTimeSeriesValue wQParameterSettingTimeSeriesValue2;
        WQParameterType wQParameterType = parameterSetTableModel$TableRow.d(n);
        if (wQParameterType == WQParameterType.Value) {
            double d = RMAIO.parseDouble((Object)object);
            if ((parameterSetTableModel$TableRow = (WQParameterSettingDoubleValue)parameterSetTableModel$TableRow.b(n)) != null) {
                parameterSetTableModel$TableRow.setValue(d);
            }
            return;
        }
        if (wQParameterType == WQParameterType.Table && object instanceof SeasonalVariationData) {
            SeasonalVariationData seasonalVariationData = (SeasonalVariationData)object;
            WQParameterSettingSeasonalVariationValue wQParameterSettingSeasonalVariationValue = (WQParameterSettingSeasonalVariationValue)parameterSetTableModel$TableRow.b(n);
            if (wQParameterSettingSeasonalVariationValue != null) {
                wQParameterSettingSeasonalVariationValue.setValue((Object)seasonalVariationData);
            }
            return;
        }
        if (wQParameterType == WQParameterType.TimeSeries && (wQParameterSettingTimeSeriesValue2 = (WQParameterSettingTimeSeriesValue)parameterSetTableModel$TableRow.b(n)) != null) {
            this.updateTimeSeriesValue(wQParameterSettingTimeSeriesValue2, object, wQParameterSettingTimeSeriesValue -> parameterSetTableModel$TableRow.a(n, (ParameterSettingValue<?>)wQParameterSettingTimeSeriesValue));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateTimeSeriesValue(WQParameterSettingTimeSeriesValue<?> wQParameterSettingDSSValue, Object object, Consumer<WQParameterSettingTimeSeriesValue<?>> consumer) {
        if (object instanceof DssData) {
            object = (DssData)object;
            if (wQParameterSettingDSSValue.getTimeSeriesType() == WQParameterTimeSeriesType.DSS) {
                wQParameterSettingDSSValue.setValue(object);
                return;
            }
            wQParameterSettingDSSValue = new WQParameterSettingDSSValue();
            wQParameterSettingDSSValue.setValue(object);
            consumer.accept((WQParameterSettingTimeSeriesValue<?>)wQParameterSettingDSSValue);
            return;
        }
        if (!(object instanceof StateVariable)) return;
        object = (StateVariable)object;
        if (wQParameterSettingDSSValue.getTimeSeriesType() == WQParameterTimeSeriesType.StateVariable) {
            ((WQParameterSettingStateVariableValue)wQParameterSettingDSSValue).setValue((Object)new StateVariableIdentifier(object.getName(), object.getIndex()));
            return;
        }
        wQParameterSettingDSSValue = new WQParameterSettingStateVariableValue();
        wQParameterSettingDSSValue.setValue((Object)new StateVariableIdentifier(object.getName(), object.getIndex()));
        consumer.accept((WQParameterSettingTimeSeriesValue<?>)wQParameterSettingDSSValue);
    }

    private boolean isValidValue(ParameterSetTableModel$TableParameter object, double d) {
        Double d2 = object.getAbsMin();
        Double d3 = object.getAbsMax();
        boolean bl = true;
        Window window = SwingUtilities.windowForComponent((Component)this._table);
        if (RMAConst.isUndefinedValue((double)d)) {
            return true;
        }
        if (d < 0.0 && object.getId() != 1002 && object.getId() != 1005) {
            object = WqI18n.a("Param.ParamSetPanel.Msg.ValueGreaterThanZero").format((Object)object.getDescription());
            String string = WqI18n.a("Param.ParamSetPanel.Msg.ValueGreaterThanZero.Title").getText();
            JOptionPane.showMessageDialog(window, object, string, 1);
            return false;
        }
        if (d2 != null && d2 != -9999.0 && d < d2) {
            bl = false;
        }
        if (d3 != null && d3 != -9999.0 && d > d3) {
            bl = false;
        }
        if (!bl) {
            object = WqI18n.a("Param.ParamSetPanel.Msg.InvalidValue").format(new Object[]{object.getDescription(), d2, d3});
            String string = WqI18n.a("Param.ParamSetPanel.Msg.InvalidValue.Title").getText();
            JOptionPane.showMessageDialog(window, object, string, 1);
            return false;
        }
        return true;
    }

    public Map<Integer, ParameterOption> getParameterOptionsRows() {
        HashMap<Integer, ParameterOption> hashMap = new HashMap<Integer, ParameterOption>();
        for (int i = 0; i < this._rows.size(); ++i) {
            ParameterSetTableModel$TableRow parameterSetTableModel$TableRow = this._rows.get(i);
            if (parameterSetTableModel$TableRow.b() == null) continue;
            hashMap.put(i, (ParameterOption)parameterSetTableModel$TableRow.b());
        }
        return hashMap;
    }

    private void buildHeaders() {
        Object object2;
        this._col2RegionMap.clear();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(WqI18n.a("Param.ParamSetPanel.Header.Group").getText());
        arrayList.add(WqI18n.a("Param.ParamSetPanel.Header.Name").getText());
        arrayList.add(WqI18n.a("Param.ParamSetPanel.Header.Units").getText());
        arrayList.add(WqI18n.a("Param.ParamSetPanel.Header.Type").getText());
        arrayList.add(WqI18n.a("Param.ParamSetPanel.Header.Value").getText());
        arrayList.add(WqI18n.a("Param.ParamSetPanel.Header.Theta").getText());
        int n = 6;
        if (this._geometry != null && (object2 = this._geometry.getRssWqGeometry()) != null && (object2 = object2.getRegionSet()) != null) {
            object2 = object2.getRegions();
            for (Object object2 : object2) {
                if (!(object2 instanceof WQDefaultRegion) && (object2.getElements() == null || object2.getElements().isEmpty())) continue;
                this._col2RegionMap.put(n, (Region)object2);
                arrayList.add(WqI18n.a("Param.ParamSetPanel.Header.Type").getText());
                arrayList.add(WqI18n.a("Param.ParamSetPanel.Header.Value").getText());
                arrayList.add(WqI18n.a("Param.ParamSetPanel.Header.Theta").getText());
                n += 3;
            }
        }
        object2 = new String[arrayList.size()];
        this.m_columnNames = arrayList.toArray((T[])object2);
    }

    public ConstituentSetManager getConstituentSet() {
        return this._constituentSet;
    }

    static {
        Logger.getLogger(ParameterSetEditor.class.getName());
    }
}

