/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.client.wqParameters;

import hec.rss.model.StateVariable;
import hec.rss.wq.client.wqParameters.StateVariablePanel;
import hec.rss.wq.dataSources.dss.DssPlotPanel;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.StateVariableIdentifier;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.parameter.WQParameterTimeSeriesType;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import rma.swing.ButtonCmdPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJPanel;

final class ParameterSetTimeSeriesEditor
extends RmaJDialog {
    private final List<StateVariable> _stateVariables;
    private final Consumer<DssData> _dssSelectedAction;
    private final Consumer<StateVariable> _stateVariableSelectedAction;
    private RmaJComboBox<WQParameterTimeSeriesType> _typeComboBox;
    private ButtonCmdPanel _okCancelPanel;
    private DssPlotPanel _dssPanel;
    private RmaJPanel _cardPanel;
    private StateVariablePanel _stateVariablePanel;

    ParameterSetTimeSeriesEditor(Window window, List<StateVariable> list, Consumer<DssData> consumer, Consumer<StateVariable> consumer2) {
        super(window, WqI18n.a("Parameter.TimeSeriesEditor.Title").getText(), true);
        this.setSize(730, 500);
        this.setMinimumSize(new Dimension(440, 220));
        this._dssSelectedAction = consumer;
        this._stateVariableSelectedAction = consumer2;
        this._stateVariables = list;
        this.buildComponents();
        this.addListeners();
    }

    private void addListeners() {
        this._typeComboBox.addActionListener(serializable -> {
            serializable = (CardLayout)this._cardPanel.getLayout();
            ((CardLayout)((Object)serializable)).show((Container)this._cardPanel, Objects.requireNonNull(this._typeComboBox.getSelectedItem()).toString());
        });
        this._okCancelPanel.getButton(8).addActionListener(actionEvent -> {
            if (this._typeComboBox.getSelectedItem() == WQParameterTimeSeriesType.DSS) {
                actionEvent = new DssData();
                actionEvent.setDssPath(this._dssPanel.getDssPath());
                actionEvent.setDssFilePath(this._dssPanel.getDssFilePath());
                this._dssSelectedAction.accept((DssData)actionEvent);
            } else if (this._typeComboBox.getSelectedItem() == WQParameterTimeSeriesType.StateVariable) {
                this._stateVariableSelectedAction.accept(this._stateVariablePanel.getSelectedStateVariable());
            }
            this.dispose();
        });
        this._okCancelPanel.getButton(4).addActionListener(actionEvent -> this.dispose());
    }

    private void buildComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        JLabel jLabel = WqI18n.a("Parameter.TimeSeriesEditor.TypeLabel").createJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._typeComboBox = new RmaJComboBox();
        this._typeComboBox.setModel(new DefaultComboBoxModel<WQParameterTimeSeriesType>(WQParameterTimeSeriesType.values()));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add(this._typeComboBox, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this.add((Component)rmaJPanel, gridBagConstraints);
        this._cardPanel = this.buildCardPanel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ParameterSetTimeSeriesEditor parameterSetTimeSeriesEditor = this;
        parameterSetTimeSeriesEditor.add((Component)parameterSetTimeSeriesEditor._cardPanel, gridBagConstraints);
        this._okCancelPanel = new ButtonCmdPanel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        ParameterSetTimeSeriesEditor parameterSetTimeSeriesEditor2 = this;
        parameterSetTimeSeriesEditor2.add((Component)parameterSetTimeSeriesEditor2._okCancelPanel, gridBagConstraints);
        this._typeComboBox.setSelectedItem((Object)WQParameterTimeSeriesType.DSS);
        this.setModified(false);
    }

    private RmaJPanel buildCardPanel() {
        CardLayout cardLayout = new CardLayout();
        cardLayout = new RmaJPanel((LayoutManager)cardLayout);
        this._dssPanel = new DssPlotPanel(false, false);
        this._stateVariablePanel = new StateVariablePanel(this._stateVariables);
        cardLayout.add((Component)((Object)this._dssPanel), WQParameterTimeSeriesType.DSS.toString());
        cardLayout.add((Component)((Object)this._stateVariablePanel), WQParameterTimeSeriesType.StateVariable.toString());
        return cardLayout;
    }

    final void fill(StateVariableIdentifier stateVariableIdentifier) {
        this._typeComboBox.setSelectedItem((Object)WQParameterTimeSeriesType.StateVariable);
        this._stateVariablePanel.setSelectedStateVariable(stateVariableIdentifier);
    }

    final void fill(DssData dssData) {
        this._typeComboBox.setSelectedItem((Object)WQParameterTimeSeriesType.DSS);
        this._dssPanel.fillPanel(dssData);
    }
}

