/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.dataSources;

import hec.rss.wq.dataSources.ambient.AmbientDataSource;
import hec.rss.wq.dataSources.constant.ConstantDataSource;
import hec.rss.wq.dataSources.elevation.ElevationDataSource;
import hec.rss.wq.dataSources.excel.ExcelDataSource;
import hec.rss.wq.dataSources.latlong.LatLongDataSource;
import hec.rss.wq.dataSources.obs.ComputedCloudinessDataSource;
import hec.rss.wq.dataSources.pairedData.PairedCurveDataSource;
import hec.rss.wq.dataSources.pairedData.PairedDataSource;
import hec.rss.wq.dataSources.table.TableDataSource;
import hec.rss.wq.dataSources.timeSeries.DssDataSource;
import hec.rss.wq.ui.DataSource;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.ambient.AmbientData;
import hec.wqenginecore.dataSource.constant.ConstantData;
import hec.wqenginecore.dataSource.elevation.ElevationData;
import hec.wqenginecore.dataSource.excel.ExcelData;
import hec.wqenginecore.dataSource.latlong.LatLongData;
import hec.wqenginecore.dataSource.obs.ObservedData;
import hec.wqenginecore.dataSource.pairedData.PairedCurveData;
import hec.wqenginecore.dataSource.pairedData.PairedData;
import hec.wqenginecore.dataSource.table.TableData;
import hec.wqenginecore.dataSource.timeSeries.DssData;

public class DataSourceFactory {
    private DataSourceFactory() {
    }

    public static DataSource a(Data data) {
        if (data instanceof TableData) {
            return new TableDataSource((TableData)data);
        }
        if (data instanceof PairedCurveData) {
            return new PairedCurveDataSource((PairedCurveData)data);
        }
        if (data instanceof PairedData) {
            return new PairedDataSource((PairedData)data);
        }
        if (data instanceof ObservedData) {
            return new ComputedCloudinessDataSource((ObservedData)data);
        }
        if (data instanceof DssData) {
            return new DssDataSource((DssData)data);
        }
        if (data instanceof ConstantData) {
            return new ConstantDataSource((ConstantData)data);
        }
        if (data instanceof ElevationData) {
            return new ElevationDataSource((ElevationData)data);
        }
        if (data instanceof ExcelData) {
            return new ExcelDataSource((ExcelData)data);
        }
        if (data instanceof LatLongData) {
            return new LatLongDataSource((LatLongData)data);
        }
        if (data instanceof AmbientData) {
            return new AmbientDataSource((AmbientData)data);
        }
        return null;
    }
}

