/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.dataSources;

import hec.clientapp.model.TSDataSet;
import hec.data.TimeWindow;
import hec.heclib.util.HecTime;
import hec.hecmath.HecMathException;
import hec.io.DSSIdentifier;
import hec.io.TimeSeriesContainer;
import hec.model.TSRecord;
import hec.rss.wq.dataSources.DataSourceFactory;
import hec.rss.wq.dataSources.timeSeries.DssDataSource;
import hec.rss.wq.ui.DataSource;
import hec.rss.wq.ui.ParameterMap;
import hec.rss.wq.ui.ParameterMap$Id;
import hec.rss.wq.ui.TimeSeriesDataSource;
import hec.wqenginecore.DataProvider;
import hec.wqenginecore.WQTime;
import hec.wqenginecore.dataSource.Data;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class WQDataProvider
implements DataProvider {
    public static final Logger logger = Logger.getLogger(WQDataProvider.class.getName());
    public static final ParameterMap$Id<WQTime> WQ_TIME_PARAMETER = new ParameterMap$Id();
    private TSDataSet a;

    public WQDataProvider() {
    }

    public WQDataProvider(TSDataSet tSDataSet) {
        this();
        this.a = tSDataSet;
    }

    public double[] getDataValues(Data data, WQTime wQTime, String string, String string2) {
        return this.a(data, wQTime, null, string, string2);
    }

    public double[] getDataValues(Data data, WQTime wQTime, @Nonnull Object object, String string) {
        Object object2 = object;
        return this.a(data, wQTime, object2, object2.toString(), string);
    }

    public double[] a(Data data, WQTime object, Object object2, String string, String string2) {
        logger.info("Looking for WQ Time Series data for " + string + " - " + string2);
        double[] dArray = null;
        HecTime hecTime = new HecTime(object.getStartTimeString());
        HecTime hecTime2 = new HecTime(object.getEndTimeString());
        DataSource dataSource = DataSourceFactory.a(data);
        if (dataSource instanceof TimeSeriesDataSource) {
            TimeWindow timeWindow;
            TimeSeriesDataSource timeSeriesDataSource = (TimeSeriesDataSource)dataSource;
            ParameterMap parameterMap = new ParameterMap();
            if (parameterMap.a(TimeSeriesDataSource.TIME_WINDOW_PARAMETER) == null) {
                timeWindow = new TimeWindow(hecTime.getJavaDate(0), true, hecTime2.getJavaDate(0), true);
                parameterMap.a(TimeSeriesDataSource.TIME_WINDOW_PARAMETER, timeWindow);
            }
            parameterMap.a(WQ_TIME_PARAMETER, object);
            if (object2 != null) {
                dataSource.addParameters(parameterMap, object2);
            }
            timeWindow = timeSeriesDataSource.getTimeSeries(parameterMap);
            if (this.a != null && ("DSSData".equals(data.getType()) || "LatLongData".equals(data.getType()) || "ObservedData".equals(data.getType()))) {
                data = this.a(string, string2);
                if (data != null) {
                    data.getTSArray();
                    dArray = data.getInterpolatedTSArray(hecTime, hecTime2, (int)object.getWQDeltaTinSec() / 60);
                } else {
                    object = "Failed to find matching Water Quality Time Series Record in '" + String.valueOf(this.a) + "' for " + string + " - " + string2;
                    logger.warning((String)object);
                    this.a.printWarningMessage((String)object);
                }
            } else if (timeWindow.size() == 1) {
                data = (TimeSeriesContainer)timeWindow.get(0);
                try {
                    object = DssDataSource.a((TimeSeriesContainer)data, hecTime, hecTime2);
                    dArray = object.getValues();
                }
                catch (HecMathException hecMathException) {
                    dArray = data.getValues();
                }
            }
        }
        return dArray;
    }

    public DSSIdentifier getLocationFileAndPath(Data data, String string, String string2) {
        DataSource dataSource = DataSourceFactory.a(data);
        if (dataSource instanceof TimeSeriesDataSource && this.a != null && "DSSData".equals(data.getType()) && (data = this.a(string, string2)) != null) {
            data = new DSSIdentifier(data.getDSSFilename(), data.getDSSPathname());
            return data;
        }
        return null;
    }

    private TSRecord a(String string, String string2) {
        String string3 = string + "-" + string2;
        if ((string3 = this.a.getTSRecord(string3, string2)) == null) {
            string3 = this.a.getTSRecord(string, string2);
        }
        return string3;
    }
}

