/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.dataSources.constant;

import hec.rss.wq.dataSources.DataSourcePanel;
import hec.rss.wq.dataSources.constant.ConstantDataSourcePanel$1;
import hec.rss.wq.dataSources.constant.ConstantDataSourcePanel$TextKeyListener;
import hec.wqenginecore.dataSource.constant.ConstantData;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.text.Document;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTextField;
import rma.swing.text.DecimalNumberDocument;
import rma.util.RMAIO;

public class ConstantDataSourcePanel
extends RmaJPanel
implements DataSourcePanel<ConstantData> {
    public static final String DSS_DATA_PROPERTY = "DssData";
    private RmaJDescriptionField _descriptionText;
    private RmaJComboBox _unitsComboBox;
    private RmaJTextField _valueText;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    ConstantData _constantData;

    public ConstantDataSourcePanel() {
        this.initComponents();
        DecimalNumberDocument decimalNumberDocument = new DecimalNumberDocument();
        this._valueText.setDocument((Document)decimalNumberDocument);
        this._valueText.setHorizontalAlignment(4);
        this._valueText.addKeyListener((KeyListener)new ConstantDataSourcePanel$TextKeyListener(this));
        this._unitsComboBox.addActionListener((ActionListener)new ConstantDataSourcePanel$1(this));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this._descriptionText = new RmaJDescriptionField();
        this._valueText = new RmaJTextField();
        this._unitsComboBox = new RmaJComboBox();
        this.jLabel1.setText("Constant Value:");
        this.jLabel1.setMaximumSize(new Dimension(90, 14));
        this.jLabel1.setMinimumSize(new Dimension(90, 14));
        this.jLabel1.setPreferredSize(new Dimension(90, 14));
        this.jLabel2.setText("Units:");
        this.jLabel3.setText("Description:");
        this._descriptionText.setColumns(20);
        this._descriptionText.setRows(5);
        this._unitsComboBox.setModifiable(true);
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        GroupLayout groupLayout2 = groupLayout;
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this._valueText, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this._unitsComboBox, -2, 100, -2)).addComponent((Component)this._descriptionText, -1, 361, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout groupLayout3 = groupLayout;
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, 14, -2).addComponent(this.jLabel2).addComponent((Component)this._valueText, -2, -1, -2).addComponent((Component)this._unitsComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 8, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this._descriptionText, -2, -1, -2)).addContainerGap()));
    }

    public void validateData() throws IOException {
        if (this._constantData == null) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        double d = RMAIO.parseDouble((String)this._valueText.getText(), (double)Double.NEGATIVE_INFINITY);
        if (d == Double.NEGATIVE_INFINITY) {
            return;
        }
        if (!arrayList.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("The Following Errors Occurred:");
            for (String string : arrayList) {
                stringBuffer.append(string + "\n");
            }
            throw new IOException(RMAIO.toHtmlString((String)((Object)arrayList).toString()));
        }
    }

    @Override
    public void save() {
        if (!this.isModified()) {
            return;
        }
        if (this._constantData == null) {
            return;
        }
        this._constantData.setConstantValue(RMAIO.parseDouble((String)this._valueText.getText(), (double)Double.NEGATIVE_INFINITY));
        this._constantData.setDescription(this._descriptionText.getText());
        String string = this._unitsComboBox.getSelectedItem() != null ? this._unitsComboBox.getSelectedItem().toString() : "";
        this._constantData.setUnits(string);
    }

    @Override
    public void fillPanel(ConstantData stringArray) {
        this.clearPanel();
        this._constantData = stringArray;
        if (this._constantData == null) {
            return;
        }
        stringArray = this._constantData.getAvailableUnits();
        this._unitsComboBox.setModel(new DefaultComboBoxModel<String>(stringArray));
        this._valueText.setText(RMAIO.toTable((double)this._constantData.getConstantValue()));
        this._descriptionText.setText(this._constantData.getDescription());
        String string = this._constantData.getUnits();
        if (string != null && !string.isEmpty()) {
            this._unitsComboBox.setSelectedItem((Object)string);
            return;
        }
        this._unitsComboBox.setSelectedIndex(stringArray.length > 0 ? 0 : -1);
    }

    public String getUnits() {
        Object object = this._unitsComboBox.getSelectedItem();
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public double getConstantValue() {
        return RMAIO.parseDouble((String)this._valueText.getText());
    }

    private void clearPanel() {
        this._valueText.setText("");
        this._descriptionText.setText("");
        this._unitsComboBox.setSelectedIndex(-1);
    }

    public void refresh() {
        ConstantDataSourcePanel constantDataSourcePanel = this;
        constantDataSourcePanel.fillPanel(constantDataSourcePanel._constantData);
    }

    static /* synthetic */ void a(ConstantDataSourcePanel constantDataSourcePanel, String string, Object object, Object object2) {
        constantDataSourcePanel.firePropertyChange(string, null, object2);
    }

    static /* synthetic */ void b(ConstantDataSourcePanel constantDataSourcePanel, String string, Object object, Object object2) {
        constantDataSourcePanel.firePropertyChange(string, null, object2);
    }
}

