/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.dataSources.dss;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.data.Parameter;
import hec.data.TimeWindow;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.PairedDataSet;
import hec.gfx2d.PlotLayout;
import hec.gfx2d.TimeSeriesDataSet;
import hec.gfx2d.ViewportLayout;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import hec.rss.client.RSimSimulationMode;
import hec.rss.wq.dataSources.timeSeries.DssDataSource;
import hec.rss.wq.dataSources.timeSeries.TimeSeriesPanel;
import hec.rss.wq.ui.ParameterMap;
import hec.rss.wq.ui.TimeSeriesDataSource;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mil.army.usace.hec.metadata.UnitUtil;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJPanel;

public final class DssPlotPanel
extends RmaJPanel {
    private static final MessageFormat a = new MessageFormat("{0}\n({1})");
    private TimeSeriesPanel _dssPanel;
    private G2dPanel _plotPanel;
    private String _parameterLabel = "";
    private boolean _legendVisible;
    private RmaJButton _refreshPlotButton;

    public DssPlotPanel() {
        this(true, true);
    }

    public DssPlotPanel(boolean bl, boolean bl2) {
        super((LayoutManager)new GridBagLayout());
        this.buildComponents(bl, bl2);
        this.addListeners();
        DssPlotPanel dssPlotPanel = this;
        dssPlotPanel.plotDataSource(dssPlotPanel.getDssDataSource());
    }

    private void addListeners() {
        this._dssPanel.setSelectedPathListener(() -> {
            DssPlotPanel dssPlotPanel = this;
            dssPlotPanel.plotDataSource(dssPlotPanel.getDssDataSource());
        });
        this._refreshPlotButton.addActionListener(actionEvent -> {
            DssPlotPanel dssPlotPanel = this;
            dssPlotPanel.plotDataSource(dssPlotPanel.getDssDataSource());
        });
    }

    private DssDataSource getDssDataSource() {
        DssData dssData = new DssData();
        dssData.setDssPath(this._dssPanel.getDssPath());
        dssData.setDssFilePath(this._dssPanel.getDssFilePath());
        return new DssDataSource(dssData);
    }

    private void buildComponents(boolean bl, boolean bl2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._dssPanel = new TimeSeriesPanel(bl, bl2);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        DssPlotPanel dssPlotPanel = this;
        dssPlotPanel.add((Component)((Object)dssPlotPanel._dssPanel), gridBagConstraints);
        this._refreshPlotButton = new RmaJButton(WqI18n.a("Parameter.TimeSeriesEditor.RefreshPlotButton").getText());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 35);
        DssPlotPanel dssPlotPanel2 = this;
        dssPlotPanel2.add((Component)dssPlotPanel2._refreshPlotButton, gridBagConstraints);
        this._plotPanel = new G2dPanel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        DssPlotPanel dssPlotPanel3 = this;
        dssPlotPanel3.add((Component)dssPlotPanel3._plotPanel, gridBagConstraints);
    }

    public final void setParameterLabel(String string) {
        this._parameterLabel = string != null ? string : "";
    }

    public final void setLegendVisible(boolean bl) {
        this._legendVisible = bl;
    }

    private void plotDataSource(DssDataSource dssDataSource) {
        if (dssDataSource == null) {
            return;
        }
        this._plotPanel.setVisible(false);
        this._plotPanel.clearPanel();
        PlotLayout plotLayout = new PlotLayout();
        Object object = this.collectBoundingTimeWindow(dssDataSource);
        List<Object> list = new ArrayList<TimeSeriesContainer>();
        if (dssDataSource.getTimeSeries().isEmpty()) {
            list.add(this.buildDefaultTimeSeriesContainer((TimeWindow)object));
        } else {
            list = this.fetchDataContainers(dssDataSource, (TimeWindow)object);
            if (list.isEmpty()) {
                list.add((TimeSeriesContainer)((DataContainer)this.buildDefaultTimeSeriesContainer((TimeWindow)object)));
            }
        }
        object = this.organizeDataContainers(dssDataSource, list);
        this.configureViewports(plotLayout, (Map<String, List<G2dObject>>)object, dssDataSource);
        this.finalizePlotPanel(plotLayout);
    }

    private TimeSeriesContainer buildDefaultTimeSeriesContainer(TimeWindow object) {
        Object object2;
        TimeSeriesContainer timeSeriesContainer = new TimeSeriesContainer();
        if (object != null && object.getStartDate() != null) {
            timeSeriesContainer.setStartTime(HecTime.fromInstant((Instant)object.getStartDate().toInstant(), (ZoneId)ZoneId.of("UTC")));
        } else {
            int n = Year.now().getValue();
            object2 = LocalDate.of(n, 1, 1);
            object2 = ((LocalDate)object2).atStartOfDay(ZoneOffset.UTC).toInstant();
            timeSeriesContainer.setStartTime(HecTime.fromInstant((Instant)object2, (ZoneId)ZoneId.of("UTC")));
        }
        if (object != null && object.getEndDate() != null) {
            timeSeriesContainer.setEndTime(HecTime.fromInstant((Instant)object.getEndDate().toInstant(), (ZoneId)ZoneId.of("UTC")));
        } else {
            int n = Year.now().getValue();
            object2 = LocalDate.of(n, 12, 31);
            object2 = ((LocalDate)object2).atTime(23, 59, 59, 999999999);
            object = ((LocalDateTime)object2).atZone(ZoneOffset.UTC).toInstant();
            timeSeriesContainer.setEndTime(HecTime.fromInstant((Instant)object, (ZoneId)ZoneId.of("UTC")));
        }
        double[] dArray = new double[2];
        object2 = dArray;
        dArray[0] = -3.4028234663852886E38;
        object2[1] = -3.4028234663852886E38;
        timeSeriesContainer.setValues((double[])object2);
        object2 = new HecTimeArray(2);
        object2.setElementAt(timeSeriesContainer.getStartTime(), 0);
        object2.setElementAt(timeSeriesContainer.getEndTime(), 1);
        timeSeriesContainer.setTimes((HecTimeArray)object2);
        object2 = new DSSPathname(this._dssPanel.getDssPath());
        object = object2.getCPart();
        if (object == null || ((String)object).isBlank()) {
            object = Parameter.getParamString((int)Parameter.PARAMID_FLOW);
        }
        int n = ClientApp.Workspace().getUnitSystem();
        timeSeriesContainer.setUnits(Parameter.getUnitsStringForSystem((String)object, (int)n));
        timeSeriesContainer.parameter = object;
        return timeSeriesContainer;
    }

    private TimeWindow collectBoundingTimeWindow(DssDataSource dssDataSource) {
        dssDataSource = dssDataSource.getTimeWindow();
        ClientMode clientMode = ClientApp.frame().getCurrentMode();
        if (clientMode instanceof RSimSimulationMode && (clientMode = ((RSimSimulationMode)clientMode).getSimTimeWindow()) != null) {
            dssDataSource = clientMode;
        }
        return dssDataSource;
    }

    private List<DataContainer> fetchDataContainers(DssDataSource dssDataSource, TimeWindow timeWindow) {
        List<Object> list = new ArrayList<DataContainer>();
        if (timeWindow != null) {
            ParameterMap parameterMap = new ParameterMap();
            parameterMap.a(TimeSeriesDataSource.TIME_WINDOW_PARAMETER, timeWindow);
            if (dssDataSource.d() != null && dssDataSource.d().isProfileData()) {
                list = Collections.singletonList(dssDataSource.getPairedData(parameterMap));
            } else {
                list.addAll(dssDataSource.getTimeSeries(parameterMap));
            }
        } else if (dssDataSource.d() != null && dssDataSource.d().isProfileData()) {
            list = Collections.singletonList(dssDataSource.e());
        } else {
            list.addAll(dssDataSource.getTimeSeries());
        }
        return list;
    }

    private Map<String, List<G2dObject>> organizeDataContainers(DssDataSource dssDataSource, List<DataContainer> object) {
        HashMap<String, List<G2dObject>> hashMap = new HashMap<String, List<G2dObject>>();
        object = object.iterator();
        while (object.hasNext()) {
            DataContainer dataContainer = (DataContainer)object.next();
            Object object2 = null;
            G2dObject g2dObject = null;
            if (dataContainer instanceof TimeSeriesContainer) {
                object2 = ((TimeSeriesContainer)dataContainer).units != null ? ((TimeSeriesContainer)dataContainer).units : "";
                g2dObject = this.createTimeSeriesDataSet((TimeSeriesContainer)dataContainer, dssDataSource.getName());
            } else if (dataContainer instanceof PairedDataContainer) {
                object2 = ((PairedDataContainer)dataContainer).yunits + "/" + ((PairedDataContainer)dataContainer).xunits;
                g2dObject = this.createPairedDataSet((PairedDataContainer)dataContainer, dssDataSource.getName());
            }
            if (g2dObject == null) continue;
            hashMap.computeIfAbsent((String)object2, string -> new ArrayList()).add(g2dObject);
        }
        return hashMap;
    }

    private G2dObject createTimeSeriesDataSet(TimeSeriesContainer timeSeriesContainer, String string) {
        timeSeriesContainer = new TimeSeriesDataSet(timeSeriesContainer);
        timeSeriesContainer.setName(string);
        return timeSeriesContainer;
    }

    private G2dObject createPairedDataSet(PairedDataContainer pairedDataContainer, String string) {
        PairedDataSet pairedDataSet = new PairedDataSet(pairedDataContainer);
        pairedDataSet.setName(string);
        pairedDataSet.xunits = pairedDataContainer.xunits;
        pairedDataSet.yunits = pairedDataContainer.yunits;
        return pairedDataSet;
    }

    private void configureViewports(PlotLayout plotLayout, Map<String, List<G2dObject>> object, DssDataSource dssDataSource) {
        for (Map.Entry<String, List<G2dObject>> entry : object.entrySet()) {
            ViewportLayout viewportLayout = plotLayout.addViewport();
            this.configureViewport(viewportLayout, entry, dssDataSource);
        }
    }

    private void configureViewport(ViewportLayout viewportLayout, Map.Entry<String, List<G2dObject>> object, DssDataSource dssDataSource2) {
        String string = (String)object.getKey();
        Object object2 = Parameter.getParameterForUnitsString((String)string);
        object2 = this._parameterLabel.isBlank() ? (object2 != null ? object2.getParameter() : "") : this._parameterLabel;
        string = a.format(new String[]{object2, string});
        viewportLayout.setAxisLabel("Y1", string);
        if (dssDataSource2.d() != null && dssDataSource2.d().isProfileData()) {
            this.configureProfileData(viewportLayout, (Map.Entry<String, List<G2dObject>>)((Object)object));
        }
        for (G2dObject g2dObject : (List)object.getValue()) {
            viewportLayout.addCurve("Y1", (Object)g2dObject);
        }
    }

    private void configureProfileData(ViewportLayout viewportLayout, Map.Entry<String, List<G2dObject>> object) {
        if (!(object = object.getValue()).isEmpty() && object.get(0) instanceof PairedDataSet) {
            object = (PairedDataSet)object.get(0);
            String string = a.format(new String[]{this._parameterLabel, UnitUtil.getBestMatch((String)((PairedDataSet)object).xunits)});
            viewportLayout.setAxisLabel("X1", string);
            if (object.getYParameterId() == Parameter.PARAMID_DEPTH) {
                viewportLayout.setAxisReversed("Y1", true);
            }
        }
    }

    private void finalizePlotPanel(PlotLayout plotLayout) {
        this._plotPanel.buildComponents(plotLayout);
        if (this._plotPanel.getLegendPanel() != null) {
            this._plotPanel.setLegendVisible(this._legendVisible);
        }
        this._plotPanel.setVisible(true);
        this._plotPanel.revalidate();
    }

    public final String getDssPath() {
        return this._dssPanel.getDssPath();
    }

    public final String getDssFilePath() {
        return this._dssPanel.getDssFilePath();
    }

    public final void fillPanel(DssData dssData) {
        this._dssPanel.fillPanel(dssData);
        DssPlotPanel dssPlotPanel = this;
        dssPlotPanel.plotDataSource(dssPlotPanel.getDssDataSource());
    }
}

