/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.dataSources.excel;

import hec.rss.wq.dataSources.DataSourcePanel;
import hec.rss.wq.dataSources.excel.ExcelDataSourcePanel$1;
import hec.rss.wq.dataSources.excel.ExcelDataSourcePanel$2;
import hec.rss.wq.dataSources.excel.ExcelDataSourcePanel$3;
import hec.rss.wq.dataSources.excel.ExcelWorksheetPanel;
import hec.rss.wq.ui.OkCancelDialog;
import hec.wqenginecore.dataSource.excel.ExcelData;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTextField;
import rma.util.RMAUtil;

public class ExcelDataSourcePanel
extends RmaJPanel
implements DataSourcePanel<ExcelData> {
    public static final String TIMESERIES_DATA_PROPERTY = "TimeSeriesData";
    String worksheetName;
    String timeColumn;
    String valueColumn;
    int topRow;
    int bottomRow;
    MessageFormat rangeFormat = new MessageFormat("\"{0}\" time col:\"{1}\" value col:\"{2}\" rows: {3} - {4}");
    ExcelData _data;
    private RmaJDescriptionField _excelDataDescriptionTxt;
    private RmaJTextField _excelFileNameTxt;
    private RmaJTextField _excelRangeTxt;
    private RmaJComboBox<String> _excelUnitsComboBox;
    private JButton _setExcelDataButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;

    public ExcelDataSourcePanel() {
        this.initComponents();
        this._excelUnitsComboBox.addActionListener((ActionListener)new ExcelDataSourcePanel$1(this));
    }

    @Override
    public void fillPanel(ExcelData object) {
        this._data = object;
        this.clearPanel();
        if (this._data == null) {
            return;
        }
        this._excelFileNameTxt.setText(this._data.getExcelFilePath());
        this._excelDataDescriptionTxt.setText(this._data.getDescription());
        String[] stringArray = object.getAvailableUnits();
        this._excelUnitsComboBox.setModel(new DefaultComboBoxModel<String>(stringArray));
        object = object.getUnits();
        this._excelUnitsComboBox.setSelectedItem(object != null ? object : "");
        if (object != null && !((String)object).isEmpty()) {
            this._excelUnitsComboBox.setSelectedItem(object);
        } else {
            this._excelUnitsComboBox.setSelectedIndex(stringArray.length > 0 ? 0 : -1);
        }
        this.worksheetName = this._data.getWorksheetName();
        this.timeColumn = this._data.getTimeColumn();
        this.valueColumn = this._data.getValueColumn();
        this.topRow = this._data.getTopRow();
        this.bottomRow = this._data.getBottomRow();
        object = new String[]{this.worksheetName != null ? this.worksheetName : "", this.timeColumn != null ? this.timeColumn : "", this.valueColumn != null ? this.valueColumn : "", Integer.toString(this.topRow), Integer.toString(this.bottomRow)};
        this._excelRangeTxt.setText(this.rangeFormat.format(object));
    }

    public void validatePanel() throws IOException {
    }

    public String getUnits() {
        Object object = this._excelUnitsComboBox.getSelectedItem();
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public void savePanel() {
        if (this._data == null) {
            return;
        }
        if (!RMAUtil.isChildrenModified((Container)((Object)this))) {
            return;
        }
        Object object = this._excelUnitsComboBox.getSelectedItem();
        this._data.setUnits(object != null ? object.toString() : "");
        this._data.setExcelFilePath(this._excelFileNameTxt.getText());
        this._data.setWorksheetName(this.worksheetName);
        this._data.setTopRow(this.topRow);
        this._data.setBottomRow(this.bottomRow);
        this._data.setTimeColumn(this.timeColumn);
        this._data.setValueColumn(this.valueColumn);
        this._data.setDescription(this._excelDataDescriptionTxt.getText());
    }

    private void clearPanel() {
        this._excelUnitsComboBox.setModel(new DefaultComboBoxModel());
        this._excelFileNameTxt.setText("");
        this._excelDataDescriptionTxt.setText("");
        this._excelRangeTxt.setText("");
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this._excelFileNameTxt = new RmaJTextField();
        this._excelRangeTxt = new RmaJTextField();
        this._excelUnitsComboBox = new RmaJComboBox();
        this.jLabel4 = new JLabel();
        this._setExcelDataButton = new JButton();
        this._excelDataDescriptionTxt = new RmaJDescriptionField();
        this.jLabel1.setText("Excel File:");
        this.jLabel2.setText("Worksheet Range:");
        this.jLabel3.setText("Description:");
        this._excelFileNameTxt.setEditable(false);
        this._excelRangeTxt.setEditable(false);
        this._excelUnitsComboBox.setMinimumSize(new Dimension(100, 20));
        this._excelUnitsComboBox.setPreferredSize(new Dimension(100, 20));
        this.jLabel4.setText("Units:");
        this._setExcelDataButton.setText("Set Excel Data...");
        this._setExcelDataButton.addActionListener(new ExcelDataSourcePanel$2(this));
        this._excelDataDescriptionTxt.setColumns(20);
        this._excelDataDescriptionTxt.setRows(5);
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        GroupLayout groupLayout2 = groupLayout;
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._excelFileNameTxt, -1, 310, Short.MAX_VALUE).addComponent((Component)this._excelRangeTxt)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this._excelUnitsComboBox, -2, -1, -2)).addComponent(this._setExcelDataButton, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(2, 2, 2).addComponent((Component)this._excelDataDescriptionTxt, -1, 451, Short.MAX_VALUE))).addContainerGap()));
        GroupLayout groupLayout3 = groupLayout;
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this._excelFileNameTxt, -2, -1, -2).addComponent((Component)this._excelUnitsComboBox, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this._excelRangeTxt, -2, -1, -2).addComponent(this._setExcelDataButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)this._excelDataDescriptionTxt, -2, -1, -2).addComponent(this.jLabel3)).addContainerGap()));
    }

    private void _setExcelDataButtonActionPerformed(ActionEvent serializable) {
        serializable = new ExcelWorksheetPanel();
        ((ExcelWorksheetPanel)serializable).setExcelFileNameText(this._data.getExcelFilePath());
        ((ExcelWorksheetPanel)serializable).setWorksheetNameText(this._data.getWorksheetName());
        ((ExcelWorksheetPanel)serializable).setTimeColumn(this._data.getTimeColumn());
        ((ExcelWorksheetPanel)serializable).setValueColumn(this._data.getValueColumn());
        ((ExcelWorksheetPanel)serializable).setTopRow(this._data.getTopRow());
        ((ExcelWorksheetPanel)serializable).setBottomRow(this._data.getBottomRow());
        OkCancelDialog okCancelDialog = new OkCancelDialog(SwingUtilities.windowForComponent((Component)((Object)this)), (JComponent)serializable, Dialog.ModalityType.APPLICATION_MODAL);
        okCancelDialog.pack();
        okCancelDialog.setLocationRelativeTo(SwingUtilities.windowForComponent((Component)((Object)this)));
        okCancelDialog.addPropertyChangeListener(new ExcelDataSourcePanel$3(this, okCancelDialog, (ExcelWorksheetPanel)serializable));
        okCancelDialog.setTitle("Excel Worksheet and Data Range");
        okCancelDialog.setVisible(true);
    }

    static /* synthetic */ void a(ExcelDataSourcePanel excelDataSourcePanel, String string, Object object, Object object2) {
        excelDataSourcePanel.firePropertyChange(string, null, object2);
    }

    static /* synthetic */ void b(ExcelDataSourcePanel excelDataSourcePanel, String string, Object object, Object object2) {
        excelDataSourcePanel.firePropertyChange(string, null, object2);
    }
}

