/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.dataSources.latlong;

import com.google.common.flogger.FluentLogger;
import hec.data.TimeWindow;
import hec.io.TimeSeriesContainer;
import hec.rss.wq.dataSources.DataSourcePanel;
import hec.rss.wq.dataSources.latlong.LatLongDataSource$LatLongPanelPropertyChangeListener;
import hec.rss.wq.dataSources.latlong.LatLongDataSourcePanel;
import hec.rss.wq.model.SolarRadiationComputeException;
import hec.rss.wq.model.SolarRadiationUtils;
import hec.rss.wq.ui.ParameterMap;
import hec.rss.wq.ui.TimeSeriesDataSource;
import hec.wqenginecore.dataSource.latlong.LatLongData;
import hec.wqengineimpl.metstation.variable.ShortWaveRadiation;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;

public class LatLongDataSource
implements TimeSeriesDataSource<LatLongData> {
    public static final String DUST_COEF_PROPERTY = "DustCoef";
    private final LatLongData e;
    private final String f = "Lat-Long";
    String a = null;
    Double b = null;
    LatLongDataSourcePanel c = null;
    PropertyChangeSupport d = new PropertyChangeSupport(this);

    public LatLongDataSource(LatLongData latLongData) {
        this.e = latLongData;
    }

    @Override
    public JComponent getComponent() {
        return this.b();
    }

    @Override
    public List<TimeSeriesContainer> getTimeSeries(ParameterMap parameterMap) {
        parameterMap = parameterMap.a(TimeSeriesDataSource.TIME_WINDOW_PARAMETER);
        Double d = this.b != null ? this.b : null;
        try {
            parameterMap = SolarRadiationUtils.a((TimeWindow)parameterMap, d, ShortWaveRadiation.getDefaultComputedUnits(), this.e, null, null);
            return Collections.singletonList(parameterMap);
        }
        catch (SolarRadiationComputeException solarRadiationComputeException) {
            ((FluentLogger.Api)((FluentLogger.Api)FluentLogger.forEnclosingClass().atWarning()).withCause((Throwable)solarRadiationComputeException)).log("Error computing solar radiation time series for plotting " + this.e.getName());
            return Collections.emptyList();
        }
    }

    @Override
    public List<TimeSeriesContainer> getTimeSeries() {
        int n = Calendar.getInstance().get(1);
        Object object = new SimpleDateFormat("ddMMMyyyy HHmm");
        try {
            TimeWindow timeWindow = new TimeWindow(((DateFormat)object).parse("01JAN" + n + " 0000"), true, ((DateFormat)object).parse("31DEC" + n + " 2400"), true);
            object = new ParameterMap();
            ((ParameterMap)object).a(TimeSeriesDataSource.TIME_WINDOW_PARAMETER, timeWindow);
            return this.getTimeSeries((ParameterMap)object);
        }
        catch (ParseException parseException) {
            ParseException parseException2 = parseException;
            parseException.printStackTrace();
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public TimeWindow getTimeWindow() {
        return null;
    }

    public LatLongData a() {
        return this.e;
    }

    public LatLongDataSourcePanel b() {
        if (this.c == null) {
            this.c = new LatLongDataSourcePanel();
            this.c.fillPanel(this.e);
            this.c.addPropertyChangeListener(new LatLongDataSource$LatLongPanelPropertyChangeListener(this));
        }
        return this.c;
    }

    @Override
    public String getName() {
        return this.e.getName();
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public void validateData() throws IOException {
        if (this.c != null) {
            this.c.validatePanel();
        }
    }

    @Override
    public void save() throws IOException {
        if (this.c != null) {
            this.c.savePanel();
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.d.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.d.removePropertyChangeListener(propertyChangeListener);
    }

    public String toString() {
        return "Lat-Long";
    }

    @Override
    public /* synthetic */ DataSourcePanel getSourceComponent() {
        return this.b();
    }

    @Override
    public /* synthetic */ Object getData() {
        return this.a();
    }
}

