/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.dataSources.obs;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.data.TimeWindow;
import hec.heclib.dss.HecTimeSeries;
import hec.heclib.util.HecTime;
import hec.hecmath.HecMathException;
import hec.io.TimeSeriesContainer;
import hec.rss.client.RSimSimulationMode;
import hec.rss.wq.dataSources.DataSourcePanel;
import hec.rss.wq.dataSources.dss.BaseDssPanel;
import hec.rss.wq.dataSources.obs.ComputedCloudinessDataSourcePanel;
import hec.rss.wq.dataSources.timeSeries.DssDataSource;
import hec.rss.wq.model.CloudinessComputeException;
import hec.rss.wq.model.CloudinessUtils;
import hec.rss.wq.ui.ParameterMap;
import hec.rss.wq.ui.ParameterMap$Id;
import hec.wqenginecore.dataSource.latlong.LatLongData;
import hec.wqenginecore.dataSource.obs.ObservedData;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.metstation.MetStation;
import hec.wqengineimpl.metstation.WQMetStation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JComponent;
import mil.army.usace.hec.metadata.UnitsConversionException;

public class ComputedCloudinessDataSource
extends DssDataSource {
    private final ObservedData h;
    public static final ParameterMap$Id<LatLongData> LAT_LONG_PARAMETER = new ParameterMap$Id();

    public ComputedCloudinessDataSource(ObservedData observedData) {
        super((DssData)observedData);
        this.h = observedData;
    }

    @Override
    public JComponent getComponent() {
        return this.b();
    }

    public ObservedData a() {
        return this.h;
    }

    public ComputedCloudinessDataSourcePanel b() {
        if (this.a == null) {
            this.a = new ComputedCloudinessDataSourcePanel();
            if (this.h != null) {
                this.h.setCloudinessDSSFileName(null);
                this.h.setCloudinessDSSPath(null);
                this.a.fillPanel((DssData)this.h);
                this.a.addPropertyChangeListener(this.f);
            }
        }
        return (ComputedCloudinessDataSourcePanel)this.a;
    }

    @Override
    public TimeWindow getTimeWindow() {
        TimeWindow timeWindow = super.getTimeWindow();
        ClientMode clientMode = ClientApp.frame().getCurrentMode();
        if (clientMode instanceof RSimSimulationMode) {
            if ((clientMode = ((RSimSimulationMode)clientMode).getSimTimeWindow()) != null) {
                timeWindow = clientMode;
            }
        } else if (timeWindow != null) {
            int n = Calendar.getInstance().get(1);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(timeWindow.getEndDate());
            int n2 = calendar.get(1);
            if (n2 < n) {
                n = n2;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMMyyyy HHmm");
            try {
                return new TimeWindow(simpleDateFormat.parse("01JAN" + n + " 0000"), true, simpleDateFormat.parse("31DEC" + n + " 2400"), true);
            }
            catch (ParseException parseException) {
                ((FluentLogger.Api)((FluentLogger.Api)FluentLogger.forEnclosingClass().atWarning()).withCause((Throwable)parseException)).log("Error parsing date");
            }
        }
        return timeWindow;
    }

    @Override
    public List<TimeSeriesContainer> getTimeSeries(ParameterMap parameterMap) {
        List<TimeSeriesContainer> list = Collections.emptyList();
        if (this.h.getCloudinessDSSPath() != null && this.h.getCloudinessDSSFileName() != null) {
            list = this.b(parameterMap);
        }
        if (list.isEmpty()) {
            List<TimeSeriesContainer> list2 = this.a(parameterMap);
            if (parameterMap != null) {
                LatLongData latLongData = parameterMap.a(LAT_LONG_PARAMETER);
                String string = CloudinessUtils.DSS_OUTPUT_INTERVAL;
                if (!list2.isEmpty() && latLongData != null) {
                    parameterMap = (TimeWindow)parameterMap.a(TIME_WINDOW_PARAMETER);
                    try {
                        parameterMap = CloudinessUtils.a((TimeWindow)parameterMap, list2.get(0), latLongData, string);
                        list = Collections.singletonList(parameterMap);
                    }
                    catch (CloudinessComputeException cloudinessComputeException) {
                        ((FluentLogger.Api)((FluentLogger.Api)FluentLogger.forEnclosingClass().atWarning()).withCause((Throwable)cloudinessComputeException)).log("Error computing cloudiness for plotting " + this.h.getName() + " with observed SW Radiation " + String.valueOf(list2.get(0)) + " and computed Lat-Long SW Radiation");
                    }
                }
            }
        }
        return list;
    }

    private List<TimeSeriesContainer> b(ParameterMap parameterMap) {
        ArrayList<TimeSeriesContainer> arrayList = new ArrayList<TimeSeriesContainer>();
        if (parameterMap != null) {
            String string = this.h.getCloudinessDSSPath();
            String string2 = this.h.getCloudinessDSSFileName();
            HecTimeSeries hecTimeSeries = new HecTimeSeries();
            hecTimeSeries.setDSSFileName(string2);
            hecTimeSeries.setPathname(string);
            parameterMap = (TimeWindow)parameterMap.a(TIME_WINDOW_PARAMETER);
            if (parameterMap != null) {
                if (parameterMap.getStartDate() != null) {
                    hecTimeSeries.setStartTime(new HecTime(parameterMap.getStartDate(), 0));
                }
                if (parameterMap.getEndDate() != null) {
                    hecTimeSeries.setEndTime(new HecTime(parameterMap.getEndDate(), 0));
                }
            }
            parameterMap = new TimeSeriesContainer();
            int n = hecTimeSeries.read((TimeSeriesContainer)parameterMap, false);
            hecTimeSeries.close();
            if (n < -1) {
                logger.log(Level.FINE, "Time Series Read: \n" + string2 + "\n" + string + "\nReturned status of " + n);
            } else {
                try {
                    parameterMap = CloudinessUtils.a((TimeSeriesContainer)parameterMap, CloudinessUtils.DSS_OUTPUT_INTERVAL);
                }
                catch (HecMathException | UnitsConversionException throwable) {
                    logger.log(Level.WARNING, "Error converting to time step " + CloudinessUtils.DSS_OUTPUT_INTERVAL + " for timeseries " + String.valueOf(parameterMap), throwable);
                }
                arrayList.add((TimeSeriesContainer)parameterMap);
            }
        }
        return arrayList;
    }

    @Override
    public String getName() {
        return this.h.getName();
    }

    @Override
    public String toString() {
        return "Compute from ObsSW and Lat-Long";
    }

    @Override
    public void addParameters(ParameterMap parameterMap, Object object) {
        if (object instanceof WQMetStation) {
            object = (WQMetStation)object;
            object = CloudinessUtils.a((MetStation)object);
            parameterMap.a(LAT_LONG_PARAMETER, object);
        }
    }

    @Override
    public /* synthetic */ BaseDssPanel c() {
        return this.b();
    }

    @Override
    public /* synthetic */ DssData d() {
        return this.a();
    }

    @Override
    public /* synthetic */ DataSourcePanel getSourceComponent() {
        return this.b();
    }

    @Override
    public /* synthetic */ Object getData() {
        return this.a();
    }
}

