/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.dataSources.pairedData;

import hec.heclib.dss.HecPairedData;
import hec.io.PairedDataContainer;
import hec.rss.wq.dataSources.DataSourceFactory;
import hec.rss.wq.dataSources.dss.BaseDssPanel;
import hec.rss.wq.ui.PairedDataDataSource;
import hec.rss.wq.ui.ParameterMap;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.pairedData.PairedCurveData;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ItemEvent;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.list.RmaListModel;
import rma.util.RMAUtil;

public class PairedDataDSSPanel
extends BaseDssPanel {
    private RmaJComboBox<String> _curveCombo;
    private PairedDataContainer _pdc;
    protected PairedCurveData _pairedCurveData;

    public PairedDataDSSPanel(boolean bl) {
        super(bl);
        this.setEPartEnabled(false);
        this.setDPartEnabled(false);
    }

    public PairedDataDSSPanel() {
        this(false);
    }

    @Override
    public void fillPanel(DssData dssData) {
        this.fillPanel(dssData, null);
    }

    public void fillPanel(DssData dssData, ParameterMap listArray) {
        super.fillPanel(dssData);
        if (dssData instanceof PairedCurveData) {
            this._pairedCurveData = (PairedCurveData)dssData;
        }
        if ((listArray = this.getPairedDataContainer((Data)dssData, (ParameterMap)listArray)) != null) {
            listArray = new List[]{null, List.of(listArray)};
            this.setDataContainer(listArray);
        }
        listArray = this.getCurve((Data)dssData);
        int n = 0;
        if (listArray != null) {
            n = listArray.intValue();
        }
        if (n < this._curveCombo.getItemCount()) {
            this._curveCombo.setSelectedIndex(n);
            return;
        }
        this._curveCombo.setSelectedIndex(-1);
    }

    private PairedDataContainer getPairedDataContainer(Data object, ParameterMap parameterMap) {
        PairedDataContainer pairedDataContainer = null;
        if ((object = DataSourceFactory.a(object)) instanceof PairedDataDataSource) {
            object = (PairedDataDataSource)object;
            pairedDataContainer = object.getPairedData(parameterMap);
        }
        return pairedDataContainer;
    }

    private Integer getCurve(Data object) {
        Integer n = null;
        if ((object = DataSourceFactory.a(object)) instanceof PairedDataDataSource) {
            object = (PairedDataDataSource)object;
            n = object.getCurve(null);
        }
        return n;
    }

    @Override
    public void save() {
        super.save();
        if (this._pairedCurveData != null) {
            this._pairedCurveData.setCurve(this._curveCombo.getSelectedIndex());
        }
    }

    @Override
    protected void addAccessoryFields() {
        JLabel jLabel = WqI18n.a("PairedDataPanel.Label.Curve").createJLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add(jLabel, gridBagConstraints);
        this._curveCombo = new RmaJComboBox();
        this._curveCombo.setModifiable(true);
        this._curveCombo.setPrototypeDisplayValue((Object)"XXXX");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        PairedDataDSSPanel pairedDataDSSPanel = this;
        pairedDataDSSPanel.add((Component)pairedDataDSSPanel._curveCombo, gridBagConstraints);
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this._curveCombo.addItemListener(this::curveComboChanged);
    }

    private void curveComboChanged(ItemEvent itemEvent) {
        if (2 == itemEvent.getStateChange()) {
            return;
        }
        PairedDataDSSPanel pairedDataDSSPanel = this;
        pairedDataDSSPanel.firePropertyChange(pairedDataDSSPanel.getPropertyChangeName(), null, this._curveCombo.getSelectedItem());
    }

    public int getSelectedCurveIndex() {
        return this._curveCombo.getSelectedIndex();
    }

    @Override
    protected void clearPanel() {
        super.clearPanel();
        this._pdc = null;
        this._curveCombo.setModel((ComboBoxModel)new RmaListModel());
    }

    @Override
    protected void setDataContainer(List[] object) {
        String string = null;
        if (object[1] != null && !object[1].isEmpty()) {
            string = (String)object[1].get(0);
        }
        if (string instanceof PairedDataContainer) {
            this._pdc = (PairedDataContainer)string;
            object = new HecPairedData();
            int n = object.read(this._pdc);
            if (n == 0) {
                PairedDataDSSPanel pairedDataDSSPanel = this;
                pairedDataDSSPanel.setLastSelectedFile(pairedDataDSSPanel._pdc.fileName);
                PairedDataDSSPanel pairedDataDSSPanel2 = this;
                pairedDataDSSPanel2.setPathName(pairedDataDSSPanel2._pdc.fullName);
                PairedDataDSSPanel pairedDataDSSPanel3 = this;
                pairedDataDSSPanel3.setFileName(pairedDataDSSPanel3._pdc.fileName);
                PairedDataDSSPanel pairedDataDSSPanel4 = this;
                pairedDataDSSPanel4.setUnits(pairedDataDSSPanel4._pdc.xunits + "/" + this._pdc.yunits);
                PairedDataDSSPanel pairedDataDSSPanel5 = this;
                pairedDataDSSPanel5.setDataType(pairedDataDSSPanel5._pdc.xtype);
                PairedDataDSSPanel pairedDataDSSPanel6 = this;
                pairedDataDSSPanel6.firePropertyChange(pairedDataDSSPanel6.getPropertyChangeName(), null, this._pdc.fullName);
                RMAUtil.setParentModified((Component)((Object)this));
                this.closeSelectorFrame();
                PairedDataDSSPanel pairedDataDSSPanel7 = this;
                object = pairedDataDSSPanel7.interpretUnits(pairedDataDSSPanel7._pdc.xunits);
                this.setInterpUnits((String)object);
                object = new RmaListModel();
                if (this._pdc.labelsUsed) {
                    object.addAll((Object[])this._pdc.labels);
                } else {
                    for (n = 0; n < this._pdc.numberCurves; ++n) {
                        object.addElement((Object)String.valueOf(n + 1));
                    }
                }
                this._curveCombo.setModel((ComboBoxModel)object);
                if (object.size() == 1) {
                    this._curveCombo.setSelectedIndex(0);
                }
            }
            return;
        }
        object = WqI18n.a("PairedDataPanel.Msg.WrongDssType").getText();
        string = WqI18n.a("PairedDataPanel.Msg.WrongDssType.Title").getText();
        JOptionPane.showMessageDialog((Component)((Object)this), object, string, -1);
    }

    public PairedDataContainer getPairedDataContainer() {
        return this._pdc;
    }

    @Override
    protected String getSelectorTitle() {
        return WqI18n.a("PairedDataPanel.ListSelection.Title").getText();
    }

    @Override
    protected String getPropertyChangeName() {
        return "PairedData";
    }
}

