/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.dataSources.pairedData;

import com.google.common.flogger.FluentLogger;
import hec.data.TimeWindow;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecDSSUtilities;
import hec.heclib.util.HecTime;
import hec.model.RunTimeWindow;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.NavigableMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;

public class SelectionTypeUtils {
    private static final FluentLogger a = FluentLogger.forEnclosingClass();
    public static final String DATE_TIME_PATTERN = "ddMMMyyyy HH[:]mm";

    private SelectionTypeUtils() {
    }

    public static Collection<String> a(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        HecDSSUtilities hecDSSUtilities = new HecDSSUtilities();
        try {
            int n = SelectionTypeUtils.a(string, hecDSSUtilities);
            if (n != 0) {
                ((FluentLogger.Api)a.atWarning()).log("Failed to open the source HecDSSUtilities manager:%s", (Object)string);
            } else {
                arrayList.addAll(SelectionTypeUtils.a(hecDSSUtilities, string2));
            }
        }
        finally {
            SelectionTypeUtils.a(hecDSSUtilities);
        }
        return arrayList;
    }

    public static void a(HecDSSUtilities hecDSSUtilities) {
        if (hecDSSUtilities != null) {
            hecDSSUtilities.close();
        }
    }

    public static Collection<String> a(HecDSSUtilities stringArray, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((stringArray = stringArray.getCatalog(false, string = SelectionTypeUtils.a(string))) != null && stringArray.length > 0) {
            arrayList.addAll(Arrays.asList(stringArray));
        }
        return arrayList;
    }

    public static String a(String string) {
        string = new DSSPathname(string.trim());
        string.setEPart("");
        string.setDPart("");
        String string2 = "*";
        String string3 = string;
        String[] stringArray = string3.getParts();
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (string4 != null && !string4.isEmpty()) continue;
            stringArray[i] = string2;
        }
        string3.setParts(stringArray);
        string = string.getPathname();
        return string;
    }

    public static int a(String string, HecDSSUtilities hecDSSUtilities) {
        int n = -1;
        if (string != null && !string.isEmpty() && (n = hecDSSUtilities.setDSSFileName(string, true)) != 0) {
            ((FluentLogger.Api)a.atWarning()).log("Failed to set the filename for the source HecDSSUtilities manager:%s", (Object)string);
        }
        return n;
    }

    public static NavigableMap<Instant, String> a(File file, Collection<String> object) {
        TreeMap<Instant, String> treeMap = new TreeMap<Instant, String>();
        if (object != null && !object.isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                Object object2 = SelectionTypeUtils.a(file, string);
                ZoneId zoneId = object2;
                object2 = string;
                object2 = new DSSPathname((String)object2);
                object2 = object2.getEPart();
                object2 = SelectionTypeUtils.a((String)object2, zoneId);
                treeMap.put((Instant)object2, string);
            }
        }
        return treeMap;
    }

    public static ZoneId a(File file, String string) {
        return null;
    }

    public static Instant a(String string, ZoneId zoneId) {
        Instant instant = null;
        if (string != null && !string.isEmpty()) {
            instant = SelectionTypeUtils.c(string, zoneId);
        }
        return instant;
    }

    public static Instant b(String object, ZoneId zoneId) {
        if (zoneId == null) {
            ((FluentLogger.Api)((FluentLogger.Api)a.atInfo()).atMostEvery(1, TimeUnit.HOURS)).log("No zoneId provided for turning time portion of DssPath into an Instant.  Using system default.");
            zoneId = ZoneId.systemDefault();
        }
        DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern(DATE_TIME_PATTERN).toFormatter(Locale.ENGLISH);
        object = LocalDateTime.parse((CharSequence)object, dateTimeFormatter);
        object = ((LocalDateTime)object).atZone(zoneId).toInstant();
        return object;
    }

    public static Instant c(String object, ZoneId zoneId) {
        ZoneId zoneId2 = ZoneId.of("UTC");
        HecTime hecTime = new HecTime();
        hecTime.set((String)object);
        if (zoneId != null && !zoneId2.equals(zoneId)) {
            hecTime = HecTime.convertToTimeZone((HecTime)hecTime, (TimeZone)TimeZone.getTimeZone(zoneId), (TimeZone)TimeZone.getTimeZone("UTC"));
        }
        object = hecTime.getInstant(zoneId2);
        return object;
    }

    public static String a(String object, String string, Instant instant) {
        Collection<String> collection = SelectionTypeUtils.a((String)object, string);
        if (!collection.isEmpty() && (instant = SelectionTypeUtils.a(object = SelectionTypeUtils.a(new File((String)object), collection), instant)) != null) {
            object = (String)object.get(instant);
            return object;
        }
        return string;
    }

    public static List<String> a(String iterator, String object, TimeWindow timeWindow) {
        iterator = SelectionTypeUtils.a((String)((Object)iterator), (String)object);
        object = new ArrayList();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object2 = new DSSPathname(string);
            object2 = SelectionTypeUtils.c(object2.getEPart(), ZoneId.of("UTC"));
            if (timeWindow != null && !timeWindow.contains(Date.from((Instant)object2), true)) continue;
            object.add(string);
        }
        return object;
    }

    public static Instant a(NavigableMap<Instant, String> navigableMap, Instant instant) {
        Instant instant2 = null;
        if (navigableMap != null && !navigableMap.isEmpty() && instant != null) {
            instant2 = SelectionTypeUtils.a(instant, navigableMap.floorKey(instant), navigableMap.ceilingKey(instant));
        }
        return instant2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Instant a(Instant comparable, Instant instant, Instant instant2) {
        void var0_7;
        void var2_9;
        void var1_8;
        if (var1_8 == null && var2_9 == null) {
            return var0_7;
        }
        if (var1_8 != null) {
            Duration duration;
            if (var2_9 == null) {
                void var0_2 = var1_8;
                return var0_7;
            }
            Duration duration2 = Duration.between(comparable, (Temporal)var1_8).abs();
            if (duration2.compareTo(duration = Duration.between(comparable, (Temporal)var2_9).abs()) <= 0) {
                void var0_4 = var1_8;
                return var0_7;
            }
        }
        void var0_6 = var2_9;
        return var0_7;
    }

    @CheckForNull
    public static TimeWindow a(@CheckForNull RunTimeWindow runTimeWindow) {
        Date date = null;
        if (runTimeWindow != null) {
            date = null;
            Object object = runTimeWindow.getStartTime();
            if (object != null) {
                date = object.getJavaDate(0);
            }
            object = null;
            if ((runTimeWindow = runTimeWindow.getEndTime()) != null) {
                object = runTimeWindow.getJavaDate(0);
            }
            date = new TimeWindow(date, true, (Date)object, true);
        }
        return date;
    }

    public static List<String> a(String string, String string2, RunTimeWindow runTimeWindow) {
        runTimeWindow = SelectionTypeUtils.a(runTimeWindow);
        return SelectionTypeUtils.a(string, string2, (TimeWindow)runTimeWindow);
    }
}

