/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.dataSources.timeSeries;

import hec.data.Parameter;
import hec.data.TimeWindow;
import hec.heclib.dss.HecPairedData;
import hec.heclib.dss.HecTimeSeries;
import hec.heclib.util.HecTime;
import hec.hecmath.HecMathException;
import hec.hecmath.TimeSeriesMath;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import hec.rss.wq.dataSources.DataSourcePanel;
import hec.rss.wq.dataSources.dss.BaseDssPanel;
import hec.rss.wq.dataSources.pairedData.PairedDataDSSPanel;
import hec.rss.wq.dataSources.timeSeries.DssDataSource$TimeSeriesPanelPropertyChangeListener;
import hec.rss.wq.dataSources.timeSeries.TimeSeriesPanel;
import hec.rss.wq.ui.PairedDataDataSource;
import hec.rss.wq.ui.ParameterMap;
import hec.rss.wq.ui.TimeSeriesDataSource;
import hec.wqenginecore.dataSource.pairedData.SelectionType;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import mil.army.usace.hec.metadata.UnitUtil;

public class DssDataSource
implements PairedDataDataSource,
TimeSeriesDataSource<DssData> {
    public static final Logger logger = Logger.getLogger(DssDataSource.class.getName());
    protected BaseDssPanel a;
    private DssData h;
    protected boolean b = true;
    protected String c;
    protected String d;
    protected List<TimeSeriesContainer> e = null;
    private TimeSeriesContainer i = null;
    private DateFormat j = new SimpleDateFormat("HHmm");
    private DateFormat k = new SimpleDateFormat("ddMMMyyyy");
    protected DssDataSource$TimeSeriesPanelPropertyChangeListener f = new DssDataSource$TimeSeriesPanelPropertyChangeListener(this);
    protected PropertyChangeSupport g = new PropertyChangeSupport(this);

    public DssDataSource(DssData dssData) {
        this.h = dssData;
        this.b = dssData.hasInterpretedUnits();
        this.c = this.h != null ? dssData.getDssPath() : "";
        this.d = this.h != null ? dssData.getDssFilePath() : "";
    }

    @Override
    public List<TimeSeriesContainer> getTimeSeries() {
        return this.getTimeSeries(null);
    }

    public PairedDataContainer e() {
        return this.getPairedData(null);
    }

    private HecTime a(Date date) {
        if (date == null) {
            return null;
        }
        return new HecTime(this.k.format(date), this.j.format(date));
    }

    @Override
    public List<TimeSeriesContainer> getTimeSeries(ParameterMap parameterMap) {
        return this.a(parameterMap);
    }

    protected List<TimeSeriesContainer> a(ParameterMap parameterMap) {
        this.e = Collections.EMPTY_LIST;
        if (this.d != null && !this.d.isEmpty() && this.c != null && !this.c.isEmpty()) {
            HecTimeSeries hecTimeSeries = new HecTimeSeries();
            hecTimeSeries.setDSSFileName(this.d);
            hecTimeSeries.setPathname(this.c);
            if ((parameterMap = parameterMap != null ? (TimeWindow)parameterMap.a(TIME_WINDOW_PARAMETER) : null) != null) {
                if (parameterMap.getStartDate() != null) {
                    hecTimeSeries.setStartTime(this.a(parameterMap.getStartDate()));
                }
                if (parameterMap.getEndDate() != null) {
                    hecTimeSeries.setEndTime(this.a(parameterMap.getEndDate()));
                }
            }
            parameterMap = new TimeSeriesContainer();
            int n = hecTimeSeries.read((TimeSeriesContainer)parameterMap, false);
            hecTimeSeries.close();
            if (n < -1) {
                logger.log(Level.FINE, "Time Series Read: \n" + this.h.getDssFilePath() + "\n" + this.h.getDssPath() + "\nReturned status of " + n);
            } else {
                this.e = new ArrayList<TimeSeriesContainer>();
                this.e.add((TimeSeriesContainer)parameterMap);
            }
        }
        return this.e;
    }

    @Override
    public PairedDataContainer getPairedData(ParameterMap parameterMap) {
        return this.getPairedData(parameterMap, this.d, this.c);
    }

    @Override
    public PairedDataContainer getPairedData(ParameterMap parameterMap, String string, String string2) {
        Integer n;
        HecPairedData hecPairedData = new HecPairedData();
        hecPairedData.setDSSFileName(string);
        hecPairedData.setPathname(string2);
        string = parameterMap != null ? (TimeWindow)parameterMap.a(TIME_WINDOW_PARAMETER) : null;
        if (string != null) {
            if (string.getStartDate() != null) {
                hecPairedData.setStartTime(this.a(string.getStartDate()));
            }
            if (string.getEndDate() != null) {
                hecPairedData.setEndTime(this.a(string.getEndDate()));
            }
        }
        string = new PairedDataContainer();
        int n2 = hecPairedData.read((PairedDataContainer)string);
        hecPairedData.close();
        if (n2 < -1) {
            logger.log(Level.FINE, "Paired Data Read: \n" + this.h.getDssFilePath() + "\n" + this.h.getDssPath() + "\nReturned status of " + n2);
        }
        if ((n = this.getCurve(parameterMap)) == null) {
            n = 0;
        }
        DssDataSource.a((PairedDataContainer)string, parameterMap, n);
        return string;
    }

    public static void a(PairedDataContainer pairedDataContainer, ParameterMap object, int n) {
        object = UnitUtil.getBestMatch((String)pairedDataContainer.xunits);
        String string = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ELEV, (int)1);
        String string2 = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ELEV, (int)2);
        if (string.equalsIgnoreCase((String)object) || string2.equalsIgnoreCase((String)object)) {
            object = pairedDataContainer.xOrdinates;
            pairedDataContainer.xOrdinates = pairedDataContainer.yOrdinates[n];
            pairedDataContainer.yOrdinates[n] = (double[])object;
            object = pairedDataContainer.xunits;
            pairedDataContainer.xunits = pairedDataContainer.yunits;
            pairedDataContainer.yunits = object;
            object = pairedDataContainer.xparameter;
            pairedDataContainer.xparameter = pairedDataContainer.yparameter;
            pairedDataContainer.yparameter = object;
        }
    }

    @Override
    public Integer getCurve(ParameterMap parameterMap) {
        if (this.h != null && this.h.isProfileData()) {
            return 0;
        }
        return null;
    }

    @Override
    public SelectionType getSelectionType(ParameterMap parameterMap) {
        return SelectionType.UseSelectedRecord;
    }

    @Override
    public TimeWindow getTimeWindow() {
        Object object2;
        List<TimeSeriesContainer> list = this.a((ParameterMap)null);
        if (list.isEmpty()) {
            return null;
        }
        HecTime hecTime = null;
        HecTime hecTime2 = null;
        for (Object object2 : list) {
            if ((object2 = object2.getTimes()) == null) continue;
            for (int i = 0; i < object2.numberElements(); ++i) {
                if (hecTime == null || hecTime.greaterThan(object2.element(i))) {
                    hecTime = object2.element(i);
                }
                if (hecTime2 != null && !hecTime2.lessThan(object2.element(i))) continue;
                hecTime2 = object2.element(i);
            }
        }
        list = new SimpleDateFormat("ddMMMyyyy, HH:mm");
        try {
            if (hecTime != null && hecTime2 != null) {
                object2 = new TimeWindow(((DateFormat)((Object)list)).parse(hecTime.dateAndTime(4)), true, ((DateFormat)((Object)list)).parse(hecTime2.dateAndTime(4)), true);
                return object2;
            }
        }
        catch (ParseException parseException) {
            object2 = parseException;
            parseException.printStackTrace();
        }
        return null;
    }

    public DssData d() {
        return this.h;
    }

    public BaseDssPanel c() {
        if (this.a == null) {
            if (this.h.isProfileData()) {
                this.a = new PairedDataDSSPanel();
                this.a.fillPanel(this.h);
                this.a.addPropertyChangeListener(this.f);
            } else {
                this.a = new TimeSeriesPanel(this.b);
                this.a.fillPanel(this.h);
                this.a.addPropertyChangeListener(this.f);
            }
        }
        return this.a;
    }

    public static TimeSeriesContainer a(TimeSeriesContainer object, HecTime hecTime, HecTime hecTime2) throws HecMathException {
        TimeSeriesMath.checkTimeSeries((TimeSeriesContainer)object);
        if (hecTime.value() > object.times[object.numberValues - 1]) {
            HecTime hecTime3 = new HecTime();
            hecTime3.set(object.times[object.numberValues - 1]);
            object = "Beginning of timewindow " + String.valueOf(hecTime) + " exceeds the end time " + String.valueOf(hecTime3) + " of the time series";
            throw new HecMathException("DssDataSource.trimTimeSeries: " + (String)object);
        }
        if (hecTime2.value() < object.times[0]) {
            HecTime hecTime4 = new HecTime();
            hecTime4.set(object.times[0]);
            object = "End of timewindow " + String.valueOf(hecTime2) + " before the beginning time " + String.valueOf(hecTime4) + " of the time series";
            throw new HecMathException("DssDataSource.trimTimeSeries: " + (String)object);
        }
        TimeSeriesMath timeSeriesMath = new TimeSeriesMath(object);
        timeSeriesMath = (TimeSeriesMath)timeSeriesMath.copy();
        int n = 0;
        int n2 = -1;
        int n3 = hecTime.value();
        int n4 = hecTime2.value();
        for (int i = 0; i < object.times.length; ++i) {
            if (n3 > object.times[i]) continue;
            if (n4 < object.times[i]) break;
            ++n;
            if (n2 >= 0) continue;
            n2 = i;
        }
        if (n == 0) {
            object = "No values found in time window";
            throw new HecMathException("DssDataSource.trimTimeSeries: " + (String)object);
        }
        int[] nArray = new int[n];
        double[] dArray = new double[n];
        System.arraycopy(object.times, n2, nArray, 0, n);
        System.arraycopy(object.values, n2, dArray, 0, n);
        object = (TimeSeriesContainer)timeSeriesMath.getData();
        ((TimeSeriesContainer)timeSeriesMath.getData()).times = nArray;
        object.values = dArray;
        object.numberValues = n;
        object.startTime = nArray[0];
        object.endTime = nArray[n - 1];
        return object;
    }

    @Override
    public String getName() {
        return this.h.getName();
    }

    @Override
    public JComponent getComponent() {
        return this.c();
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public void validateData() throws IOException {
        if (this.a != null) {
            this.a.validateData();
        }
    }

    @Override
    public void save() throws IOException {
        if (this.a != null) {
            this.a.save();
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.g.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.g.removePropertyChangeListener(propertyChangeListener);
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        boolean bl;
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (DssDataSource)object;
        boolean bl2 = Objects.equals(this.c, ((DssDataSource)object).c) || this.c != null && this.c.equalsIgnoreCase(((DssDataSource)object).c);
        boolean bl3 = bl = Objects.equals(this.d, ((DssDataSource)object).d) || this.d != null && this.d.equalsIgnoreCase(((DssDataSource)object).d);
        return bl2 && bl;
    }

    public int hashCode() {
        return Objects.hash(this.c == null ? null : this.c.toLowerCase(), this.d == null ? null : this.d.toLowerCase());
    }

    @Override
    public /* synthetic */ DataSourcePanel getSourceComponent() {
        return this.c();
    }

    @Override
    public /* synthetic */ Object getData() {
        return this.d();
    }
}

