/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.map;

import hec.appInterface.AppDaddy;
import hec.map.GlyphDataRecord;
import hec.map.LayerSelectionFactory;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.ModeDrawingAttributeSet;
import hec.map.ModelDrawingAttributeSet;
import hec.map.ModelDrawingAttributeSetFactory;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.map.aishape.AiShapeArc;
import hec.map.aishape.AiShapeFieldDescriptor;
import hec.map.aishape.AiShapeGlyph;
import hec.map.aishape.AiShapeGlyphDataRecord;
import hec.map.aishape.AiShapeObject;
import hec.map.aishape.Field;
import hec.rss.wq.client.crossSection.CrossSectionManagerGlyphSelection;
import hec.rss.wq.map.CrossSectionAttributeSet;
import hec.rss.wq.model.CrossSectionManager;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;

public class CrossSectionManagerGlyph
extends AiShapeGlyph {
    private final CrossSectionAttributeSet _csmDas;
    private CrossSectionManager _manager;
    private int _riverCol = -1;
    private int _reachCol = -1;
    private int _stationCol = -1;

    public CrossSectionManagerGlyph(MapPanel mapPanel, CrossSectionManager crossSectionManager) {
        super(mapPanel, crossSectionManager.getShapeMap());
        this._manager = crossSectionManager;
        mapPanel = this._manager.getShapeMap();
        if (mapPanel != null) {
            mapPanel = (AiShapeGlyphDataRecord)this.getDefaultDataRecord();
            mapPanel.setDefaultLineColor(Color.GREEN.darker());
            mapPanel.setDefaultColor(Color.GREEN.darker());
            this.setDataRecord((GlyphDataRecord)mapPanel);
        }
        this.findColumns();
        this._csmDas = this.findAttributeSet();
    }

    private CrossSectionAttributeSet findAttributeSet() {
        Object object = AppDaddy.getFrame().getCurrentModule();
        object = object != null ? object.toString() : " ";
        if ((object = ModeDrawingAttributeSet.getModeAttributeSet((String)object)) == null) {
            return null;
        }
        return (CrossSectionAttributeSet)object.getModelAttributeSet("Cross Sections");
    }

    private void findColumns() {
        Object object = this._manager.getShapeMap();
        if (object == null) {
            return;
        }
        String string = this._manager.getRiverColumn();
        String string2 = this._manager.getReachColumn();
        String string3 = this._manager.getStationColumn();
        object = object.getFieldDescriptors();
        new ArrayList();
        int n = 0;
        object = object.iterator();
        while (object.hasNext()) {
            AiShapeFieldDescriptor aiShapeFieldDescriptor = (AiShapeFieldDescriptor)object.next();
            if (aiShapeFieldDescriptor.toString().equals(string)) {
                this._riverCol = n;
            } else if (aiShapeFieldDescriptor.toString().equals(string2)) {
                this._reachCol = n;
            } else if (aiShapeFieldDescriptor.toString().equals(string3)) {
                this._stationCol = n;
            }
            if (this._riverCol >= 0 && this._reachCol >= 0 && this._stationCol >= 0) {
                return;
            }
            ++n;
        }
    }

    public void draw(Graphics graphics, MapScale mapScale) {
        if (!this.isShown()) {
            return;
        }
        super.draw(graphics, mapScale);
    }

    public String getToolTipText(WorldPt worldPt, MouseEvent object) {
        double d = this._mapPanel.scale().x2e(5) - this._mapPanel.scale().x2e(0);
        object = this._manager.getShapeMap();
        if (object == null) {
            return null;
        }
        object = object.getShapes();
        for (int i = 0; i < object.size(); ++i) {
            AiShapeObject aiShapeObject = (AiShapeObject)object.get(i);
            Vector vector = aiShapeObject instanceof AiShapeArc ? ((AiShapeArc)aiShapeObject).getArcLines() : null;
            if (vector == null) continue;
            for (int j = 0; j < vector.size(); ++j) {
                WorldLine worldLine = (WorldLine)vector.get(j);
                if (!worldLine.nearPt(worldPt, d)) continue;
                return this.getShapeToolTip(aiShapeObject);
            }
        }
        return null;
    }

    private String getShapeToolTip(AiShapeObject aiShapeObject) {
        Field field;
        aiShapeObject = aiShapeObject.getAttribute();
        StringBuilder stringBuilder = new StringBuilder("<html>");
        if (this._riverCol >= 0) {
            field = aiShapeObject.getField(this._riverCol);
            stringBuilder.append("River: " + String.valueOf(field.getValue()));
        }
        if (this._reachCol >= 0) {
            field = aiShapeObject.getField(this._reachCol);
            stringBuilder.append("<br>Reach: " + String.valueOf(field.getValue()));
        }
        if (this._stationCol >= 0) {
            field = aiShapeObject.getField(this._stationCol);
            stringBuilder.append("<br>Station: " + String.valueOf(field.getValue()));
        }
        return stringBuilder.toString();
    }

    public String getName() {
        return this._manager.getName();
    }

    public boolean isShown() {
        if (this._csmDas == null) {
            return false;
        }
        return this._csmDas.isShown();
    }

    public ModelDrawingAttributeSet getAttributeSet() {
        return this._csmDas;
    }

    static {
        LayerSelectionFactory.addMapping((String)CrossSectionManagerGlyph.class.getName(), (String)CrossSectionManagerGlyphSelection.class.getName());
        ModelDrawingAttributeSetFactory.addMapping((String)"Cross Sections", (String)CrossSectionAttributeSet.class.getName());
    }
}

