/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.map;

import hec.appInterface.AppDaddy;
import hec.clientapp.client.ClientApp;
import hec.clientapp.model.StreamAlignment;
import hec.gui.NameDialog;
import hec.lang.NamedType;
import hec.map.LayerSelectionFactory;
import hec.map.LocalPt;
import hec.map.MapGlyph;
import hec.map.MapLabelItem;
import hec.map.MapObjectInterface;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.appInterface.MapApplicationModule;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.model.StreamElement;
import hec.model.StreamJunction;
import hec.model.StreamNode;
import hec.rss.client.RSimSimulationMode;
import hec.rss.client.RssSystemGlyph;
import hec.rss.model.Element;
import hec.rss.model.JunctionElement;
import hec.rss.wq.client.WaterQualityDPData;
import hec.rss.wq.client.WaterQualityMode;
import hec.rss.wq.client.massinjection.FindSitesForGeometry;
import hec.rss.wq.client.massinjection.MassInjectionDrawPropData;
import hec.rss.wq.client.massinjection.MassInjectionMapGlyphSelection;
import hec.rss.wq.client.massinjection.PlaceMassInjectionSiteDialog;
import hec.rss.wq.map.MassInjectionIcon;
import hec.rss.wq.model.JsonManager;
import hec.rss.wq.model.massinjection.MassInjectionManager;
import hec.rss.wq.model.massinjection.MassInjectionSetManager;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.SubDomainJunction;
import hec.wqenginecore.massinjection.MassInjectionSite;
import hec.wqengineimpl.massInjection.WQMassInjectionSite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.text.Document;
import rma.swing.text.DssPathnamePartDocument;

public class MassInjectionManagerGlyph
extends MapGlyph {
    private List<MapGlyph.Selection> _selectionList = new ArrayList<MapGlyph.Selection>();
    private StreamAlignmentGlyph _alignGlyph;
    private MassInjectionManager _siteMap;
    private MassInjectionSetManager _setMgr;
    private MassInjectionIcon _miIcon;
    private RssSystemGlyph _sysGlyph;

    public MassInjectionManagerGlyph(MapPanel mapPanel, MassInjectionManager massInjectionManager) {
        super(mapPanel, (MapObjectInterface)massInjectionManager);
        this._siteMap = massInjectionManager;
        this._miIcon = new MassInjectionIcon(14.0);
    }

    public Path2D getIcon() {
        return this._miIcon;
    }

    public void draw(Graphics graphics, MapScale mapScale) {
        int n;
        MassInjectionSetManager massInjectionSetManager;
        if (this._siteMap == null) {
            return;
        }
        if (!this.findStreamGlyph()) {
            return;
        }
        this._miIcon = new MassInjectionIcon(20.0);
        Object object = ClientApp.frame().getCurrentMode();
        boolean bl = true;
        if (object instanceof WaterQualityMode) {
            object = (WaterQualityMode)object;
            massInjectionSetManager = ((WaterQualityMode)object).getMassInjectionSetManager();
            this.setSelectedMassInjectionSetManager(massInjectionSetManager);
        } else if (object instanceof RSimSimulationMode) {
            object = (RSimSimulationMode)object;
            massInjectionSetManager = ((RSimSimulationMode)object).getMassInjectionSetManager();
            this.setSelectedMassInjectionSetManager(massInjectionSetManager);
            bl = false;
        }
        object = this._siteMap.getMassInjectionSites();
        for (n = 0; _paintOk && n < object.size(); ++n) {
            massInjectionSetManager = (WQMassInjectionSite)object.get(n);
            if (massInjectionSetManager == null) continue;
            this.drawSite(graphics, mapScale, (WQMassInjectionSite)massInjectionSetManager, bl);
        }
        for (n = 0; _paintOk && n < this._selectionList.size(); ++n) {
            object = this._selectionList.get(n);
            if (((MapGlyph.Selection)object).object == null || !(((MapGlyph.Selection)object).object instanceof WQMassInjectionSite)) continue;
            this.drawSelectedSite(graphics, mapScale, (WQMassInjectionSite)((MapGlyph.Selection)object).object, false, ((MapGlyph.Selection)object).editing);
        }
    }

    public String getDescription() {
        String string = super.getDescription();
        MassInjectionSetManager massInjectionSetManager = this.getSelectedMassInjectionSetManager();
        if (massInjectionSetManager != null) {
            string = ((JsonManager)massInjectionSetManager).getName();
        }
        return string;
    }

    private void drawSite(Graphics graphics, MapScale mapScale, WQMassInjectionSite wQMassInjectionSite, boolean bl) {
        Object object;
        Color color;
        if (wQMassInjectionSite == null) {
            return;
        }
        Object object2 = this._alignGlyph.findReach(wQMassInjectionSite.getStreamName());
        if (object2 == null) {
            return;
        }
        Object object3 = object2.getLocationByStation(wQMassInjectionSite.getStreamStation());
        if (object3 == null || !object3.isValid()) {
            return;
        }
        int n = WaterQualityDPData.b();
        int n2 = mapScale.e2x(object3.e);
        int n3 = mapScale.n2y(object3.n);
        MassInjectionDrawPropData massInjectionDrawPropData = MassInjectionDrawPropData.b(n);
        Color color2 = color = massInjectionDrawPropData != null ? massInjectionDrawPropData.getColor() : Color.BLACK;
        if (!this.siteInSelectedSet(wQMassInjectionSite, bl)) {
            if (!bl) {
                return;
            }
            color = Color.LIGHT_GRAY;
        }
        if ((object = object2.getAlignment().findReach(object3, 5.0)) == null) {
            return;
        }
        double d = object.getCoordByStation(wQMassInjectionSite.getStreamStation());
        object2 = new WorldPt();
        object3 = new WorldPt();
        if (!object.getLine().getSlopeAtCoord(d, object3, (WorldPt)object2)) {
            return;
        }
        double d2 = object2.e == 0.0 ? 1.5707963267948966 : Math.atan(object2.n / object2.e);
        graphics.setColor(color);
        object = this._miIcon.getBounds2D();
        object2 = ((Graphics2D)graphics).getTransform();
        object3 = new AffineTransform((AffineTransform)object2);
        ((Graphics2D)graphics).setTransform((AffineTransform)object3);
        ((Graphics2D)graphics).translate(n2, n3);
        ((Graphics2D)graphics).translate(-Math.sin(d2) * ((RectangularShape)object).getMaxX(), -Math.cos(d2) * ((RectangularShape)object).getMaxY());
        ((Graphics2D)graphics).rotate(-d2);
        ((Graphics2D)graphics).fill(this._miIcon);
        ((Graphics2D)graphics).setTransform((AffineTransform)object2);
        boolean bl2 = massInjectionDrawPropData != null ? massInjectionDrawPropData.getDrawName() : true;
        Font font = object2 = massInjectionDrawPropData != null ? massInjectionDrawPropData.getNameFont() : this._mapPanel.getFont();
        if (bl2) {
            graphics = new MapLabelItem(wQMassInjectionSite.getName(), n2, n3, 6, 7, this._glyphLevel + 0.3f, (Font)object2, Color.BLACK, null, graphics);
            this._mapPanel.viewport().addMapLabelItem((MapLabelItem)graphics);
        }
    }

    private boolean siteInSelectedSet(WQMassInjectionSite wQMassInjectionSite, boolean bl) {
        if (this._setMgr == null || this._setMgr.getSet() == null) {
            return bl;
        }
        return this._setMgr.getSet().hasMassInjectionSite(wQMassInjectionSite.getId());
    }

    public void drawSelectedSite(Graphics graphics, MapScale mapScale, WQMassInjectionSite wQMassInjectionSite, boolean bl, boolean bl2) {
        Object object;
        if (wQMassInjectionSite == null) {
            return;
        }
        Object object2 = this.getReferencePoint(wQMassInjectionSite);
        if (object2 == null || !object2.isValid()) {
            return;
        }
        int n = this._miIcon.getBounds().width / 2;
        int n2 = this._miIcon.getBounds().height / 2;
        int n3 = mapScale.e2x(((WorldPt)object2).e);
        int n4 = mapScale.n2y(((WorldPt)object2).n);
        Color color = Color.BLACK;
        if (this.siteInSelectedSet(wQMassInjectionSite, true)) {
            color = Color.GRAY;
        }
        if ((object = this._alignGlyph.findReach(wQMassInjectionSite.getStreamName())) == null) {
            return;
        }
        object2 = object.getAlignment().findReach((WorldPt)object2, 5.0);
        if (object2 == null) {
            return;
        }
        double d = object2.getCoordByStation(wQMassInjectionSite.getStreamStation());
        object = new WorldPt();
        Object object3 = new WorldPt();
        if (!object2.getLine().getSlopeAtCoord(d, object3, (WorldPt)object)) {
            return;
        }
        double d2 = object.e == 0.0 ? 1.5707963267948966 : Math.atan(object.n / object.e);
        graphics.setColor(Color.YELLOW);
        object2 = this._miIcon.getBounds2D();
        object = ((Graphics2D)graphics).getTransform();
        object3 = new AffineTransform((AffineTransform)object);
        ((Graphics2D)graphics).setTransform((AffineTransform)object3);
        ((Graphics2D)graphics).translate(n3, n4);
        ((Graphics2D)graphics).translate(-Math.sin(d2) * ((RectangularShape)object2).getMaxX(), -Math.cos(d2) * ((RectangularShape)object2).getMaxY());
        ((Graphics2D)graphics).rotate(-d2);
        ((Graphics2D)graphics).fill(this._miIcon);
        graphics.setColor(color);
        ((Graphics2D)graphics).draw(this._miIcon);
        if (bl) {
            graphics.setXORMode(XOR_COLOR);
        }
        if (bl2) {
            graphics.setColor(Color.black);
            graphics.fillRect(-n - 5, -n2 - 5, 5, 5);
            graphics.fillRect(-n - 5, n2, 5, 5);
            graphics.fillRect(n, -n2 - 5, 5, 5);
            graphics.fillRect(n, n2, 5, 5);
        }
        ((Graphics2D)graphics).setTransform((AffineTransform)object);
        int massInjectionDrawPropData = WaterQualityDPData.b();
        MassInjectionDrawPropData massInjectionDrawPropData2 = MassInjectionDrawPropData.b(massInjectionDrawPropData);
        if (massInjectionDrawPropData2 != null) {
            massInjectionDrawPropData2.getNameFont();
        } else {
            this._mapPanel.getFont();
        }
        MapLabelItem mapLabelItem = new MapLabelItem(wQMassInjectionSite.getName(), n3, n4, 6, 7, this._glyphLevel + 0.3f, this._mapPanel.getFont(), Color.BLACK, null, graphics);
        this._mapPanel.viewport().addMapLabelItem(mapLabelItem);
        if (bl) {
            graphics.setPaintMode();
        }
    }

    boolean findSysGlyph() {
        this._sysGlyph = (RssSystemGlyph)this._mapPanel.findGlyphOfClass(RssSystemGlyph.class.getName());
        return this._sysGlyph != null;
    }

    boolean findStreamGlyph() {
        this._alignGlyph = (StreamAlignmentGlyph)this._mapPanel.findGlyphOfClass(StreamAlignmentGlyph.class.getName());
        return this._alignGlyph != null;
    }

    public WorldPt getReferencePoint(WQMassInjectionSite wQMassInjectionSite) {
        StreamElement streamElement = this._alignGlyph.findReach(wQMassInjectionSite.getStreamName());
        if (streamElement != null) {
            return streamElement.getLocationByStation(wQMassInjectionSite.getStreamStation());
        }
        return null;
    }

    public WQMassInjectionSite moveSite(WQMassInjectionSite wQMassInjectionSite, WorldPt worldPt, StreamElement streamElement, double d, double d2) {
        if (this._siteMap == null || wQMassInjectionSite == null) {
            return wQMassInjectionSite;
        }
        worldPt = this._mapPanel.scale().wp2lp(worldPt);
        this._mapPanel.scale().x2e(worldPt.x + 8);
        this._mapPanel.scale().x2e(worldPt.x);
        wQMassInjectionSite.setStreamStation(streamElement.getName(), d2);
        return wQMassInjectionSite;
    }

    public WQMassInjectionSite createMassInjectionSite(LocalPt localPt, StreamElement streamElement) {
        Object object;
        List<Object> list;
        Object object2;
        if (this._siteMap == null) {
            return null;
        }
        this.findSysGlyph();
        WorldPt worldPt = this._mapPanel.scale((MapGlyph)this).lp2wp(localPt);
        localPt = this._alignGlyph.findStreamJunction(streamElement, localPt);
        Element element = null;
        if (this._sysGlyph != null) {
            object2 = this._mapPanel.scale().wp2lp(worldPt);
            double d = this._mapPanel.scale().x2e(((LocalPt)object2).x + 3) - this._mapPanel.scale().x2e(((LocalPt)object2).x);
            element = this._sysGlyph.findJunction(worldPt, d);
        }
        if (localPt != null || element != null) {
            object2 = new PlaceMassInjectionSiteDialog((Frame)ClientApp.frame(), true, streamElement);
            if (localPt != null && element != null && localPt.getLocation().equals(element.getReferencePt())) {
                element = null;
            }
            ((PlaceMassInjectionSiteDialog)((Object)object2)).setJunctions((StreamJunction)localPt, (JunctionElement)element);
        } else {
            object2 = new NameDialog((Frame)ClientApp.frame(), true);
        }
        object2.setNameFieldDocument((Document)new DssPathnamePartDocument());
        object2.setName("");
        object2.setDescription("");
        object2.setTitle("Name New Mass Injection Site");
        object2.setExistingNames(this._siteMap.getMassInjectionSiteNames());
        object2.setVisible(true);
        if (object2.isCanceled()) {
            return null;
        }
        String string = object2.getName();
        Object object3 = object2.getDescription();
        WQMassInjectionSite wQMassInjectionSite = this._siteMap.addMassInjectionSite(string, (String)object3);
        if (object2 instanceof PlaceMassInjectionSiteDialog) {
            object3 = ((PlaceMassInjectionSiteDialog)((Object)(object2 = (PlaceMassInjectionSiteDialog)((Object)object2)))).getSelectedObject();
            if (object3 == localPt) {
                list = localPt.getNodeVector();
                object = (StreamNode)((Vector)list).get(0);
                for (int i = 1; i < ((Vector)list).size(); ++i) {
                    StreamNode streamNode;
                    localPt = (StreamNode)((Vector)list).get(i);
                    if (!(streamNode.getStreamCoord() > object.getStreamCoord())) continue;
                    object = localPt;
                }
                streamElement = object.getStream();
                wQMassInjectionSite.setStreamStation(object.getStation());
                wQMassInjectionSite.setStreamName(streamElement.getName());
                wQMassInjectionSite.setAtJunction(true);
            } else if (object3 instanceof StreamElement) {
                streamElement = (StreamElement)object3;
                wQMassInjectionSite.setStreamStation(streamElement.getStationByLocation(worldPt));
                wQMassInjectionSite.setStreamName(streamElement.getName());
            } else if (object3 != null && object3 == element) {
                double d = ((JunctionElement)element).getStreamStation();
                streamElement = ((JunctionElement)element).getStream();
                wQMassInjectionSite.setStreamStation(d);
                wQMassInjectionSite.setStreamName(streamElement.getName());
                wQMassInjectionSite.setAtJunction(true);
            } else {
                wQMassInjectionSite.setStreamStation(streamElement.getName(), streamElement.getStationByLocation(worldPt));
            }
        } else {
            wQMassInjectionSite.setStreamStation(streamElement.getName(), streamElement.getStationByLocation(worldPt));
        }
        if (this._setMgr != null) {
            object2 = new FindSitesForGeometry();
            object3 = new ArrayList<WQMassInjectionSite>();
            object3.add(wQMassInjectionSite);
            list = ((FindSitesForGeometry)object2).a(this._setMgr.getGeometry(), (List<WQMassInjectionSite>)object3, (StreamAlignment)this._alignGlyph.getMap());
            if (list.size() > 0) {
                object = ((FindSitesForGeometry)object2).a((MassInjectionSite)list.get(0));
                this._setMgr.getSet().addMassInjectionSite((MassInjectionSite)list.get(0));
                if (object != null && (localPt = this._setMgr.getSet().getMassInjectionSiteData((MassInjectionSite)list.get(0))) != null) {
                    if (object instanceof SubDomain) {
                        streamElement = (SubDomain)object;
                        localPt.setSubDomainRef(streamElement.getRef());
                    } else if (object instanceof SubDomainJunction) {
                        streamElement = (SubDomainJunction)object;
                        localPt.setSubDomainJunctionRef(streamElement.getRef());
                    }
                }
            }
        }
        return wQMassInjectionSite;
    }

    public MassInjectionManager getMassInjectionManager() {
        return (MassInjectionManager)this.getMap();
    }

    public boolean sitePopupMenu(LocalPt localPt) {
        if (this._siteMap == null || localPt == null) {
            return false;
        }
        double d = this._mapPanel.scale().x2e(localPt.x + 5) - this._mapPanel.scale().x2e(localPt.x);
        WorldPt worldPt = this._mapPanel.scale().lp2wp(localPt);
        WQMassInjectionSite wQMassInjectionSite = this.findSite(worldPt, d);
        if (wQMassInjectionSite != null) {
            this._selectionList.clear();
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)wQMassInjectionSite, false);
            this._selectionList.add(selection);
            MassInjectionManagerGlyph massInjectionManagerGlyph = this;
            massInjectionManagerGlyph.drawSelectedSite(massInjectionManagerGlyph._mapPanel.viewport().getGraphics(), this._mapPanel.scale(), wQMassInjectionSite, false, false);
            MassInjectionManagerGlyph massInjectionManagerGlyph2 = this;
            massInjectionManagerGlyph2.drawSelectedSite(massInjectionManagerGlyph2._mapPanel.viewport().getBufferedGraphics(), this._mapPanel.scale(), wQMassInjectionSite, false, false);
            selection = AppDaddy.getFrame();
            selection = (MapApplicationModule)selection.getCurrentModule();
            selection.objectPopupMenu((NamedType)wQMassInjectionSite, localPt);
            return true;
        }
        return false;
    }

    public boolean objectPopupMenu(LocalPt localPt, int n) {
        NamedType[] namedTypeArray = this.findSite(localPt);
        if (namedTypeArray != null) {
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)namedTypeArray, false);
            if (!this._selectionList.contains(selection)) {
                this.clearSelection();
                this._selectionList.add(selection);
            }
            MassInjectionManagerGlyph massInjectionManagerGlyph = this;
            massInjectionManagerGlyph.drawSelectedSite(massInjectionManagerGlyph._mapPanel.viewport().getGraphics(), this._mapPanel.scale(), (WQMassInjectionSite)namedTypeArray, false, false);
            MassInjectionManagerGlyph massInjectionManagerGlyph2 = this;
            massInjectionManagerGlyph2.drawSelectedSite(massInjectionManagerGlyph2._mapPanel.viewport().getBufferedGraphics(), this._mapPanel.scale(), (WQMassInjectionSite)namedTypeArray, false, false);
            selection = AppDaddy.getFrame();
            selection = (MapApplicationModule)selection.getCurrentModule();
            if (this._selectionList.size() == 1) {
                return selection.objectPopupMenu((NamedType)namedTypeArray, localPt);
            }
            namedTypeArray = this.getSelections();
            return selection.objectPopupMenu(namedTypeArray, localPt);
        }
        return false;
    }

    public void clearSelection() {
        boolean bl;
        int n = this._selectionList.size();
        boolean bl2 = bl = n > 0;
        if (n > 0) {
            Graphics graphics = this._mapPanel.viewport().getGraphics();
            for (int i = 0; i < n; ++i) {
                MapGlyph.Selection selection = this._selectionList.get(i);
                this.drawSite(graphics, this._mapPanel.scale(), (WQMassInjectionSite)selection.object, true);
            }
        }
        this._selectionList.clear();
        if (bl) {
            this._mapPanel.paintMap();
        }
    }

    public WQMassInjectionSite selectSite(LocalPt localPt, boolean bl, boolean bl2) {
        if (!bl) {
            this._selectionList.clear();
        }
        if (this._siteMap == null || localPt == null) {
            return null;
        }
        double d = this._mapPanel.scale().x2e(localPt.x + 5) - this._mapPanel.scale().x2e(localPt.x);
        localPt = this._mapPanel.scale().lp2wp(localPt);
        if ((localPt = this.findSite((WorldPt)localPt, d)) != null) {
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)localPt, bl2);
            if (!this._selectionList.contains(selection)) {
                this._selectionList.add(selection);
            }
            if (bl) {
                Graphics graphics = this._mapPanel.viewport().getGraphics();
                this.drawSelectedSite(graphics, this._mapPanel.scale(), (WQMassInjectionSite)localPt, false, bl2);
                graphics.dispose();
            } else {
                this._mapPanel.paintMap();
            }
        } else if (!bl) {
            this._mapPanel.paintMap();
        }
        return localPt;
    }

    public WQMassInjectionSite findSite(LocalPt localPt) {
        if (this._siteMap == null || localPt == null) {
            return null;
        }
        localPt = this._mapPanel.scale().lp2wp(localPt);
        return this.findSite((WorldPt)localPt);
    }

    private WQMassInjectionSite findSite(WorldPt worldPt) {
        if (this._siteMap == null || worldPt == null) {
            return null;
        }
        double d = this._mapPanel.scale().x2e(5) - this._mapPanel.scale().x2e(0);
        return this.findSite(worldPt, d);
    }

    private WQMassInjectionSite findSite(WorldPt worldPt, double d) {
        new WorldRect(worldPt, d);
        MapScale mapScale = this._mapPanel.scale((MapGlyph)this);
        worldPt = mapScale.wp2lp(worldPt);
        Object object = this._siteMap.getMassInjectionSites();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2;
            WQMassInjectionSite wQMassInjectionSite = (WQMassInjectionSite)object.next();
            if (wQMassInjectionSite == null || (object2 = this._alignGlyph.findReach(wQMassInjectionSite.getStreamName())) == null) continue;
            WorldPt worldPt2 = this.getReferencePoint(wQMassInjectionSite);
            worldPt2 = mapScale.wp2lp(worldPt2);
            Object object3 = object2.getLocationByStation(wQMassInjectionSite.getStreamStation());
            if (object3 == null || !object3.isValid() || (object2 = object2.getAlignment().findReach((WorldPt)object3, 5.0)) == null) continue;
            double d2 = object2.getCoordByStation(wQMassInjectionSite.getStreamStation());
            object3 = new WorldPt();
            WorldPt worldPt3 = new WorldPt();
            boolean bl = object2.getLine().getSlopeAtCoord(d2, worldPt3, (WorldPt)object3);
            double d3 = !bl ? 1.5707963267948966 : (((WorldPt)object3).e == 0.0 ? 1.5707963267948966 : Math.atan(((WorldPt)object3).n / ((WorldPt)object3).e));
            object2 = this._miIcon.getBounds2D();
            object3 = new AffineTransform();
            ((AffineTransform)object3).translate(worldPt2.x, worldPt2.y);
            ((AffineTransform)object3).translate(-Math.sin(d3) * ((RectangularShape)object2).getMaxX(), -Math.cos(d3) * ((RectangularShape)object2).getMaxY());
            ((AffineTransform)object3).rotate(-d3);
            if (!(object2 = ((AffineTransform)object3).createTransformedShape((Shape)object2)).contains(new Point2D.Double(worldPt.x, worldPt.y))) continue;
            return wQMassInjectionSite;
        }
        return null;
    }

    public void setSelectedMassInjectionSetManager(MassInjectionSetManager massInjectionSetManager) {
        this._setMgr = massInjectionSetManager;
    }

    public MassInjectionSetManager getSelectedMassInjectionSetManager() {
        return this._setMgr;
    }

    public String getToolTipText(WorldPt worldPt, MouseEvent mouseEvent) {
        if (this._siteMap == null || worldPt == null) {
            return null;
        }
        if ((worldPt = this.findSite(worldPt)) != null) {
            return worldPt.getName();
        }
        return null;
    }

    public void setSelection(WQMassInjectionSite wQMassInjectionSite, boolean bl) {
        wQMassInjectionSite = new MapGlyph.Selection((MapGlyph)this, (Object)wQMassInjectionSite, bl);
        this._selectionList.clear();
        this._selectionList.add((MapGlyph.Selection)wQMassInjectionSite);
        this._mapPanel.paintMap();
    }

    static {
        LayerSelectionFactory.addMapping((String)MassInjectionManagerGlyph.class.getName(), (String)MassInjectionMapGlyphSelection.class.getName());
    }
}

