/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.model;

import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyList;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.SimulationPeriod;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.io.Identifier;
import hec.lang.UserId;
import hec.model.RunTimeWindow;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.wq.model.AltWaterQualityOptions$ManagerRef;
import hec.rss.wq.model.BoundaryConditionSetManager;
import hec.rss.wq.model.ConstituentSetManager;
import hec.rss.wq.model.CrossSectionManager;
import hec.rss.wq.model.InitialConditionSetManager;
import hec.rss.wq.model.JsonManager;
import hec.rss.wq.model.MetData;
import hec.rss.wq.model.ObsDatasetManager;
import hec.rss.wq.model.WQTSDataProvider;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.model.dispersionCoeff.DispersionSetManager;
import hec.rss.wq.model.massinjection.MassInjectionSetManager;
import hec.rss.wq.model.wqParameters.ParameterSetManager;
import hec.wqenginecore.OutputVariableOptions;
import hec.wqenginecore.parameter.ParameterSet;
import hec.wqengineimpl.parameter.WQParameterSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.util.RMAIO;

public class AltWaterQualityOptions
implements Cloneable {
    public static final Logger logger = Logger.getLogger(AltWaterQualityOptions.class.getName());
    public static final String WATER_QUALITY_BEGIN = "WaterQualityBegin";
    public static final String WATER_QUALITY_END = "WaterQualityEnd";
    private static final String RAS_FOLDER = "ras-exports";
    private boolean _runWq;
    private AltWaterQualityOptions$ManagerRef<ConstituentSetManager> _constituentRef;
    private AltWaterQualityOptions$ManagerRef<ObsDatasetManager> _obsDataRef;
    private AltWaterQualityOptions$ManagerRef<MetData> _metDataRef;
    private AltWaterQualityOptions$ManagerRef<MassInjectionSetManager> _massInjectionRef;
    private AltWaterQualityOptions$ManagerRef<DispersionSetManager> _dispCoefRef;
    private AltWaterQualityOptions$ManagerRef<ParameterSetManager> _paramsRef;
    private AltWaterQualityOptions$ManagerRef<WqGeometry> _geoRef;
    private AltWaterQualityOptions$ManagerRef<InitialConditionSetManager> _icRef;
    private AltWaterQualityOptions$ManagerRef<BoundaryConditionSetManager> _bcRef;
    private int _numberThreads = 1;
    private int _numOutputTimeSteps = 1;
    private boolean _preserveConcentration = true;
    private boolean _firstOrderSolution = true;
    private OutputVariableOptions _outputVaribleOpts = new OutputVariableOptions();
    private boolean _coupledFlowWQCompute = false;
    private int _timeStep = -1;
    private int _timestepIncrement = -1;
    private ObsDatasetManager _obsDataSetMgr;
    private List<AltWaterQualityOptions$ManagerRef<? extends Manager>> _managerRefs;

    public AltWaterQualityOptions() {
        this.initManagerRefs();
    }

    private void initManagerRefs() {
        this._constituentRef = new AltWaterQualityOptions$ManagerRef<ConstituentSetManager>(this, ConstituentSetManager.class);
        this._obsDataRef = new AltWaterQualityOptions$ManagerRef<ObsDatasetManager>(this, ObsDatasetManager.class);
        this._metDataRef = new AltWaterQualityOptions$ManagerRef<MetData>(this, MetData.class);
        this._massInjectionRef = new AltWaterQualityOptions$ManagerRef<MassInjectionSetManager>(this, MassInjectionSetManager.class);
        this._dispCoefRef = new AltWaterQualityOptions$ManagerRef<DispersionSetManager>(this, DispersionSetManager.class);
        this._paramsRef = new AltWaterQualityOptions$ManagerRef<ParameterSetManager>(this, ParameterSetManager.class);
        this._geoRef = new AltWaterQualityOptions$ManagerRef<WqGeometry>(this, WqGeometry.class);
        this._icRef = new AltWaterQualityOptions$ManagerRef<InitialConditionSetManager>(this, InitialConditionSetManager.class);
        this._bcRef = new AltWaterQualityOptions$ManagerRef<BoundaryConditionSetManager>(this, BoundaryConditionSetManager.class);
        this._managerRefs = new ArrayList<AltWaterQualityOptions$ManagerRef<? extends Manager>>();
        this._managerRefs.add(this._constituentRef);
        this._managerRefs.add(this._obsDataRef);
        this._managerRefs.add(this._metDataRef);
        this._managerRefs.add(this._massInjectionRef);
        this._managerRefs.add(this._dispCoefRef);
        this._managerRefs.add(this._paramsRef);
        this._managerRefs.add(this._geoRef);
        this._managerRefs.add(this._icRef);
        this._managerRefs.add(this._bcRef);
    }

    public void setRunWq(boolean bl) {
        this._runWq = bl;
    }

    public boolean shouldRunWq() {
        return this._runWq;
    }

    public void writeData(BufferedWriter bufferedWriter) {
        if (bufferedWriter == null) {
            return;
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)WATER_QUALITY_BEGIN);
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("RunWq=" + this._runWq));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("TimeStep=" + this._timeStep));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("TimeStepIncrement=" + this._timestepIncrement));
        if (this._constituentRef.b != null) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Constituent=" + this._constituentRef.b));
        }
        if (this._constituentRef.a >= 0) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ConstituentId=" + this._constituentRef.a));
        }
        if (this._constituentRef.c >= 0) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ConstituentBaseId=" + this._constituentRef.c));
        }
        if (this._obsDataRef.b != null) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ObsData=" + this._obsDataRef.b));
        }
        if (this._obsDataRef.a >= 0) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ObsDataId=" + this._obsDataRef.a));
        }
        if (this._obsDataRef.c >= 0) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ObsDataBaseId=" + this._obsDataRef.c));
        }
        if (this._icRef.b != null) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("InitialConditions=" + this._icRef.b));
        }
        if (this._icRef.a >= 0) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("InitialConditionsId=" + this._icRef.a));
        }
        if (this._icRef.c >= 0) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("InitialConditionsBaseId=" + this._icRef.c));
        }
        if (this._bcRef.b != null) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("BoundaryConditions=" + this._bcRef.b));
        }
        if (this._bcRef.a >= 0) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("BoundaryConditionsId=" + this._bcRef.a));
        }
        if (this._bcRef.c >= 0) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("BoundaryConditionsBaseId=" + this._bcRef.c));
        }
        if (this._metDataRef.b != null) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("MetData=" + this._metDataRef.b));
        }
        if (this._metDataRef.a >= 0) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("MetDataId=" + this._metDataRef.a));
        }
        if (this._metDataRef.c >= 0) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("MetDataBaseId=" + this._metDataRef.c));
        }
        if (this._massInjectionRef.b != null) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("MassInjection=" + this._massInjectionRef.b));
        }
        if (this._massInjectionRef.a >= 0) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("MassInjectionId=" + this._massInjectionRef.a));
        }
        if (this._massInjectionRef.c >= 0) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("MassInjectionBaseId=" + this._massInjectionRef.c));
        }
        if (this._dispCoefRef.b != null) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("DispersionCoef=" + this._dispCoefRef.b));
        }
        if (this._dispCoefRef.a >= 0) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("DispersionCoefId=" + this._dispCoefRef.a));
        }
        if (this._dispCoefRef.c >= 0) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("DispersionCoefBaseId=" + this._dispCoefRef.c));
        }
        if (this._paramsRef.b != null) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Parameters=" + this._paramsRef.b));
        }
        if (this._paramsRef.a >= 0) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ParametersId=" + this._paramsRef.a));
        }
        if (this._paramsRef.c >= 0) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ParametersBaseId=" + this._paramsRef.c));
        }
        if (this._geoRef.b != null) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("WqGeometry=" + this._geoRef.b));
        }
        if (this._geoRef.a >= 0) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("WqGeometryId=" + this._geoRef.a));
        }
        if (this._geoRef.c >= 0) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("WqGeometryBaseId=" + this._geoRef.c));
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("NumberThreads=" + this._numberThreads));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("OutputSteps=" + this._numOutputTimeSteps));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("PreserveConcentration=" + this._preserveConcentration));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("FirstOrderSolution=" + this._firstOrderSolution));
        this._outputVaribleOpts.writeOutputVariableOptions(bufferedWriter);
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("CoupledFlowWQCompute=" + this._coupledFlowWQCompute));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)WATER_QUALITY_END);
    }

    public void readData(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            return;
        }
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.contains(WATER_QUALITY_END)) {
                    return;
                }
                String string2 = RMAIO.getType((String)string, (String)"=");
                string = RMAIO.getParam((String)string, (String)"=");
                if ("RunWq".equalsIgnoreCase(string2)) {
                    this._runWq = Boolean.parseBoolean(string);
                    continue;
                }
                if ("TimeStep".equalsIgnoreCase(string2)) {
                    this._timeStep = RMAIO.parseInt((String)string);
                    continue;
                }
                if ("TimeStepIncrement".equalsIgnoreCase(string2)) {
                    this._timestepIncrement = RMAIO.parseInt((String)string);
                    continue;
                }
                if ("Constituent".equalsIgnoreCase(string2)) {
                    this._constituentRef.b = string;
                    continue;
                }
                if ("ConstituentId".equalsIgnoreCase(string2)) {
                    this._constituentRef.a = RMAIO.parseInt((String)string, (int)-1);
                    continue;
                }
                if ("ConstituentBaseId".equalsIgnoreCase(string2)) {
                    this._constituentRef.c = RMAIO.parseInt((String)string, (int)-1);
                    continue;
                }
                if ("InitialConditions".equalsIgnoreCase(string2)) {
                    this._icRef.b = string;
                    continue;
                }
                if ("InitialConditionsId".equalsIgnoreCase(string2)) {
                    this._icRef.a = RMAIO.parseInt((String)string, (int)-1);
                    continue;
                }
                if ("InitialConditionsBaseId".equalsIgnoreCase(string2)) {
                    this._icRef.c = RMAIO.parseInt((String)string, (int)-1);
                    continue;
                }
                if ("BoundaryConditions".equalsIgnoreCase(string2)) {
                    this._bcRef.b = string;
                    continue;
                }
                if ("BoundaryConditionsId".equalsIgnoreCase(string2)) {
                    this._bcRef.a = RMAIO.parseInt((String)string, (int)-1);
                    continue;
                }
                if ("BoundaryConditionsBaseId".equalsIgnoreCase(string2)) {
                    this._bcRef.c = RMAIO.parseInt((String)string, (int)-1);
                    continue;
                }
                if ("ObsData".equalsIgnoreCase(string2)) {
                    this._obsDataRef.b = string;
                    continue;
                }
                if ("ObsDataId".equalsIgnoreCase(string2)) {
                    this._obsDataRef.a = RMAIO.parseInt((String)string, (int)-1);
                    continue;
                }
                if ("ObsDataBaseId".equalsIgnoreCase(string2)) {
                    this._obsDataRef.c = RMAIO.parseInt((String)string, (int)-1);
                    continue;
                }
                if ("MetData".equalsIgnoreCase(string2)) {
                    this._metDataRef.b = string;
                    continue;
                }
                if ("MetDataId".equalsIgnoreCase(string2)) {
                    this._metDataRef.a = RMAIO.parseInt((String)string, (int)-1);
                    continue;
                }
                if ("MetDataBaseId".equalsIgnoreCase(string2)) {
                    this._metDataRef.c = RMAIO.parseInt((String)string, (int)-1);
                    continue;
                }
                if ("MassInjection".equalsIgnoreCase(string2)) {
                    this._massInjectionRef.b = string;
                    continue;
                }
                if ("MassInjectionId".equalsIgnoreCase(string2)) {
                    this._massInjectionRef.a = RMAIO.parseInt((String)string, (int)-1);
                    continue;
                }
                if ("MassInjectionBaseId".equalsIgnoreCase(string2)) {
                    this._massInjectionRef.c = RMAIO.parseInt((String)string, (int)-1);
                    continue;
                }
                if ("DispersionCoef".equalsIgnoreCase(string2)) {
                    this._dispCoefRef.b = string;
                    continue;
                }
                if ("DispersionCoefId".equalsIgnoreCase(string2)) {
                    this._dispCoefRef.a = RMAIO.parseInt((String)string, (int)-1);
                    continue;
                }
                if ("DispersionCoefBaseId".equalsIgnoreCase(string2)) {
                    this._dispCoefRef.c = RMAIO.parseInt((String)string, (int)-1);
                    continue;
                }
                if ("Parameters".equalsIgnoreCase(string2)) {
                    this._paramsRef.b = string;
                    continue;
                }
                if ("ParametersId".equalsIgnoreCase(string2)) {
                    this._paramsRef.a = RMAIO.parseInt((String)string, (int)-1);
                    continue;
                }
                if ("ParametersBaseId".equalsIgnoreCase(string2)) {
                    this._paramsRef.c = RMAIO.parseInt((String)string, (int)-1);
                    continue;
                }
                if ("WqGeometry".equalsIgnoreCase(string2)) {
                    this._geoRef.b = string;
                    continue;
                }
                if ("WqGeometryId".equalsIgnoreCase(string2)) {
                    this._geoRef.a = RMAIO.parseInt((String)string, (int)-1);
                    continue;
                }
                if ("WqGeometryBaseId".equalsIgnoreCase(string2)) {
                    this._geoRef.c = RMAIO.parseInt((String)string, (int)-1);
                    continue;
                }
                if ("NumberThreads".equalsIgnoreCase(string2)) {
                    this._numberThreads = RMAIO.parseInt((String)string, (int)1);
                    continue;
                }
                if ("OutputSteps".equalsIgnoreCase(string2)) {
                    this._numOutputTimeSteps = RMAIO.parseInt((String)string, (int)1);
                    continue;
                }
                if ("PreserveConcentration".equalsIgnoreCase(string2)) {
                    this._preserveConcentration = RMAIO.parseBoolean((String)string, (boolean)true);
                    continue;
                }
                if ("FirstOrderSolution".equalsIgnoreCase(string2)) {
                    this._firstOrderSolution = RMAIO.parseBoolean((String)string, (boolean)true);
                    continue;
                }
                if ("OutputVariablesBegin".equalsIgnoreCase(string2)) {
                    this._outputVaribleOpts.readOutputVariableOptions(bufferedReader);
                    continue;
                }
                if (!"CoupledFlowWQCompute".equalsIgnoreCase(string2)) continue;
                this._coupledFlowWQCompute = RMAIO.parseBoolean((String)string, (boolean)true);
            }
            return;
        }
        catch (IOException iOException) {
            System.out.println("WaterQualityOptions.readData:Exception reading file " + String.valueOf(iOException));
            return;
        }
    }

    public String getGeometryName() {
        return this._geoRef.b;
    }

    public void setGeometryName(String string) {
        this._geoRef.b = string;
    }

    public void setGeometryId(int n) {
        this._geoRef.a = n;
    }

    public int getGeometryId() {
        return this._geoRef.a;
    }

    public ParameterSetManager getParameterSetManager(RssAlt rssAlt) {
        return (ParameterSetManager)this.getManager(rssAlt, ParameterSetManager.class, this._paramsRef.a);
    }

    public String getParametersName() {
        return this._paramsRef.b;
    }

    public void setParametersName(String string) {
        this._paramsRef.b = string;
    }

    public void setParametersId(int n) {
        this._paramsRef.a = n;
    }

    public int getParametersId() {
        return this._paramsRef.a;
    }

    public InitialConditionSetManager getInitialConditionsSetManager(RssAlt rssAlt) {
        return (InitialConditionSetManager)this.getManager(rssAlt, InitialConditionSetManager.class, this._icRef.a);
    }

    public String getIcName() {
        return this._icRef.b;
    }

    public void setIcName(String string) {
        this._icRef.b = string;
    }

    public int getIcId() {
        return this._icRef.a;
    }

    public void setIcId(int n) {
        this._icRef.a = n;
    }

    public String getDispersionCoefName() {
        return this._dispCoefRef.b;
    }

    public DispersionSetManager getDispersionSetManager(RssAlt rssAlt) {
        return (DispersionSetManager)this.getManager(rssAlt, DispersionSetManager.class, this._dispCoefRef.a);
    }

    public void setDispersionCoefId(int n) {
        this._dispCoefRef.a = n;
    }

    public int getDispersionCoefId() {
        return this._dispCoefRef.a;
    }

    public void setDispersionCoefName(String string) {
        this._dispCoefRef.b = string;
    }

    public String getMassInjectionName() {
        return this._massInjectionRef.b;
    }

    public void setMassInjectionName(String string) {
        this._massInjectionRef.b = string;
    }

    public void setMassInjectionId(int n) {
        this._massInjectionRef.a = n;
    }

    public int getMassInjectionId() {
        return this._massInjectionRef.a;
    }

    public String getMetDataName() {
        return this._metDataRef.b;
    }

    public void setMetDataName(String string) {
        this._metDataRef.b = string;
    }

    public void setMetDataId(int n) {
        this._metDataRef.a = n;
    }

    public int getMetDataId() {
        return this._metDataRef.a;
    }

    public String getObservedDataName() {
        return this._obsDataRef.b;
    }

    public void setObservedDataName(String string) {
        this._obsDataRef.b = string;
    }

    public void setObservedDataId(int n) {
        this._obsDataRef.a = n;
    }

    public int getObservedDataId() {
        return this._obsDataRef.a;
    }

    public ConstituentSetManager getConstituentSetManager(RssAlt rssAlt) {
        return (ConstituentSetManager)this.getManager(rssAlt, ConstituentSetManager.class, this._constituentRef.a);
    }

    public String getConstituentName() {
        return this._constituentRef.b;
    }

    public void setConstituentName(String string) {
        this._constituentRef.b = string;
    }

    public void setConstituentId(int n) {
        this._constituentRef.a = n;
    }

    public int getConstituentId() {
        return this._constituentRef.a;
    }

    public String getBcName() {
        return this._bcRef.b;
    }

    public void setBcId(int n) {
        this._bcRef.a = n;
    }

    public int getBcId() {
        return this._bcRef.a;
    }

    public void setBcName(String string) {
        this._bcRef.b = string;
    }

    public AltWaterQualityOptions clone() {
        AltWaterQualityOptions altWaterQualityOptions = null;
        try {
            altWaterQualityOptions = (AltWaterQualityOptions)super.clone();
            ((AltWaterQualityOptions)super.clone())._outputVaribleOpts = this._outputVaribleOpts.clone();
            altWaterQualityOptions._bcRef = this._bcRef.a();
            altWaterQualityOptions._constituentRef = this._constituentRef.a();
            altWaterQualityOptions._dispCoefRef = this._dispCoefRef.a();
            altWaterQualityOptions._geoRef = this._geoRef.a();
            altWaterQualityOptions._icRef = this._icRef.a();
            altWaterQualityOptions._massInjectionRef = this._massInjectionRef.a();
            altWaterQualityOptions._metDataRef = this._metDataRef.a();
            altWaterQualityOptions._obsDataRef = this._obsDataRef.a();
            altWaterQualityOptions._outputVaribleOpts = this._outputVaribleOpts.clone();
            altWaterQualityOptions._paramsRef = this._paramsRef.a();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("AltWaterQualityOptions.clone:exception " + String.valueOf(cloneNotSupportedException));
        }
        return altWaterQualityOptions;
    }

    public boolean refreshData(RssAlt rssAlt, RssAlt rssAlt2) {
        if (rssAlt != null && rssAlt2 != null) {
            Object object = rssAlt2.getWaterQualityOptions();
            if (object == null) {
                return false;
            }
            this._firstOrderSolution = ((AltWaterQualityOptions)object)._firstOrderSolution;
            this._numberThreads = ((AltWaterQualityOptions)object)._numberThreads;
            this._numOutputTimeSteps = ((AltWaterQualityOptions)object)._numOutputTimeSteps;
            this._outputVaribleOpts = ((AltWaterQualityOptions)object)._outputVaribleOpts.clone();
            this._preserveConcentration = ((AltWaterQualityOptions)object)._preserveConcentration;
            this._coupledFlowWQCompute = ((AltWaterQualityOptions)object)._coupledFlowWQCompute;
            this._timeStep = ((AltWaterQualityOptions)object)._timeStep;
            this._timestepIncrement = ((AltWaterQualityOptions)object)._timestepIncrement;
            this._runWq = ((AltWaterQualityOptions)object)._runWq;
            rssAlt2.getProxyList();
            rssAlt.getProxyList();
            object = (RmiWorkspace)rssAlt2.getWorkspace().getRemote();
            String string = null;
            try {
                string = object.getWorkspacePath();
            }
            catch (RemoteException remoteException) {
                logger.log(Level.WARNING, "Failed to get source watershed path during refresh of " + String.valueOf(rssAlt) + ". Exception", remoteException);
            }
            if (string == null) {
                return false;
            }
            object = (RmiWorkspace)rssAlt.getWorkspace().getRemote();
            String string2 = null;
            try {
                string2 = object.getWorkspacePath();
            }
            catch (RemoteException remoteException) {
                logger.log(Level.WARNING, "failed to get destination watershed path during refresh of " + String.valueOf(rssAlt) + ". Exception", remoteException);
            }
            if (string2 == null) {
                return false;
            }
            if (!string2.endsWith("rss")) {
                string2 = RMAIO.concatPath((String)string2, (String)"rss");
            }
            object = rssAlt.getProxyList().getContainer();
            String string3 = AltWaterQualityOptions.getPrefix(rssAlt.getName());
            this.refreshGeometry(rssAlt2, rssAlt, string, string2, string3, (ManagerProxyListContainer)object);
            this.refreshMetData(rssAlt2, rssAlt, string, string2, string3, (ManagerProxyListContainer)object);
            this.refreshConstituentSet(rssAlt2, rssAlt, string, string2, string3, (ManagerProxyListContainer)object);
            this.refreshBoundaryConditionSet(rssAlt2, rssAlt, string, string2, string3, (ManagerProxyListContainer)object);
            this.refreshInitialConditionsSet(rssAlt2, rssAlt, string, string2, string3, (ManagerProxyListContainer)object);
            this.refreshDispersionSet(rssAlt2, rssAlt, string, string2, string3, (ManagerProxyListContainer)object);
            this.refreshParameterSet(rssAlt2, rssAlt, string, string2, string3, (ManagerProxyListContainer)object);
            this.refreshObservedData(rssAlt2, rssAlt, string, string2, string3, (ManagerProxyListContainer)object);
            this.refreshMassInjection(rssAlt2, rssAlt, string, string2, string3, (ManagerProxyListContainer)object);
            if (object.isModified() && (object = rssAlt.getWorkspace()).getObject() instanceof RmiWorkspace) {
                object = (RmiWorkspace)object.getObject();
                try {
                    object.saveWorkspace(UserId.getUserId());
                }
                catch (RemoteException remoteException) {
                    object = remoteException;
                    remoteException.printStackTrace();
                }
            }
            this.updateObsStationNetworkElements(rssAlt.getSystem(), rssAlt2.getSystem());
        }
        return true;
    }

    private boolean refreshMassInjection(RssAlt manager, RssAlt rssAlt, String object, String string, String string2, ManagerProxyListContainer managerProxyListContainer) {
        AltWaterQualityOptions altWaterQualityOptions = manager.getWaterQualityOptions();
        String string3 = AltWaterQualityOptions.getRealName(altWaterQualityOptions._massInjectionRef.b);
        String string4 = AltWaterQualityOptions.getRealName(this._massInjectionRef.b);
        if (string3 != null && string3.equals(string4)) {
            boolean bl = this.refreshData((RssAlt)manager, rssAlt, (String)object, altWaterQualityOptions._massInjectionRef, this._massInjectionRef);
            if (!bl) {
                logger.log(Level.WARNING, "Refresh for WQ MassInjection Set " + String.valueOf(this._massInjectionRef) + " failed");
            }
            if ((object = this.getMassInjectionSetManager(rssAlt)) != null) {
                ((MassInjectionSetManager)object).setGeometryId(this._geoRef.a);
                ((MassInjectionSetManager)object).setConstituentSetId(this._constituentRef.a);
            }
            return bl;
        }
        if (altWaterQualityOptions._massInjectionRef.a >= 0) {
            object = RMAIO.concatPath((String)string, (String)"wq/");
            if ((manager = this.saveMassInjectionAs((RssAlt)manager, (String)object, string2, managerProxyListContainer, this._geoRef.a, this._constituentRef.a, altWaterQualityOptions._massInjectionRef.a, this)) == null) {
                logger.log(Level.WARNING, "Creating WQ MassInjection Set failed during refresh of " + String.valueOf(rssAlt));
            } else {
                managerProxyListContainer.setModified(true);
            }
            return manager != null;
        }
        this._massInjectionRef.a = -1;
        logger.log(Level.INFO, "No WQ MassInjection Set to refresh for " + String.valueOf(rssAlt));
        return true;
    }

    private boolean refreshObservedData(RssAlt manager, RssAlt rssAlt, String string, String string2, String string3, ManagerProxyListContainer managerProxyListContainer) {
        AltWaterQualityOptions altWaterQualityOptions = manager.getWaterQualityOptions();
        String string4 = AltWaterQualityOptions.getRealName(altWaterQualityOptions._obsDataRef.b);
        String string5 = AltWaterQualityOptions.getRealName(this._obsDataRef.b);
        if (string4 != null && string4.equals(string5)) {
            boolean bl = this.refreshData((RssAlt)manager, rssAlt, string, altWaterQualityOptions._obsDataRef, this._obsDataRef);
            if (!bl) {
                logger.log(Level.WARNING, "Refresh for WQ ObservedData Set " + String.valueOf(this._obsDataRef) + " failed");
            }
            return bl;
        }
        if (altWaterQualityOptions._obsDataRef.a >= 0) {
            string = RMAIO.concatPath((String)string2, (String)"wq");
            if ((manager = this.saveObsDataAs((RssAlt)manager, string, string3, managerProxyListContainer, altWaterQualityOptions._obsDataRef.a, this)) == null) {
                logger.log(Level.WARNING, "Creating WQ ObservedData Set failed during refresh of " + String.valueOf(rssAlt));
            } else {
                managerProxyListContainer.setModified(true);
            }
            return manager != null;
        }
        this._obsDataRef.a = -1;
        logger.log(Level.INFO, "No WQ ObservedData Set to refresh for " + String.valueOf(rssAlt));
        return true;
    }

    private boolean refreshParameterSet(RssAlt rssAlt, RssAlt rssAlt2, String string, String object, String object2, ManagerProxyListContainer managerProxyListContainer) {
        AltWaterQualityOptions altWaterQualityOptions = rssAlt.getWaterQualityOptions();
        String string2 = AltWaterQualityOptions.getRealName(altWaterQualityOptions._paramsRef.b);
        String string3 = AltWaterQualityOptions.getRealName(this._paramsRef.b);
        if (string2 != null && string2.equals(string3)) {
            boolean bl = this.refreshData(rssAlt, rssAlt2, string, altWaterQualityOptions._paramsRef, this._paramsRef);
            if (!bl) {
                logger.log(Level.WARNING, "Refresh for WQ Parameter Set " + String.valueOf(this._paramsRef) + " failed");
            }
            object = this.getParameterSetManager(rssAlt2);
            object2 = rssAlt.getWaterQualityOptions().getParameterSetManager(rssAlt);
            if (object != null) {
                if (object2 != null) {
                    int n = rssAlt.getWaterQualityOptions().getConstituentId();
                    ParameterSet parameterSet = ((ParameterSetManager)object2).getSet(n);
                    ((ParameterSetManager)object).clearSet();
                    ((ParameterSetManager)object).setSet(this._constituentRef.a, (WQParameterSet)parameterSet);
                }
                ((ParameterSetManager)object).setGeometryId(this._geoRef.a);
                object.setModified(true);
                object.getProxyList().saveManager(UserId.getUserId(), (Manager)object);
            }
            return bl;
        }
        object2 = this.saveParameterSetAs(rssAlt, (String)(object = RMAIO.concatPath((String)object, (String)"wq/")), (String)object2, managerProxyListContainer, this._geoRef.a, this._constituentRef.a, altWaterQualityOptions._paramsRef.a, this);
        if (object2 == null) {
            logger.log(Level.WARNING, "Creating WQ Parameter Set failed during refresh of " + String.valueOf(rssAlt2));
        } else {
            managerProxyListContainer.setModified(true);
        }
        return object2 != null;
    }

    private boolean refreshDispersionSet(RssAlt manager, RssAlt rssAlt, String object, String string, String string2, ManagerProxyListContainer managerProxyListContainer) {
        AltWaterQualityOptions altWaterQualityOptions = manager.getWaterQualityOptions();
        String string3 = AltWaterQualityOptions.getRealName(altWaterQualityOptions._dispCoefRef.b);
        String string4 = AltWaterQualityOptions.getRealName(this._dispCoefRef.b);
        if (string3 != null && string3.equals(string4)) {
            boolean bl = this.refreshData((RssAlt)manager, rssAlt, (String)object, altWaterQualityOptions._dispCoefRef, this._dispCoefRef);
            if (!bl) {
                logger.log(Level.WARNING, "Refresh for WQ DispersionCoef Set " + String.valueOf(this._dispCoefRef) + " failed");
            }
            if ((object = this.getDispersionSetManager(rssAlt)) != null) {
                ((DispersionSetManager)object).setGeometryId(this._geoRef.a);
                object.setModified(true);
                object.getProxyList().saveManager(UserId.getUserId(), (Manager)object);
            }
            return bl;
        }
        object = RMAIO.concatPath((String)string, (String)"wq/");
        if ((manager = this.saveDispersionSetAs((RssAlt)manager, (String)object, string2, managerProxyListContainer, this._geoRef.a, altWaterQualityOptions._dispCoefRef.a, this)) == null) {
            logger.log(Level.WARNING, "Creating WQ DispersionCoef Set failed during refresh of " + String.valueOf(rssAlt));
        } else {
            managerProxyListContainer.setModified(true);
        }
        return manager != null;
    }

    private boolean refreshInitialConditionsSet(RssAlt manager, RssAlt rssAlt, String object, String string, String string2, ManagerProxyListContainer managerProxyListContainer) {
        AltWaterQualityOptions altWaterQualityOptions = manager.getWaterQualityOptions();
        String string3 = AltWaterQualityOptions.getRealName(altWaterQualityOptions._icRef.b);
        String string4 = AltWaterQualityOptions.getRealName(this._icRef.b);
        if (string3 != null && string3.equals(string4)) {
            boolean bl = this.refreshData((RssAlt)manager, rssAlt, (String)object, altWaterQualityOptions._icRef, this._icRef);
            if (!bl) {
                logger.log(Level.WARNING, "Refresh for WQ InitialConditions Set " + String.valueOf(this._icRef) + " failed");
            }
            if ((object = this.getInitialConditionsSetManager(rssAlt)) != null) {
                ((InitialConditionSetManager)object).setGeometryId(this._geoRef.a);
                ((InitialConditionSetManager)object).setConstituentSetId(this._constituentRef.a);
                object.setModified(true);
                object.getProxyList().saveManager(UserId.getUserId(), (Manager)object);
            }
            return bl;
        }
        object = RMAIO.concatPath((String)string, (String)"wq/");
        if ((manager = this.saveInitialConditionsAs((RssAlt)manager, (String)object, string2, managerProxyListContainer, this._geoRef.a, this._constituentRef.a, altWaterQualityOptions._icRef.a, this)) == null) {
            logger.log(Level.WARNING, "Creating WQ InitialConditions Set failed during refresh of " + String.valueOf(rssAlt));
        } else {
            managerProxyListContainer.setModified(true);
        }
        return manager != null;
    }

    private boolean refreshBoundaryConditionSet(RssAlt manager, RssAlt rssAlt, String object, String string, String string2, ManagerProxyListContainer managerProxyListContainer) {
        AltWaterQualityOptions altWaterQualityOptions = manager.getWaterQualityOptions();
        String string3 = AltWaterQualityOptions.getRealName(altWaterQualityOptions._bcRef.b);
        String string4 = AltWaterQualityOptions.getRealName(this._bcRef.b);
        if (string3 != null && string3.equals(string4)) {
            boolean bl = this.refreshData((RssAlt)manager, rssAlt, (String)object, altWaterQualityOptions._bcRef, this._bcRef);
            if (!bl) {
                logger.log(Level.WARNING, "Refresh for WQ BoundaryCondition Set " + String.valueOf(this._bcRef) + " failed");
            }
            if ((object = this.getBcManager(rssAlt)) != null) {
                ((BoundaryConditionSetManager)object).setGeometryId(this._geoRef.a);
                ((BoundaryConditionSetManager)object).setConstituentSetId(this._constituentRef.a);
                object.setModified(true);
                object.getProxyList().saveManager(UserId.getUserId(), (Manager)object);
            }
            return bl;
        }
        object = RMAIO.concatPath((String)string, (String)"wq/");
        if ((manager = this.saveBoundaryConditionAs((RssAlt)manager, (String)object, string2, managerProxyListContainer, this._geoRef.a, this._constituentRef.a, altWaterQualityOptions._bcRef.a, this)) == null) {
            logger.log(Level.WARNING, "Creating WQ BoundaryCondition Set failed during refresh of " + String.valueOf(rssAlt));
        } else {
            managerProxyListContainer.setModified(true);
        }
        return manager != null;
    }

    private boolean refreshConstituentSet(RssAlt manager, RssAlt rssAlt, String string, String string2, String string3, ManagerProxyListContainer managerProxyListContainer) {
        AltWaterQualityOptions altWaterQualityOptions = manager.getWaterQualityOptions();
        String string4 = AltWaterQualityOptions.getRealName(altWaterQualityOptions._constituentRef.b);
        String string5 = AltWaterQualityOptions.getRealName(this._constituentRef.b);
        if (string4 != null && string4.equals(string5)) {
            boolean bl = this.refreshData((RssAlt)manager, rssAlt, string, altWaterQualityOptions._constituentRef, this._constituentRef);
            if (!bl) {
                logger.log(Level.WARNING, "Refresh for WQ Constituent Set " + String.valueOf(this._constituentRef) + " failed");
            }
            return bl;
        }
        string = RMAIO.concatPath((String)string2, (String)"wq/");
        if ((manager = this.saveConstituentSetAs((RssAlt)manager, string, string3, managerProxyListContainer, altWaterQualityOptions._constituentRef.a, this)) == null) {
            logger.log(Level.WARNING, "Creating WQ Constituent Set failed during refresh of " + String.valueOf(rssAlt));
        } else {
            managerProxyListContainer.setModified(true);
        }
        return manager != null;
    }

    private boolean refreshMetData(RssAlt manager, RssAlt rssAlt, String string, String object, String string2, ManagerProxyListContainer managerProxyListContainer) {
        AltWaterQualityOptions altWaterQualityOptions = manager.getWaterQualityOptions();
        Object object2 = AltWaterQualityOptions.getRealName(altWaterQualityOptions._metDataRef.b);
        Object object3 = AltWaterQualityOptions.getRealName(this._metDataRef.b);
        if (object2 != null && object2.equals(object3)) {
            boolean bl = this.refreshData((RssAlt)manager, rssAlt, string, altWaterQualityOptions._metDataRef, this._metDataRef);
            if (!bl) {
                logger.log(Level.WARNING, "Refresh for WQ MetData " + String.valueOf(this._metDataRef) + " failed");
            }
            object = this.getGeometryManager(rssAlt);
            object2 = altWaterQualityOptions.getGeometryManager((RssAlt)manager);
            object3 = this.getMetDataManager(rssAlt);
            if (object3 != null && object != null && object2 != null) {
                this.updateMetDataAssignments((MetData)object3, (RssAlt)manager, (WqGeometry)((Object)object2), (WqGeometry)((Object)object));
                object3.getProxyList().saveManager(UserId.getUserId(), (Manager)object3);
            }
            return bl;
        }
        if (altWaterQualityOptions._metDataRef.a >= 0) {
            if ((manager = this.saveMetDataAs((RssAlt)manager, (String)(object = RMAIO.concatPath((String)object, (String)"wq")), string2, managerProxyListContainer, (WqGeometry)((Object)(object2 = this.getGeometryManager(rssAlt))), (WqGeometry)((Object)(object3 = altWaterQualityOptions.getGeometryManager((RssAlt)manager))), altWaterQualityOptions._metDataRef.a, this)) == null) {
                logger.log(Level.WARNING, "Creating WQ MetData failed during refresh of " + String.valueOf(rssAlt));
            } else {
                managerProxyListContainer.setModified(true);
            }
            return manager != null;
        }
        this._metDataRef.a = -1;
        logger.log(Level.INFO, "No WQ MetData Set to refresh for " + String.valueOf(rssAlt));
        return true;
    }

    private boolean refreshGeometry(RssAlt rssAlt, RssAlt object, String string, String string2, String string3, ManagerProxyListContainer managerProxyListContainer) {
        Object object2 = rssAlt.getWaterQualityOptions();
        String string4 = AltWaterQualityOptions.getRealName(object2._geoRef.b);
        String string5 = AltWaterQualityOptions.getRealName(this._geoRef.b);
        int n = ((RssAlt)object).getSystemIndex();
        String string6 = RMAIO.concatPath((String)string2, (String)"wq/geometry");
        if (string4 != null && string4.equals(string5)) {
            boolean bl = this.refreshData(rssAlt, (RssAlt)object, string, object2._geoRef, this._geoRef);
            if (!bl) {
                logger.log(Level.WARNING, "Refresh for WQ Geometry " + String.valueOf(this._geoRef) + " failed");
                rssAlt.printErrorMessage("Refresh of WQ Geometry " + String.valueOf(this._geoRef) + " failed");
            }
            object2 = this.getGeometryManager((RssAlt)object);
            object = (WqGeometry)this.getManager(rssAlt, WqGeometry.class, rssAlt.getWaterQualityOptions().getGeometryId());
            if (object2 != null) {
                if (object != null && (object = ((WqGeometry)((Object)object)).getSteadyFlowPath()) != null && (object = AltWaterQualityOptions.copyFile(object.toString(), string2, rssAlt.getFileManager())) != null) {
                    object = Paths.get((String)object, new String[0]);
                    ((WqGeometry)((Object)object2)).setSteadyFlowPath((Path)object);
                }
                ((WqGeometry)((Object)object2)).setNetworkId(n);
                this.saveGeometryCrossSectionManager(string3, (WqGeometry)((Object)object2), rssAlt, string6, managerProxyListContainer);
                object2.getProxyList().saveManager(UserId.getUserId(), (Manager)object2);
            }
            return bl;
        }
        object2 = this.saveGeometryAs(rssAlt, string6, string3, managerProxyListContainer, n, object2._geoRef.a, this);
        if (object2 == null) {
            logger.log(Level.WARNING, "Creating WQ Geometry failed during refresh of " + String.valueOf(object));
        } else {
            managerProxyListContainer.setModified(true);
        }
        return object2 != null;
    }

    private boolean refreshData(RssAlt rssAlt, RssAlt rssAlt2, String string, AltWaterQualityOptions$ManagerRef altWaterQualityOptions$ManagerRef, AltWaterQualityOptions$ManagerRef altWaterQualityOptions$ManagerRef2) {
        boolean bl;
        altWaterQualityOptions$ManagerRef.d.getName();
        string = AltWaterQualityOptions.getRealName(altWaterQualityOptions$ManagerRef.b);
        String string2 = AltWaterQualityOptions.getRealName(altWaterQualityOptions$ManagerRef2.b);
        if (string != null && string.equals(string2)) {
            string2 = this.getManager(rssAlt2, altWaterQualityOptions$ManagerRef2.d, altWaterQualityOptions$ManagerRef2.a);
            string = rssAlt.getWaterQualityOptions().getManager(rssAlt, altWaterQualityOptions$ManagerRef);
            if (string == null) {
                logger.log(Level.WARNING, "Failed to find source WQ manager " + String.valueOf(altWaterQualityOptions$ManagerRef2) + " during refresh");
            }
            if (string2 != null) {
                bl = string2.refreshData((Manager)string);
                if (string2 instanceof ObsDatasetManager) {
                    ((ObsDatasetManager)((Object)string2)).updateElementNetworkIds(rssAlt2.getSystem(), rssAlt.getSystem());
                }
            } else {
                logger.log(Level.WARNING, "Failed to find dest WQ manager " + String.valueOf(altWaterQualityOptions$ManagerRef2) + " during refresh");
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private static String getPrefix(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(58);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return null;
    }

    private static String getRealName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(58);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    private static Manager createManager(ManagerProxyList managerProxyList, String string, String string2, String string3, String string4) {
        managerProxyList = managerProxyList.newManager("rss", string);
        managerProxyList.setName(string2);
        string = managerProxyList.getIdentifier();
        string.setName(string2);
        string.setDescription(string3);
        string.setPath(string4);
        managerProxyList.saveManager();
        return managerProxyList;
    }

    private static List<ManagerProxy> getManagerProxies(ManagerProxyList managerProxyList, String iterator) {
        ArrayList<ManagerProxy> arrayList = new ArrayList<ManagerProxy>();
        iterator = managerProxyList.getManagerIDList((String)((Object)iterator));
        iterator = ((Vector)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            Identifier identifier = (Identifier)iterator.next();
            identifier = managerProxyList.getManager(identifier);
            arrayList.add((ManagerProxy)identifier);
        }
        return arrayList;
    }

    public AltWaterQualityOptions saveManagersAs(RssAlt rssAlt, String string, String string2, ManagerProxyListContainer managerProxyListContainer, int n) {
        AltWaterQualityOptions altWaterQualityOptions = new AltWaterQualityOptions();
        WqGeometry wqGeometry = this.saveGeometryAs(rssAlt, RMAIO.concatPath((String)string, (String)"wq/geometry"), string2, managerProxyListContainer, n, this._geoRef.a, altWaterQualityOptions);
        JsonManager jsonManager = this.getGeometryManager(rssAlt);
        this.saveMetDataAs(rssAlt, RMAIO.concatPath((String)string, (String)"wq"), string2, managerProxyListContainer, wqGeometry, (WqGeometry)jsonManager, this._metDataRef.a, altWaterQualityOptions);
        jsonManager = this.saveConstituentSetAs(rssAlt, RMAIO.concatPath((String)string, (String)"wq/"), string2, managerProxyListContainer, this._constituentRef.a, altWaterQualityOptions);
        int n2 = -1;
        if (jsonManager != null) {
            n2 = jsonManager.getIndex();
        }
        int n3 = -1;
        if (wqGeometry != null) {
            n3 = wqGeometry.getIndex();
        }
        this.saveBoundaryConditionAs(rssAlt, RMAIO.concatPath((String)string, (String)"wq/"), string2, managerProxyListContainer, n3, n2, this._bcRef.a, altWaterQualityOptions);
        this.saveInitialConditionsAs(rssAlt, RMAIO.concatPath((String)string, (String)"wq/"), string2, managerProxyListContainer, n3, n2, this._icRef.a, altWaterQualityOptions);
        this.saveDispersionSetAs(rssAlt, RMAIO.concatPath((String)string, (String)"wq/"), string2, managerProxyListContainer, n3, this._dispCoefRef.a, altWaterQualityOptions);
        this.saveParameterSetAs(rssAlt, RMAIO.concatPath((String)string, (String)"wq/"), string2, managerProxyListContainer, n3, n2, this._paramsRef.a, altWaterQualityOptions);
        this.saveMassInjectionAs(rssAlt, RMAIO.concatPath((String)string, (String)"wq/"), string2, managerProxyListContainer, n3, n2, this._massInjectionRef.a, altWaterQualityOptions);
        this.saveObsDataAs(rssAlt, RMAIO.concatPath((String)string, (String)"wq/"), string2, managerProxyListContainer, this._obsDataRef.a, altWaterQualityOptions);
        altWaterQualityOptions._firstOrderSolution = this._firstOrderSolution;
        altWaterQualityOptions._numberThreads = this._numberThreads;
        altWaterQualityOptions._numOutputTimeSteps = this._numOutputTimeSteps;
        altWaterQualityOptions._preserveConcentration = this._preserveConcentration;
        altWaterQualityOptions._runWq = this._runWq;
        altWaterQualityOptions.getOutputVariableOptions().copyFrom(this._outputVaribleOpts);
        altWaterQualityOptions._coupledFlowWQCompute = this._coupledFlowWQCompute;
        altWaterQualityOptions._timeStep = this._timeStep;
        altWaterQualityOptions._timestepIncrement = this._timestepIncrement;
        return altWaterQualityOptions;
    }

    private ObsDatasetManager saveObsDataAs(RssAlt manager, String string, String string2, ManagerProxyListContainer managerProxyListContainer, int n, AltWaterQualityOptions altWaterQualityOptions) {
        if ((manager = (ObsDatasetManager)this.saveManagerAs((RssAlt)manager, string, string2, managerProxyListContainer, ObsDatasetManager.class.getName(), n)) != null) {
            altWaterQualityOptions.setObservedDataId(manager.getIndex());
            altWaterQualityOptions._obsDataRef.c = this._obsDataRef.a;
            altWaterQualityOptions.setObservedDataName(manager.getName());
            altWaterQualityOptions._obsDataSetMgr = manager;
        }
        return manager;
    }

    private MassInjectionSetManager saveMassInjectionAs(RssAlt manager, String string, String string2, ManagerProxyListContainer managerProxyListContainer, int n, int n2, int n3, AltWaterQualityOptions altWaterQualityOptions) {
        if ((manager = (MassInjectionSetManager)this.saveManagerAs((RssAlt)manager, string, string2, managerProxyListContainer, MassInjectionSetManager.class.getName(), n3)) != null) {
            altWaterQualityOptions.setMassInjectionId(manager.getIndex());
            altWaterQualityOptions._massInjectionRef.c = this._massInjectionRef.a;
            altWaterQualityOptions.setMassInjectionName(manager.getName());
            if (n != -1) {
                manager.setGeometryId(n);
                manager.setModified(true);
            }
            if (n2 != -1) {
                manager.setConstituentSetId(n2);
                manager.setModified(true);
            }
            if (manager.isModified()) {
                manager.getProxyList().saveManager(UserId.getUserId(), manager);
            }
        }
        return manager;
    }

    private ParameterSetManager saveParameterSetAs(RssAlt manager, String object, String object2, ManagerProxyListContainer managerProxyListContainer, int n, int n2, int n3, AltWaterQualityOptions altWaterQualityOptions) {
        if ((object = (ParameterSetManager)this.saveManagerAs((RssAlt)manager, (String)object, (String)object2, managerProxyListContainer, ParameterSetManager.class.getName(), n3)) != null) {
            altWaterQualityOptions.setParametersId(((JsonManager)((Object)object)).getIndex());
            altWaterQualityOptions._paramsRef.c = this._paramsRef.a;
            altWaterQualityOptions.setParametersName(((JsonManager)((Object)object)).getName());
            if (n2 != -1) {
                object2 = (ParameterSetManager)manager.getWaterQualityOptions().getManager((RssAlt)manager, ParameterSetManager.class, this._paramsRef.a);
                manager = (ConstituentSetManager)manager.getWaterQualityOptions().getManager((RssAlt)manager, ConstituentSetManager.class, this._constituentRef.a);
                if (object2 != null && manager != null) {
                    manager = ((ParameterSetManager)object2).getSet(manager.getIndex());
                    ((ParameterSetManager)object).clearSet();
                    ((ParameterSetManager)object).setSet(n2, (WQParameterSet)manager);
                }
            }
            if (n != -1) {
                ((ParameterSetManager)object).setGeometryId(n);
                object.setModified(true);
            }
            if (object.isModified()) {
                object.getProxyList().saveManager(UserId.getUserId(), (Manager)object);
            }
        } else {
            System.out.println("saveParameterSetAs:failed to create new ParameterSetManager " + this.getParametersName() + " for Alternative " + String.valueOf(manager));
        }
        return object;
    }

    private DispersionSetManager saveDispersionSetAs(RssAlt rssAlt, String object, String string, ManagerProxyListContainer managerProxyListContainer, int n, int n2, AltWaterQualityOptions altWaterQualityOptions) {
        if ((object = (DispersionSetManager)this.saveManagerAs(rssAlt, (String)object, string, managerProxyListContainer, DispersionSetManager.class.getName(), n2)) != null) {
            altWaterQualityOptions.setDispersionCoefId(((JsonManager)((Object)object)).getIndex());
            altWaterQualityOptions._dispCoefRef.c = this._dispCoefRef.a;
            altWaterQualityOptions.setDispersionCoefName(((JsonManager)((Object)object)).getName());
            if (n != -1) {
                ((DispersionSetManager)object).setGeometryId(n);
                object.setModified(true);
            }
            if (object.isModified()) {
                object.getProxyList().saveManager(UserId.getUserId(), (Manager)object);
            }
        } else {
            System.out.println("saveDispersionSetAs:failed to create new DispersionSetManager " + this.getDispersionCoefName() + " for Alternative " + String.valueOf(rssAlt));
        }
        return object;
    }

    private InitialConditionSetManager saveInitialConditionsAs(RssAlt rssAlt, String object, String string, ManagerProxyListContainer managerProxyListContainer, int n, int n2, int n3, AltWaterQualityOptions altWaterQualityOptions) {
        if ((object = (InitialConditionSetManager)this.saveManagerAs(rssAlt, (String)object, string, managerProxyListContainer, InitialConditionSetManager.class.getName(), n3)) != null) {
            altWaterQualityOptions.setIcId(((JsonManager)((Object)object)).getIndex());
            altWaterQualityOptions._icRef.c = this._icRef.a;
            altWaterQualityOptions.setIcName(((JsonManager)((Object)object)).getName());
            if (n != -1) {
                ((InitialConditionSetManager)object).setGeometryId(n);
                object.setModified(true);
            }
            if (n2 != -1) {
                ((InitialConditionSetManager)object).setConstituentSetId(n2);
                object.setModified(true);
            }
            if (object.isModified()) {
                object.getProxyList().saveManager(UserId.getUserId(), (Manager)object);
            }
        } else {
            System.out.println("saveInitialConditionsAs:failed to create new InitialConditionSetManager " + this.getIcName() + " for Alternative " + String.valueOf(rssAlt));
        }
        return object;
    }

    private BoundaryConditionSetManager saveBoundaryConditionAs(RssAlt rssAlt, String object, String string, ManagerProxyListContainer managerProxyListContainer, int n, int n2, int n3, AltWaterQualityOptions altWaterQualityOptions) {
        if ((object = (BoundaryConditionSetManager)this.saveManagerAs(rssAlt, (String)object, string, managerProxyListContainer, BoundaryConditionSetManager.class.getName(), n3)) != null) {
            altWaterQualityOptions.setBcId(((JsonManager)((Object)object)).getIndex());
            altWaterQualityOptions._bcRef.c = this._bcRef.a;
            altWaterQualityOptions.setBcName(((JsonManager)((Object)object)).getName());
            if (n != -1) {
                ((BoundaryConditionSetManager)object).setGeometryId(n);
                object.setModified(true);
            }
            if (n2 != -1) {
                ((BoundaryConditionSetManager)object).setConstituentSetId(n2);
                object.setModified(true);
            }
            if (object.isModified()) {
                object.getProxyList().saveManager(UserId.getUserId(), (Manager)object);
            }
        } else {
            System.out.println("saveBoundaryConditionAs:failed to create new BoundaryConditionSetManager " + this.getBcName() + " for Alternative " + String.valueOf(rssAlt));
        }
        return object;
    }

    private ConstituentSetManager saveConstituentSetAs(RssAlt rssAlt, String object, String string, ManagerProxyListContainer managerProxyListContainer, int n, AltWaterQualityOptions altWaterQualityOptions) {
        if ((object = (ConstituentSetManager)this.saveManagerAs(rssAlt, (String)object, string, managerProxyListContainer, ConstituentSetManager.class.getName(), n)) != null) {
            altWaterQualityOptions.setConstituentId(((JsonManager)((Object)object)).getIndex());
            altWaterQualityOptions._constituentRef.c = this._constituentRef.a;
            altWaterQualityOptions.setConstituentName(((JsonManager)((Object)object)).getName());
            if (object.isModified()) {
                object.getProxyList().saveManager(UserId.getUserId(), (Manager)object);
            }
        } else {
            System.out.println("saveConstituentSetAs:failed to create new ConstituentSetManager " + this.getConstituentName() + " for Alternative " + String.valueOf(rssAlt));
        }
        return object;
    }

    private MetData saveMetDataAs(RssAlt rssAlt, String object, String string, ManagerProxyListContainer managerProxyListContainer, WqGeometry wqGeometry, WqGeometry wqGeometry2, int n, AltWaterQualityOptions altWaterQualityOptions) {
        if ((object = (MetData)this.saveManagerAs(rssAlt, (String)object, string, managerProxyListContainer, MetData.class.getName(), n)) != null) {
            altWaterQualityOptions.setMetDataId(object.getIndex());
            altWaterQualityOptions._metDataRef.c = this._metDataRef.a;
            altWaterQualityOptions.setMetDataName(object.getName());
            this.updateMetDataAssignments((MetData)object, rssAlt, wqGeometry2, wqGeometry);
            if (object.isModified()) {
                object.getProxyList().saveManager(UserId.getUserId(), (Manager)object);
            }
        } else {
            System.out.println("saveMetDataAs:failed to create new MetData " + this.getMetDataName() + " for Alternative " + String.valueOf(rssAlt));
        }
        return object;
    }

    private void updateMetDataAssignments(MetData metData, RssAlt manager, WqGeometry object, WqGeometry wqGeometry) {
        if (wqGeometry != null) {
            RssWQGeometry rssWQGeometry = wqGeometry.getRssWqGeometry();
            if (rssWQGeometry != null) {
                Map map;
                rssWQGeometry = rssWQGeometry.getMetAssignmentSet();
                manager = manager.getWaterQualityOptions().getMetDataManager((RssAlt)manager);
                int n = manager.getIndex();
                object = object.getRssWqGeometry().getMetAssignmentSet();
                if ((object = object.getMetStationSetIds()).contains(n) && (map = rssWQGeometry.getMetStationMap(n)) != null) {
                    rssWQGeometry.setMetStationMap(metData.getIndex(), map);
                    wqGeometry.setModified(true);
                    wqGeometry.getProxyList().saveManager(UserId.getUserId(), (Manager)wqGeometry);
                }
                return;
            }
            System.out.println("updateMetDataAssignments:failed to get the RssWqGeometry from " + wqGeometry.getName() + " MetData Assignments not updated");
        }
    }

    private WqGeometry saveGeometryAs(RssAlt rssAlt, String string, String string2, ManagerProxyListContainer managerProxyListContainer, int n, int n2, AltWaterQualityOptions altWaterQualityOptions) {
        WqGeometry wqGeometry = (WqGeometry)this.saveManagerAs(rssAlt, string, string2, managerProxyListContainer, WqGeometry.class.getName(), n2);
        Object object = rssAlt.getWaterQualityOptions().getGeometryManager(rssAlt);
        if (wqGeometry != null) {
            if ((object = ((WqGeometry)((Object)object)).getSteadyFlowPath()) != null) {
                String string3 = RMAIO.getDirectoryFromPath((String)string);
                string3 = RMAIO.getDirectoryFromPath((String)string3);
                string3 = AltWaterQualityOptions.copyFile(object.toString(), string3, rssAlt.getFileManager());
                if (string3 != null) {
                    object = Paths.get(string3, new String[0]);
                }
            }
            wqGeometry.setSteadyFlowPath((Path)object);
            this.saveGeometryCrossSectionManager(string2, wqGeometry, rssAlt, string, managerProxyListContainer);
            altWaterQualityOptions.setGeometryId(wqGeometry.getIndex());
            altWaterQualityOptions.setGeometryName(wqGeometry.getName());
            altWaterQualityOptions._geoRef.c = this._geoRef.a;
            wqGeometry.setNetworkId(n);
            wqGeometry.getProxyList().saveManager(UserId.getUserId(), (Manager)wqGeometry);
        } else {
            System.out.println("saveGeometryAs:failed to create new WqGeometry " + this.getGeometryName() + " for Alternative " + String.valueOf(rssAlt));
        }
        return wqGeometry;
    }

    private void saveGeometryCrossSectionManager(String string, WqGeometry wqGeometry, RssAlt rssAlt, String string2, ManagerProxyListContainer managerProxyListContainer) {
        Object object = rssAlt.getWaterQualityOptions().getGeometryManager(rssAlt);
        int n = -1;
        CrossSectionManager crossSectionManager = null;
        CrossSectionManager crossSectionManager2 = null;
        if (object != null) {
            n = object.getCrossSectionManagerId();
            crossSectionManager2 = object.getCrossSectionManager();
            object = null;
            if (crossSectionManager2 != null) {
                object = crossSectionManager2.getName();
                if (string != null) {
                    object = string + ":" + (String)object;
                }
            }
            if (object != null) {
                crossSectionManager = (CrossSectionManager)this.findExistingManager(wqGeometry.getProxyList().getContainer(), (String)object, CrossSectionManager.class.getName());
            }
        }
        if (crossSectionManager == null) {
            crossSectionManager = (CrossSectionManager)this.saveManagerAs(rssAlt, string2, string, managerProxyListContainer, CrossSectionManager.class.getName(), n);
            if (crossSectionManager != null && crossSectionManager2 != null) {
                object = crossSectionManager2.getRasFile();
                if (object != null) {
                    string = RMAIO.getDirectoryFromPath((String)string2);
                    string = RMAIO.getDirectoryFromPath((String)string);
                    object = AltWaterQualityOptions.copyFile((String)object, string, rssAlt.getFileManager());
                }
                crossSectionManager.setRasFile((String)object);
                crossSectionManager.getProxyList().saveManager(UserId.getUserId(), (Manager)crossSectionManager);
            }
        } else {
            object = crossSectionManager2.getRasFile();
            if (object != null) {
                string = RMAIO.getDirectoryFromPath((String)string2);
                string = RMAIO.getDirectoryFromPath((String)string);
                object = AltWaterQualityOptions.copyFile((String)object, string, rssAlt.getFileManager());
            }
            crossSectionManager.setRasFile((String)object);
            crossSectionManager.getProxyList().saveManager(UserId.getUserId(), (Manager)crossSectionManager);
        }
        if (crossSectionManager == null) {
            System.out.println("saveGeometryAs:failed to copy Geometry's CrossSectionManager to Simulation");
            return;
        }
        wqGeometry.setCrossSectionManagerId(crossSectionManager.getIndex());
        wqGeometry.setModified(true);
    }

    private static String copyFile(String object, String string, RmiFileManager rmiFileManager) {
        List<String> list;
        if (((String)object).toLowerCase().endsWith(".shp")) {
            list = AltWaterQualityOptions.findMatchingFiles((String)object, rmiFileManager);
        } else {
            list = new ArrayList<String>();
            list.add((String)object);
        }
        object = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            Identifier identifier = new Identifier(string2);
            string2 = RMAIO.getFileFromPath((String)string2);
            String string3 = RMAIO.concatPath((String)string, (String)RAS_FOLDER);
            string2 = RMAIO.concatPath((String)string3, (String)string2);
            string2 = new Identifier(string2);
            try {
                if (rmiFileManager.copyFile(identifier, (Identifier)string2)) {
                    object.add(string2.getPath());
                    continue;
                }
                logger.severe("Failed to copy file from " + identifier.getPath() + " to " + string2.getPath());
                continue;
            }
            catch (RemoteException remoteException) {
                logger.severe("error copying file from " + identifier.getPath() + " to " + string2.getPath() + " error:" + String.valueOf(remoteException));
            }
        }
        if (object.size() > 0) {
            return (String)object.get(0);
        }
        return null;
    }

    private static List<String> findMatchingFiles(String stringArray, RmiFileManager rmiFileManager) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add((String)stringArray);
        String string = RMAIO.getDirectoryFromPath((String)stringArray);
        stringArray = RMAIO.getFileNameNoExtension((String)stringArray);
        stringArray = stringArray.concat(".*");
        try {
            stringArray = rmiFileManager.list(string, (String)stringArray);
        }
        catch (RemoteException remoteException) {
            logger.severe("Error getting file listing for " + string + " Error:" + String.valueOf(remoteException));
            return arrayList;
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(RMAIO.concatPath((String)string, (String)stringArray[i]));
            }
        }
        return arrayList;
    }

    private Manager findExistingManager(ManagerProxyListContainer object, String string, String string2) {
        object = object.getManagerProxyList("rss", string2);
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            string2 = (ManagerProxy)((Vector)object).get(i);
            if (string2 == null || !string.equals(string2.getName())) continue;
            return string2.loadManager(null, null);
        }
        return null;
    }

    private Manager saveManagerAs(RssAlt rssAlt, String string, String string2, ManagerProxyListContainer managerProxyListContainer, String string3, int n) {
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((rssAlt = rssAlt.getProxyList().getManagerProxy(string3, n)) != null && (rssAlt = rssAlt.loadManager(null, null)) != null) {
            if ((rssAlt = rssAlt.saveManagerAs(string, string2, managerProxyListContainer)) != null) {
                managerProxyListContainer.setModified(true);
            }
            return rssAlt;
        }
        return null;
    }

    public List<WQTSDataProvider> getWQTSDataProviders(RssAlt rssAlt) {
        ArrayList<WQTSDataProvider> arrayList = new ArrayList<WQTSDataProvider>();
        for (AltWaterQualityOptions$ManagerRef<? extends Manager> altWaterQualityOptions$ManagerRef : this._managerRefs) {
            Manager manager = this.getManager(rssAlt, altWaterQualityOptions$ManagerRef);
            if (!(manager instanceof WQTSDataProvider)) continue;
            arrayList.add((WQTSDataProvider)manager);
        }
        return arrayList;
    }

    public BoundaryConditionSetManager getBcManager(RssAlt rssAlt) {
        return (BoundaryConditionSetManager)this.getManager(rssAlt, BoundaryConditionSetManager.class, this._bcRef.a);
    }

    public WqGeometry getGeometryManager(RssAlt rssAlt) {
        return (WqGeometry)this.getManager(rssAlt, WqGeometry.class, this._geoRef.a);
    }

    public MetData getMetDataManager(RssAlt rssAlt) {
        return (MetData)this.getManager(rssAlt, MetData.class, this._metDataRef.a);
    }

    public MassInjectionSetManager getMassInjectionSetManager(RssAlt rssAlt) {
        return (MassInjectionSetManager)this.getManager(rssAlt, MassInjectionSetManager.class, this._massInjectionRef.a);
    }

    public ObsDatasetManager getObservedDataSetManager(RssAlt rssAlt) {
        return (ObsDatasetManager)this.getManager(rssAlt, ObsDatasetManager.class, this._obsDataRef.a);
    }

    private <T extends Manager> Manager getManager(RssAlt rssAlt, Class<T> clazz, int n) {
        if ((rssAlt = rssAlt.getProxyList().getManagerProxy(clazz.getName(), n)) != null) {
            rssAlt = rssAlt.loadManager(null, null);
            return rssAlt;
        }
        return null;
    }

    private Manager getManager(RssAlt rssAlt, AltWaterQualityOptions$ManagerRef altWaterQualityOptions$ManagerRef) {
        return this.getManager(rssAlt, altWaterQualityOptions$ManagerRef.d, altWaterQualityOptions$ManagerRef.a);
    }

    public int getNumberThreads() {
        return this._numberThreads;
    }

    public void setNumberThreads(int n) {
        this._numberThreads = n;
    }

    public int getNumberOutputTimeSteps() {
        return this._numOutputTimeSteps;
    }

    public void setNumberOutputTimeSteps(int n) {
        this._numOutputTimeSteps = n;
    }

    public boolean getPreserveConcentration() {
        return this._preserveConcentration;
    }

    public void setPreserveConcentration(boolean bl) {
        this._preserveConcentration = bl;
    }

    public boolean getFirstOrderSolution() {
        return this._firstOrderSolution;
    }

    public void setFirstOrderSolution(boolean bl) {
        this._firstOrderSolution = bl;
    }

    public OutputVariableOptions getOutputVariableOptions() {
        return this._outputVaribleOpts;
    }

    public boolean getCoupledFlowWQCompute() {
        return this._coupledFlowWQCompute;
    }

    public void setCoupledFlowWQCompute(boolean bl) {
        this._coupledFlowWQCompute = bl;
    }

    public void updateObsStationNetworkElements(RssSystem rssSystem, RssSystem rssSystem2) {
        if (this._obsDataSetMgr != null && rssSystem != null && rssSystem2 != null) {
            this._obsDataSetMgr.updateElementNetworkIds(rssSystem, rssSystem2);
        }
    }

    public boolean deleteManagers(RssAlt rssAlt) {
        ManagerProxyListContainer managerProxyListContainer = rssAlt.getProxyList().getContainer();
        if (!(managerProxyListContainer instanceof SimulationPeriod)) {
            return false;
        }
        managerProxyListContainer = (SimulationPeriod)managerProxyListContainer;
        AltWaterQualityOptions altWaterQualityOptions = this;
        boolean bl = true & altWaterQualityOptions.deleteManager(altWaterQualityOptions._constituentRef, (SimulationPeriod)managerProxyListContainer, rssAlt);
        AltWaterQualityOptions altWaterQualityOptions2 = this;
        bl &= altWaterQualityOptions2.deleteManager(altWaterQualityOptions2._obsDataRef, (SimulationPeriod)managerProxyListContainer, rssAlt);
        AltWaterQualityOptions altWaterQualityOptions3 = this;
        bl &= altWaterQualityOptions3.deleteManager(altWaterQualityOptions3._metDataRef, (SimulationPeriod)managerProxyListContainer, rssAlt);
        AltWaterQualityOptions altWaterQualityOptions4 = this;
        bl &= altWaterQualityOptions4.deleteManager(altWaterQualityOptions4._massInjectionRef, (SimulationPeriod)managerProxyListContainer, rssAlt);
        AltWaterQualityOptions altWaterQualityOptions5 = this;
        bl &= altWaterQualityOptions5.deleteManager(altWaterQualityOptions5._dispCoefRef, (SimulationPeriod)managerProxyListContainer, rssAlt);
        AltWaterQualityOptions altWaterQualityOptions6 = this;
        bl &= altWaterQualityOptions6.deleteManager(altWaterQualityOptions6._paramsRef, (SimulationPeriod)managerProxyListContainer, rssAlt);
        AltWaterQualityOptions altWaterQualityOptions7 = this;
        bl &= altWaterQualityOptions7.deleteManager(altWaterQualityOptions7._geoRef, (SimulationPeriod)managerProxyListContainer, rssAlt);
        AltWaterQualityOptions altWaterQualityOptions8 = this;
        bl &= altWaterQualityOptions8.deleteManager(altWaterQualityOptions8._icRef, (SimulationPeriod)managerProxyListContainer, rssAlt);
        AltWaterQualityOptions altWaterQualityOptions9 = this;
        return bl &= altWaterQualityOptions9.deleteManager(altWaterQualityOptions9._bcRef, (SimulationPeriod)managerProxyListContainer, rssAlt);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean deleteManager(AltWaterQualityOptions$ManagerRef<?> altWaterQualityOptions$ManagerRef, SimulationPeriod simulationPeriod, RssAlt rssAlt) {
        if (altWaterQualityOptions$ManagerRef == null) return false;
        if (altWaterQualityOptions$ManagerRef.a == -1) return false;
        try {
            Manager manager = this.getManager(rssAlt, altWaterQualityOptions$ManagerRef);
            if (manager == null) {
                logger.warning("Failed to find for deletion WQ manager " + String.valueOf(altWaterQualityOptions$ManagerRef) + " in Alternative " + String.valueOf(rssAlt) + " for simulation " + String.valueOf(simulationPeriod));
                return false;
            }
            if (!simulationPeriod.deleteManager("rss", manager.getIdentifier(), true)) {
                logger.warning("Failed to delete WQ manager " + String.valueOf(altWaterQualityOptions$ManagerRef) + " in Alternative " + String.valueOf(rssAlt) + " for simulation " + String.valueOf(simulationPeriod));
                return false;
            }
            altWaterQualityOptions$ManagerRef.a = -1;
            return true;
        }
        catch (Exception exception) {
            logger.warning("Exception " + String.valueOf(exception) + " during deletion of " + String.valueOf(altWaterQualityOptions$ManagerRef) + " in Alternative " + String.valueOf(rssAlt) + " for simulation " + String.valueOf(simulationPeriod));
        }
        return false;
    }

    public void setTimestep(int n) {
        this._timeStep = n;
    }

    public void setTimestepIncrement(int n) {
        this._timestepIncrement = n;
    }

    public int getTimestep() {
        return this._timeStep;
    }

    public int getTimestepIncrement() {
        return this._timestepIncrement;
    }

    public int getTimestepMinutes() {
        if (this._timeStep >= 0 && this._timestepIncrement >= 0) {
            RunTimeWindow runTimeWindow = new RunTimeWindow();
            runTimeWindow.setTimeStep(this._timeStep, this._timestepIncrement);
            return runTimeWindow.getTimeStepMinutes();
        }
        return -1;
    }
}

