/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.heclib.dss.DSSPathname;
import hec.io.Identifier;
import hec.rss.wq.model.ConstituentManager;
import hec.rss.wq.model.ConstituentSetManager;
import hec.rss.wq.model.GeometryManager;
import hec.rss.wq.model.JsonManager;
import hec.rss.wq.model.WQTSDataProvider;
import hec.rss.wq.model.WqGeometry;
import hec.wqenginecore.BoundaryCondition;
import hec.wqenginecore.BoundaryConditionSet;
import hec.wqenginecore.dataSource.ambient.AmbientData;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.geometry.SubDomainBoundaryRef;
import hec.wqengineimpl.boundaryconditions.WQBoundaryConditionSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class BoundaryConditionSetManager
extends JsonManager
implements ConstituentManager,
GeometryManager,
WQTSDataProvider {
    public static final String EXT = ".boundaryCondSet";
    public static final String SUBDIR = "wq/";
    @JsonProperty
    private int _version = -1;
    @JsonProperty
    @JsonDeserialize(as=WQBoundaryConditionSet.class)
    @JsonSerialize(as=WQBoundaryConditionSet.class)
    private BoundaryConditionSet _set;
    @JsonProperty
    private int _geometryId;
    @JsonProperty
    private int _constituentSetId;

    public BoundaryConditionSetManager() {
    }

    public BoundaryConditionSetManager(BoundaryConditionSet boundaryConditionSet) {
        super(boundaryConditionSet.getName());
        this._set = boundaryConditionSet;
    }

    @Override
    public boolean readFile(Identifier identifier) {
        boolean bl = super.readFile(identifier);
        if (bl) {
            Object object = this._set.getBoundaryConditions();
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (BoundaryCondition)object.next();
                if ((object2 = object2.getDataSources()).stream().anyMatch(data -> data instanceof AmbientData)) continue;
                object2.add(new AmbientData());
            }
        }
        return bl;
    }

    public BoundaryConditionSet getSet() {
        return this._set;
    }

    public void setSet(BoundaryConditionSet boundaryConditionSet) {
        this._set = boundaryConditionSet;
    }

    @Override
    @JsonProperty
    public String getName() {
        String string = "";
        if (this._set != null) {
            string = this._set.getName();
        }
        return string;
    }

    @Override
    @JsonProperty
    public String getDescription() {
        String string = "";
        if (this._set != null) {
            string = this._set.getDescription();
        }
        return string;
    }

    public void setDescription(String string) {
        super.setDescription(string);
        if (this._set instanceof WQBoundaryConditionSet) {
            WQBoundaryConditionSet wQBoundaryConditionSet = (WQBoundaryConditionSet)this._set;
            wQBoundaryConditionSet.setDescription(string);
        }
    }

    public void setName(String string) {
        super.setName(string);
        if (this._set instanceof WQBoundaryConditionSet) {
            WQBoundaryConditionSet wQBoundaryConditionSet = (WQBoundaryConditionSet)this._set;
            wQBoundaryConditionSet.setName(string);
        }
    }

    @Override
    public void setGeometryId(int n) {
        this._geometryId = n;
    }

    @Override
    public int getGeometryId() {
        return this._geometryId;
    }

    @Override
    public WqGeometry getGeometry() {
        ManagerProxy managerProxy = this._proxyList.getManagerProxy(WqGeometry.class.getName(), this._geometryId);
        if (managerProxy != null) {
            return (WqGeometry)managerProxy.loadManager(null, null);
        }
        return null;
    }

    @Override
    public void setConstituentSetId(int n) {
        this._constituentSetId = n;
    }

    @Override
    public int getConstituentSetId() {
        return this._constituentSetId;
    }

    @Override
    public ConstituentSetManager getConstituentSet() {
        ManagerProxy managerProxy = this._proxyList.getManagerProxy(ConstituentSetManager.class.getName(), this._constituentSetId);
        if (managerProxy != null) {
            return (ConstituentSetManager)managerProxy.loadManager(null, null);
        }
        return null;
    }

    @Override
    protected void updateToCurrentVersion() {
        this._version = 1;
    }

    @Override
    public List<TSRecordProxy> getActiveTSRecordProxies(TSDataSet tSDataSet) {
        ArrayList<TSRecordProxy> arrayList = new ArrayList<TSRecordProxy>();
        Collection collection = this._set.getBoundaryConditions();
        Iterator iterator = collection.iterator();
        ConstituentSetManager constituentSetManager = this.getConstituentSet();
        while (iterator.hasNext()) {
            BoundaryCondition boundaryCondition = (BoundaryCondition)iterator.next();
            collection = boundaryCondition.getBoundaryRef();
            Object object = this.getGeometry().getRssWqGeometry().getBoundary((SubDomainBoundaryRef)collection);
            if (!object.getInExtent() || (collection = boundaryCondition.getSelectedDataSource()) == null || !"DSSData".equals(collection.getType())) continue;
            DssData dssData = (DssData)collection;
            collection = new TSRecordProxy();
            collection.setInput(true);
            collection.setDescription("SubDomainBoundary:" + object.getName() + ", BoundaryConditionSetManager:" + ((JsonManager)this).getName());
            collection.setDSSPathname(dssData.getDssPath());
            collection.setDSSFilename(dssData.getDssFilePath());
            collection.setIndex(object.getId());
            collection.setName(object.getName());
            object = new DSSPathname(dssData.getDssPath());
            collection.setTSDataSet(tSDataSet);
            if (constituentSetManager != null) {
                boundaryCondition = constituentSetManager.getSet().getConstituent(Integer.valueOf(boundaryCondition.getConstituentId()));
                if (boundaryCondition != null) {
                    object = boundaryCondition.getDisplayName();
                    collection.setParamName((String)object);
                    object = boundaryCondition.getUnit();
                    collection.setUnits((String)object);
                    collection.setVariableId(2000 + boundaryCondition.getId());
                } else {
                    collection.setParamName(object.getCPart());
                }
            } else {
                collection.setParamName(object.getCPart());
            }
            arrayList.add((TSRecordProxy)collection);
        }
        return arrayList;
    }

    @Override
    protected boolean alwaysRelativeToBase() {
        return true;
    }
}

