/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.model;

import hec.data.TimeWindow;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DssDataType;
import hec.heclib.dss.HecDataManager;
import hec.heclib.dss.HecTimeSeriesBase;
import hec.heclib.util.HecTime;
import hec.hecmath.HecMath;
import hec.hecmath.HecMathException;
import hec.hecmath.TimeSeriesMath;
import hec.io.DSSIdentifier;
import hec.io.DataContainer;
import hec.io.TimeSeriesContainer;
import hec.model.RunTimeWindow;
import hec.rss.wq.model.CloudinessComputeException;
import hec.rss.wq.model.SolarRadiationComputeException;
import hec.rss.wq.model.SolarRadiationUtils;
import hec.wqenginecore.WQEngineAdapter;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.latlong.LatLongData;
import hec.wqenginecore.dataSource.obs.ObservedData;
import hec.wqenginecore.metstation.MetStation;
import hec.wqengineimpl.metstation.WQMetStation;
import hec.wqengineimpl.metstation.variable.Cloudiness;
import hec.wqengineimpl.metstation.variable.ShortWaveRadiation;
import java.io.FileNotFoundException;
import java.rmi.RemoteException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import mil.army.usace.hec.metadata.IntervalFactory;
import mil.army.usace.hec.metadata.UnitsConversionException;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import rma.util.RMAConst;

public final class CloudinessUtils {
    private static final String a = IntervalFactory.regular1Hour().getInterval();
    public static final String DSS_OUTPUT_INTERVAL = IntervalFactory.regular1Hour().getInterval();
    public static final double DAYTIME_SOLAR_RAD_THRESHOLD = 10.0;

    private CloudinessUtils() {
        throw new AssertionError((Object)"CloudinessUtils is a utility class that cannot be instantiated");
    }

    public static TimeSeriesContainer a(RunTimeWindow object, Cloudiness cloudiness, WQMetStation wQMetStation, DSSIdentifier dSSIdentifier, DSSManager dSSManager, String string) throws CloudinessComputeException {
        Instant instant = null;
        if ((cloudiness = cloudiness.getSelectedData()) instanceof ObservedData) {
            cloudiness = (ObservedData)cloudiness;
            instant = object.getStartTime().getInstant(ZoneId.of("UTC"));
            object = object.getEndTime().getInstant(ZoneId.of("UTC"));
            TimeWindow timeWindow = new TimeWindow(Date.from(instant), true, Date.from((Instant)object), true);
            DSSIdentifier dSSIdentifier2 = new DSSIdentifier();
            dSSIdentifier2.setFileName(cloudiness.getDssFilePath());
            dSSIdentifier2.setDSSPath(cloudiness.getDssPath());
            dSSIdentifier2.setTimeWindow(HecTime.fromInstant((Instant)instant, (ZoneId)ZoneId.systemDefault()), HecTime.fromInstant((Instant)object, (ZoneId)ZoneId.systemDefault()));
            try {
                object = dSSManager.readTS(dSSIdentifier2, false);
                cloudiness = CloudinessUtils.a((MetStation)wQMetStation);
                instant = CloudinessUtils.a(timeWindow, (TimeSeriesContainer)object, (LatLongData)cloudiness, string, dSSIdentifier, dSSManager);
            }
            catch (HecMathException | SolarRadiationComputeException | FileNotFoundException | RemoteException | UnitsConversionException throwable) {
                throw new CloudinessComputeException((Exception)throwable);
            }
        }
        return instant;
    }

    public static LatLongData a(MetStation metStation) {
        List list = metStation.getVariables();
        if (list == null) {
            return null;
        }
        list = list.stream().filter(metVariable -> metVariable instanceof ShortWaveRadiation).findFirst().orElse(null);
        LatLongData latLongData = null;
        if (list != null && (list = (Data)list.getDataSources().stream().filter(data -> data instanceof LatLongData).findFirst().orElse(null)) instanceof LatLongData) {
            latLongData = (LatLongData)list;
        }
        if (latLongData == null) {
            latLongData = LatLongData.createLatLongData((MetStation)metStation);
        }
        return latLongData;
    }

    public static TimeSeriesContainer a(TimeWindow timeWindow, TimeSeriesContainer timeSeriesContainer, LatLongData latLongData, String string) throws CloudinessComputeException {
        try {
            return CloudinessUtils.a(timeWindow, timeSeriesContainer, latLongData, string, null, null);
        }
        catch (HecMathException | SolarRadiationComputeException | RemoteException | UnitsConversionException throwable) {
            throw new CloudinessComputeException((Exception)throwable);
        }
    }

    private static TimeSeriesContainer a(TimeWindow timeWindow, TimeSeriesContainer timeSeriesContainer, LatLongData object, String string, DSSIdentifier dSSIdentifier, DSSManager dSSManager) throws HecMathException, RemoteException, UnitsConversionException, CloudinessComputeException, SolarRadiationComputeException {
        TimeSeriesContainer timeSeriesContainer2 = new TimeSeriesContainer();
        object = SolarRadiationUtils.a(timeWindow, (Double)object.getDustCoefficient(), ShortWaveRadiation.getDefaultComputedUnits(), object, null, null);
        if (timeSeriesContainer.numberValues == 0 || object.numberValues == 0) {
            return timeSeriesContainer2;
        }
        Object object2 = timeWindow.getStartDate().getTimezoneOffset() + "M";
        Object object3 = CloudinessUtils.a((TimeSeriesContainer)object, a, (String)object2);
        timeSeriesContainer = CloudinessUtils.a(timeSeriesContainer, a, (String)object2);
        object3 = CloudinessUtils.a((TimeSeriesContainer)object3, timeWindow);
        timeSeriesContainer = CloudinessUtils.a(timeSeriesContainer, timeWindow);
        timeSeriesContainer2.type = DssDataType.PER_AVER.toString();
        int n = CloudinessUtils.a(timeWindow.getStartDate(), timeWindow.getEndDate());
        timeSeriesContainer2.values = new double[n + 1];
        Arrays.fill(timeSeriesContainer2.values, -3.4028234663852886E38);
        timeSeriesContainer2.times = new int[n + 1];
        timeSeriesContainer2.parameter = object.parameter;
        timeSeriesContainer2.units = Cloudiness.getDefaultUnits();
        timeSeriesContainer2.numberValues = timeSeriesContainer2.values.length;
        object = ((TimeSeriesContainer)object3).values;
        object2 = timeSeriesContainer.values;
        object3 = new ArrayList();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n2 = 1;
        HecTime hecTime = new HecTime();
        hecTime.set(timeSeriesContainer.times[0]);
        timeSeriesContainer2.times[0] = (int)hecTime.getMinutes();
        timeSeriesContainer2.values[0] = 0.0;
        ZoneId zoneId = ZoneId.of("UTC");
        int n3 = hecTime.getLocalDateTime().getDayOfMonth();
        for (int i = 0; i < ((Object)object2).length; ++i) {
            hecTime.set(timeSeriesContainer.times[i]);
            int n4 = hecTime.getLocalDateTime().getDayOfMonth();
            if (n4 == n3 && i != ((Object)object2).length - 1) {
                object3.add((double)object[i]);
                arrayList.add((double)object2[i]);
                continue;
            }
            if (n2 >= n) continue;
            if (i == ((Object)object2).length - 1) {
                object3.add((double)object[i]);
                arrayList.add((double)object2[i]);
                Instant instant = hecTime.getInstant(zoneId);
                instant = instant.atZone(zoneId).toLocalDate().atStartOfDay(zoneId).toInstant().plus(Duration.ofDays(1L));
                hecTime.set(HecTime.fromInstant((Instant)instant, (ZoneId)zoneId));
            }
            timeSeriesContainer2.times[n2] = (int)hecTime.getMinutes();
            double[] dArray = object3.stream().mapToDouble(Double::doubleValue).toArray();
            double[] dArray2 = arrayList.stream().mapToDouble(Double::doubleValue).toArray();
            timeSeriesContainer2.values[n2] = CloudinessUtils.a(dArray, dArray2);
            ++n2;
            n3 = n4;
            object3.clear();
            arrayList.clear();
            object3.add((double)object[i]);
            arrayList.add((double)object2[i]);
        }
        timeSeriesContainer2.removeAllMissing();
        if (timeSeriesContainer2.numberValues > 0) {
            HecTime hecTime2 = new HecTime(timeSeriesContainer2.times[1], 11);
            Instant instant = hecTime2.getInstant(zoneId);
            instant = instant.atZone(zoneId).toLocalDate().atStartOfDay(zoneId).toInstant().minus(Duration.ofDays(1L));
            hecTime2.set(HecTime.fromInstant((Instant)instant, (ZoneId)zoneId));
            timeSeriesContainer2.setStartTime(hecTime2);
            HecTime hecTime3 = new HecTime();
            hecTime3.set(timeSeriesContainer2.times[timeSeriesContainer2.times.length - 1]);
            timeSeriesContainer2.setEndTime(hecTime3);
            timeSeriesContainer2.times[0] = (int)hecTime2.getMinutes();
            timeSeriesContainer2.values[0] = timeSeriesContainer2.values[1];
        }
        TimeSeriesContainer timeSeriesContainer3 = CloudinessUtils.a(timeSeriesContainer2, string);
        CloudinessUtils.a(timeSeriesContainer3, dSSIdentifier, dSSManager);
        return timeSeriesContainer3;
    }

    private static void a(TimeSeriesContainer timeSeriesContainer, DSSIdentifier dSSIdentifier, DSSManager dSSManager) throws RemoteException, CloudinessComputeException {
        if (dSSIdentifier != null && dSSManager != null) {
            timeSeriesContainer.fullName = dSSIdentifier.getDSSPath();
            timeSeriesContainer.fileName = dSSIdentifier.getFileName();
            DSSPathname dSSPathname = new DSSPathname(timeSeriesContainer.fullName);
            int[] nArray = new int[1];
            int n = HecDataManager.getDssFileVersion((String)dSSIdentifier.getFileName());
            int n2 = timeSeriesContainer.interval;
            if (n == 7) {
                n2 = timeSeriesContainer.interval * 60;
            }
            dSSPathname.setEPart(DSSPathname.getRegularTsEPartFromInterval((int)n, (int)n2, (int[])nArray));
            if (nArray[0] != 0) {
                throw new CloudinessComputeException("Failed to get pathname interval (e-part) for  " + timeSeriesContainer.interval + " for timeseries: " + String.valueOf(timeSeriesContainer));
            }
            timeSeriesContainer.fullName = dSSPathname.getPathname();
            n = dSSManager.write((DataContainer)timeSeriesContainer);
            if (n != 0) {
                throw new CloudinessComputeException("Failed to write Cloudiness TimeSeries " + String.valueOf(timeSeriesContainer) + " return:" + n);
            }
        }
    }

    private static double a(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Hourly LatLong and Hourly Observed SW Radiation Arrays must be of equal length");
        }
        double d = 0.0;
        double d2 = 0.0;
        int n = dArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!RMAConst.isValidValue((double)dArray[i]) || !RMAConst.isValidValue((double)dArray2[i]) || !(dArray[i] > 10.0)) continue;
            d += dArray[i];
            d2 += dArray2[i];
            ++n2;
        }
        if (n2 == 0) {
            return 0.5;
        }
        double d3 = d2 / d;
        return CloudinessUtils.a(d3);
    }

    private static double a(double d) {
        double d2 = 0.0;
        if (d < 1.0) {
            double d3;
            d2 = Math.sqrt((1.0 - d) / 0.65);
            if (d3 > 1.0) {
                d2 = 1.0;
            }
        }
        return d2;
    }

    private static TimeSeriesContainer a(TimeSeriesContainer timeSeriesContainer, TimeWindow timeWindow) {
        HecTime hecTime = new HecTime(timeWindow.getStartDate(), 0);
        timeWindow = new HecTime(timeWindow.getEndDate(), 0);
        timeSeriesContainer.trimToTime(hecTime, (HecTime)timeWindow);
        return timeSeriesContainer;
    }

    private static TimeSeriesContainer a(TimeSeriesContainer timeSeriesContainer, String string, String string2) throws HecMathException, UnitsConversionException {
        timeSeriesContainer = (TimeSeriesContainer)timeSeriesContainer.clone();
        v0.type = DssDataType.PER_AVER.toString();
        TimeSeriesMath timeSeriesMath = new TimeSeriesMath(timeSeriesContainer);
        int n = HecTimeSeriesBase.getIntervalFromEPart((String)string);
        HecMath hecMath = timeSeriesMath.interpolateDataAtRegularInterval(n + "M", string2);
        if (hecMath != null) {
            timeSeriesContainer = (TimeSeriesContainer)hecMath.getData();
        }
        TimeSeriesContainer timeSeriesContainer2 = timeSeriesContainer;
        timeSeriesContainer2.setValues(WQEngineAdapter.convertSWRad((double[])timeSeriesContainer2.values, (String)timeSeriesContainer.units));
        return timeSeriesContainer;
    }

    public static TimeSeriesContainer a(TimeSeriesContainer timeSeriesContainer, String string) throws HecMathException, UnitsConversionException {
        return CloudinessUtils.a(timeSeriesContainer, string, "0M");
    }

    private static int a(Date comparable, Date comparable2) {
        comparable = ((Date)comparable).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        comparable2 = ((Date)comparable2).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return (int)Duration.between(((LocalDate)comparable).atStartOfDay(), ((LocalDate)comparable2).atStartOfDay()).toDays() + 1;
    }
}

