/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import hec.clientapp.model.ManagerProxyList;
import hec.io.Identifier;
import hec.rss.wq.model.JsonManager;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.ConstituentSet;
import hec.wqengineimpl.WQConstituentSet;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConstituentSetManager
extends JsonManager {
    public static final int CURRENT_VERSION = 1;
    public static final Logger logger = Logger.getLogger(ConstituentSetManager.class.getName());
    public static final String EXT = ".constituentSet";
    public static final String SUBDIR = "wq/";
    @JsonProperty
    private int _version = -1;
    @JsonProperty
    @JsonDeserialize(as=WQConstituentSet.class)
    @JsonSerialize(as=WQConstituentSet.class)
    private ConstituentSet _set;

    public ConstituentSetManager() {
    }

    public ConstituentSetManager(ConstituentSet constituentSet) {
        super(constituentSet.getName());
        this._set = constituentSet;
    }

    public ConstituentSet getSet() {
        return this._set;
    }

    public void setSet(ConstituentSet constituentSet) {
        this._set = constituentSet;
        if (this._set != null) {
            ConstituentSetManager constituentSetManager = this;
            constituentSetManager.setName(constituentSetManager._set.getName());
            ConstituentSetManager constituentSetManager2 = this;
            constituentSetManager2.setDescription(constituentSetManager2._set.getDescription());
            return;
        }
        this.setName("");
        this.setDescription("");
    }

    @Override
    @JsonProperty
    public String getName() {
        String string = "";
        if (this._set != null) {
            string = this._set.getName();
        }
        return string;
    }

    @Override
    @JsonProperty
    public String getDescription() {
        String string = "";
        if (this._set != null) {
            string = this._set.getDescription();
        }
        return string;
    }

    public void setDescription(String string) {
        super.setDescription(string);
        if (this._set instanceof WQConstituentSet) {
            string = (WQConstituentSet)this._set;
            string.setDescription(super.getDescription());
        }
    }

    public void setName(String string) {
        super.setName(string);
        if (this._set instanceof WQConstituentSet) {
            string = (WQConstituentSet)this._set;
            string.setName(super.getName());
        }
    }

    @Override
    protected void updateToCurrentVersion() {
        this._version = 1;
    }

    public List<ConstituentSet> loadAllSets() {
        return ConstituentSetManager.a(this._proxyList);
    }

    public static List<ConstituentSet> a(ManagerProxyList managerProxyList) {
        ArrayList<ConstituentSet> arrayList = new ArrayList<ConstituentSet>();
        Object object = managerProxyList.getManagerIDList(ConstituentSetManager.class.getName());
        object = ((Vector)object).iterator();
        while (object.hasNext()) {
            Object object2 = (Identifier)object.next();
            try {
                object2 = managerProxyList.loadManager(ConstituentSetManager.class.getName(), object2);
                if (!(object2 instanceof ConstituentSetManager)) continue;
                object2 = (ConstituentSetManager)((Object)object2);
                object2 = object2.getSet();
                arrayList.add((ConstituentSet)object2);
            }
            catch (RemoteException remoteException) {
                logger.log(Level.WARNING, "Unexpected Exception", remoteException);
            }
        }
        return arrayList;
    }

    public static List<Constituent> a(List<ConstituentSet> list) {
        ArrayList<Constituent> arrayList = new ArrayList<Constituent>();
        if (list != null && !list.isEmpty()) {
            HashSet hashSet = new HashSet();
            HashSet hashSet2 = new HashSet();
            list.stream().filter(Objects::nonNull).map(ConstituentSet::getConstituentList).flatMap(collection -> collection.stream()).filter(Objects::nonNull).forEach(constituent -> {
                if (ConstituentSetManager.a(constituent)) {
                    String string = constituent.getName();
                    if (!hashSet.contains(string)) {
                        hashSet.add(string);
                        arrayList.add((Constituent)constituent);
                    }
                    return;
                }
                int n = constituent.getId();
                if (!hashSet2.contains(n)) {
                    hashSet2.add(n);
                    arrayList.add((Constituent)constituent);
                }
            });
        }
        return arrayList;
    }

    public static boolean a(Constituent constituent) {
        boolean bl = false;
        if (constituent != null) {
            bl = constituent.getLibraryName().startsWith("General Constituent");
        }
        return bl;
    }
}

