/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.model;

import hec.appInterface.FileOpener;
import hec.clientapp.client.ClientApp;
import hec.clientapp.model.Manager;
import hec.io.Identifier;
import hec.io.SimpleFileOpenerImpl;
import hec.lang.UserId;
import hec.map.MapIdentifier;
import hec.map.MapObjectFactory;
import hec.map.MapObjectInterface;
import hec.map.WorldRect;
import hec.map.aishape.AiShapeMap;
import hec.map.crs.CoordinateReferenceSystem;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.util.RMAIO;

public class CrossSectionManager
extends Manager
implements MapObjectInterface {
    public static final String FILE_EXT = ".crossSections";
    private String _rasFile;
    private String _riverColumnName;
    private String _reachColumnName;
    private String _stationColumnName;
    private AiShapeMap _map;
    private MapIdentifier _mapId;

    public void init() {
    }

    public boolean readFile(Identifier identifier) {
        Object object = identifier.getFile();
        System.out.println("opening " + object.getPath());
        try {
            BufferedReader bufferedReader = object.getBufferedReader();
            while ((object = bufferedReader.readLine()) != null) {
                String string = RMAIO.getType((String)object, (String)"=");
                object = RMAIO.getParam((String)object, (String)"=");
                if ("Name".equals(string)) {
                    this.setName((String)object);
                    continue;
                }
                if ("Description".equals(string)) {
                    this.setDescription((String)object);
                    continue;
                }
                if ("RasFile".equals(string)) {
                    CrossSectionManager crossSectionManager = this;
                    crossSectionManager.setRasFile(crossSectionManager.makeAbsolutePath((String)object));
                    continue;
                }
                if ("RiverColumn".equals(string)) {
                    this.setRiverColumn((String)object);
                    continue;
                }
                if ("ReachColumn".equals(string)) {
                    this.setReachColumn((String)object);
                    continue;
                }
                if (!"StationColumn".equals(string)) continue;
                this.setStationColumn((String)object);
            }
        }
        catch (IOException iOException) {
            this.printErrorMessage("Failed to read file " + identifier.getPath());
            return false;
        }
        this.setModified(false);
        return true;
    }

    public void setRiverColumn(String string) {
        this._riverColumnName = string;
    }

    public String getRiverColumn() {
        return this._riverColumnName;
    }

    public void setReachColumn(String string) {
        this._reachColumnName = string;
    }

    public String getReachColumn() {
        return this._reachColumnName;
    }

    public void setStationColumn(String string) {
        this._stationColumnName = string;
    }

    public String getStationColumn() {
        return this._stationColumnName;
    }

    /*
     * Loose catch block
     */
    public boolean writeFile(Identifier identifier) {
        if (this.getReadOnly()) {
            System.out.println("File " + identifier.getFile().getPath() + " is marked readonly");
            return false;
        }
        super.writeFile(identifier);
        Object object = identifier.getFile();
        System.out.println("writing " + object.getPath());
        RMAIO.getVersionStamp();
        this.setReloadOk(false);
        object = object.getBufferedWriter();
        if (object == null) {
            return false;
        }
        RMAIO.fout((BufferedWriter)object, (String)("Name=" + this.getName()));
        RMAIO.fout((BufferedWriter)object, (String)("Description=" + this.getDescription()));
        CrossSectionManager crossSectionManager = this;
        RMAIO.fout((BufferedWriter)object, (String)("RasFile=" + crossSectionManager.getRelativePath(crossSectionManager._rasFile)));
        RMAIO.fout((BufferedWriter)object, (String)("RiverColumn=" + this.getRiverColumn()));
        RMAIO.fout((BufferedWriter)object, (String)("ReachColumn=" + this.getReachColumn()));
        RMAIO.fout((BufferedWriter)object, (String)("StationColumn=" + this.getStationColumn()));
        try {
            ((BufferedWriter)object).close();
        }
        catch (IOException iOException) {}
        this.setModified(false);
        this.setReloadOk(true);
        return true;
        catch (Exception exception) {
            try {
                this.printMessage("Failed to write file " + identifier.getPath() + " " + String.valueOf(exception));
            }
            catch (Throwable throwable) {
                try {
                    ((BufferedWriter)object).close();
                }
                catch (IOException iOException) {}
                this.setModified(false);
                this.setReloadOk(true);
                throw throwable;
            }
            try {
                ((BufferedWriter)object).close();
            }
            catch (IOException iOException) {}
            this.setModified(false);
            this.setReloadOk(true);
            return false;
        }
    }

    public AiShapeMap getShapeMap() {
        if (this._map == null) {
            this._map = new AiShapeMap();
            this._map.setFileOpener((FileOpener)ClientApp.Workspace());
            Object object = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            Identifier identifier = new Identifier(this.getRasFile());
            try {
                object = object.openFile(UserId.getUserId(), identifier);
                if (object != null) {
                    this._mapId = new MapIdentifier((Identifier)object);
                    this._mapId.setName(this.getName());
                    this._mapId.setMapShown(true);
                    this._mapId.setIsManager(true);
                    this._map.setMapIdentifier(this._mapId);
                    this._map.load();
                    return this._map;
                }
            }
            catch (IOException iOException) {
                object = iOException;
                iOException.printStackTrace();
                this._map = null;
            }
            return null;
        }
        return this._map;
    }

    public void setRasFile(String string) {
        this._rasFile = string;
        this._map = null;
    }

    public String getRasFile() {
        return this._rasFile;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return null;
    }

    public WorldRect getExtent() {
        WorldRect worldRect = null;
        Object object = this.getRasFile();
        if (object != null) {
            object = MapObjectFactory.newMapObject((FileOpener)new SimpleFileOpenerImpl(), (String)object);
            try {
                object.load();
                worldRect = object.getExtent();
                object.unload();
            }
            catch (IOException iOException) {
                object = iOException;
                iOException.printStackTrace();
            }
        }
        return worldRect;
    }

    public MapIdentifier getMapIdentifier() {
        if (this._mapId == null) {
            MapIdentifier mapIdentifier = new MapIdentifier(this.getIdentifier());
            mapIdentifier.setMapShown(true);
            mapIdentifier.setIsManager(true);
            this._mapId = mapIdentifier;
        }
        return this._mapId;
    }

    public void load() throws IOException {
    }

    public void setExtent(WorldRect worldRect) {
    }

    public void setMapIdentifier(MapIdentifier mapIdentifier) {
    }

    public void unload() {
    }
}

