/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import hec.clientapp.model.ManagerProxy;
import hec.heclib.dss.DSSPathname;
import hec.io.Identifier;
import hec.model.RunTimeWindow;
import hec.rss.model.PDCDataSet;
import hec.rss.model.PDCDataSet$RecordBuilder;
import hec.rss.model.PDCRecord;
import hec.rss.model.RssSystem;
import hec.rss.wq.dataSources.DataSourceFactory;
import hec.rss.wq.dataSources.pairedData.PairedCurveDataSource;
import hec.rss.wq.dataSources.pairedData.SelectionTypeUtils;
import hec.rss.wq.model.ConstituentManager;
import hec.rss.wq.model.ConstituentSetManager;
import hec.rss.wq.model.GeometryManager;
import hec.rss.wq.model.JsonManager;
import hec.rss.wq.model.WQPDCDataProvider;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.ui.DataSource;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.ConstituentSet;
import hec.wqenginecore.InitialConditionSet;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.geometry.Geometry;
import hec.wqenginecore.geometry.SubDomainRef;
import hec.wqengineimpl.initialCondition.InitialConditionsSourceSelection;
import hec.wqengineimpl.initialCondition.WQInitialConditionSet;
import hec.wqengineimpl.initialCondition.WQInitialConditionSet2;
import hec.wqengineimpl.initialCondition.WQMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class InitialConditionSetManager
extends JsonManager
implements ConstituentManager,
GeometryManager,
WQPDCDataProvider {
    public static final int CURRENT_VERSION = 2;
    public static final Logger logger = Logger.getLogger(InitialConditionSetManager.class.getName());
    public static final String EXT = ".initialCondSet";
    public static final String SUBDIR = "wq/";
    @JsonProperty
    private int _version = -1;
    @JsonProperty
    private InitialConditionSet _initialConditionSet;
    @JsonProperty
    private int _geometryId;
    @JsonProperty
    private int _constituentId;

    @JsonIgnore
    public InitialConditionSet getSet() {
        return this.getInitialConditionSet();
    }

    @JsonDeserialize(as=WQInitialConditionSet.class)
    public void setSet(InitialConditionSet initialConditionSet) {
        if (initialConditionSet instanceof WQInitialConditionSet) {
            initialConditionSet = WQInitialConditionSet2.build((WQInitialConditionSet)((WQInitialConditionSet)initialConditionSet));
        }
        if (initialConditionSet != null) {
            this._initialConditionSet = initialConditionSet;
            InitialConditionSetManager initialConditionSetManager = this;
            initialConditionSetManager.setName(initialConditionSetManager._initialConditionSet.getName());
            InitialConditionSetManager initialConditionSetManager2 = this;
            initialConditionSetManager2.setDescription(initialConditionSetManager2._initialConditionSet.getDescription());
            return;
        }
        this._initialConditionSet = null;
        this.setName("");
        this.setDescription("");
    }

    @Override
    protected ObjectMapper getNewObjectMapper(Identifier identifier) {
        identifier = super.getNewObjectMapper(identifier);
        identifier.registerSubtypes(new NamedType[]{new NamedType(WQInitialConditionSet.class, "WQInitialConditionSet")});
        identifier.registerSubtypes(new NamedType[]{new NamedType(WQInitialConditionSet2.class, "WQInitialConditionSet2")});
        return identifier;
    }

    public void setInitialConditionSet(InitialConditionSet initialConditionSet) {
        this.setSet(initialConditionSet);
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
    public InitialConditionSet getInitialConditionSet() {
        return this._initialConditionSet;
    }

    @Override
    @JsonProperty
    public String getName() {
        String string = "";
        InitialConditionSet initialConditionSet = this.getSet();
        if (initialConditionSet != null) {
            string = initialConditionSet.getName();
        }
        return string;
    }

    @Override
    @JsonProperty
    public String getDescription() {
        String string = "";
        InitialConditionSet initialConditionSet = this.getSet();
        if (initialConditionSet != null) {
            string = initialConditionSet.getDescription();
        }
        return string;
    }

    public void setDescription(String string) {
        WQInitialConditionSet wQInitialConditionSet;
        super.setDescription(string);
        string = this.getSet();
        if (string instanceof WQInitialConditionSet) {
            wQInitialConditionSet = (WQInitialConditionSet)string;
            wQInitialConditionSet.setDescription(super.getDescription());
        }
        if (string instanceof WQInitialConditionSet2) {
            wQInitialConditionSet = (WQInitialConditionSet2)string;
            wQInitialConditionSet.setDescription(super.getDescription());
        }
    }

    public void setName(String string) {
        WQInitialConditionSet wQInitialConditionSet;
        super.setName(string);
        string = this.getSet();
        if (string instanceof WQInitialConditionSet) {
            wQInitialConditionSet = (WQInitialConditionSet)string;
            wQInitialConditionSet.setName(super.getName());
        }
        if (string instanceof WQInitialConditionSet2) {
            wQInitialConditionSet = (WQInitialConditionSet2)string;
            wQInitialConditionSet.setName(super.getName());
        }
    }

    @Override
    public void setGeometryId(int n) {
        this._geometryId = n;
    }

    @Override
    public int getGeometryId() {
        return this._geometryId;
    }

    @Override
    @JsonIgnore
    public WqGeometry getGeometry() {
        ManagerProxy managerProxy = this._proxyList.getManagerProxy(WqGeometry.class.getName(), this._geometryId);
        if (managerProxy != null) {
            return (WqGeometry)managerProxy.loadManager(null, null);
        }
        return null;
    }

    @Override
    public void setConstituentSetId(int n) {
        this._constituentId = n;
    }

    @Override
    public int getConstituentSetId() {
        return this._constituentId;
    }

    @Override
    @JsonIgnore
    public ConstituentSetManager getConstituentSet() {
        ManagerProxy managerProxy = this._proxyList.getManagerProxy(ConstituentSetManager.class.getName(), this._constituentId);
        if (managerProxy != null) {
            return (ConstituentSetManager)managerProxy.loadManager(null, null);
        }
        return null;
    }

    @Override
    protected void updateToCurrentVersion() {
        this._version = 2;
    }

    @Override
    @Nonnull
    public List<PDCRecord> getActivePDCRecords(PDCDataSet object, @CheckForNull RunTimeWindow runTimeWindow, RssSystem initialConditionSet) {
        object = new ArrayList();
        initialConditionSet = this.getInitialConditionSet();
        if (initialConditionSet instanceof WQInitialConditionSet2) {
            initialConditionSet = (WQInitialConditionSet2)initialConditionSet;
            if ((initialConditionSet = initialConditionSet.getReservoirSourcesMap()) != null && !initialConditionSet.isEmpty()) {
                initialConditionSet = initialConditionSet.entrySet();
                for (Iterator iterator : initialConditionSet) {
                    Integer n = (Integer)iterator.getKey();
                    if ((iterator = (WQMap)iterator.getValue()) == null || iterator.isEmpty()) continue;
                    iterator = iterator.entrySet();
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        Object object2 = (Map.Entry)iterator.next();
                        SubDomainRef subDomainRef = (SubDomainRef)object2.getKey();
                        object2 = (InitialConditionsSourceSelection)object2.getValue();
                        if (subDomainRef == null || object2 == null || !((object2 = (Data)object2.getSelected()) instanceof DssData)) continue;
                        object2 = (DssData)object2;
                        Constituent constituent = this.getConstituent(n);
                        object2 = this.buildRecord((DssData)object2, subDomainRef, constituent, runTimeWindow);
                        object.add(object2);
                    }
                }
            }
        }
        return object;
    }

    @CheckForNull
    private Constituent getConstituent(Integer n) {
        Constituent constituent = null;
        ConstituentSetManager constituentSetManager = this.getConstituentSet();
        if (constituentSetManager != null) {
            ConstituentSet constituentSet = constituentSetManager.getSet();
            if (constituentSet != null) {
                constituent = constituentSet.getConstituent(n);
                if (constituent == null) {
                    logger.log(Level.WARNING, "Cannot find matching Constituent for id:{0} in ConstituentSet:{1} from ConstituentSetManager: {2}, {3}", new Object[]{n, constituentSet.getName(), ((JsonManager)constituentSetManager).getName(), this.getConstituentSetId()});
                }
            } else {
                logger.warning("Cannot find ConstituentSet from ConstituentSetManager:" + ((JsonManager)constituentSetManager).getName());
            }
        } else {
            logger.warning("Cannot find ConstituentSetManager for constituent set id:" + this.getConstituentSetId());
        }
        return constituent;
    }

    private PDCRecord buildRecord(@Nonnull DssData dssData, @Nonnull SubDomainRef object, @CheckForNull Constituent constituent, @CheckForNull RunTimeWindow object2) {
        PDCDataSet$RecordBuilder pDCDataSet$RecordBuilder = new PDCDataSet$RecordBuilder();
        pDCDataSet$RecordBuilder.withIsInput(true);
        pDCDataSet$RecordBuilder.withDssFilename(dssData.getDssFilePath());
        String string = dssData.getDssPath();
        DataSource dataSource = DataSourceFactory.a((Data)dssData);
        if (dataSource instanceof PairedCurveDataSource) {
            dataSource = (PairedCurveDataSource)dataSource;
            string = ((PairedCurveDataSource)dataSource).a(SelectionTypeUtils.a(object2), dssData.getDssFilePath(), null);
        }
        pDCDataSet$RecordBuilder.withDssPathname(string);
        dataSource = object.getSubDomain((Geometry)this.getGeometry().getRssWqGeometry());
        int n = dataSource.getId();
        pDCDataSet$RecordBuilder.withIndex(n);
        String string2 = dataSource.getName();
        object = constituent == null ? "null" : constituent.getName();
        object2 = string2 + "-" + (String)object;
        pDCDataSet$RecordBuilder.withName((String)object2);
        pDCDataSet$RecordBuilder.withDescription("Constituent:" + (String)object + ", Reservoir:" + string2);
        if (constituent != null) {
            pDCDataSet$RecordBuilder.withParamName(constituent.getDisplayName());
            string2 = constituent.getUnit();
            pDCDataSet$RecordBuilder.withUnits(string2);
            pDCDataSet$RecordBuilder.withVarId(2000 + constituent.getId());
        } else {
            string2 = new DSSPathname(string);
            pDCDataSet$RecordBuilder.withParamName(string2.getCPart());
        }
        return pDCDataSet$RecordBuilder.build();
    }

    @Override
    protected boolean alwaysRelativeToBase() {
        return true;
    }
}

