/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import hec.clientapp.model.Manager;
import hec.clientapp.rmi.csinterface.HecRmiWorkspace;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.io.Identifier;
import hec.wqenginecore.jackson.ObjectMapperUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.util.RMAIO;

@JsonPropertyOrder(value={"index", "name", "description"})
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class JsonManager
extends Manager {
    public static final Logger logger = Logger.getLogger(JsonManager.class.getName());
    @JsonProperty
    private String _ressimVersion;

    protected JsonManager(String string) {
        super(string);
    }

    protected JsonManager() {
    }

    public void init() {
    }

    @JsonProperty
    public int getIndex() {
        return super.getIndex();
    }

    public boolean readFile(Identifier identifier) {
        this._lastModifiedTime = Long.MIN_VALUE;
        Object object = identifier.getFile();
        if (object == null) {
            return false;
        }
        if (object.exists()) {
            ObjectMapper objectMapper = this.getNewObjectMapper(identifier);
            try {
                object = object.getBufferedReader();
                try {
                    this.readValue(objectMapper, (BufferedReader)object);
                }
                finally {
                    if (object != null) {
                        ((BufferedReader)object).close();
                    }
                }
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "Error reading file " + identifier.getPath(), iOException);
                this.printErrorMessage("Failed to read file " + identifier.getPath());
                return false;
            }
        }
        this.setModified(false);
        return true;
    }

    protected ObjectMapper getNewObjectMapper(Identifier identifier) {
        return ObjectMapperUtil.getNewObjectMapper((String)this.getBasePath(identifier), (Class[])new Class[]{((Object)((Object)this)).getClass()});
    }

    private String getBasePath(Identifier identifier) {
        String string = null;
        try {
            String string2;
            Object object;
            if (this.alwaysRelativeToBase()) {
                object = (RmiWorkspace)this.getWorkspace().getRemote();
                object = (HecRmiWorkspace)object.getChildWorkspace("");
                string2 = object.getBaseWorkspace().getWorkspacePath();
            } else {
                object = this.getProxyList();
                object = object != null ? object.getContainer() : null;
                object = object != null ? object.getChildWorkspace("RSS") : null;
                string2 = object != null ? object.getWorkspacePath() : null;
            }
            object = string2;
            string = string2;
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Error getting workspace path information for path reletivization:  " + identifier.getPath(), exception);
        }
        return string;
    }

    protected void readValue(ObjectMapper objectMapper, BufferedReader bufferedReader) throws IOException {
        objectMapper = objectMapper.readerForUpdating((Object)this);
        objectMapper.readValue((Reader)bufferedReader);
    }

    protected boolean alwaysRelativeToBase() {
        return false;
    }

    /*
     * Loose catch block
     */
    public boolean writeFile(Identifier identifier) {
        block18: {
            if (this.getReadOnly()) {
                System.out.println("File " + identifier.getFile().getPath() + " is marked readonly");
                return false;
            }
            this.updateToCurrentVersion();
            super.writeFile(identifier);
            Object object = identifier.getFile();
            System.out.println("writing " + object.getPath());
            Object object2 = RMAIO.getVersionStamp();
            if (object2 != null) {
                this._ressimVersion = object2[0];
            }
            this.setReloadOk(false);
            object = object.getBufferedWriter();
            if (object == null) {
                return false;
            }
            object2 = ObjectMapperUtil.getNewObjectMapper((String)this.getBasePath(identifier));
            object2.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            this.writeValue((ObjectMapper)object2, (BufferedWriter)object);
            try {
                ((BufferedWriter)object).close();
                break block18;
            }
            catch (IOException iOException) {}
            break block18;
            catch (JsonMappingException jsonMappingException) {
                object2 = jsonMappingException;
                String string = jsonMappingException.getPathReference();
                Object object3 = object2;
                object2 = object2.getCause();
                if (object2 != null) {
                    object3 = object2;
                }
                logger.log(Level.WARNING, "Error writing json for field:" + string + " to file:" + identifier.getPath(), (Throwable)object3);
                this.printErrorMessage("Failed to write file " + identifier.getPath());
                try {
                    ((BufferedWriter)object).close();
                }
                catch (IOException iOException) {}
                this.setModified(false);
                this.setReloadOk(true);
                return false;
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "Error writing file " + identifier.getPath(), iOException);
                this.printErrorMessage("Failed to write file " + identifier.getPath());
                {
                    catch (Throwable throwable) {
                        try {
                            ((BufferedWriter)object).close();
                        }
                        catch (IOException iOException2) {}
                        this.setModified(false);
                        this.setReloadOk(true);
                        throw throwable;
                    }
                }
                try {
                    ((BufferedWriter)object).close();
                }
                catch (IOException iOException3) {}
                this.setModified(false);
                this.setReloadOk(true);
                return false;
            }
        }
        this.setModified(false);
        this.setReloadOk(true);
        return true;
    }

    protected abstract void updateToCurrentVersion();

    protected void writeValue(ObjectMapper objectMapper, BufferedWriter bufferedWriter) throws IOException {
        objectMapper.writeValue((Writer)bufferedWriter, (Object)this);
    }

    @JsonProperty
    public String getName() {
        return super.getName();
    }

    @JsonProperty
    public String getDescription() {
        return super.getDescription();
    }

    @JsonProperty
    public long getLastModifiedTime() {
        return super.getLastModifiedTime();
    }
}

