/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import hec.clientapp.model.Manager;
import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.clientapp.rmi.csinterface.HecRmiWorkspace;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecTimeSeriesBase;
import hec.io.DSSIdentifier;
import hec.io.Identifier;
import hec.map.MapGlyphFactory;
import hec.map.MapIdentifier;
import hec.map.MapObjectInterface2;
import hec.map.MapToolSet;
import hec.map.WorldRect;
import hec.map.crs.CoordinateReferenceSystem;
import hec.model.RunTimeWindow;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableSet;
import hec.rss.wq.model.CloudinessComputeException;
import hec.rss.wq.model.CloudinessUtils;
import hec.rss.wq.model.SolarRadiationComputeException;
import hec.rss.wq.model.SolarRadiationUtils;
import hec.rss.wq.model.WQTSDataProvider;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.elevation.ElevationData;
import hec.wqenginecore.dataSource.latlong.LatLongData;
import hec.wqenginecore.dataSource.obs.ObservedData;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.jackson.ObjectMapperUtil;
import hec.wqenginecore.metstation.MetStation;
import hec.wqenginecore.metstation.MetStationSet;
import hec.wqenginecore.metstation.MetVariable;
import hec.wqenginecore.metstation.MetVariableTypes;
import hec.wqengineimpl.metstation.WQMetStation;
import hec.wqengineimpl.metstation.WQMetStationSet;
import hec.wqengineimpl.metstation.variable.Cloudiness;
import hec.wqengineimpl.metstation.variable.ShortWaveRadiation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.server.RemoteWrapper;

public class MetData
extends Manager
implements MapObjectInterface2,
WQTSDataProvider {
    public static final Logger logger = Logger.getLogger(MetData.class.getName());
    public static final int CURRENT_VERSION = 1;
    public static final String FILE_EXT = ".met";
    @JsonProperty
    private int _version = -1;
    WQMetStationSet _metStationSet = new WQMetStationSet();
    MapIdentifier _mapIdentifier = new MapIdentifier();

    public MetData() {
        this._mapIdentifier.setMapShown(true);
    }

    public void setIndex(int n) {
        super.setIndex(n);
        this._metStationSet.setId(n);
    }

    public void setName(String string) {
        super.setName(string);
        this._metStationSet.setName(string);
    }

    public void setDescription(String string) {
        super.setDescription(string);
        this._metStationSet.setDescription(string);
    }

    public void init() {
    }

    public List<WQMetStation> getStations(Predicate<WQMetStation> predicate) {
        return this._metStationSet.getStations(predicate);
    }

    public WQMetStationSet getMetStationSet() {
        return this._metStationSet;
    }

    public void setMetStationSet(WQMetStationSet wQMetStationSet) {
        this._metStationSet = wQMetStationSet;
        this.setModified(true);
    }

    public boolean writeFile(Identifier identifier) {
        super.writeFile(identifier);
        if (identifier == null) {
            return true;
        }
        this._version = 1;
        String string = this.getBasepath(identifier);
        string = ObjectMapperUtil.getNewObjectMapper((String)string);
        string = string.writerFor(WQMetStationSet.class);
        Object object = identifier.getFile().getPath();
        object = new File((String)object);
        if (!((File)(object = ((File)object).getParentFile())).exists()) {
            ((File)object).mkdirs();
        }
        try {
            object = new FileOutputStream(identifier.getFile().getPath());
            try {
                string.writeValue((OutputStream)object, (Object)this._metStationSet);
            }
            finally {
                ((OutputStream)object).close();
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Error writing stations set", exception);
            this.printErrorMessage("Failed to write file " + identifier.getPath());
            return false;
        }
        this.setModified(false);
        return true;
    }

    private String getBasepath(Identifier identifier) {
        String string = null;
        try {
            RemoteWrapper remoteWrapper = this.getWorkspace();
            remoteWrapper = remoteWrapper != null ? (RmiWorkspace)remoteWrapper.getRemote() : null;
            remoteWrapper = remoteWrapper != null ? (HecRmiWorkspace)remoteWrapper.getChildWorkspace("") : null;
            remoteWrapper = remoteWrapper != null ? remoteWrapper.getBaseWorkspace() : null;
            string = remoteWrapper != null ? remoteWrapper.getWorkspacePath() : null;
            if (string == null) {
                logger.log(Level.INFO, "Workspace path information not found for path relativization: {0}", identifier.getPath());
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, exception, () -> "Error getting workspace path information for path relativization:  " + identifier.getPath());
        }
        return string;
    }

    public boolean readFile(Identifier identifier) {
        super.readFile(identifier);
        String string = this.getBasepath(identifier);
        string = ObjectMapperUtil.getNewObjectMapper((String)string);
        string = string.readerFor(WQMetStationSet.class);
        Object object = identifier.getFile().getPath();
        object = new File((String)object);
        if (((File)object).exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(identifier.getFile().getPath());){
                this._metStationSet = (WQMetStationSet)string.readValue((InputStream)fileInputStream);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, exception, () -> MetData.a((File)object));
                this.printErrorMessage("Failed to read file " + identifier.getPath());
                return false;
            }
        }
        this.updateDataSourceElevations();
        MetData metData = this;
        metData.setDescription(metData._metStationSet.getDescription());
        MetData metData2 = this;
        metData2.setName(metData2._metStationSet.getName());
        MetData metData3 = this;
        metData3.setIndex(metData3._metStationSet.getId());
        this.setModified(false);
        return true;
    }

    private void updateDataSourceElevations() {
        Object object = this._metStationSet.getStations();
        object = object.iterator();
        while (object.hasNext()) {
            MetStation metStation = (MetStation)object.next();
            Object object2 = metStation.getVariables();
            object2 = object2.iterator();
            while (object2.hasNext()) {
                Object object3 = (MetVariable)object2.next();
                object3 = object3.getDataSources();
                object3 = object3.iterator();
                while (object3.hasNext()) {
                    Data data = (Data)object3.next();
                    if (!(data instanceof ElevationData)) continue;
                    ((ElevationData)data).setElevation(metStation.getReferenceElevation());
                }
            }
        }
    }

    public MapToolSet getMapTools() {
        return null;
    }

    public void setMapIdentifier(MapIdentifier mapIdentifier) {
    }

    public MapIdentifier getMapIdentifier() {
        return this._mapIdentifier;
    }

    public void setExtent(WorldRect worldRect) {
    }

    public WorldRect getExtent() {
        WorldRect worldRect = null;
        Object object = this._metStationSet.getStations();
        object = object.iterator();
        while (object.hasNext()) {
            MetStation metStation = (MetStation)object.next();
            if (!(metStation instanceof WQMetStation)) continue;
            metStation = (WQMetStation)metStation;
            if ((metStation = metStation.getGeometry()) == null) continue;
            metStation = metStation.getEnvelopeInternal();
            if (worldRect == null) {
                worldRect = new WorldRect();
                worldRect.init(metStation.getMinX(), metStation.getMaxY(), metStation.getMaxX(), metStation.getMinY());
                continue;
            }
            worldRect.grow(new WorldRect(metStation.getMinX(), metStation.getMaxY(), metStation.getMaxX(), metStation.getMinY()));
        }
        return worldRect;
    }

    public void load() throws IOException {
    }

    public void unload() {
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return null;
    }

    public Data getSelectedData(MetVariable metVariable) {
        String string = metVariable.getSelectedDataSourceName();
        metVariable = metVariable.getDataSources().stream().filter(data -> Objects.equals(data.getName(), string)).findFirst().orElse(null);
        return metVariable;
    }

    @Override
    public List<TSRecordProxy> getActiveTSRecordProxies(TSDataSet tSDataSet, RssAlt rssAlt) {
        ArrayList<TSRecordProxy> arrayList = new ArrayList<TSRecordProxy>();
        List list = this._metStationSet.getActiveStations();
        Iterator iterator = list.iterator();
        RssModelVariableSet.addModelVariable(null);
        while (iterator.hasNext()) {
            MetStation metStation = (MetStation)iterator.next();
            List list2 = metStation.getVariables();
            MetVariableTypes[] metVariableTypesArray = MetVariableTypes.values();
            int n = metVariableTypesArray.length;
            for (int i = 0; i < n; ++i) {
                int[] nArray;
                int n2;
                String string;
                List list3 = list = metVariableTypesArray[i];
                list = list2;
                MetVariable metVariable = null;
                if (list != null) {
                    metVariable = list.stream().filter(arg_0 -> MetData.a((MetVariableTypes)list3, arg_0)).findFirst().orElse(null);
                }
                if (metVariable != null && "Compute from ObsSW and Lat-Long".equals(metVariable.getSelectedDataSourceName())) {
                    list = new TSRecordProxy();
                    list.setInput(true);
                    list.setIndex(metStation.getId());
                    list.setDescription("MetStation:" + metStation.getName() + ", MetData:" + this.getName());
                    list3 = new DSSPathname();
                    list3.setBPart(metStation.getName());
                    list3.setCPart("Cloud Cover");
                    string = CloudinessUtils.DSS_OUTPUT_INTERVAL;
                    if (rssAlt != null) {
                        list.setDSSFilename(rssAlt.getInputMetDataDSSFileName());
                    }
                    list3.setFPart(MetData.a((MetStationSet)this._metStationSet));
                    n2 = HecTimeSeriesBase.getIntervalFromEPart((String)string) * 60;
                    nArray = new int[1];
                    list3.setEPart(DSSPathname.getRegularTsEPartFromInterval((int)7, (int)n2, (int[])nArray));
                    list.setDSSPathname(list3.getPathname());
                    list.setParamName(metVariable.getType());
                    list.setUnits(Cloudiness.getDefaultUnits());
                    list.setName(metStation.getName() + "-" + metVariable.getType());
                    list.setTSDataSet(tSDataSet);
                    arrayList.add((TSRecordProxy)list);
                    continue;
                }
                if (metVariable != null && "DSS".equals(metVariable.getSelectedDataSourceName())) {
                    list3 = (DssData)this.getSelectedData(metVariable);
                    list = new TSRecordProxy();
                    list.setInput(true);
                    list.setIndex(metStation.getId());
                    list.setDescription("MetStation:" + metStation.getName() + ", MetData:" + this.getName());
                    list.setDSSPathname(list3.getDssPath());
                    list.setDSSFilename(list3.getDssFilePath());
                    list.setParamName(metVariable.getType());
                    list.setUnits(list3.getUnits());
                    list.setName(metStation.getName() + "-" + metVariable.getType());
                    list.setTSDataSet(tSDataSet);
                    arrayList.add((TSRecordProxy)list);
                    continue;
                }
                if (metVariable == null || !"Lat-Long".equals(metVariable.getSelectedDataSourceName())) continue;
                list3 = (LatLongData)this.getSelectedData(metVariable);
                list = new TSRecordProxy();
                list.setInput(true);
                list.setIndex(metStation.getId());
                list.setDescription("MetStation:" + metStation.getName() + ", MetData:" + this.getName());
                string = new DSSPathname();
                string.setBPart(metStation.getName());
                string.setCPart("Irrad");
                n2 = (int)list3.getComputeInterval() * 60;
                nArray = new int[1];
                string.setEPart(DSSPathname.getRegularTsEPartFromInterval((int)7, (int)n2, (int[])nArray));
                if (rssAlt != null) {
                    list.setDSSFilename(rssAlt.getInputMetDataDSSFileName());
                }
                string.setFPart(MetData.a((MetStationSet)this._metStationSet));
                list.setDSSPathname(string.getPathname());
                list.setParamName(metVariable.getType());
                list.setUnits(ShortWaveRadiation.getDefaultComputedUnits());
                list.setName(metStation.getName() + "-" + metVariable.getType());
                list.setTSDataSet(tSDataSet);
                arrayList.add((TSRecordProxy)list);
            }
        }
        return arrayList;
    }

    private static String a(MetStationSet object) {
        int n = ((String)(object = object.getName())).indexOf(":");
        if (n > 0) {
            object = ((String)object).substring(n + 1);
        }
        return object;
    }

    @Override
    public List<String> prepareForExtract(RunTimeWindow runTimeWindow, RssAlt rssAlt, DSSManager dSSManager) {
        String string = CloudinessUtils.DSS_OUTPUT_INTERVAL;
        return MetData.a((MetStationSet)this._metStationSet, runTimeWindow, rssAlt.getInputMetDataDSSFileName(), dSSManager, string);
    }

    public static List<String> a(MetStationSet metStationSet, RunTimeWindow runTimeWindow, String string, DSSManager dSSManager, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (metStationSet == null) {
            return arrayList;
        }
        Object object = metStationSet.getActiveStations();
        if (object == null || object.isEmpty()) {
            return arrayList;
        }
        DSSPathname dSSPathname = new DSSPathname();
        dSSPathname.setFPart(MetData.a(metStationSet));
        DSSIdentifier dSSIdentifier = new DSSIdentifier(string);
        object = object.iterator();
        while (object.hasNext()) {
            string = (MetStation)object.next();
            if (!(string instanceof WQMetStation)) continue;
            string = (WQMetStation)string;
            Object object2 = string.getVariables();
            object2 = object2.iterator();
            while (object2.hasNext()) {
                Object object3 = (MetVariable)object2.next();
                if (object3 instanceof Cloudiness) {
                    object3 = MetData.a(metStationSet, runTimeWindow, dSSManager, (WQMetStation)string, dSSPathname, dSSIdentifier, (Cloudiness)object3, string2);
                    arrayList.addAll((Collection<String>)object3);
                    continue;
                }
                if (!(object3 instanceof ShortWaveRadiation)) continue;
                object3 = MetData.a(metStationSet, runTimeWindow, dSSManager, (WQMetStation)string, dSSPathname, dSSIdentifier, (ShortWaveRadiation)object3);
                arrayList.addAll((Collection<String>)object3);
            }
        }
        return arrayList;
    }

    private static List<String> a(MetStationSet metStationSet, RunTimeWindow runTimeWindow, DSSManager dSSManager, WQMetStation wQMetStation, DSSPathname dSSPathname, DSSIdentifier dSSIdentifier, ShortWaveRadiation shortWaveRadiation) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((shortWaveRadiation = shortWaveRadiation.getSelectedData()) instanceof LatLongData) {
            shortWaveRadiation = (LatLongData)shortWaveRadiation;
            dSSPathname.setBPart(wQMetStation.getName());
            dSSPathname.setCPart("Irrad");
            dSSIdentifier.setDSSPath(dSSPathname.getPathname());
            try {
                SolarRadiationUtils.a(runTimeWindow, null, ShortWaveRadiation.getDefaultComputedUnits(), (LatLongData)shortWaveRadiation, dSSIdentifier, dSSManager);
            }
            catch (SolarRadiationComputeException solarRadiationComputeException) {
                arrayList.add("Error computing solar radiation for: " + metStationSet.getName() + " - " + wQMetStation.getName() + ".\n" + solarRadiationComputeException.getMessage());
            }
        }
        return arrayList;
    }

    private static List<String> a(MetStationSet metStationSet, RunTimeWindow runTimeWindow, DSSManager dSSManager, WQMetStation wQMetStation, DSSPathname dSSPathname, DSSIdentifier dSSIdentifier, Cloudiness cloudiness, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Data data = cloudiness.getSelectedData();
        if (data instanceof ObservedData) {
            dSSPathname.setBPart(wQMetStation.getName());
            dSSPathname.setCPart("Cloud Cover");
            dSSIdentifier.setDSSPath(dSSPathname.getPathname());
            try {
                runTimeWindow = CloudinessUtils.a(runTimeWindow, cloudiness, wQMetStation, dSSIdentifier, dSSManager, string);
                ((ObservedData)data).setCloudinessDSSPath(runTimeWindow.fullName);
                ((ObservedData)data).setCloudinessDSSFileName(runTimeWindow.fileName);
            }
            catch (CloudinessComputeException cloudinessComputeException) {
                arrayList.add("Error computing cloudiness for: " + metStationSet.getName() + " - " + wQMetStation.getName() + ".\n" + cloudinessComputeException.getMessage());
            }
        }
        return arrayList;
    }

    private static /* synthetic */ boolean a(MetVariableTypes metVariableTypes, MetVariable metVariable) {
        return metVariable.getType().equals(metVariableTypes.getName());
    }

    private static /* synthetic */ String a(File file) {
        return "Error reading stations set from file:" + file.getAbsolutePath();
    }

    static {
        MapGlyphFactory.addMapping((String)"hec.rss.wq.model.MetData", (String)"hec.rss.wq.client.metstation.MetStationMapGlyph");
    }
}

