/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import hec.clientapp.model.Manager;
import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.clientapp.rmi.csinterface.HecRmiWorkspace;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.data.TimeWindow;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.io.DSSIdentifier;
import hec.io.Identifier;
import hec.io.PairedDataContainer;
import hec.map.MapGlyphFactory;
import hec.map.MapIdentifier;
import hec.map.MapObjectInterface2;
import hec.map.MapToolSet;
import hec.map.WorldRect;
import hec.map.crs.CoordinateReferenceSystem;
import hec.model.RunTimeWindow;
import hec.rss.model.Element;
import hec.rss.model.PDCDataSet;
import hec.rss.model.PDCDataSet$RecordBuilder;
import hec.rss.model.PDCRecord;
import hec.rss.model.RssSystem;
import hec.rss.wq.dataSources.DataSourceFactory;
import hec.rss.wq.dataSources.pairedData.PairedCurveDataSource;
import hec.rss.wq.dataSources.pairedData.SelectionTypeUtils;
import hec.rss.wq.model.WQPDCDataProvider;
import hec.rss.wq.model.WQTSDataProvider;
import hec.rss.wq.ui.DataSource;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.jackson.ObjectMapperUtil;
import hec.wqenginecore.observed.ObsStation;
import hec.wqenginecore.observed.ObsVariable;
import hec.wqengineimpl.observed.WQObsConstituentVariable;
import hec.wqengineimpl.observed.WQObsStation;
import hec.wqengineimpl.observed.WQObsStationNetworkElement;
import hec.wqengineimpl.observed.WQObsStationSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import mil.army.usace.hec.rmi.server.DSSFileManager;

public class ObsDatasetManager
extends Manager
implements MapObjectInterface2,
WQPDCDataProvider,
WQTSDataProvider {
    public static final Logger logger = Logger.getLogger(ObsDatasetManager.class.getName());
    public static final int CURRENT_VERSION = 1;
    public static final String FILE_EXT = ".obs";
    private static final SimpleDateFormat a = new SimpleDateFormat("ddMMMyyyy, HH:mm");
    private static final SimpleDateFormat b = new SimpleDateFormat("ddMMMyyyy HH[:]mm");
    @JsonProperty
    private int _version = -1;
    WQObsStationSet _obsStationSet = new WQObsStationSet();
    MapIdentifier _mapIdentifier = new MapIdentifier();

    public ObsDatasetManager() {
        this._mapIdentifier.setMapShown(true);
    }

    public void setIndex(int n) {
        super.setIndex(n);
        this._obsStationSet.setId(n);
    }

    public void setName(String string) {
        super.setName(string);
        this._obsStationSet.setName(string);
    }

    public void setDescription(String string) {
        super.setDescription(string);
        this._obsStationSet.setDescription(string);
    }

    public void init() {
    }

    public List<WQObsStation> getStations(Predicate<WQObsStation> predicate) {
        return this._obsStationSet.getStations(predicate);
    }

    public WQObsStationSet getObsStationSet() {
        return this._obsStationSet;
    }

    public void setObsStationSet(WQObsStationSet wQObsStationSet) {
        this._obsStationSet = wQObsStationSet;
        this.setModified(true);
    }

    public boolean writeFile(Identifier identifier) {
        super.writeFile(identifier);
        if (identifier == null) {
            return true;
        }
        this._version = 1;
        String string = this.getBasepath(identifier);
        string = ObjectMapperUtil.getNewObjectMapper((String)string);
        string = string.writerFor(WQObsStationSet.class);
        Object object = identifier.getFile().getPath();
        object = new File((String)object);
        if (!((File)(object = ((File)object).getParentFile())).exists()) {
            ((File)object).mkdirs();
        }
        try {
            object = new FileOutputStream(identifier.getFile().getPath());
            try {
                string.writeValue((OutputStream)object, (Object)this._obsStationSet);
            }
            finally {
                ((OutputStream)object).close();
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Error writing stations set", exception);
            this.printErrorMessage("Failed to write file " + identifier.getPath());
            return false;
        }
        this.setModified(false);
        return true;
    }

    private String getBasepath(Identifier identifier) {
        String string = null;
        try {
            RmiWorkspace rmiWorkspace = (RmiWorkspace)this.getWorkspace().getRemote();
            rmiWorkspace = (HecRmiWorkspace)rmiWorkspace.getChildWorkspace("");
            string = rmiWorkspace.getBaseWorkspace().getWorkspacePath();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, exception, () -> "Error getting workspace path information for path reletivization:  " + identifier.getPath());
        }
        return string;
    }

    public boolean readFile(Identifier identifier) {
        super.readFile(identifier);
        String string = this.getBasepath(identifier);
        string = ObjectMapperUtil.getNewObjectMapper((String)string);
        string = string.readerFor(WQObsStationSet.class);
        Object object = identifier.getFile().getPath();
        object = new File((String)object);
        if (((File)object).exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(identifier.getFile().getPath());){
                this._obsStationSet = (WQObsStationSet)string.readValue((InputStream)fileInputStream);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, exception, () -> ObsDatasetManager.a((File)object));
                this.printErrorMessage("Failed to read file " + identifier.getPath());
                return false;
            }
        }
        ObsDatasetManager obsDatasetManager = this;
        obsDatasetManager.setDescription(obsDatasetManager._obsStationSet.getDescription());
        this.setModified(false);
        return true;
    }

    public MapToolSet getMapTools() {
        return null;
    }

    public void setMapIdentifier(MapIdentifier mapIdentifier) {
    }

    public MapIdentifier getMapIdentifier() {
        return this._mapIdentifier;
    }

    public void setExtent(WorldRect worldRect) {
    }

    public WorldRect getExtent() {
        WorldRect worldRect = null;
        Object object = this._obsStationSet.getStations();
        object = object.iterator();
        while (object.hasNext()) {
            ObsStation obsStation = (ObsStation)object.next();
            if (!(obsStation instanceof WQObsStation)) continue;
            obsStation = (WQObsStation)obsStation;
            if ((obsStation = obsStation.getGeometry()) == null) continue;
            obsStation = obsStation.getEnvelopeInternal();
            if (worldRect == null) {
                worldRect = new WorldRect();
                worldRect.init(obsStation.getMinX(), obsStation.getMaxY(), obsStation.getMaxX(), obsStation.getMinY());
                continue;
            }
            worldRect.grow(new WorldRect(obsStation.getMinX(), obsStation.getMaxY(), obsStation.getMaxX(), obsStation.getMinY()));
        }
        return worldRect;
    }

    public void load() throws IOException {
    }

    public void unload() {
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return null;
    }

    @Override
    public List<TSRecordProxy> getActiveTSRecordProxies(TSDataSet tSDataSet) {
        ArrayList<TSRecordProxy> arrayList = new ArrayList<TSRecordProxy>();
        List list = this._obsStationSet.getStations();
        TSRecordProxy tSRecordProxy = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            ObsStation obsStation = (ObsStation)list.get(i);
            if (obsStation instanceof WQObsStation && ((WQObsStation)obsStation).isProfileStation()) continue;
            tSRecordProxy.addAll(obsStation.getVariables());
        }
        for (ObsStation obsStation : tSRecordProxy) {
            list = obsStation.getSelectedData();
            if (!(list instanceof DssData)) continue;
            list = (DssData)list;
            tSRecordProxy = new TSRecordProxy();
            tSRecordProxy.setInput(true);
            tSRecordProxy.setDSSPathname(list.getDssPath());
            tSRecordProxy.setDSSFilename(list.getDssFilePath());
            DSSPathname dSSPathname = new DSSPathname(list.getDssPath());
            tSRecordProxy.setUnits(list.getUnits());
            tSRecordProxy.setName(obsStation.getDisplayName());
            tSRecordProxy.setTSDataSet(tSDataSet);
            tSRecordProxy.setParamName(dSSPathname.getCPart());
            if (obsStation instanceof WQObsConstituentVariable) {
                tSRecordProxy.setVariableId(2000 + ((WQObsConstituentVariable)obsStation).getConstituentId());
            }
            arrayList.add(tSRecordProxy);
        }
        return arrayList;
    }

    @Override
    public List<PDCRecord> getActivePDCRecords(PDCDataSet pDCDataSet, RunTimeWindow runTimeWindow, RssSystem rssSystem) {
        ArrayList<PDCRecord> arrayList = new ArrayList<PDCRecord>();
        Object object = this._obsStationSet.getStations();
        Set<Element> set = ObsDatasetManager.a(rssSystem);
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (ObsStation)object.next();
            if (!(object2 instanceof WQObsStation) || !((WQObsStation)object2).isProfileStation()) continue;
            object2 = this.buildProfileRecord((WQObsStation)object2, set, rssSystem, runTimeWindow);
            arrayList.addAll((Collection<PDCRecord>)object2);
        }
        pDCDataSet.addAll(arrayList);
        return arrayList;
    }

    public List<PairedDataContainer> getPairedData(RssSystem object, RunTimeWindow runTimeWindow) {
        object = this.getActivePDCRecords(new PDCDataSet(), runTimeWindow, (RssSystem)object);
        return this.readProfiles((List<PDCRecord>)object);
    }

    private List<PairedDataContainer> readProfiles(List<PDCRecord> object) {
        ArrayList<PairedDataContainer> arrayList = new ArrayList<PairedDataContainer>();
        object = this.filterDuplicatePDCRecords((List<PDCRecord>)object);
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (PDCRecord)object.next();
            DSSIdentifier dSSIdentifier = new DSSIdentifier();
            dSSIdentifier.setDSSPath(object2.getDSSPathname());
            dSSIdentifier.setFileName(object2.getDSSFilename());
            dSSIdentifier.setUnits(object2.getUnits());
            object2 = this.getDSSFileManagerWrapper().getRemote();
            if (!(object2 instanceof DSSFileManager)) continue;
            object2 = (DSSFileManager)object2;
            object2 = object2.readPairedDataContainer(dSSIdentifier);
            arrayList.add((PairedDataContainer)object2);
        }
        arrayList.sort(this::compareDates);
        return arrayList;
    }

    private int compareDates(PairedDataContainer object, PairedDataContainer object2) {
        object = ((PairedDataContainer)object).date;
        object2 = ((PairedDataContainer)object2).date;
        if ((object == null || ((String)object).isEmpty()) && (object2 == null || ((String)object2).isEmpty())) {
            return 0;
        }
        if (object == null || ((String)object).isEmpty()) {
            return 1;
        }
        if (object2 == null || ((String)object2).isEmpty()) {
            return -1;
        }
        try {
            Date date = b.parse((String)object);
            Date date2 = b.parse((String)object2);
            return date.compareTo(date2);
        }
        catch (ParseException parseException) {
            logger.log(Level.WARNING, parseException, () -> ObsDatasetManager.a((String)object, (String)object2));
            return 0;
        }
    }

    private List<PDCRecord> filterDuplicatePDCRecords(List<PDCRecord> object) {
        ArrayList<PDCRecord> arrayList = new ArrayList<PDCRecord>();
        object = object.iterator();
        while (object.hasNext()) {
            PDCRecord pDCRecord = (PDCRecord)object.next();
            if (!arrayList.stream().noneMatch(pDCRecord2 -> this.pdcsMatch((PDCRecord)pDCRecord2, pDCRecord))) continue;
            arrayList.add(pDCRecord);
        }
        return arrayList;
    }

    private boolean pdcsMatch(PDCRecord pDCRecord, PDCRecord pDCRecord2) {
        return pDCRecord.getDSSFilename().equalsIgnoreCase(pDCRecord2.getDSSFilename()) && this.profilePathsMatch(pDCRecord.getDSSPathname(), pDCRecord2.getDSSPathname());
    }

    private boolean profilePathsMatch(String string, String string2) {
        string = new DSSPathname(string);
        string2 = new DSSPathname(string2);
        string.setDPart("");
        string2.setDPart("");
        return string.getPathname().equalsIgnoreCase(string2.getPathname());
    }

    private List<PDCRecord> buildProfileRecord(WQObsStation wQObsStation, Set<Element> set, RssSystem rssSystem, RunTimeWindow runTimeWindow) {
        ArrayList<PDCRecord> arrayList = new ArrayList<PDCRecord>();
        Object object = wQObsStation.getVariables();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (ObsVariable)object.next();
            if (!(object2 instanceof WQObsConstituentVariable)) continue;
            List list = wQObsStation.getNetworkElements();
            Data data = object2.getSelectedData();
            if (!(data instanceof DssData)) continue;
            object2 = this.buildRecordsForElement(set, rssSystem, (WQObsConstituentVariable)object2, (DssData)data, list, runTimeWindow);
            arrayList.addAll((Collection<PDCRecord>)object2);
        }
        return arrayList;
    }

    private List<PDCRecord> buildRecordsForElement(Set<Element> set, RssSystem rssSystem, WQObsConstituentVariable wQObsConstituentVariable, DssData dssData, List<WQObsStationNetworkElement> object, RunTimeWindow runTimeWindow) {
        ArrayList<PDCRecord> arrayList = new ArrayList<PDCRecord>();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (WQObsStationNetworkElement)object.next();
            if (object2.getNetworkId() != rssSystem.getIndex() || (object2 = (Element)set.stream().filter(arg_0 -> ObsDatasetManager.a((WQObsStationNetworkElement)object2, arg_0)).findFirst().orElse(null)) == null) continue;
            object2 = this.buildRecords(dssData, (Element)object2, wQObsConstituentVariable, runTimeWindow);
            object2 = object2.iterator();
            while (object2.hasNext()) {
                PDCRecord pDCRecord = (PDCRecord)object2.next();
                if (this.containsRecord(arrayList, pDCRecord)) continue;
                arrayList.add(pDCRecord);
            }
        }
        return arrayList;
    }

    private boolean containsRecord(List<PDCRecord> object, PDCRecord pDCRecord) {
        boolean bl = false;
        object = object.iterator();
        while (object.hasNext()) {
            PDCRecord pDCRecord2 = (PDCRecord)object.next();
            if (!pDCRecord2.getDSSFilename().equalsIgnoreCase(pDCRecord.getDSSFilename()) || !pDCRecord2.getDSSPathname().equalsIgnoreCase(pDCRecord.getDSSPathname())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private List<PDCRecord> buildRecords(@Nonnull DssData dssData, @Nonnull Element element, @CheckForNull WQObsConstituentVariable wQObsConstituentVariable, @CheckForNull RunTimeWindow runTimeWindow) {
        ArrayList<PDCRecord> arrayList = new ArrayList<PDCRecord>();
        Object object = SelectionTypeUtils.a(dssData.getDssFilePath(), dssData.getDssPath(), runTimeWindow);
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (String)object.next();
            DssData dssData2 = new DssData();
            dssData2.setDssFilePath(dssData.getDssFilePath());
            dssData2.setDssPath((String)object2);
            dssData2.setUnits(dssData.getUnits());
            dssData2.setAvailableUnits(dssData.getAvailableUnits());
            dssData2.setName(dssData.getName());
            object2 = this.buildRecord(dssData2, element, wQObsConstituentVariable, runTimeWindow);
            if (object2 == null) continue;
            arrayList.add((PDCRecord)object2);
        }
        return arrayList;
    }

    private PDCRecord buildRecord(@Nonnull DssData dssData, @Nonnull Element object, @CheckForNull WQObsConstituentVariable wQObsConstituentVariable, @CheckForNull RunTimeWindow object2) {
        Object object3 = null;
        PDCDataSet$RecordBuilder pDCDataSet$RecordBuilder = new PDCDataSet$RecordBuilder();
        pDCDataSet$RecordBuilder.withIsInput(true);
        pDCDataSet$RecordBuilder.withDssFilename(dssData.getDssFilePath());
        String string = dssData.getDssPath();
        DataSource dataSource = DataSourceFactory.a((Data)dssData);
        if (dataSource instanceof PairedCurveDataSource) {
            dataSource = (PairedCurveDataSource)dataSource;
            if (object2 != null) {
                object3 = this.toDate(object2.getLookbackTime());
                object2 = this.toDate(object2.getEndTime());
                object3 = new TimeWindow((Date)object3, true, (Date)object2, true);
            }
            string = ((PairedCurveDataSource)dataSource).a((TimeWindow)object3, dssData.getDssFilePath(), null);
        }
        pDCDataSet$RecordBuilder.withDssPathname(string);
        int n = object.getIndex();
        pDCDataSet$RecordBuilder.withIndex(n);
        object3 = ((Element)object).getDisplayName();
        object2 = wQObsConstituentVariable == null ? "null" : wQObsConstituentVariable.getDisplayName();
        object = (String)object2 + ":" + (String)object3 + ":" + dssData.getName();
        pDCDataSet$RecordBuilder.withName((String)object);
        pDCDataSet$RecordBuilder.withDescription("Constituent:" + (String)object2 + ", Network Element:" + (String)object3);
        if (wQObsConstituentVariable != null) {
            pDCDataSet$RecordBuilder.withParamName(wQObsConstituentVariable.getDisplayName());
            object = dssData.getUnits();
            if (((String)object).isEmpty()) {
                object = dssData.getAvailableUnits()[0];
            }
            pDCDataSet$RecordBuilder.withUnits((String)object);
            pDCDataSet$RecordBuilder.withVarId(2000 + wQObsConstituentVariable.getConstituentId());
        } else {
            object = new DSSPathname(string);
            pDCDataSet$RecordBuilder.withParamName(object.getCPart());
        }
        return pDCDataSet$RecordBuilder.build();
    }

    private Date toDate(HecTime hecTime) {
        try {
            return a.parse(hecTime.dateAndTime(4));
        }
        catch (ParseException parseException) {
            logger.log(Level.WARNING, parseException, () -> "Error parsing date: " + hecTime.dateAndTime(4));
            return null;
        }
    }

    public static Set<Element> a(RssSystem object) {
        LinkedHashSet<Element> linkedHashSet = new LinkedHashSet<Element>();
        for (Object object2 : ((RssSystem)object).getElementVector()) {
            if (!(object2 instanceof Element)) continue;
            object2 = (Element)object2;
            linkedHashSet.add((Element)object2);
            linkedHashSet.addAll(ObsDatasetManager.a(object2));
        }
        return linkedHashSet;
    }

    public static List<Element> a(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        if (element != null) {
            for (int i = 0; i < element.getChildElementCount(); ++i) {
                Element element2 = element.getChildElementAt(i);
                arrayList.add(element2);
                arrayList.addAll(ObsDatasetManager.a(element2));
            }
        }
        return arrayList;
    }

    public boolean refreshData(Manager manager) {
        if (!(manager instanceof ObsDatasetManager)) {
            logger.log(Level.INFO, () -> "can't refresh from type " + manager.getClass().getName() + " when I'm a " + this.getClass().getName());
            return false;
        }
        Object object = (ObsDatasetManager)manager;
        object = ((ObsDatasetManager)object).getObsStationSet();
        this._obsStationSet = new WQObsStationSet();
        this._obsStationSet.setDescription(object.getDescription());
        this._obsStationSet.setName(object.getName());
        this._obsStationSet.setId(object.getId());
        this._obsStationSet.setUserDefinedVariables(new ArrayList(object.getUserDefinedVariables()));
        for (ObsStation obsStation : object.getStations()) {
            if (!(obsStation instanceof WQObsStation)) continue;
            obsStation = new WQObsStation((WQObsStation)obsStation);
            this._obsStationSet.addStation((WQObsStation)obsStation);
        }
        return super.refreshData(manager);
    }

    void updateElementNetworkIds(RssSystem rssSystem, RssSystem rssSystem2) {
        if (rssSystem == null || rssSystem2 == null) {
            return;
        }
        for (Object object : this._obsStationSet.getStations()) {
            if (!(object instanceof WQObsStation)) continue;
            object = (WQObsStation)object;
            object = object.getNetworkElements();
            object = object.iterator();
            while (object.hasNext()) {
                WQObsStationNetworkElement wQObsStationNetworkElement = (WQObsStationNetworkElement)object.next();
                if (wQObsStationNetworkElement.getNetworkId() != rssSystem2.getIndex()) continue;
                wQObsStationNetworkElement.setNetworkId(rssSystem.getIndex());
            }
        }
        ObsDatasetManager obsDatasetManager = this;
        obsDatasetManager.writeFile(obsDatasetManager.getIdentifier());
    }

    private static /* synthetic */ boolean a(WQObsStationNetworkElement wQObsStationNetworkElement, Element element) {
        return element.getIndex() == wQObsStationNetworkElement.getElementId();
    }

    private static /* synthetic */ String a(String string, String string2) {
        return "Error parsing date: " + string + " or " + string2;
    }

    private static /* synthetic */ String a(File file) {
        return "Error reading stations set from file:" + file.getAbsolutePath();
    }

    static {
        MapGlyphFactory.addMapping((String)"hec.rss.wq.model.ObsDatasetManager", (String)"hec.rss.wq.client.observeddataset.ObsStationMapGlyph");
    }
}

