/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.model;

import hec.data.TimeWindow;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DssDataType;
import hec.heclib.dss.HecDataManager;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.io.DSSIdentifier;
import hec.io.DataContainer;
import hec.io.TimeSeriesContainer;
import hec.model.RunTimeWindow;
import hec.rss.wq.model.SolarRadiationComputeException;
import hec.wqenginecore.ConversionUtils;
import hec.wqenginecore.dataSource.latlong.LatLongData;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import rma.util.RMAConst;

public class SolarRadiationUtils {
    private SolarRadiationUtils() {
    }

    public static TimeSeriesContainer a(RunTimeWindow runTimeWindow, Double d, String string, LatLongData latLongData, DSSIdentifier dSSIdentifier, DSSManager dSSManager) throws SolarRadiationComputeException {
        HecTime hecTime = runTimeWindow.getStartTime();
        runTimeWindow = runTimeWindow.getEndTime();
        HecTimeArray hecTimeArray = new HecTimeArray();
        hecTimeArray.setSize(2);
        hecTimeArray.set(0, hecTime);
        hecTimeArray.set(1, (HecTime)runTimeWindow);
        return SolarRadiationUtils.a(hecTimeArray, d, string, latLongData, dSSIdentifier, dSSManager);
    }

    public static TimeSeriesContainer a(TimeWindow timeWindow, Double d, String string, LatLongData latLongData, DSSIdentifier dSSIdentifier, DSSManager dSSManager) throws SolarRadiationComputeException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMMyyyy HHmm");
        HecTimeArray hecTimeArray = new HecTimeArray();
        hecTimeArray.setSize(2);
        hecTimeArray.set(0, simpleDateFormat.format(timeWindow.getStartDate()));
        hecTimeArray.set(1, simpleDateFormat.format(timeWindow.getEndDate()));
        return SolarRadiationUtils.a(hecTimeArray, d, string, latLongData, dSSIdentifier, dSSManager);
    }

    public static TimeSeriesContainer a(HecTimeArray object, Double d, String string, LatLongData latLongData, DSSIdentifier dSSIdentifier, DSSManager dSSManager) throws SolarRadiationComputeException {
        Double d2 = latLongData.getComputeInterval();
        int n = d2.intValue();
        long l = object.element(1).getTimeInMillis() - object.element(0).getTimeInMillis();
        long l2 = l / 1000L / 60L;
        int n2 = (int)l2 / n - 1;
        object.resizeWithInterval(1, n2, n);
        TimeSeriesContainer timeSeriesContainer = new TimeSeriesContainer();
        int n3 = object.numberElements();
        double[] dArray = new double[n3];
        double d3 = d != null ? d.doubleValue() : latLongData.getDustCoefficient();
        double d4 = latLongData.getLatitude();
        double d5 = latLongData.getLongitude();
        double d6 = latLongData.getNearestMeridian();
        timeSeriesContainer.interval = n;
        if (!RMAConst.isValidValue((double)d3)) {
            d3 = 0.0;
        }
        for (int i = 0; i < n3; ++i) {
            dArray[i] = ConversionUtils.computeSolarRaditation((HecTime)object.element(i), (double)d4, (double)d5, (double)d6, (double)d3, (double)10.0, (double)0.0);
        }
        timeSeriesContainer.set(dArray, object);
        String string2 = timeSeriesContainer.units = string != null ? string : latLongData.getUnits();
        if (dSSIdentifier != null && dSSManager != null) {
            timeSeriesContainer.fullName = dSSIdentifier.getDSSPath();
            timeSeriesContainer.fileName = dSSIdentifier.getFileName();
            DSSPathname dSSPathname = new DSSPathname(timeSeriesContainer.fullName);
            object = new int[1];
            int n4 = HecDataManager.getDssFileVersion((String)dSSIdentifier.getFileName());
            int n5 = timeSeriesContainer.interval;
            if (n4 == 7) {
                n5 = timeSeriesContainer.interval * 60;
            }
            dSSPathname.setEPart(DSSPathname.getRegularTsEPartFromInterval((int)n4, (int)n5, (int[])object));
            if (object[0] != false) {
                throw new SolarRadiationComputeException("Failed to get pathname interval (e-part) for  " + timeSeriesContainer.interval + " for timeseries: " + String.valueOf(timeSeriesContainer));
            }
            try {
                timeSeriesContainer.fullName = dSSPathname.getPathname();
                timeSeriesContainer.type = DssDataType.INST_VAL.toString();
                int n6 = dSSManager.write((DataContainer)timeSeriesContainer);
                if (n6 != 0) {
                    throw new SolarRadiationComputeException("Failed to write Solar Radiation TimeSeries " + String.valueOf(timeSeriesContainer) + " return:" + n6);
                }
            }
            catch (RemoteException remoteException) {
                throw new SolarRadiationComputeException("Failed to write Solar Radiation TimeSeries " + String.valueOf(timeSeriesContainer), remoteException);
            }
        }
        return timeSeriesContainer;
    }
}

