/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.model;

import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyList;
import hec.clientapp.model.TSDataSet;
import hec.clientapp.rmi.csinterface.HecRmiWorkspace;
import hec.io.DataContainer;
import hec.io.Identifier;
import hec.io.TimeSeriesContainer;
import hec.lang.NamedType;
import hec.lang.annotation.Scriptable;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.model.TSLocation;
import hec.model.TSRecord;
import hec.rss.RssRmiWorkspace;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.ChannelType;
import hec.rss.model.CoefRouting;
import hec.rss.model.DiversionElement;
import hec.rss.model.DivertedOutletElement;
import hec.rss.model.Element;
import hec.rss.model.Function;
import hec.rss.model.IterationBlock;
import hec.rss.model.JunctionElement;
import hec.rss.model.LagAndKRouting;
import hec.rss.model.MuskingumCunge8ptRouting;
import hec.rss.model.MuskingumCungePrismRouting;
import hec.rss.model.MuskingumCungeRouting;
import hec.rss.model.MuskingumRouting;
import hec.rss.model.NullRouting;
import hec.rss.model.OpRule;
import hec.rss.model.OutletGroupElement;
import hec.rss.model.PDCDataSet;
import hec.rss.model.PulsChannelRoutingWithLosses;
import hec.rss.model.ReachElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssAlt;
import hec.rss.model.RssNode;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssRun;
import hec.rss.model.RssSimRun;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSRecordImpl;
import hec.rss.model.Spillway;
import hec.rss.model.SsarrRouting;
import hec.rss.model.StateVariable;
import hec.rss.model.WorkingRDRouting;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.plugins.waterquality.model.RssWQTime;
import hec.rss.wq.dataSources.WQDataProvider;
import hec.rss.wq.dataSources.WQPairedDataProvider;
import hec.rss.wq.model.AltWaterQualityOptions;
import hec.rss.wq.model.CloudinessUtils;
import hec.rss.wq.model.ConstituentSetManager;
import hec.rss.wq.model.MetData;
import hec.rss.wq.model.RssComputeWQObsStation;
import hec.rss.wq.model.RssComputeWQObsStation$ObsStatOutputGeomType;
import hec.rss.wq.model.WQInputDataSetCollection;
import hec.rss.wq.model.WQInputsChecker;
import hec.rss.wq.model.WQParameterProcessor;
import hec.rss.wq.model.WqGeometry;
import hec.rss.wq.model.massinjection.MassInjectionManager;
import hec.rss.wq.model.massinjection.MassInjectionSetManager;
import hec.rss.wq.util.WqI18n;
import hec.wqenginecore.BoundaryConditionSet;
import hec.wqenginecore.ConservationType;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.ConstituentSet;
import hec.wqenginecore.DataProvider;
import hec.wqenginecore.InitialConditionSet;
import hec.wqenginecore.OutputVariableOptions;
import hec.wqenginecore.PairedDataProvider;
import hec.wqenginecore.StateVariableIdentifier;
import hec.wqenginecore.WQEngineAdapter;
import hec.wqenginecore.WQException;
import hec.wqenginecore.WQFlowComputeType;
import hec.wqenginecore.WQIO;
import hec.wqenginecore.WQParamTimeVarData;
import hec.wqenginecore.WQRoutingMethod;
import hec.wqenginecore.WQTime;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.dispersion.DispersionCoefSettings;
import hec.wqenginecore.geometry.BoundaryType;
import hec.wqenginecore.geometry.Geometry;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.SubDomainBoundary;
import hec.wqenginecore.geometry.SubDomainJunction;
import hec.wqenginecore.geometry.SubDomainType;
import hec.wqenginecore.massinjection.MassInjectionSet;
import hec.wqenginecore.massinjection.MassInjectionSite;
import hec.wqenginecore.metstation.MetStationSet;
import hec.wqenginecore.observed.ObsStation;
import hec.wqenginecore.observed.ObsStationSet;
import hec.wqenginecore.parameter.ParameterSet;
import hec.wqenginecore.parameter.ParameterSetting;
import hec.wqenginecore.parameter.ParameterSettingValue;
import hec.wqenginecore.parameter.WQParameterTimeSeriesType;
import hec.wqenginecore.parameter.WQParameterType;
import hec.wqengineimpl.WQConstituent;
import hec.wqengineimpl.WQLibraryRegistryImpl;
import hec.wqengineimpl.dispersion.WQDispersionCoefSettings;
import hec.wqengineimpl.geometry.WQGeoSubDomain;
import hec.wqengineimpl.initialCondition.WQInitialConditionSet2;
import hec.wqengineimpl.libraries.BaseWQLibrary;
import hec.wqengineimpl.observed.WQObsStation;
import hec.wqengineimpl.parameter.WQParameterSet;
import hec.wqengineimpl.parameter.WQParameterSettingDSSValue;
import hec.wqengineimpl.parameter.WQParameterSettingStateVariableValue;
import hec.wqengineimpl.parameter.WQParameterSettingTimeSeriesValue;
import hec.wqengineimpl.region.WQRegion;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import org.openide.util.lookup.Lookups;
import rma.util.RMAIO;

public class WQRun
implements RssReturnStatusConstants {
    public static final Logger logger = Logger.getLogger(WQRun.class.getName());
    private static final String _testName = "defaultTest";
    private RssSystem _rssSystem = null;
    private RssAlt _rssAlt = null;
    private RssRun _rssRun = null;
    private RssWQGeometry _wqGeo = null;
    private WqGeometry _wqGeoUI = null;
    private RssWQTime _wqTime = null;
    private WQEngineAdapter _wqEngine = null;
    private WQIO _wqio = null;
    private ConstituentSet _wqConstitSet = null;
    private BoundaryConditionSet _bcSet = null;
    private ParameterSet _wqParameterSet = null;
    private InitialConditionSet _icSet = null;
    private WQDispersionCoefSettings _dispCoefSet = null;
    private MassInjectionSet _massInjectionSet = null;
    private List<MassInjectionSite> _massInjectionSites = null;
    private MetStationSet _metDataSet = null;
    private ObsStationSet _obsDataSet = null;
    private WQFlowComputeType _flowComputeType = WQFlowComputeType.INSTANTANEOUS;
    private ArrayList<WQParamTimeVarData> _timeVaryingWQParams = new ArrayList();
    private List<RssComputeWQObsStation> _outputObsStations = new ArrayList<RssComputeWQObsStation>();
    private static final String STATE_VAR_BOUND_TEMP_SOURCE = "wq_bound_temp_src";
    private static final String STATE_VAR_INFLOW_DEPTH_STRING = "wq_inflow_depth";
    private static final String STATE_VAR_MIN_DZ_STRING = "wq_min_dz";

    public WQRun() {
        this._wqEngine = new WQEngineAdapter();
    }

    public WQRun(RssSimRun rssSimRun, RssRun rssRun) {
        this(rssSimRun.getRssAlt(), rssRun);
    }

    public WQRun(RssAlt rssAlt, RssRun rssRun) {
        this._wqEngine = new WQEngineAdapter();
        this._rssAlt = rssAlt;
        this._rssRun = rssRun;
        if (this._rssAlt != null) {
            this._rssSystem = this._rssAlt.getSystem();
        }
    }

    public void setAlternative(RssAlt rssAlt) {
        this._rssAlt = rssAlt;
    }

    @Deprecated
    public boolean runTest() {
        this._rssRun.printMessage("Running Test: defaultTest");
        try {
            this.loadData();
            this.createWQGeometry();
            this.initConstituentSet();
            this.initHDF5Output(1);
            this.initWQEngine();
            this.computeUncoupled();
            this.finalizeCompute();
        }
        catch (WQException wQException) {
            this._rssRun.printMessage("WQTest.runTest failed");
            return false;
        }
        return true;
    }

    public boolean initialize() {
        if (this.isComputeCanceled()) {
            return false;
        }
        try {
            this.initRssWQGeometry(true);
            this.loadData();
            this.initConstituentSet();
            this.initParameterSet();
            this.initInitialConditionsSet();
            this.initBoundaryConditionSet();
            this.initMetDataSet();
            this.initObsDataSet();
            this.initDispersionSet();
            this.initMassInjectionSet();
            if (this.isComputeCanceled()) {
                return false;
            }
            if (!this.checkWQRunDatasets()) {
                return false;
            }
            this.initWQEngine();
            if (this.isComputeCanceled()) {
                return false;
            }
            WQRun wQRun = this;
            wQRun.initHDF5Output(wQRun._rssSystem.getUnitSystem());
            if (this.isComputeCanceled()) {
                return false;
            }
            this.checkStateVariables();
            this.initObsStatsDssOutput();
        }
        catch (WQException wQException) {
            this.printWQErrorMessages(wQException);
            logger.log(Level.WARNING, "WQEngine Init failed", wQException);
            return false;
        }
        return true;
    }

    public boolean checkWQRunDatasets() {
        WQInputDataSetCollection wQInputDataSetCollection = new WQInputDataSetCollection();
        Object object = this._rssAlt.getSystem();
        wQInputDataSetCollection.a((RssSystem)object);
        wQInputDataSetCollection.a(this._rssAlt);
        wQInputDataSetCollection.a(this._rssRun);
        wQInputDataSetCollection.a(this._wqGeo);
        wQInputDataSetCollection.a(this._wqGeoUI);
        wQInputDataSetCollection.a(this._wqConstitSet);
        wQInputDataSetCollection.a(this._wqParameterSet);
        wQInputDataSetCollection.a(this._icSet);
        wQInputDataSetCollection.a(this._bcSet);
        wQInputDataSetCollection.a(this._metDataSet);
        wQInputDataSetCollection.a((DispersionCoefSettings)this._dispCoefSet);
        wQInputDataSetCollection.a(this._obsDataSet);
        wQInputDataSetCollection.a(this._massInjectionSet);
        if (this._massInjectionSet != null) {
            object = this.getMassInjectionSites();
            wQInputDataSetCollection.a((List<MassInjectionSite>)object);
        }
        wQInputDataSetCollection.a(this._rssRun.getRunTimeWindow());
        object = new WQInputsChecker(wQInputDataSetCollection);
        this._rssRun.printMessage("\n");
        this._rssRun.printMessage(WqI18n.a("WQRun.CheckDataSets.Header.Overall").getText());
        ((WQInputsChecker)object).b(true);
        boolean bl = !((WQInputsChecker)object).a();
        return bl;
    }

    private void loadData() throws WQException {
        this._rssSystem = null;
        if (this._rssAlt != null) {
            this._rssSystem = this._rssAlt.getSystem();
        }
        if (this._rssRun == null) {
            throw new WQException(WqI18n.a("WQRun.Init.RssRun.Error").getText());
        }
        if (this._rssSystem == null) {
            throw new WQException(WqI18n.a("WQRun.Init.RssSystem.Error").getText());
        }
        Path path = this.getRasSteadyFlowPath();
        this._rssRun.printMessage(WqI18n.a("WQRun.Init.RASSteadyFlow.Msg").format((Object)path));
        this._wqGeo.loadFlowTable(path, this._rssSystem.getUnitSystem());
    }

    private Path getRasSteadyFlowPath() {
        Path path = null;
        Object object = this._rssRun.getProxyList();
        String string = this._rssAlt.getWaterQualityOptions().getGeometryName();
        if ((object = this.getManager((ManagerProxyList)object, WqGeometry.class, string)) != null) {
            path = ((WqGeometry)((Object)object)).getSteadyFlowPath();
        }
        return path;
    }

    private void initTSrecords(RunTimeWindow runTimeWindow) throws WQException {
        if (this._rssRun == null) {
            return;
        }
        this._rssRun.clearOutputTSData();
        TSDataSet tSDataSet = this._rssRun.getRegOutputTSData();
        if (tSDataSet != null) {
            this.initTSDataSet(tSDataSet, runTimeWindow);
        }
        if ((tSDataSet = this._rssRun.getWQOutputTSData()) != null) {
            this.initTSDataSet(tSDataSet, runTimeWindow);
        }
    }

    public void initTSDataSet(TSDataSet object, RunTimeWindow runTimeWindow) throws WQException {
        object.initialize(runTimeWindow);
        object = object.getTSRecords();
        int n = object.size();
        for (int i = 0; i < n; ++i) {
            TSRecord tSRecord = (TSRecord)object.get(i);
            String string = tSRecord.getDSSPathname();
            if (string == null || string.isEmpty()) continue;
            if (tSRecord instanceof RssTSRecordImpl) {
                ((RssTSRecordImpl)tSRecord).setRssRun(this._rssRun);
            }
            try {
                tSRecord.loadTSData(runTimeWindow.getLookbackTime(), runTimeWindow.getEndTime());
                continue;
            }
            catch (Exception exception) {
                throw new WQException(WqI18n.a("WQRun.Init.TSRecord.Error").format(new Object[]{tSRecord.getName(), tSRecord.getDSSFilename(), tSRecord.getDSSPathname()}));
            }
        }
    }

    public boolean writeWQTSRecords(TSDataSet tSDataSet) {
        Object object = tSDataSet.getTSRecords();
        tSDataSet = tSDataSet.getDSSFileManager();
        object = object.iterator();
        while (object.hasNext()) {
            TSRecord tSRecord = (TSRecord)object.next();
            TimeSeriesContainer timeSeriesContainer = tSRecord.getTimeSeriesContainer();
            timeSeriesContainer.setStoreAsDoubles(true);
            try {
                tSDataSet.write((DataContainer)timeSeriesContainer);
            }
            catch (RemoteException remoteException) {
                logger.log(Level.WARNING, "Failed to write ts tsRecord " + tSRecord.getName() + "\nDSS file: " + tSRecord.getDSSFilename() + "\nDSS pathname: " + tSRecord.getDSSPathname(), remoteException);
                return false;
            }
        }
        return true;
    }

    private void createWQGeometry() throws WQException {
        this._wqGeo.createGeometry(this._rssSystem);
        this._wqGeo.createBoundaries();
        this._wqGeo.createLocalBoundaries(this._rssSystem);
        this._wqGeo.associateBoundaries();
    }

    private void initConstituentSet() throws WQException {
        this._wqConstitSet = this._rssAlt.getWaterQualityOptions().getConstituentSetManager(this._rssAlt).getSet();
        if (this._wqConstitSet == null) {
            throw new WQException(WqI18n.a("WQRun.Init.ConstitSet.Error").format((Object)this._rssAlt.getWaterQualityOptions().getConstituentName()));
        }
    }

    private void initParameterSet() throws WQException {
        ConstituentSetManager constituentSetManager = this._rssAlt.getWaterQualityOptions().getConstituentSetManager(this._rssAlt);
        this._wqParameterSet = this._rssAlt.getWaterQualityOptions().getParameterSetManager(this._rssAlt).getSet(constituentSetManager.getIndex());
        if (this._wqParameterSet == null) {
            throw new WQException(WqI18n.a("WQRun.Init.ParamSet.Error").format((Object)this._rssAlt.getWaterQualityOptions().getParametersName()));
        }
    }

    private void initBoundaryConditionSet() throws WQException {
        this._bcSet = this._rssAlt.getWaterQualityOptions().getBcManager(this._rssAlt).getSet();
        if (this._bcSet == null) {
            throw new WQException(WqI18n.a("WQRun.Init.BCSet.Error").format((Object)this._rssAlt.getWaterQualityOptions().getBcName()));
        }
    }

    private void initDispersionSet() throws WQException {
        this._dispCoefSet = this._rssAlt.getWaterQualityOptions().getDispersionSetManager(this._rssAlt).getSet();
        if (this._dispCoefSet == null) {
            throw new WQException(WqI18n.a("WQRun.Init.DispSet.Error").format((Object)this._rssAlt.getWaterQualityOptions().getDispersionCoefName()));
        }
    }

    private void initObsDataSet() throws WQException {
        String string = this._rssAlt.getWaterQualityOptions().getObservedDataName();
        if (string != null) {
            this._obsDataSet = this._rssAlt.getWaterQualityOptions().getObservedDataSetManager(this._rssAlt).getObsStationSet();
            if (this._obsDataSet == null) {
                throw new WQException(WqI18n.a("WQRun.Init.ObsSet.Error").format((Object)string));
            }
        }
    }

    private void initMetDataSet() throws WQException {
        String string = this._rssAlt.getWaterQualityOptions().getMetDataName();
        if (string != null) {
            this._metDataSet = this._rssAlt.getWaterQualityOptions().getMetDataManager(this._rssAlt).getMetStationSet();
            if (this._metDataSet == null) {
                throw new WQException(WqI18n.a("WQRun.Init.MetDataSet.Error").format((Object)string));
            }
            string = CloudinessUtils.DSS_OUTPUT_INTERVAL;
            MetData.a(this._metDataSet, this._rssRun.getRunTimeWindow(), this._rssRun.getDSSOutputFile(), this._rssRun.getDSSFileManager(), string);
        }
    }

    private void initMassInjectionSet() throws WQException {
        String string = this._rssAlt.getWaterQualityOptions().getMassInjectionName();
        if (string != null) {
            this._massInjectionSet = this._rssAlt.getWaterQualityOptions().getMassInjectionSetManager(this._rssAlt).getSet();
            if (this._massInjectionSet == null) {
                throw new WQException(WqI18n.a("WQRun.Init.MassInject.Error").format((Object)string));
            }
            this._massInjectionSites = this.getMassInjectionSites();
        }
    }

    private void initRssWQGeometry(boolean bl) throws WQException {
        this._wqGeo = this._rssAlt.getWaterQualityOptions().getGeometryManager(this._rssAlt).getRssWqGeometry();
        String string = this._rssAlt.getWaterQualityOptions().getGeometryName();
        if (this._wqGeo == null) {
            throw new WQException(WqI18n.a("WQRun.Init.WQGeom.Error").format((Object)string));
        }
        ManagerProxyList managerProxyList = this._rssAlt.getProxyList();
        String string2 = this._rssAlt.getWaterQualityOptions().getGeometryName();
        this._wqGeoUI = this.getManager(managerProxyList, WqGeometry.class, string2);
        if (this._wqGeoUI == null) {
            throw new WQException(WqI18n.a("WQRun.Init.WQGeomUI.Error").format((Object)string));
        }
    }

    @Scriptable
    public RssWQGeometry getRssWQGeometry() {
        if (this._wqGeo == null) {
            try {
                this.initRssWQGeometry(false);
            }
            catch (WQException wQException) {
                logger.log(Level.WARNING, "Failed to get RssWQGeometry", wQException);
            }
        }
        return this._wqGeo;
    }

    public ObsStationSet getObsStationSet() {
        if (this._obsDataSet == null) {
            try {
                this.initObsDataSet();
            }
            catch (WQException wQException) {
                String string = WqI18n.a("WQRun.Init.ObsSet.Error").format((Object)this._obsDataSet.getName());
                logger.log(Level.WARNING, string, wQException);
                this._rssRun.printWarningMessage(string);
            }
        }
        return this._obsDataSet;
    }

    public List<RssComputeWQObsStation> getOutputObsStations() {
        return this._outputObsStations;
    }

    private void initInitialConditionsSet() throws WQException {
        this._icSet = this._rssAlt.getWaterQualityOptions().getInitialConditionsSetManager(this._rssAlt).getSet();
        if (this._icSet == null) {
            throw new WQException(WqI18n.a("WQRun.Init.ICSet.Error").format((Object)this._rssAlt.getWaterQualityOptions().getIcName()));
        }
    }

    private List<MassInjectionSite> getMassInjectionSites() {
        Object object = this._rssAlt.getWaterQualityOptions().getMassInjectionSetManager(this._rssAlt);
        Object object2 = this.getMassInjectionSiteManager();
        if (object != null && object2 != null) {
            object2 = object2.getMassInjectionSites();
            object2 = new ArrayList(object2);
            object = ((MassInjectionSetManager)object).getSet().getMassInjectionSiteList((List)object2);
            return object;
        }
        return null;
    }

    private MassInjectionManager getMassInjectionSiteManager() {
        RssRmiWorkspace rssRmiWorkspace = (RssRmiWorkspace)((Object)this._rssRun.getWorkspace().getRemote());
        MassInjectionManager massInjectionManager = null;
        try {
            rssRmiWorkspace = rssRmiWorkspace.getChildWorkspace("");
            if (rssRmiWorkspace instanceof HecRmiWorkspace && (rssRmiWorkspace = ((HecRmiWorkspace)rssRmiWorkspace).getBaseWorkspace()) != null) {
                rssRmiWorkspace = (RssRmiWorkspace)rssRmiWorkspace.getChildWorkspace("rss");
                Vector vector = (rssRmiWorkspace = rssRmiWorkspace.getManagers()).getManagerIDList(MassInjectionManager.class.getName());
                if (!vector.isEmpty() && (vector = (Identifier)vector.elementAt(0)) != null && (massInjectionManager = (MassInjectionManager)(rssRmiWorkspace = rssRmiWorkspace.getManager((Identifier)vector)).loadManager(null, null)) == null) {
                    this._rssRun.printErrorMessage(WqI18n.a("WQRun.Init.MassInjectMan.Error").getText());
                }
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("WQRun: exception getting base wksp options" + String.valueOf(remoteException));
            this._rssRun.printErrorMessage(WqI18n.a("WQRun.Init.BaseWorkspace.Error").getText());
            return null;
        }
        return massInjectionManager;
    }

    private void initHDF5Output(int n) throws WQException {
        Object object = RMAIO.userNameToFileName((String)this._rssRun.getName()) + ".h5";
        String string = this._rssAlt.getWorkspacePath();
        object = Paths.get(string, new String[]{"rss", object});
        this._wqio = new WQIO(object.toString());
        object = this._wqEngine.getVersionNumber();
        this._wqio.init((String)object);
        this._wqio.writeGeoHDF5((Geometry)this._wqGeo);
        object = this._rssAlt.getWaterQualityOptions();
        int n2 = ((AltWaterQualityOptions)object).getNumberOutputTimeSteps();
        OutputVariableOptions outputVariableOptions = ((AltWaterQualityOptions)object).getOutputVariableOptions();
        RunTimeWindow runTimeWindow = this._rssRun.getRunTimeWindow();
        int n3 = ((AltWaterQualityOptions)object).getTimestepMinutes();
        this._wqio.initHDF5Results((Geometry)this._wqGeo, this._wqConstitSet, n, outputVariableOptions, this._wqEngine, runTimeWindow, n2, n3);
    }

    private void initWQEngine() throws WQException {
        Object object = RMAIO.userNameToFileName((String)this._rssRun.getName()) + ".wqEngineLog";
        String string = this._rssAlt.getWorkspacePath();
        object = Paths.get(string, new String[]{"rss", object});
        object = object.toString();
        this._wqEngine.setLogFile((String)object);
        int n = this._rssSystem.getUnitSystem();
        this._wqEngine.initCompute(n);
        n = -1;
        int n2 = 1;
        int n3 = ConservationType.CONSERVE_MASS.getId();
        AltWaterQualityOptions altWaterQualityOptions = this._rssAlt.getWaterQualityOptions();
        if (altWaterQualityOptions != null) {
            n = altWaterQualityOptions.getNumberThreads();
            if (!altWaterQualityOptions.getFirstOrderSolution()) {
                n2 = 2;
            }
            if (altWaterQualityOptions.getPreserveConcentration()) {
                n3 = ConservationType.CONSERVE_CONCENTRATION.getId();
            }
        }
        this._wqEngine.setNumThreads(n);
        this._wqEngine.setSolutionOrder(n2);
        this._wqEngine.setConservationType(n3);
        if (Boolean.getBoolean("reservoirThermalMixingOff")) {
            this._wqEngine.setResThermalMixing(false);
        }
        this._wqEngine.setGeoData((Geometry)this._wqGeo);
        this.setRoutingData();
        this._wqEngine.setBoundaryGeoData((Geometry)this._wqGeo);
        this._wqEngine.setWQControlDeviceData((Geometry)this._wqGeo);
        this._wqGeo.updateWQJunctionsForExtent();
        this._wqEngine.setWQJnctGeoData((Geometry)this._wqGeo);
        this._wqEngine.setWQRegions((Geometry)this._wqGeo);
        this._wqTime = new RssWQTime();
        Object object2 = this._rssRun.getRunTimeWindow();
        this._wqTime.setWQTimeFromRTW((RunTimeWindow)object2);
        n2 = altWaterQualityOptions.getTimestep();
        n3 = altWaterQualityOptions.getTimestepIncrement();
        this._wqTime.setWQTimeStep(n2, n3);
        this._wqEngine.setRunTimeInfo((WQTime)this._wqTime);
        TSDataSet tSDataSet = this._rssRun.getInputWQTSDataSet(true);
        this.initTSDataSet(tSDataSet, (RunTimeWindow)object2);
        object2 = this._rssRun.getInputWQPDCDataSet();
        this.setParamFilePaths();
        Object object3 = altWaterQualityOptions.getOutputVariableOptions() != null ? altWaterQualityOptions.getOutputVariableOptions() : new OutputVariableOptions();
        this._wqEngine.setWQConstituentData(this._wqConstitSet, object3);
        object3 = ((WQParameterSet)this._wqParameterSet).getParametersForConstituentSet(this._wqConstitSet);
        this._wqEngine.setWQParameterData(this._wqParameterSet, (Geometry)this._wqGeo, (Set)object3, this._timeVaryingWQParams);
        if (this._wqConstitSet.usesNSM1()) {
            this._wqEngine.setLightFieldParams();
        }
        if (this._metDataSet != null) {
            this._wqEngine.setMetStations(this._metDataSet, (Geometry)this._wqGeo);
            object3 = new WQDataProvider(tSDataSet);
            this._wqEngine.setMetData(this._metDataSet, (DataProvider)object3, (WQTime)this._wqTime);
        }
        object3 = new WQDataProvider(tSDataSet);
        this._wqEngine.setBoundaryConcentrations(this._bcSet, this._wqConstitSet, (Geometry)this._wqGeo, (DataProvider)object3, (WQTime)this._wqTime);
        if (this._icSet instanceof WQInitialConditionSet2) {
            tSDataSet = (WQInitialConditionSet2)this._icSet;
            object2 = new WQPairedDataProvider((PDCDataSet)((Object)object2), this._wqTime);
            tSDataSet.setPairedDataProvider((PairedDataProvider)object2);
        }
        this._wqEngine.setInitialConditions(this._icSet, (Geometry)this._wqGeo, this._wqConstitSet);
        this._wqEngine.setDispersionDataReaches((DispersionCoefSettings)this._dispCoefSet, (Geometry)this._wqGeo);
        this._wqEngine.setDispersionDataReservoirs((DispersionCoefSettings)this._dispCoefSet, (Geometry)this._wqGeo);
        if (this._massInjectionSet != null && this._massInjectionSites != null) {
            this._wqEngine.setMassInjectionData(this._massInjectionSet, this._massInjectionSites, (Geometry)this._wqGeo, this._wqConstitSet, (DataProvider)object3, (WQTime)this._wqTime);
        }
        this._wqEngine.finalizeInitialization();
    }

    private void checkStateVariables() {
        Object object = this._rssSystem.getStateVariableList();
        Iterator<StateVariable> iterator = object.iterator();
        while (iterator.hasNext()) {
            StateVariable stateVariable;
            object = iterator.next();
            object = object;
            object = stateVariable.getName();
            if (((String)object).startsWith("wq_shading_coef")) {
                this._rssRun.printWarningMessage(WqI18n.a("WQRun.Init.ShadingStateVar.Warning").format(object));
            }
            if (((String)object).startsWith("wq_sheltering_coef")) {
                this._rssRun.printWarningMessage(WqI18n.a("WQRun.Init.ShelteringStateVar.Warning").format(object));
            }
            if (((String)object).startsWith("wq_entrain_coef")) {
                this._rssRun.printWarningMessage(WqI18n.a("WQRun.Init.EntrainmentStateVar.Warning").format(object));
            }
            if (((String)object).startsWith("wq_ssc")) {
                this._rssRun.printWarningMessage(WqI18n.a("WQRun.Init.SscStateVar.Warning").format(object));
            }
            if (!((String)object).startsWith("wq_tcd")) continue;
            this._rssRun.printWarningMessage(WqI18n.a("WQRun.Init.TcdStateVar.Warning").format(object));
        }
    }

    private void initObsStatsDssOutput() {
        if (this._obsDataSet != null) {
            this._outputObsStations.clear();
            Collection collection = this._wqConstitSet.getConstituentList();
            Object object = this._obsDataSet.getActiveStations();
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (ObsStation)object.next();
                object2 = (WQObsStation)object2;
                object2 = new RssComputeWQObsStation((WQObsStation)object2);
                WQRun wQRun = this;
                ((RssComputeWQObsStation)((Object)object2)).a(this._rssSystem, wQRun, wQRun._wqGeo, collection);
                if (!((RssComputeWQObsStation)((Object)object2)).a()) continue;
                this._outputObsStations.add((RssComputeWQObsStation)((Object)object2));
                object2 = ((RssComputeWQObsStation)((Object)object2)).h();
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    String string = (String)object2.next();
                    this._rssRun.printWarningMessage(string);
                }
            }
        }
    }

    public Set<StateVariable> getWQStateVariables(IterationBlock iterationBlock) {
        HashSet<StateVariable> hashSet = new HashSet<StateVariable>();
        for (WQParamTimeVarData n : this._timeVaryingWQParams) {
            ParameterSetting parameterSetting = n.paramSetting;
            WQParameterType wQParameterType = (parameterSetting = parameterSetting.getParameterValue()).getType();
            if (wQParameterType != WQParameterType.TimeSeries || (wQParameterType = (WQParameterSettingTimeSeriesValue)parameterSetting).getTimeSeriesType() != WQParameterTimeSeriesType.StateVariable) continue;
            boolean bl = false;
            int n2 = n.regionId;
            Object object2 = this._wqGeo.getRegionSet();
            WQRegion wQRegion = (WQRegion)object2.getRegion(n2);
            Set set = wQRegion.getElements();
            for (Object object2 : set) {
                int n3 = object2.getSubDomain((Geometry)this._wqGeo).getElementId();
                if (!iterationBlock.a(n3)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            StateVariableIdentifier stateVariableIdentifier = (StateVariableIdentifier)((WQParameterSettingStateVariableValue)parameterSetting).getValue();
            object2 = this._rssRun.getNetwork().getStateVariable(stateVariableIdentifier.getIndex());
            if (object2 != null) {
                ((StateVariable)object2).setAlwaysCompute(true);
                hashSet.add((StateVariable)object2);
                continue;
            }
            this._rssRun.printWarningMessage(WqI18n.a("WQRun.Init.StateVarNotFound.Warning").format((Object)stateVariableIdentifier.getName()));
        }
        return hashSet;
    }

    private int getFlowComputeType() throws WQException {
        int n = -1;
        int n2 = this._rssAlt.getFlowComputeType();
        if (n2 == 0) {
            n2 = this._rssAlt.getComputedFlowComputeType();
        }
        if (n2 == 0) {
            throw new WQException(WqI18n.a("WQRun.Init.FlowCompType.Error").getText());
        }
        if (n2 == 1) {
            n = WQFlowComputeType.PERIOD_AVERAGE.id();
            this._flowComputeType = WQFlowComputeType.PERIOD_AVERAGE;
        } else if (n2 == 2) {
            n = WQFlowComputeType.INSTANTANEOUS.id();
            this._flowComputeType = WQFlowComputeType.INSTANTANEOUS;
        }
        return n;
    }

    private void setRoutingData() throws WQException {
        Object object = this._wqGeo.getSubDomainsInExtent();
        object = object.iterator();
        while (object.hasNext()) {
            NamedType namedType;
            SubDomain subDomain = (SubDomain)object.next();
            if (subDomain.getType() != SubDomainType.REACH_1D || !((namedType = this._rssSystem.getElement(subDomain.getElementId())) instanceof ReachElement)) continue;
            namedType = (ReachElement)namedType;
            ((ReachElement)namedType).initializeRoutingForWQ(this._rssSystem.getRssRun().getRunTimeWindow());
            namedType = namedType.getFunction();
            if ((namedType = this.getWQReachRoutingMethod((Function)namedType)) == null) continue;
            this._wqEngine.setReachRoutingInfo(subDomain, namedType.id());
        }
    }

    private WQRoutingMethod getWQReachRoutingMethod(Function function) {
        if (function instanceof NullRouting) {
            return WQRoutingMethod.NULL_ROUTING;
        }
        if (function instanceof CoefRouting) {
            return WQRoutingMethod.COEF_ROUTING;
        }
        if (function instanceof MuskingumRouting) {
            return WQRoutingMethod.MUSK_ROUTING;
        }
        if (function instanceof MuskingumCungeRouting) {
            if (((MuskingumCungeRouting)function).getChannelType() == ChannelType.EIGHT_POINT) {
                return WQRoutingMethod.MUSK8PT_ROUTING;
            }
            if (((MuskingumCungeRouting)function).getChannelType() == ChannelType.CIRCLE || ((MuskingumCungeRouting)function).getChannelType() == ChannelType.TRAPEZOID) {
                return WQRoutingMethod.MUSKPRISM_ROUTING;
            }
            return WQRoutingMethod.MUSK_ROUTING;
        }
        if (function instanceof MuskingumCunge8ptRouting) {
            return WQRoutingMethod.MUSK8PT_ROUTING;
        }
        if (function instanceof MuskingumCungePrismRouting) {
            return WQRoutingMethod.MUSKPRISM_ROUTING;
        }
        if (function instanceof WorkingRDRouting) {
            return WQRoutingMethod.WORKINGRD_ROUTING;
        }
        if (function instanceof PulsChannelRoutingWithLosses) {
            return WQRoutingMethod.MODPULS_ROUTING;
        }
        if (function instanceof SsarrRouting) {
            return WQRoutingMethod.SSARR_ROUTING;
        }
        if (function instanceof LagAndKRouting) {
            return WQRoutingMethod.VARLAGK_ROUTING;
        }
        return null;
    }

    public void printWQErrorMessages(WQException object) {
        if (object.isNativeException()) {
            this._rssRun.printLogMessage(WqI18n.a("WQRun.WQNative.Exception").getText());
            this._rssRun.printLogMessage(object.getNativeExceptionMessage());
            this._rssRun.printErrorMessage(WqI18n.a("WQRun.WQNative.Exception").getText());
            this._rssRun.printErrorMessage(object.getNativeExceptionMessage());
        }
        if (object.getMessage() != null) {
            this._rssRun.printLogMessage(object.getMessage());
            this._rssRun.printErrorMessage(object.getMessage());
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        object.printStackTrace(printWriter);
        printWriter.flush();
        object = stringWriter.toString();
        this._rssRun.printLogMessage((String)object);
    }

    private <T extends Manager> T getManager(ManagerProxyList object, Class<T> clazz, String string) {
        object = this.getProxies((ManagerProxyList)object, clazz);
        object = object.stream().filter(managerProxy -> Objects.equals(string, managerProxy.getName())).map(managerProxy -> managerProxy.loadManager(null, null)).findFirst().orElse(null);
        return (T)object;
    }

    private List<ManagerProxy> getProxies(ManagerProxyList managerProxyList, Class clazz) {
        List<Object> list = Collections.emptyList();
        Collection collection = null;
        if (managerProxyList != null) {
            collection = managerProxyList.getManagerIDList(clazz.getName());
        }
        if (collection != null) {
            list = collection.stream().map(arg_0 -> ((ManagerProxyList)managerProxyList).getManagerProxy(arg_0)).collect(Collectors.toList());
        }
        return list;
    }

    public RssRun getRssRun() {
        return this._rssRun;
    }

    public boolean isComputeCanceled() {
        boolean bl = false;
        if (this._rssRun != null && this._rssRun.isCanceled()) {
            bl = true;
            this._rssRun.printWarningMessage(WqI18n.a("WQRun.Canceled.Run.Msg").getText());
        }
        if (this._rssSystem != null && !bl && this._rssSystem.isComputeCanceled()) {
            bl = true;
            this._rssRun.printWarningMessage(WqI18n.a("WQRun.Canceled.System.Msg").getText());
        }
        if (this._rssAlt != null && !bl && this._rssAlt.isCanceled()) {
            bl = true;
            this._rssRun.printWarningMessage(WqI18n.a("WQRun.Canceled.Alt.Msg").getText());
        }
        return bl;
    }

    public boolean computeUncoupled() {
        if (this.isComputeCanceled()) {
            return false;
        }
        this._rssRun.printMessage("\n");
        this._rssRun.printMessage(WqI18n.a("WQRun.Simulation.Start.Msg").getText());
        List<RunTimeWindow> list = this._rssRun.getTimeBlocks();
        for (int i = 0; i < list.size(); ++i) {
            if (list.size() > 1) {
                this._rssRun.printMessage("\n  Time Block " + (i + 1) + " of " + list.size());
            }
            RunTimeWindow runTimeWindow = list.get(i);
            try {
                int n;
                int n2;
                OutputVariableOptions outputVariableOptions;
                this._rssRun.printStatus("Loading Input time-series");
                this.initTSrecords(runTimeWindow);
                this._wqTime.setTimeOffset(runTimeWindow, this._rssRun.getRunTimeWindow());
                long l = System.currentTimeMillis();
                this.initHydro(i);
                AltWaterQualityOptions altWaterQualityOptions = this._rssAlt.getWaterQualityOptions();
                if (altWaterQualityOptions != null) {
                    outputVariableOptions = altWaterQualityOptions.getOutputVariableOptions();
                    n2 = altWaterQualityOptions.getNumberOutputTimeSteps();
                } else {
                    outputVariableOptions = new OutputVariableOptions();
                    n2 = 1;
                }
                this._wqTime.setCurrentTimeForStep(0, 0);
                this._wqEngine.saveState(WQEngineAdapter.STATE.TRIAL);
                if (i == 0) {
                    this._wqio.saveSnapshot(this._wqEngine, (Geometry)this._wqGeo, this._wqConstitSet, (WQTime)this._wqTime, WQTime.TIME_STEP_INFO.START_AND_END_OF_STEP, 0, outputVariableOptions);
                } else {
                    this._wqEngine.restoreState(WQEngineAdapter.STATE.TIMEBLOCK);
                }
                int n3 = runTimeWindow.getForecastSteps();
                int n4 = runTimeWindow.getNumLookbackSteps();
                int n5 = this._wqTime.getWqStepsPerHydroStep();
                int n6 = this._wqTime.getRedoSteps();
                TSDataSet tSDataSet = this._rssRun.getWQOutputTSData();
                for (n = 0; n < n3; ++n) {
                    if (this.isComputeCanceled()) {
                        return false;
                    }
                    if (n % 10 == 0) {
                        float f = (float)n / (float)n3 * 100.0f;
                        this._rssRun.printStatus(WqI18n.a("WQRun.Simulation.Status.Msg").format((Object)String.format("%.1f", Float.valueOf(f))));
                    }
                    int n7 = n + n4 + 1;
                    WQRun wQRun = this;
                    this._wqGeo.setHydroForStep(this._rssSystem, this._rssRun, wQRun, wQRun._wqEngine, this._flowComputeType, n7);
                    this._wqEngine.updateHydro((Geometry)this._wqGeo, WQTime.TIME_STEP_INFO.START_AND_END_OF_STEP.id);
                    if (n < n6) continue;
                    this.passStateVariables(n7);
                    int n8 = (n + this._wqTime.getOffset()) * n5 + 1;
                    for (int j = 0; j < n5; ++j) {
                        this.updateWQParameters(runTimeWindow, n7, n + j);
                        this._wqEngine.computeStep(n + this._wqTime.getOffset(), j);
                        this._wqTime.setCurrentTimeForStep(n, j + 1);
                        if ((j + 1) % n2 != 0) continue;
                        this._wqio.saveSnapshot(this._wqEngine, (Geometry)this._wqGeo, this._wqConstitSet, (WQTime)this._wqTime, WQTime.TIME_STEP_INFO.END_OF_STEP, n8, outputVariableOptions);
                        ++n8;
                    }
                    this._wqTime.setCurrentTimeForStep(n + 1, 0);
                    this.outputWQToDSS(tSDataSet, n7);
                }
                this._wqEngine.saveState(WQEngineAdapter.STATE.TIMEBLOCK);
                long l2 = System.currentTimeMillis();
                double d = (double)(l2 - l) / 1000.0;
                this._rssRun.printMessage(WqI18n.a("WQRun.Simulation.CompTime.Msg").format((Object)String.format("%.1f", d)));
                if (n != n3) {
                    this._rssRun.printWarningMessage(WqI18n.a("WQRun.Simulation.Incomplete.Msg").format((Object)n));
                }
                if (i == list.size() - 1) continue;
                this.writeWQTSRecords(tSDataSet);
                continue;
            }
            catch (WQException wQException) {
                this._rssRun.printErrorMessage(WqI18n.a("WQRun.Simulation.Fail.Msg").getText());
                this.printWQErrorMessages(wQException);
                return false;
            }
        }
        return true;
    }

    private void initHydro(int n) throws WQException {
        int n2;
        if (n == 0) {
            n2 = this.getFlowComputeType();
            this._wqEngine.setFlowComputeType(n2);
        }
        WQRun wQRun = this;
        this._wqGeo.initHydro(this._rssSystem, this._rssRun, wQRun, wQRun._wqEngine, this._flowComputeType);
        for (n2 = 1; n2 < this._wqTime.getNumLookbackSteps() + 1; ++n2) {
            WQRun wQRun2 = this;
            this._wqGeo.setHydroForStep(this._rssSystem, this._rssRun, wQRun2, wQRun2._wqEngine, this._flowComputeType, n2);
        }
        this._wqEngine.updateHydro((Geometry)this._wqGeo, WQTime.TIME_STEP_INFO.START_OF_STEP.id);
        this._wqEngine.updateHydro((Geometry)this._wqGeo, WQTime.TIME_STEP_INFO.END_OF_STEP.id);
        if (n == 0) {
            this._wqEngine.setInitialCellVolumes((Geometry)this._wqGeo);
        }
    }

    private void outputWQToDSS(TSDataSet tSDataSet, int n) throws WQException {
        this.outputWQToDSSJncts(tSDataSet, n);
        this.outputWQToDSSReaches(tSDataSet, n);
        this.outputWQToDSSDiversions(tSDataSet, n);
        this.outputWQToDSSResOutlets(tSDataSet, n);
        this.outputWQToDSSObsStations(tSDataSet, n);
    }

    private void outputWQToDSSJncts(TSDataSet tSDataSet, int n) throws WQException {
        List list = this._wqGeo.getWQJunctionsInExtent();
        Collection collection = this._wqConstitSet.getConstituentList();
        for (SubDomainJunction subDomainJunction : list) {
            int n2 = subDomainJunction.getId();
            int n3 = subDomainJunction.getJnctId();
            JunctionElement junctionElement = (JunctionElement)this._rssSystem.getElement(n3);
            RssNode rssNode = junctionElement.getDownstreamNode();
            for (Constituent constituent : collection) {
                int n4 = constituent.getId();
                double d = this._wqEngine.getConstitResultAtJnct(n2, n4);
                if (d == -9999.0) {
                    d = Double.NEGATIVE_INFINITY;
                }
                this.outputWQValToDSSRec(constituent, rssNode, tSDataSet, n, d);
            }
        }
    }

    private void outputWQToDSSReaches(TSDataSet tSDataSet, int n) throws WQException {
        List list = this._wqGeo.getSubDomainsInExtent();
        Collection collection = this._wqConstitSet.getConstituentList();
        for (SubDomain subDomain : list) {
            if (subDomain.getType() == SubDomainType.RESERVOIR_1DV) continue;
            int n2 = subDomain.getId();
            int n3 = subDomain.getElementId();
            ReachElement reachElement = (ReachElement)this._rssSystem.getElement(n3);
            RssNode rssNode = ((Element)reachElement).getDownstreamNode();
            for (Constituent constituent : collection) {
                int n4 = constituent.getId();
                double d = this._wqEngine.getConstitResultAtReachEnd(n2, n4);
                if (d == -9999.0) {
                    d = Double.NEGATIVE_INFINITY;
                }
                this.outputWQValToDSSRec(constituent, rssNode, tSDataSet, n, d);
            }
        }
    }

    private void outputWQToDSSDiversions(TSDataSet tSDataSet, int n) throws WQException {
        List list2 = this._wqGeo.getBoundariesInExtent();
        Collection collection = this._wqConstitSet.getConstituentList();
        block0: for (List list2 : list2) {
            List list3 = list2;
            if (list2.getBoundaryType() != BoundaryType.LOCAL_DIVERSION) continue;
            int n2 = list3.getJnctId();
            int n3 = list3.getId();
            Element element = this._rssSystem.getElement(n2);
            if (!(element instanceof JunctionElement)) continue;
            element = (JunctionElement)element;
            new Vector();
            Vector vector = ((JunctionElement)element).getDiversions(null);
            int n4 = vector.size();
            for (int i = 0; i < n4; ++i) {
                TSLocation tSLocation = (DiversionElement)vector.elementAt(i);
                Object object = tSLocation.getName();
                tSLocation = ((Element)tSLocation).getUpstreamNode();
                object = element.getName() + " - " + (String)object;
                if (!((String)object).equals(list3.getName())) continue;
                for (Constituent constituent : collection) {
                    int n5 = constituent.getId();
                    double d = this._wqEngine.getConstitResultAtBoundary(n3, n5);
                    if (d == -9999.0) {
                        d = Double.NEGATIVE_INFINITY;
                    }
                    this.outputWQValToDSSRec(constituent, (RssNode)tSLocation, tSDataSet, n, d);
                }
                continue block0;
            }
        }
    }

    private void outputWQToDSSResOutlets(TSDataSet tSDataSet, int n) throws WQException {
        List list = this._wqGeo.getSubDomainsInExtent();
        Collection collection = this._wqConstitSet.getConstituentList();
        for (Object object : list) {
            if (object.getType() == SubDomainType.REACH_1D) continue;
            int n2 = object.getId();
            int n3 = object.getElementId();
            object = (ReservoirElement)this._rssSystem.getElement(n3);
            ArrayList<RssNode> arrayList = this.getReservoirOutletNodes((ReservoirElement)object);
            int n4 = arrayList.size();
            for (Constituent constituent : collection) {
                int n5 = constituent.getId();
                object = this._wqEngine.getConstitResultOutlets(n2, n5, n4);
                for (int i = 0; i < n4; ++i) {
                    RssNode rssNode = arrayList.get(i);
                    Object object2 = object[i] == -9999.0 ? Double.NEGATIVE_INFINITY : (Object)object[i];
                    this.outputWQValToDSSRec(constituent, rssNode, tSDataSet, n, (double)object2);
                }
            }
        }
    }

    private void outputWQToDSSObsStations(TSDataSet tSDataSet, int n) throws WQException {
        Collection collection = this._wqConstitSet.getConstituentList();
        for (RssComputeWQObsStation rssComputeWQObsStation : this._outputObsStations) {
            Object object = rssComputeWQObsStation.e();
            object = collection.stream().filter(arg_0 -> ((WQObsStation)object).hasConstituent(arg_0)).collect(Collectors.toList());
            if (rssComputeWQObsStation.g() == RssComputeWQObsStation$ObsStatOutputGeomType.REACH) {
                this.outputWQObsStatReach(tSDataSet, n, rssComputeWQObsStation, (Collection<Constituent>)object);
                continue;
            }
            if (rssComputeWQObsStation.g() == RssComputeWQObsStation$ObsStatOutputGeomType.JUNCTION) {
                this.outputWQObsStatJnct(tSDataSet, n, rssComputeWQObsStation, (Collection<Constituent>)object);
                continue;
            }
            if (rssComputeWQObsStation.g() == RssComputeWQObsStation$ObsStatOutputGeomType.BOUNDARY) {
                this.outputWQObsStatBdry(tSDataSet, n, rssComputeWQObsStation, (Collection<Constituent>)object);
                continue;
            }
            if (rssComputeWQObsStation.g() != RssComputeWQObsStation$ObsStatOutputGeomType.RES_OUTLET) continue;
            this.outputWQObsStatResOutlet(tSDataSet, n, rssComputeWQObsStation, (Collection<Constituent>)object);
        }
    }

    private void outputWQObsStatJnct(TSDataSet tSDataSet, int n, RssComputeWQObsStation rssComputeWQObsStation, Collection<Constituent> object) throws WQException {
        RssNode rssNode = rssComputeWQObsStation.d();
        int n2 = rssComputeWQObsStation.f();
        object = object.iterator();
        while (object.hasNext()) {
            Constituent constituent = (Constituent)object.next();
            int n3 = constituent.getId();
            double d = this._wqEngine.getConstitResultAtJnct(n2, n3);
            if (d == -9999.0) {
                d = -3.4028234663852886E38;
            }
            this.outputWQValToDSSRec(constituent, rssNode, tSDataSet, n, d);
        }
    }

    private void outputWQObsStatReach(TSDataSet tSDataSet, int n, RssComputeWQObsStation object, Collection<Constituent> object2) throws WQException {
        RssNode rssNode = object.d();
        int n2 = object.f();
        int n3 = object.c();
        int n4 = object.b();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Constituent constituent = (Constituent)object2.next();
            int n5 = constituent.getId();
            double[] dArray = this._wqEngine.getConstitResult(n2, n5, WQTime.TIME_STEP_INFO.END_OF_STEP.id, n4);
            object = dArray;
            double d = dArray[n3];
            if (d == -9999.0) {
                d = -3.4028234663852886E38;
            }
            this.outputWQValToDSSRec(constituent, rssNode, tSDataSet, n, d);
        }
    }

    private void outputWQObsStatBdry(TSDataSet tSDataSet, int n, RssComputeWQObsStation rssComputeWQObsStation, Collection<Constituent> object) throws WQException {
        RssNode rssNode = rssComputeWQObsStation.d();
        int n2 = rssComputeWQObsStation.f();
        object = object.iterator();
        while (object.hasNext()) {
            Constituent constituent = (Constituent)object.next();
            int n3 = constituent.getId();
            double d = this._wqEngine.getConstitResultAtBoundary(n2, n3);
            if (d == -9999.0) {
                d = -3.4028234663852886E38;
            }
            this.outputWQValToDSSRec(constituent, rssNode, tSDataSet, n, d);
        }
    }

    private void outputWQObsStatResOutlet(TSDataSet tSDataSet, int n, RssComputeWQObsStation object, Collection<Constituent> object2) throws WQException {
        RssNode rssNode = object.d();
        int n2 = object.f();
        int n3 = object.c();
        int n4 = object.b();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Constituent constituent = (Constituent)object2.next();
            int n5 = constituent.getId();
            double[] dArray = this._wqEngine.getConstitResultOutlets(n2, n5, n4);
            object = dArray;
            double d = dArray[n3];
            if (d == -9999.0) {
                d = -3.4028234663852886E38;
            }
            this.outputWQValToDSSRec(constituent, rssNode, tSDataSet, n, d);
        }
    }

    private void outputWQValToDSSRec(Constituent constituent, RssNode object, TSDataSet tSDataSet, int n, double d) {
        int n2 = constituent.getId() + 2000;
        TSRecord tSRecord = tSDataSet.getTSRecord((String)(object = ((RssNode)object).getTSRecordProxy(n2).getName()), n2);
        if (tSRecord != null) {
            tSRecord.setCurrentValue(n, d);
        }
    }

    public ArrayList<RssNode> getReservoirOutletNodes(ReservoirElement object) {
        object = ((ReservoirElement)object).getReservoirOutletElements(null);
        ArrayList<RssNode> arrayList = new ArrayList<RssNode>();
        for (int i = 0; i < object.size(); ++i) {
            Object object2 = (Element)object.get(i);
            object2 = ((Element)object2).getElementVector();
            this.getReservoirOutletNodes((Vector)object2, arrayList);
        }
        return arrayList;
    }

    public void getReservoirOutletNodes(Vector object, ArrayList<RssNode> arrayList) {
        object = new ArrayList(object);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            object = element.getDownstreamNode();
            Function function = element.getFunction();
            if (function instanceof Spillway || function instanceof AdjustableFlow) {
                arrayList.add((RssNode)object);
                continue;
            }
            if (!(element instanceof OutletGroupElement)) continue;
            object = element.getElementVector();
            this.getReservoirOutletNodes((Vector)object, arrayList);
        }
    }

    public void finalizeCompute() {
        this._rssRun.printMessage(WqI18n.a("WQRun.Simulation.Complete.Msg").getText());
        try {
            this._wqEngine.finalizeCompute();
        }
        catch (WQException wQException) {
            this.printWQErrorMessages(wQException);
        }
        if (this._wqio != null) {
            try {
                this._wqio.closeFile();
                return;
            }
            catch (WQException wQException) {
                this.printWQErrorMessages(wQException);
            }
        }
    }

    protected void setParamFilePaths() throws WQException {
        WQLibraryRegistryImpl wQLibraryRegistryImpl = new WQLibraryRegistryImpl();
        for (Object object : wQLibraryRegistryImpl.getLibraries()) {
            if (!(object instanceof BaseWQLibrary)) continue;
            object = (BaseWQLibrary)object;
            String string = object.getName();
            if ((object = object.getParamFilePath()) != null) {
                this._wqEngine.setParamFilePaths(string, (Path)object);
                continue;
            }
            throw new WQException(WqI18n.a("WQRun.Init.WQLibary.Path.Error").format((Object)string));
        }
    }

    public int simulateStep(RunTimeStep runTimeStep, int n, RunTimeWindow runTimeWindow) {
        int n2;
        OutputVariableOptions outputVariableOptions;
        if (this.isComputeCanceled()) {
            return 50;
        }
        AltWaterQualityOptions altWaterQualityOptions = this._rssAlt.getWaterQualityOptions();
        if (altWaterQualityOptions != null) {
            outputVariableOptions = altWaterQualityOptions.getOutputVariableOptions();
            n2 = altWaterQualityOptions.getNumberOutputTimeSteps();
        } else {
            outputVariableOptions = new OutputVariableOptions();
            n2 = 1;
        }
        int n3 = runTimeStep.step - (runTimeStep.rtw.getNumLookbackSteps() + 1);
        this._wqTime.setCurrentStep(n3);
        int n4 = this._wqTime.getWqStepsPerHydroStep();
        this._wqTime.setTimeOffset(runTimeWindow, this._rssRun.getRunTimeWindow());
        int n5 = (n3 + this._wqTime.getOffset()) * n4 + 1;
        TSDataSet tSDataSet = this._rssRun.getWQOutputTSData();
        try {
            this._wqEngine.updateTimeOffset(this._wqTime.getOffset());
            WQRun wQRun = this;
            this._wqGeo.setHydroForStep(this._rssSystem, this._rssRun, wQRun, wQRun._wqEngine, this._flowComputeType, runTimeStep.step);
            this._wqEngine.updateHydro((Geometry)this._wqGeo, WQTime.TIME_STEP_INFO.START_AND_END_OF_STEP.id);
            this.passStateVariables(runTimeStep.step);
            for (int i = 0; i < n4; ++i) {
                this.updateWQParameters(runTimeWindow, runTimeStep.step, n3 + i);
                this._wqEngine.computeStep(n3, i);
                this._wqTime.setCurrentTimeForStep(n3, i + 1);
                int n6 = n3 * n4 + i + 1;
                if (n6 % n2 == 0) {
                    this._wqio.saveSnapshot(this._wqEngine, (Geometry)this._wqGeo, this._wqConstitSet, (WQTime)this._wqTime, WQTime.TIME_STEP_INFO.END_OF_STEP, n5, outputVariableOptions);
                }
                ++n5;
            }
            this._wqTime.setCurrentTimeForStep(n3 + 1, 0);
            this.outputWQToDSS(tSDataSet, runTimeStep.step);
        }
        catch (WQException wQException) {
            this.printWQErrorMessages(wQException);
            return 1;
        }
        return 0;
    }

    public int simulatePeriod(RunTimeWindow runTimeWindow, int n, int n2) {
        int n3;
        OutputVariableOptions outputVariableOptions;
        AltWaterQualityOptions altWaterQualityOptions = this._rssAlt.getWaterQualityOptions();
        if (altWaterQualityOptions != null) {
            outputVariableOptions = altWaterQualityOptions.getOutputVariableOptions();
            n3 = altWaterQualityOptions.getNumberOutputTimeSteps();
        } else {
            outputVariableOptions = new OutputVariableOptions();
            n3 = 1;
        }
        int n4 = n - (runTimeWindow.getNumLookbackSteps() + 1);
        int n5 = this._wqTime.getWqStepsPerHydroStep();
        TSDataSet tSDataSet = this._rssRun.getWQOutputTSData();
        this._wqTime.setCurrentStep(n4);
        try {
            while (n < n2) {
                n4 = n - (runTimeWindow.getNumLookbackSteps() + 1);
                if (this.isComputeCanceled()) {
                    return 50;
                }
                WQRun wQRun = this;
                this._wqGeo.setHydroForStep(this._rssSystem, this._rssRun, wQRun, wQRun._wqEngine, this._flowComputeType, n);
                this._wqEngine.updateHydro((Geometry)this._wqGeo, WQTime.TIME_STEP_INFO.START_AND_END_OF_STEP.id);
                this.passStateVariables(n);
                for (int i = 0; i < n5; ++i) {
                    this.updateWQParameters(runTimeWindow, n, n4 + i);
                    this._wqEngine.computeStep(n4, i);
                    this._wqTime.setCurrentTimeForStep(n4, i + 1);
                    if ((i + 1) % n3 != 0) continue;
                    int n6 = (n4 * n5 + i + 1) / n3;
                    this._wqio.saveSnapshot(this._wqEngine, (Geometry)this._wqGeo, this._wqConstitSet, (WQTime)this._wqTime, WQTime.TIME_STEP_INFO.END_OF_STEP, n6, outputVariableOptions);
                }
                this._wqTime.setCurrentTimeForStep(n4 + 1, 0);
                this.outputWQToDSS(tSDataSet, n);
                ++n;
            }
        }
        catch (WQException wQException) {
            this.printWQErrorMessages(wQException);
            return 1;
        }
        return 0;
    }

    private WQEngineAdapter.STATE resSimStateToWQState(int n) throws WQException {
        WQEngineAdapter.STATE sTATE = null;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                sTATE = WQEngineAdapter.STATE.OUTERLOOP;
                break;
            }
            case 2: {
                sTATE = WQEngineAdapter.STATE.TRIAL;
                break;
            }
            case 3: {
                sTATE = WQEngineAdapter.STATE.INNERLOOP;
                break;
            }
            case 4: {
                sTATE = WQEngineAdapter.STATE.TIMEBLOCK;
                break;
            }
            case 5: {
                sTATE = WQEngineAdapter.STATE.TIMEBLOCK2;
                break;
            }
            case 6: {
                sTATE = WQEngineAdapter.STATE.PRECOMPUTE;
                break;
            }
            default: {
                throw new WQException(WqI18n.a("WQRun.SaveState.Error").format((Object)n));
            }
        }
        return sTATE;
    }

    public void restoreElementState(int n) throws WQException {
        WQEngineAdapter.STATE sTATE = this.resSimStateToWQState(n);
        if (sTATE != null) {
            this._wqEngine.restoreState(sTATE);
            if (sTATE != WQEngineAdapter.STATE.INNERLOOP) {
                this._wqGeo.restoreElementState(sTATE);
            }
            if (sTATE == WQEngineAdapter.STATE.TRIAL) {
                this._wqEngine.setInitialCellVolumes((Geometry)this._wqGeo);
            }
        }
    }

    public void saveElementState(int n) throws WQException {
        WQEngineAdapter.STATE sTATE = this.resSimStateToWQState(n);
        this._wqEngine.saveState(sTATE);
        this._wqGeo.saveElementState(sTATE);
    }

    public int initSimulation(RunTimeWindow object) {
        this._rssRun.printMessage("\n");
        this._rssRun.printMessage(WqI18n.a("WQRun.Simulation.Start.Msg").getText());
        boolean bl = false;
        if (object.getStartTime().equalTo(this._rssRun.getRunTimeWindow().getStartTime())) {
            bl = true;
        }
        try {
            int n = 1;
            if (object.getStartTime().compareTimes(this._rssRun.getRunTimeWindow().getStartTime()) == 0) {
                n = 0;
            }
            this.initHydro(n);
            object = this._rssAlt.getWaterQualityOptions();
            object = object != null ? ((AltWaterQualityOptions)object).getOutputVariableOptions() : new OutputVariableOptions();
            this._wqTime.setCurrentTimeForStep(0, 0);
            this._wqEngine.saveState(WQEngineAdapter.STATE.TRIAL);
            if (bl) {
                this._wqio.saveSnapshot(this._wqEngine, (Geometry)this._wqGeo, this._wqConstitSet, (WQTime)this._wqTime, WQTime.TIME_STEP_INFO.START_AND_END_OF_STEP, 0, (OutputVariableOptions)object);
            }
        }
        catch (WQException wQException) {
            this.printWQErrorMessages(wQException);
            return 1;
        }
        return 0;
    }

    private <T extends ParameterSettingValue<?>> int updateWQParameters(RunTimeWindow runTimeWindow, int n, int n2) throws WQException {
        for (WQParamTimeVarData wQParamTimeVarData : this._timeVaryingWQParams) {
            ParameterSetting parameterSetting = wQParamTimeVarData.paramSetting;
            Object object = parameterSetting.getParameterValue();
            double d = wQParamTimeVarData.defaultVal;
            int n3 = wQParamTimeVarData.regionId;
            String string = this._wqGeo.getRegionSet().getRegion(n3).getName();
            WQParameterProcessor wQParameterProcessor = (WQParameterProcessor)Lookups.forPath((String)object.getLookupPath()).lookup(WQParameterProcessor.class);
            if (wQParameterProcessor != null && (object = wQParameterProcessor.processParameter(parameterSetting, object, runTimeWindow, n, n2, this, wQParamTimeVarData, string)) != null) {
                d = (Double)object;
            }
            try {
                this._wqEngine.setWQParameterDataSingleRegion(parameterSetting.getParameterId(), wQParamTimeVarData.regionId, d, parameterSetting.getTheta());
            }
            catch (WQException wQException) {
                this.printWQErrorMessages(wQException);
                return 1;
            }
        }
        return 0;
    }

    double[] getWQParameterTSRecord(int n, int n2, boolean bl, WQParameterSettingDSSValue wQParameterSettingDSSValue) {
        String string = "WQ Parameter Id " + n;
        String string2 = bl ? "Base Region" : this._wqGeo.getRegionSet().getRegion(n2).getName();
        Object object = this._rssRun.getInputWQTSDataSet(false);
        object = new WQDataProvider((TSDataSet)object);
        wQParameterSettingDSSValue = (DssData)wQParameterSettingDSSValue.getValue();
        return object.getDataValues((Data)wQParameterSettingDSSValue, (WQTime)this._wqTime, string2, string);
    }

    private boolean passStateVariables(int n) throws WQException {
        Object object = this._rssSystem.getStateVariableList();
        Iterator<StateVariable> iterator = object.iterator();
        while (iterator.hasNext()) {
            double d;
            int n2;
            ReservoirElement reservoirElement;
            double d2;
            int n3;
            Object object2;
            int n4;
            Element element;
            StateVariable stateVariable;
            object = iterator.next();
            object = object;
            String string = stateVariable.getName();
            if (string.startsWith(STATE_VAR_INFLOW_DEPTH_STRING) && (element = this.findResForSV((StateVariable)object)) != null && (n4 = this.findSubDomainIdForElem(element)) >= 0) {
                object2 = this._wqGeo.getBoundariesInExtent();
                TSRecord tSRecord = ((StateVariable)object).getTimeSeries();
                double d3 = tSRecord.getValue(n);
                if (NumericalConstants.isValidValue((double)d3)) {
                    object2 = object2.iterator();
                    while (object2.hasNext()) {
                        SubDomainBoundary subDomainBoundary = (SubDomainBoundary)object2.next();
                        if (subDomainBoundary.getDownstreamSubDomainId() != n4) continue;
                        this._wqEngine.setBoundaryInflowDepth(subDomainBoundary.getId(), d3);
                    }
                }
            }
            if (string.startsWith(STATE_VAR_BOUND_TEMP_SOURCE) && (element = this.findDivOutletForSV((StateVariable)object)) != null && (n3 = this.findSubDomainBoundIdForDivOutlet((DivertedOutletElement)element)) >= 0 && NumericalConstants.isValidValue((double)(d2 = (object2 = ((StateVariable)object).getTimeSeries()).getValue(n)))) {
                this._wqEngine.setBoundaryTempSource(n3, d2);
            }
            if (!string.startsWith(STATE_VAR_MIN_DZ_STRING) || (reservoirElement = this.findResForSV((StateVariable)object)) == null || (n2 = this.findSubDomainIdForElem(reservoirElement)) < 0 || !NumericalConstants.isValidValue((double)(d = (object2 = ((StateVariable)object).getTimeSeries()).getValue(n)))) continue;
            this._wqEngine.setMinDz(n2, d);
        }
        return true;
    }

    public ReservoirElement findResForSV(StateVariable stateVariable) {
        ReservoirElement reservoirElement = null;
        Vector vector = this._rssSystem.getElementVectorByClass(ReservoirElement.class.getName());
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            ReservoirElement reservoirElement2 = (ReservoirElement)vector.get(i);
            int n = this._rssAlt.getResOpSetSelection(reservoirElement2.getIndex());
            List<OpRule> list = reservoirElement2.getReservoirOp().getOperationSet(n).getEnabledRules(null);
            for (int j = 0; j < list.size(); ++j) {
                Object object = list.get(j);
                Object object2 = new ArrayList();
                ((OpRule)object).getReferencedStateVariables((List)object2);
                object = object2.iterator();
                while (object.hasNext()) {
                    object2 = object.next();
                    if (!(object2 = (StateVariable)object2).equals(stateVariable)) continue;
                    reservoirElement = reservoirElement2;
                    bl = true;
                    break;
                }
                if (bl) break;
            }
            if (bl) break;
        }
        return reservoirElement;
    }

    public DivertedOutletElement findDivOutletForSV(StateVariable stateVariable) {
        DivertedOutletElement divertedOutletElement = null;
        Object object = this._rssSystem.getElementVectorByClass(ReservoirElement.class.getName());
        boolean bl = false;
        object = ((Vector)object).iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (ReservoirElement)object2;
            int n = this._rssAlt.getResOpSetSelection(object2.getIndex());
            object2 = ((ReservoirElement)object2).getReservoirOp().getOperationSet(n).getRules(null);
            object2 = object2.iterator();
            while (object2.hasNext()) {
                Object object3 = object2.next();
                Element element = ((OpRule)(object3 = (OpRule)object3)).getController().getReleaseElement();
                if (element instanceof DivertedOutletElement) {
                    Object object4 = new ArrayList();
                    ((OpRule)object3).getReferencedStateVariables((List)object4);
                    object3 = object4.iterator();
                    while (object3.hasNext()) {
                        object4 = (StateVariable)object3.next();
                        if (!object4.equals(stateVariable)) continue;
                        divertedOutletElement = (DivertedOutletElement)element;
                        bl = true;
                        break;
                    }
                }
                if (!bl) continue;
            }
            if (!bl) continue;
        }
        return divertedOutletElement;
    }

    private int findSubDomainIdForElem(Element element) {
        int n = -1;
        List list = this._wqGeo.getSubDomainsInExtent();
        for (SubDomain subDomain : list) {
            list = (WQGeoSubDomain)subDomain;
            if (element.getIndex() != list.getElementId()) continue;
            n = subDomain.getId();
            break;
        }
        return n;
    }

    private int findSubDomainBoundIdForDivOutlet(DivertedOutletElement element) {
        int n = -1;
        Element element2 = element.getParent();
        element = ((Element)element).getDownstreamNode().getDownstreamElement();
        Object object = this._wqGeo.getBoundariesInExtent();
        object = object.iterator();
        while (object.hasNext()) {
            SubDomainBoundary subDomainBoundary = (SubDomainBoundary)object.next();
            if (subDomainBoundary.getUpstreamSubDomainId() < 0 || subDomainBoundary.getDownstreamSubDomainId() < 0) continue;
            Object object2 = this._wqGeo.getSubDomain(subDomainBoundary.getUpstreamSubDomainId());
            WQGeoSubDomain wQGeoSubDomain = this._wqGeo.getSubDomain(subDomainBoundary.getDownstreamSubDomainId());
            if (object2.getElementId() != element2.getIndex() || !(object2 = wQGeoSubDomain.getUpstreamElemIds()).contains(element.getIndex())) continue;
            n = subDomainBoundary.getId();
            break;
        }
        return n;
    }

    @Scriptable
    public WQEngineAdapter getWQEngineAdapter() {
        return this._wqEngine;
    }

    @Scriptable
    public WQConstituent getWQConstituent(String string) {
        if (this._wqConstitSet == null || this._wqConstitSet.getConstituentList() == null) {
            return null;
        }
        for (Constituent constituent : this._wqConstitSet.getConstituentList()) {
            if (!constituent.getDisplayName().equals(string)) continue;
            return (WQConstituent)constituent;
        }
        return null;
    }
}

