/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.wq.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import hec.clientapp.model.ManagerProxy;
import hec.map.MapIdentifier;
import hec.map.MapObjectInterface;
import hec.map.WorldRect;
import hec.map.crs.CoordinateReferenceSystem;
import hec.rss.model.ReachElement;
import hec.rss.model.RssSystem;
import hec.rss.plugins.waterquality.model.Connection;
import hec.rss.plugins.waterquality.model.ConnectionSet;
import hec.rss.plugins.waterquality.model.ReservoirLayerHeightDefinition;
import hec.rss.plugins.waterquality.model.ReservoirLayerHeightDefinitionType;
import hec.rss.plugins.waterquality.model.ReservoirLayerSpacingType;
import hec.rss.plugins.waterquality.model.RssWQGeometry;
import hec.rss.wq.model.CrossSectionManager;
import hec.rss.wq.model.JsonManager;
import hec.ui.ProgressListener;
import hec.wqenginecore.WQConsistencyCheck;
import hec.wqenginecore.WQException;
import hec.wqenginecore.flowtable.FlowTable;
import hec.wqenginecore.flowtable.FlowTableLocationTemplate;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.SubDomainType;
import hec.wqengineimpl.geometry.WQGeoSubDomain;
import hec.wqengineimpl.geometry.WQSubDomainRef;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"index", "name", "description"})
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WqGeometry
extends JsonManager
implements MapObjectInterface {
    public static final int CURRENT_VERSION = 1;
    public static final Logger logger = Logger.getLogger(WqGeometry.class.getName());
    public static final String FILE_EXT = ".geometry";
    public static final String SUBDIR = "wq/geometry/";
    @JsonProperty
    private int _version = -1;
    @JsonIgnore
    private final MapIdentifier _mapIdentifier = new MapIdentifier();
    @JsonProperty
    private int _networkId = -1;
    @JsonProperty
    private int _crossSectionManagerId;
    @JsonProperty
    private Path _steadyFlowPath;
    @JsonProperty
    private RssWQGeometry _rssWqGeometry;

    public WqGeometry() {
        this._mapIdentifier.setMapShown(true);
        this._mapIdentifier.setIsManager(true);
    }

    @Override
    public void init() {
    }

    public void setNetworkId(int n) {
        this._networkId = n;
        this.setModified(true);
    }

    public int getNetworkId() {
        return this._networkId;
    }

    public RssSystem getNetwork() {
        ManagerProxy managerProxy = this.getProxyList().getManagerProxy(RssSystem.class.getName(), this._networkId);
        if (managerProxy != null) {
            return (RssSystem)managerProxy.loadManager(null, null);
        }
        return null;
    }

    public void setCrossSectionManagerId(int n) {
        this._crossSectionManagerId = n;
    }

    public CrossSectionManager getCrossSectionManager() {
        ManagerProxy managerProxy = this.getProxyList().getManagerProxy(CrossSectionManager.class.getName(), this._crossSectionManagerId);
        if (managerProxy != null) {
            return (CrossSectionManager)managerProxy.loadManager(null, null);
        }
        return null;
    }

    public int getCrossSectionManagerId() {
        return this._crossSectionManagerId;
    }

    @Deprecated
    public String getSteadyFlowFile() {
        return null;
    }

    @Deprecated
    @JsonProperty
    public void setSteadyFlowFile(String string) {
        this.setSteadyFlowPath(new File(string).toPath());
    }

    public Path getSteadyFlowPath() {
        return this._steadyFlowPath;
    }

    public void updateSteadyFlowPath(Path path, int n) throws WQException {
        Path path2 = this._steadyFlowPath;
        if (!path.equals(path2)) {
            this._rssWqGeometry.loadFlowTable(path, n);
            this.setSteadyFlowPath(path);
        }
    }

    public void setSteadyFlowPath(Path path) {
        this._steadyFlowPath = path;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return null;
    }

    @JsonIgnore
    public WorldRect getExtent() {
        WorldRect worldRect = new WorldRect();
        return worldRect;
    }

    @JsonIgnore
    public MapIdentifier getMapIdentifier() {
        return this._mapIdentifier;
    }

    public void load() throws IOException {
    }

    public void setExtent(WorldRect worldRect) {
    }

    public void setMapIdentifier(MapIdentifier mapIdentifier) {
    }

    public void unload() {
    }

    public void setRssWqGeometry(RssWQGeometry rssWQGeometry) {
        this._rssWqGeometry = rssWQGeometry;
    }

    public RssWQGeometry getRssWqGeometry() {
        return this._rssWqGeometry;
    }

    public RssWQGeometry createRssWqGeometry(RssSystem object, ProgressListener progressListener) {
        RssWQGeometry rssWQGeometry = new RssWQGeometry(this.getIndex());
        Object object2 = rssWQGeometry.getReservoirHeightDefinition();
        int n = object.getUnitSystem();
        if (n == 2) {
            ((ReservoirLayerHeightDefinition)object2).setGlobalHeight(1.0);
        } else if (n == 1) {
            ((ReservoirLayerHeightDefinition)object2).setGlobalHeight(3.0);
        }
        try {
            rssWQGeometry.createGeometry((RssSystem)object);
            rssWQGeometry.createBoundaries((RssSystem)object);
            rssWQGeometry.createLocalBoundaries((RssSystem)object);
            rssWQGeometry.associateBoundaries();
            rssWQGeometry.associateJncts();
            object2 = this.getSteadyFlowPath();
            if (object2 != null && !object2.toString().isEmpty()) {
                object.printMessage("Loading RAS Steady Flow file: " + String.valueOf(object2));
                rssWQGeometry.loadFlowTable((Path)object2, object.getUnitSystem());
            }
        }
        catch (WQException wQException) {
            object2 = wQException;
            object = "Unexpected Exception creating wq geometry. " + wQException.getMessage();
            this.addErrorMessage(progressListener, (String)object);
            return null;
        }
        return rssWQGeometry;
    }

    public WQConsistencyCheck checkConsistency(RssSystem object) {
        String string;
        block18: {
            ReservoirLayerHeightDefinition reservoirLayerHeightDefinition;
            Object object22;
            Object object3;
            Object object4;
            Object object52;
            Object object6;
            block19: {
                block20: {
                    string = "Water Quality Geometry: " + this.getName();
                    string = new WQConsistencyCheck(string);
                    if (Files.notExists(this._steadyFlowPath, new LinkOption[0])) {
                        object6 = "RAS Steady Flow file: " + this._steadyFlowPath.toString() + " not found";
                        string.addErrorMessage((String)object6);
                    }
                    object6 = this._rssWqGeometry;
                    FlowTable flowTable = object6.getFlowTable();
                    boolean bl = true;
                    if (flowTable == null) {
                        try {
                            object6.loadFlowTable(this._steadyFlowPath, object.getUnitSystem());
                        }
                        catch (WQException wQException) {
                            object = wQException;
                            String string2 = wQException.getMessage();
                            string.addErrorMessage(string2);
                            bl = false;
                        }
                    }
                    if (bl) {
                        flowTable = object6.getFlowTable();
                        object = ((RssWQGeometry)object6).getConnectionSet();
                        for (Object object52 : object6.getSubDomainsInExtent()) {
                            int n;
                            if (object52.getType() != SubDomainType.REACH_1D) continue;
                            WQGeoSubDomain wQGeoSubDomain = (WQGeoSubDomain)object52;
                            Object object7 = wQGeoSubDomain.getXRASRiver();
                            object4 = wQGeoSubDomain.getXRASReach();
                            object3 = wQGeoSubDomain.getXRASStation();
                            if (object7 == null) {
                                WQSubDomainRef wQSubDomainRef = wQGeoSubDomain.getRef();
                                n = 0;
                                boolean bl2 = true;
                                object7 = ((ConnectionSet)object).getUpstream(wQSubDomainRef);
                                object4 = ((ConnectionSet)object).getDownstream(wQSubDomainRef);
                                object3 = "";
                                if (object7 != null) {
                                    bl2 = false;
                                    FlowTableLocationTemplate flowTableLocationTemplate = flowTable.getLocationTemplateForRow(((Connection)object7).getRiver(), ((Connection)object7).getReach(), ((Connection)object7).getStation());
                                    if (flowTableLocationTemplate != null) {
                                        n = 1;
                                    } else {
                                        object3 = "Steady flow data not found for RAS XC: " + ((Connection)object7).getRiver() + " " + ((Connection)object7).getReach() + " " + ((Connection)object7).getStation() + " in SubDomain: " + object52.getName();
                                    }
                                    wQGeoSubDomain.setSingleRiverReachStation(((Connection)object7).getRiver(), ((Connection)object7).getReach(), ((Connection)object7).getStation());
                                }
                                if (object4 != null) {
                                    bl2 = false;
                                    FlowTableLocationTemplate flowTableLocationTemplate = flowTable.getLocationTemplateForRow(((Connection)object4).getRiver(), ((Connection)object4).getReach(), ((Connection)object4).getStation());
                                    if (flowTableLocationTemplate != null) {
                                        n = 1;
                                    } else {
                                        object3 = "Steady flow data not found for RAS XC: " + ((Connection)object4).getRiver() + " " + ((Connection)object4).getReach() + " " + ((Connection)object4).getStation() + " in SubDomain: " + object52.getName();
                                    }
                                    wQGeoSubDomain.setSingleRiverReachStation(((Connection)object4).getRiver(), ((Connection)object4).getReach(), ((Connection)object4).getStation());
                                }
                                if (n != 0) continue;
                                if (bl2) {
                                    object3 = "No RAS Cross-sections found for SubDomain: " + object52.getName();
                                }
                                string.addErrorMessage((String)object3);
                                continue;
                            }
                            int n2 = ((SubDomain)object7).length;
                            for (n = 0; n < n2; ++n) {
                                FlowTableLocationTemplate flowTableLocationTemplate = flowTable.getLocationTemplateForRow((String)object7[n], object4[n], object3[n]);
                                if (flowTableLocationTemplate != null) continue;
                                String string3 = "Steady flow data not found for RAS XC: " + (String)object7[n] + " " + (String)object4[n] + " " + object3[n] + " in SubDomain: " + object52.getName();
                                string.addErrorMessage(string3);
                            }
                        }
                    }
                    boolean bl3 = false;
                    for (Object object22 : object6.getSubDomainsInExtent()) {
                        if (object22.getType() != SubDomainType.RESERVOIR_1DV) continue;
                        bl3 = true;
                        break;
                    }
                    if (!bl3) break block18;
                    reservoirLayerHeightDefinition = ((RssWQGeometry)object6).getReservoirHeightDefinition();
                    if (reservoirLayerHeightDefinition.getType() != ReservoirLayerHeightDefinitionType.Global) break block19;
                    object22 = reservoirLayerHeightDefinition.getGlobalHeight();
                    if (object22 != null) break block20;
                    object52 = "Global reservoir layer height not specified";
                    string.addErrorMessage((String)object52);
                    break block18;
                }
                if (!((Double)object22 <= 0.0)) break block18;
                object52 = "Global reservoir layer height less than or equal 0.0";
                string.addErrorMessage((String)object52);
                break block18;
            }
            for (Object object7 : object6.getSubDomainsInExtent()) {
                if (object7.getType() != SubDomainType.RESERVOIR_1DV || (object4 = reservoirLayerHeightDefinition.getSpacingType((WQSubDomainRef)(object52 = (WQSubDomainRef)object7.getRef()))) != ReservoirLayerSpacingType.CONSTANT) continue;
                object22 = reservoirLayerHeightDefinition.getConstantHeight((WQSubDomainRef)object52);
                if (object22 == null) {
                    object3 = "Reservoir layer height not specified for Reservoir: " + object7.getName();
                    string.addErrorMessage((String)object3);
                    continue;
                }
                if (!((Double)object22 <= 0.0)) continue;
                object3 = "Reservoir layer height less than or equal 0.0 for Reservoir: " + object7.getName();
                string.addErrorMessage((String)object3);
            }
        }
        return string;
    }

    public ReachElement getReachElement(RssSystem rssReturnStatusConstants, WQGeoSubDomain wQGeoSubDomain) {
        int n = wQGeoSubDomain.getElementId();
        ReachElement reachElement = null;
        if ((rssReturnStatusConstants = rssReturnStatusConstants.getElement(n)) instanceof ReachElement) {
            reachElement = (ReachElement)rssReturnStatusConstants;
        }
        return reachElement;
    }

    public void addErrorMessage(ProgressListener progressListener, String string) {
        if (progressListener != null) {
            progressListener.progress(string, ProgressListener.MessageType.ERROR);
            return;
        }
        logger.log(Level.SEVERE, string);
    }

    public void addWarningMessage(ProgressListener progressListener, String string) {
        if (progressListener != null) {
            progressListener.progress(string, ProgressListener.MessageType.WARNING);
            return;
        }
        logger.log(Level.WARNING, string);
    }

    public void importSystem(RssSystem object, ProgressListener progressListener) {
        if ((object = this.createRssWqGeometry((RssSystem)object, progressListener)) != null) {
            this.setRssWqGeometry((RssWQGeometry)object);
        }
    }

    @Override
    protected void updateToCurrentVersion() {
        this._version = 1;
    }
}

